/*
**  NSString+Extensions.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Jonathan B. Leffert <jonathan@leffert.net>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_NSString_Extensions
#define _Pantomime_H_NSString_Extensions

#import <Foundation/NSString.h>
#import <Foundation/NSData.h>

@interface NSString (PantomimeStringExtensions)

- (NSString *) stringByTrimmingWhiteSpaces;

- (int) indexOfCharacter: (unichar) theCharacter;

- (BOOL) hasCaseInsensitivePrefix: (NSString *) thePrefix;
- (BOOL) hasCaseInsensitiveSuffix: (NSString *) theSuffix;

- (NSString *) stringFromQuotedString;

- (NSString *) modifiedUTF7String;
- (NSString *) stringFromModifiedUTF7;

- (BOOL) hasREPrefix;

- (NSString *) stringByReplacingOccurrencesOfString: (NSString *) theTarget
                                         withString: (NSString *) theReplacement;
@end

#endif // _Pantomime_H_NSString_Extensions
