/*
**  Flags.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
#include <Pantomime/Flags.h>

#include <Pantomime/Constants.h>
#include <Pantomime/NSData+Extensions.h>

@implementation Flags

- (id) init
{
  self = [super init];

  return self;
}


//
//
///
- (id) initWithFlags: (int) theFlags
{
  self = [self init];

  flags = theFlags;

  return self;
}


//
//
//
- (void) dealloc
{
  [super dealloc];
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [NSNumber numberWithInt: flags] ];
}


- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  flags = [[theCoder decodeObject] intValue];

  return self;
}


//
// NSCopying protocol
//
- (id) copyWithZone: (NSZone *) zone
{
  Flags *theFlags;

  theFlags = [[Flags alloc] initWithFlags: flags];

  return theFlags;
}


//
//
//
- (void) add: (int) aFlag
{
  flags = flags | aFlag;
}


//
//
//
- (void) addFlagsFromData: (NSData *) theData
{
  NSRange theRange;
  
  if ( theData )
    {
      theRange = [theData rangeOfCString: "R"];

      if ( theRange.length )
	{
	  [self add: SEEN];
	}

      theRange = [theData rangeOfCString: "D"];
      
      if ( theRange.length )
	{
	  [self add: DELETED];
	}

      theRange = [theData rangeOfCString: "A"];

      if ( theRange.length )
	{
	  [self add: ANSWERED];
	}
    }
}


//
//
//
- (BOOL) contain: (int) theFlag
{
  if( (flags & theFlag) == theFlag ) 
    {
      return YES;
    }
  else
    {
      return NO;
    }
}


//
//
//
- (void) replaceWithFlags: (Flags *) theFlags
{
  flags = theFlags->flags;
}

//
//
//
- (void) remove: (int) theFlag
{
  flags = flags & (flags ^ theFlag);
}


//
//
//
- (void) removeAll
{
  flags = 0;
}


//
//
//
- (NSString *) string
{
  char c1, c2, c3;
  
  if (![self contain: SEEN]) c1 = 'N';
  else c1 = ' ';
  
  if ([self contain: ANSWERED]) c2 = 'A';
  else c2 = ' ';
  
  if ([self contain: DELETED]) c3 = 'D';
  else c3 = ' ';
  
  return [NSString stringWithFormat:@"%c %c %c", c1, c2, c3];
}


//
//
//
- (char *) statusString
{
  char c1;

  c1 = ([self contain: SEEN] ? 'R' : ' ');
  
  return (char*)[[NSString stringWithFormat: @"%cO", c1] cString];
}


//
//
//
- (char *) xstatusString
{
  char c1, c2;

  c1 = ([self contain: DELETED] ? 'D': ' ');
  c2 = ([self contain: ANSWERED] ? 'A': ' ');

  // Let's write _exactly_ what we have
  if (c1 == 'D' && c2 == ' ')
    {
      return "D";
    }
  else if (c1 == ' ' && c2 == 'A')
    {
      return "A";
    }
  else if (c1 == ' ' && c2 == ' ')
    {
      return "";
    }

  return "DA";
}

@end
