#ifndef INCLUDE_CONNECTION_H
#define INCLUDE_CONNECTION_H
#include "VT.h"
#include "Socket.h"
#include "History.h"
#include "MUD.h"
#include "Prefs.h"
#include "papaya/system.h"

class SystemTriggerEntity;

class Connection {

 public:

  Connection(MUD *);
  Connection(int, MUD *, int, int);
  ~Connection();
  int connect();
  VT * getVT();

  Socket * getSocket();
  char * getHost();
  char * getName();
  void setName(char *);
  int getPort();
  MUD * getMUD();

  int reconnect();

  void setNext(Connection *);
  Connection * getNext();
  History * getHistory();

  int isConnected();
  void close();

  void setCharMode(bool);
  bool getCharMode();

  Prefs * getPreferences();
  Prefs * queryPreferences();

  void closed();
  void failed(int);

  bool isClosed();

  static void keepalive_send(Connection *);

  static MUD * getLastMUD();

 private:

  void init();

  GladeXML * xml;

  MUD * mud; // Holds the host, port, login name, password, and triggers.
  guint timeout;

  VT * vt;

  Socket * s;

  Connection * next;
  History * history;

  char * name;

  int connected;
  bool copyover_event;
  bool charMode;
  bool deleted;
  bool isclosed;
  //  Prefs * prefs;

  guint keepalive_timer;
  int keepalive_pulses;

  // Used for the reconnect menu item when no MUDs are open
  static MUD * lastMUD;

  SystemTriggerEntity * loginTrigger;
  SystemTriggerEntity * passwordTrigger;

  friend gint connection_keepalive(gpointer data);
};

Connection * findConnection(char *);

extern void (*keepalive_send)(Connection *);

#endif
