#ifndef INCLUDE_GTK_TWO_WINDOW_H
#define INCLUDE_GTK_TWO_WINDOW_H

#include "BaseWindow.h"

class GTKTwoWindow : public BaseWindow {
 public:
  
  GTKTwoWindow();
  ~GTKTwoWindow();
  void createInterface();

  void addConnection(Connection *);
  void removeConnection(Connection *);

  GtkItemFactory * getItemFactory();
  Connection * getCurrentConnection();
  void nextText(Connection *);

  void pageSwitch(int);
  int numPages();
  void switchPage(int);
  void nextPage();

  void swallow();
  void closeWindow();

  void addPage(char *, GtkWidget *);

  GtkWidget * addPageForApp(char *);

  void addCustomMenu(char *, GtkItemFactoryCallback);

  void setToolbarVisible(bool);
  void getDimensions(int *, int *);
  
  int callback(int result);
  int timeout();
  int configureUsers();
  void display();

  void setTitleBar(char *);
  void setIcon(char *);

 private:

  GtkWidget * toolbar;
  GtkWidget * window;
  GtkWidget * notebook;
  GtkWidget * mud_menu;
  GtkWidget * menubar;
  GtkWidget * background_pixmap;

  GtkItemFactory * item_factory;
};

void on_notebook_page_switch(GtkNotebook * nb, gpointer data, guint p, gpointer data2);
void get_main_menu(GtkWidget *, GtkWidget **);
GtkWidget * get_mud_menu();

#endif // INCLUDE_GTK_TWO_WINDOW_H
