#ifndef INCLUDE_GRAPHICS_H
#define INCLUDE_GRAPHICS_H

#include "Connection.h"

#define MAX_COLOURS 24
#define BORDER 100
#define BASE 74
#define HEIGHT 400
#define WIDTH 600

class Graphics {

 public:

  Graphics();
  ~Graphics();

  char * getByte(char *, int *);
  char * getNumber(char *, int *);
  char * getColour(char *, int *);

  void init();
  void parse(char *);

  void drawLine(char *, int);

 private:
  Connection * c; // A Graphics class needs to know which Connection it
                  // belongs to for output.


  GtkWidget * area;
  GdkPixmap * offscreen; // The offscreen drawing area.

  bool initialised; // Have we created this Graphics drawing area yet.
};

#endif
