#ifndef INCLUDE_MUD_H
#define INCLUDE_MUD_H

#include "Prefs.h"

class MUD {
 public:

  MUD();
  MUD(char *, char * , int, char *, char *, char *, char *);
  ~MUD();

  void initPrefs(bool);

  void setName(char *);
  char * getName();

  void setHostname(char *);
  char * getHostname();

  void setPort(int);
  int getPort();

  void setLoginName(char *);
  char * getLoginName();

  void setLoginTrigger(char *);
  char * getLoginTrigger();

  void setPassword(char *);
  char * getPassword();
  
  void setPasswordTrigger(char *);
  char * getPasswordTrigger();

  Prefs * getPreferences();
  void setPreferences(Prefs *);

  void incrRefCount(bool);
  void decrRefCount(bool);

  bool getOwnPrefs();

  int getRefCount();

  bool getDeleted();

 private:
  char * name;
  char * hostname;

  char * login;
  char * login_trigger;
  char * password;
  char * password_trigger;

  Prefs * preferences;
  int port;

  int refcount;
  bool mudlist; // Has the mudlist a reference to this MUD?

  bool own_prefs;
};


#endif // INCLUDE_MUD_H
