/**
 * This file is included by Plugins, and therefore must not include any
 * files that Plugins may not include.
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "papaya/Preference.h"
#include "papaya/system.h"
class Connection;
typedef int (*SystemTriggerCallbackFunction)(regex_t *, Connection *, char *, char *, char *);

#include "papaya/Win32PluginAPIImplementation.h"

class Prefs;

Preference::Preference() {
  xml = NULL;
  availablePreferences = NULL;
}

Preference::~Preference() {

}

GtkWidget * Preference::getWidget() {
  return NULL;
}

void Preference::destroyWidget() {
}

void Preference::applyPreferences(Prefs * prefs) {

  int length = g_list_length(availablePreferences);
  for (int i = 0; i < length; i++) {
    PreferenceOptions * option = (PreferenceOptions *)g_list_nth_data(availablePreferences, i);
    

    switch (option->getType()) {
    case WidgetToggle:
    case WidgetCheckbutton:
	  preferences_set_preference_boolean(prefs, option->getName(), gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(xml, option->getWidget()))));
      break;

    case WidgetEntry:
      preferences_set_preference(prefs, option->getName(), (gchar *) gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(xml, option->getWidget()))));
      break;

    case WidgetSpinbutton:
      preferences_set_preference_integer(prefs, option->getName(), gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(glade_xml_get_widget(xml, option->getWidget()))));
      break;

    case WidgetOptionmenu:
      preferences_set_preference_integer(prefs, option->getName(), gtk_option_menu_get_history(GTK_OPTION_MENU(glade_xml_get_widget(xml, option->getWidget()))));
      break;

    default:
      printf ("Unsupported widget type on option: %s.\n", option->getName());
      break;
    }

  }


}

void Preference::loadPreferences(Prefs * prefs) {

  int length = g_list_length(availablePreferences);
  for (int i = 0; i < length; i++) {
    PreferenceOptions * option = (PreferenceOptions *)g_list_nth_data(availablePreferences, i);
    

    switch (option->getType()) {
    case WidgetToggle:
    case WidgetCheckbutton:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(xml, option->getWidget())), preferences_get_preference_boolean(prefs, option->getName()));
      break;

    case WidgetEntry:
      gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(xml, option->getWidget())), preferences_get_preference(prefs, option->getName()));
      break;

    case WidgetSpinbutton:
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(glade_xml_get_widget(xml, option->getWidget())), (int) preferences_get_preference_integer(prefs, option->getName()));
      break;

    case WidgetOptionmenu:
      gtk_option_menu_set_history(GTK_OPTION_MENU(glade_xml_get_widget(xml, option->getWidget())), preferences_get_preference_integer(prefs, option->getName()));
      break;

    default:
      printf ("Unsupported widget type on option: %s.\n", option->getName());
      break;
    }

  }



}

Category * Preference::getCategories() {
  return NULL;
}

PreferenceData::PreferenceData() {
  name = NULL;
  value = NULL;
}

PreferenceData::PreferenceData(char * n, char * v) {
  name = NULL;
  value = NULL;
  setName(n);
  setValue(v);
}

PreferenceData::PreferenceData(char * n, bool v) {
  name = NULL;
  value = NULL;
  setName(n);
  setValue(v);
}

PreferenceData::PreferenceData(char * n, int v) {
  name = NULL;
  value = NULL;
  setName(n);
  setValue(v);
}

PreferenceData::~PreferenceData() {
  free(name);
  free(value);
}

void PreferenceData::setName(char * n) {
  free(name);
  name = strdup(n);
}

char * PreferenceData::getName() {
  return name;
}

void PreferenceData::setValue(char * v) {
  free(value);
  value = strdup(v);
}

void PreferenceData::setValue(bool v) {
  char buf[1024];
  snprintf(buf, 1024, "%d", v);
  setValue(v);
}

void PreferenceData::setValue(int v) {
  char buf[1024];
  snprintf(buf, 1024, "%d", v);
  setValue(v);
}

char * PreferenceData::getValue() {
  return value;
}

PreferenceOptions::PreferenceOptions(char * n, char * w, WidgetType t) {
  name = strdup(n);
  widget = strdup(w);
  type = t;
}

PreferenceOptions::~PreferenceOptions() {
  free(name);
  free(widget);
}

char * PreferenceOptions::getName() {
  return name;
}

char * PreferenceOptions::getWidget() {
  return widget;
}

WidgetType PreferenceOptions::getType() {
  return type;
}
