#include <ctype.h>

#include "SystemTriggerEntity.h"

SystemTriggerEntity::SystemTriggerEntity() : Entity() {

  callback = NULL;
  callback_data = NULL;

  text = NULL;
  connection = NULL;

  setType(EntitySystemTrigger);
  setName(_("Unknown System Trigger"));

  widget = NULL;
}

SystemTriggerEntity::SystemTriggerEntity(char * t, Connection * c, SystemTriggerCallbackFunction func, void * d) : Entity() {

  text = NULL;
  callback = NULL;
  callback_data = NULL;
  connection = NULL;

  setName(t);
  setType(EntitySystemTrigger);

  setText(t);
  setCallback(func);
  setCallbackData(d);
  setConnection(c);

  compile();
}

SystemTriggerEntity::~SystemTriggerEntity() {
  if (text)
    free(text);

  regfree(&regexp);
}

void SystemTriggerEntity::compile() {
  if (text)
    regcomp(&regexp, text, REG_ICASE|REG_EXTENDED);
}

void SystemTriggerEntity::setText(char * t) {
  if (text)
    free(text);
  text = strdup(t);
}

void SystemTriggerEntity::setCallback(SystemTriggerCallbackFunction func) {
  callback = func;
}

void SystemTriggerEntity::setCallbackData(void * d) {
  callback_data = d;
}

void SystemTriggerEntity::setConnection(Connection * c) {
  connection = c;
}

/**
 * These are the functions that process the triggers.
 */

bool SystemTriggerEntity::findExecute(EntityType t, char * field, char * value, void * data, bool multiple) {

  if (t != getType())
    return false;

  if (disabled)
    return false;

  regmatch_t pmatch[10];
  int nmatch = 10;

  Connection * conn = (Connection *)data;
  if (connection && conn != connection)
    return false;

  if (!strcmp(field, "text")) {

    if (regexec(&regexp, value, nmatch, pmatch, 0) == 0) {
      execute((Connection *)data, value);
      return true;
    }

    return false;
  }

  return false;
}

void SystemTriggerEntity::execute(Connection * c, char * input) {

  char * stripped_input = strdup(input);
  char * ptr = stripped_input;
  char * last;

  // Strip all colour codes.

  while (*ptr != '\0') {

    // If we have hit ESCAPE, look for the next alpha character.
    if (*ptr == '\033') {
      last = ptr;

      while (!isalpha(*ptr))
	ptr++;

      ptr++;

      memmove(last, ptr, strlen(ptr) + 1);
      ptr = last;
      
      continue;
    }

    ptr++;
  }

  callback(&regexp, c, input, stripped_input, callback_data);
  free(stripped_input);
}

#define SYSTEM_TRIGGER_XML "/home/allenc/papaya/papaya/share/system_trigger.xml"

GtkWidget * SystemTriggerEntity::getWidgets() {

#if 0

  xml = glade_xml_new(SYSTEM_TRIGGER_XML, NULL, NULL);
  if (!xml) {
    printf ("Unable to load xml for system trigger interface.\n");
    return NULL;
  }

  GtkWidget * name_entry = glade_xml_get_widget(xml, "name_entry");
  GtkWidget * trigger_string = glade_xml_get_widget(xml, "trigger_string");
  GtkWidget * frame = glade_xml_get_widget(xml, "frame");
  GtkWidget * description_entry = glade_xml_get_widget(xml, "description_entry");

  gtk_entry_set_text(GTK_ENTRY(name_entry), getName());
  gtk_entry_set_text(GTK_ENTRY(trigger_string), 



  GtkTextBuffer * description_buffer = gtk_text_buffer_new(NULL);
  gtk_text_view_set_buffer(GTK_TEXT_VIEW(description_entry), description_buffer);
  GtkTextIter start, end;
  if (getDescription()) {
    gtk_text_buffer_get_bounds(description_buffer, &start, &end);
    gtk_text_buffer_insert(description_buffer, &end, getDescription(), -1);
  }
  
#endif




  if (widget)
    return widget;

  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *frame1;
  GtkWidget *table1;
  GtkWidget *label1;
  GtkWidget *name_entry;
  GtkWidget *label2;
  GtkWidget *scrolledwindow1;
  GtkTextBuffer * text_buffer;
  GtkWidget *text_view;

  GtkWidget *frame2;
  GtkWidget *vbox3;
  GtkWidget *hbox1;
  GtkWidget *label3;
  GtkWidget *string_entry;
  GtkWidget *checkbutton1;

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox2, TRUE, TRUE, 0);

  frame1 = gtk_frame_new (_("General"));
  gtk_widget_ref (frame1);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox2), frame1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 2);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame1), table1);

  label1 = gtk_label_new (_("Name: "));
  gtk_widget_ref (label1);
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  name_entry = gtk_entry_new ();
  gtk_widget_ref (name_entry);
  gtk_widget_show (name_entry);
  gtk_table_attach (GTK_TABLE (table1), name_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label2 = gtk_label_new (_("Description: "));
  gtk_widget_ref (label2);
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_table_attach (GTK_TABLE (table1), scrolledwindow1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text_buffer = gtk_text_buffer_new(NULL);
  text_view = gtk_text_view_new_with_buffer(text_buffer);
  gtk_widget_ref(text_view);
  gtk_widget_show(text_view);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text_view);

  frame2 = gtk_frame_new (_("System Trigger"));
  gtk_widget_ref (frame2);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox2), frame2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 2);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (frame2), vbox3);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox1, FALSE, TRUE, 0);

  label3 = gtk_label_new (_("Trigger String: "));
  gtk_widget_ref (label3);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox1), label3, FALSE, FALSE, 0);

  string_entry = gtk_entry_new ();
  gtk_widget_ref (string_entry);
  gtk_widget_show (string_entry);
  gtk_box_pack_start (GTK_BOX (hbox1), string_entry, TRUE, TRUE, 0);


//  char buf[16384];
//  snprintf(buf, 16384, "Trigger is specific to MUD %s.", connection ? mud_get_name(connection_get_mud()) : "[none]");

//  checkbutton1 = gtk_check_button_new_with_label (buf);
//  gtk_widget_ref (checkbutton1);
//  gtk_widget_show (checkbutton1);
//  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton1, FALSE, FALSE, 0);


  gtk_entry_set_text(GTK_ENTRY(name_entry), getName());

		     // Insert the description into the description_buffer

  gtk_entry_set_text(GTK_ENTRY(string_entry), text);


  gtk_widget_set_sensitive(string_entry, false);
  gtk_widget_set_sensitive(name_entry, false);

  gtk_widget_set_sensitive(text_view, false);

  //  gtk_widget_set_sensitive(checkbutton1, false);

  widget = vbox1;
  return widget;
}

void SystemTriggerEntity::save(FILE * fp) {
  return;
}
