#! /bin/sh

if [ $# = 0 ]
then
  # Change this line if you're installing from a binary-only distribution.
  PREFIX="/usr/local"
else
  PREFIX=$1
fi

#Determine what arguments we need to pass to install
if [ `uname` = 'Linux' ]
then
    INSTALL='install'
else
    if [ `uname` = 'FreeBSD' ]
    then
	INSTALL='install -c'
    else
	INSTALL='install'
    fi
fi

echo "Installing Papaya in $PREFIX using $INSTALL"

if [ ! -d "$PREFIX/share/papaya" ]
then
    echo "Creating $PREFIX/share/papaya"
    mkdir -p $PREFIX/share/papaya
fi

echo "Installing papaya binary."
$INSTALL -m 0755 papaya $PREFIX/bin

echo "Installing default configuration data."
$INSTALL -m 0644 rc/papayarc $PREFIX/share/papaya

echo "Installing default MUD connection wizard data."
$INSTALL -m 0644 rc/mcw.dat $PREFIX/share/papaya

echo "Installing the MUDConnector MUD list."
$INSTALL -m 0644 rc/mudlist.txt $PREFIX/share/papaya

echo "Installing bitmaps."
if [ ! -d "$PREFIX/share/papaya/bitmaps" ]
then
    mkdir $PREFIX/share/papaya/bitmaps
fi

$INSTALL -m 0644 bitmaps/papaya.xpm $PREFIX/share/papaya/bitmaps
$INSTALL -m 0644 bitmaps/papaya-logo-newbie.xpm $PREFIX/share/papaya/bitmaps
$INSTALL -m 0644 bitmaps/papaya-logo-advanced.xpm $PREFIX/share/papaya/bitmaps
$INSTALL -m 0644 bitmaps/splash.xpm $PREFIX/share/papaya/bitmaps

echo "Installing documentation."
if [ ! -d "$PREFIX/share/papaya/doc" ]
then
    mkdir $PREFIX/share/papaya/doc
fi

$INSTALL -m 0644 ../doc/LICENSE $PREFIX/share/papaya/doc
$INSTALL -m 0644 ../doc/TMC_MUDLIST $PREFIX/share/papaya/doc
$INSTALL -m 0644 ../doc/CREDITS $PREFIX/share/papaya/doc

echo "Installation complete."
