#include <ctype.h>

#include "Friends.h"
#include "Win32PluginAPI.cpp"

#define MAJOR "0"
#define MINOR "1"

static Friends * friends = NULL;

extern "C" G_MODULE_EXPORT char * plugin_query_name() {
  return "Friends";
}

extern "C" G_MODULE_EXPORT char * plugin_query_description() {
  return _("Highlights each friends channel in a different colour.");
}

extern "C" G_MODULE_EXPORT char * pluging_query_major() {
  return MAJOR;
}

extern "C" G_MODULE_EXPORT char * plugin_query_minor() {
  return MINOR;
}

extern "C" G_MODULE_EXPORT void plugin_init(plugin_address_table_t * pat) {
	plugin_address_table_init(pat);

	friends = new Friends();
}

extern "C" G_MODULE_EXPORT void plugin_cleanup(void) {
  if (friends) {
    delete(friends);
    friends = NULL;
  }
}

Friends::Friends() {
  name = strdup("Friends");


  register_plugin(this, VERSION);

  plugin_handler_add_output_filter(get_plugin_handler(), this);
}

Friends::~Friends() {
  unregister_plugin(this);

  free(name);
}

int FriendsCmp(FriendsData * d1, FriendsData * d2) {
  if (!d1)
    return 1;

  if (!d2)
    return 0;

  return (d1 > d2);
}

void Friends::output(Connection * c, char * buf) {

  if (!buf || strlen(buf) == 0)
    return;

  // Attempt to find this entry in the list

  FriendsData * data = NULL;

  for (FriendsList::iterator i = connections.begin();
       i != connections.end();
       i++) {

    if ((*i)->connection == c) {
      data = (*i);
      break;
    }
  }

  if (!data) {
    data = (FriendsData *)malloc(sizeof(FriendsData));
    data->connection = c;
    data->reading = false;

    FriendsList::iterator i = std::lower_bound(connections.begin(),
					       connections.end(),
					       data,
					       FriendsCmp);

    connections.insert(i, data);
  }

  if (data->reading) {
    // Skip past any colour codes at the start of the line.
    char * pc = buf;
    
    while (*pc == '\033') {
      pc++;
      
      while (!isalpha(*pc))
	pc++;
      
      pc++;
    }      

    if (*pc == ' ' && *(pc + 3) == ' ') { // continuing friends channel comm.
      // Append a papaya colour after the first colour codes.
      
      char colour_code[20];

      if (data->channel > MAX_CHANNELS || data->channel < MIN_CHANNELS)
	return;

      snprintf(colour_code, 20, "\033[%3.3d;%3.3d;%3.3dp",
	       colour_table[data->channel].red, 
	       colour_table[data->channel].green, 
	       colour_table[data->channel].blue);
      
      memmove(pc + strlen(colour_code), pc, strlen(pc) + 1);
      memcpy(pc, colour_code, strlen(colour_code));
      return;
    }

    data->reading = false;

    // Not a continuing communication.  Put Papaya reset at the start
    // of the line _before_ any colour codes.

    memmove(buf + strlen("\033[q"), buf, strlen(buf) + 1);
    memcpy(buf, "\033[q", strlen("\033[q"));

    // Drop through to the bottom case as it may be more friends channel
    // chat.
  }

  // Does this line start with [colour code]* (number)
  char * pc = buf;

  while (*pc == '\033') {
    pc++;

    while (!isalpha(*pc))
      pc++;

    pc++;
  }

  // Should be at the end of the colour code now.  Sanity check.
  if (pc - buf > (int)strlen(buf))
    return;

  if (*pc == '*') { // Friends channel message.
    if (sscanf(pc, "* (%d)", &data->channel) == 1) {
      // Insert a Papaya colour code.
      char colour_code[20];

      if (data->channel > MAX_CHANNELS || data->channel < MIN_CHANNELS)
	return;

      snprintf(colour_code, 20, "\033[%3.3d;%3.3d;%3.3dp",
	       colour_table[data->channel].red, 
	       colour_table[data->channel].green, 
	       colour_table[data->channel].blue);
      
      memmove(pc + strlen(colour_code), pc, strlen(pc) + 1);
      memcpy(pc, colour_code, strlen(colour_code));
      data->reading = true;
    }
  }

  return;
}

