#ifndef INCLUDE_MAPPER_H
#define INCLUDE_MAPPER_H

#include "Area.h"
#include "PapayaList.h"

#define MAX_EXITS 10
#define MAX_BUF_LEN 16384

// Structure for holding the mapping data per connection.
struct mapper_data {
  bool recording;
  char record_buf[MAX_BUF_LEN];
  char cmd[MAX_BUF_LEN];
};

struct directions {
  int direction;
  char * full_name;
  char * abbreviated_name;
  int x_mod; //+ve = east
  int y_mod; //+ve = north
  int z_mod; //+ve = up
};

class Mapper {
  
 public:

  Mapper();
  ~Mapper();

  void newRoom(struct mapper_data *);
  void save();

 private:

  // All the areas this mapper has.
  PapayaList * areaList;

  // The current area being mapped.
  Area * area;

};

#endif
