import papaya
import string

from gtk import *

popup_major = "1"
popup_minor = "0"

def popup_init():
    global popup_data
    global popup_col

    popup_data = ""
    papaya.input_add('popup_input')
    papaya.message("Python: Popup Plugin", "Popup plugin version " + popup_major + "." + popup_minor + " is now active.")

    popup_col = []

    popup_add_color(0x0000, 0x0000, 0x0000)
    popup_add_color(0xcccc, 0x0000, 0x0000)
    popup_add_color(0x0000, 0xcccc, 0x0000)
    popup_add_color(0xcccc, 0xcccc, 0x0000)
    popup_add_color(0x0000, 0x0000, 0xcccc)
    popup_add_color(0xcccc, 0x0000, 0xcccc)
    popup_add_color(0x0000, 0xcccc, 0xcccc)
    popup_add_color(0xcccc, 0xcccc, 0xcccc)

    popup_add_color(0x0000, 0x0000, 0x0000)
    popup_add_color(0xffff, 0x0000, 0x0000)
    popup_add_color(0x0000, 0xffff, 0x0000)
    popup_add_color(0xffff, 0xffff, 0x0000)
    popup_add_color(0x0000, 0x0000, 0xffff)
    popup_add_color(0xffff, 0x0000, 0xffff)
    popup_add_color(0x0000, 0xffff, 0xffff)
    popup_add_color(0xffff, 0xffff, 0xffff)

def popup_input(input):

    if input[0:5] == 'popup':
        papaya.turf_protocol_add(input[6:], 'popup_callback', input[6:])
        return ""

    return input

def popup_callback(input, data):
    global popup_data

    if input == None:
        popup_create_popup("Popup: " + data, popup_data)
        popup_data = ""
        return

    if ord(input[0]) == 0x1f:
        return

    popup_data = popup_data + input
    
def popup_create_popup(title, string):

    window = GtkWindow(WINDOW_TOPLEVEL)
    window.set_title(title)
    window.set_usize(500, 190)

    text_box = GtkHBox(0, 2)
    text_box.show()

    text = GtkText(None, None)
    text.set_editable(0)
    text.set_word_wrap(1)

    text_box.pack_start(text, 1, 1, 0)
    text.show()

    font = load_font("-*-courier-medium-r-normal-*-*-100-*-*-*-*-*-*")

    vscrollbar = GtkVScrollbar(text.get_vadjustment())
    text_box.pack_start(vscrollbar, 0, 0, 0)
    vscrollbar.show()

    window.add(text_box)
    text_box.show()
    window.show()

    popup_insert_string(window, text, font, string)

def popup_add_color(red, green, blue):
    global popup_col

    color = popup_make_color(red, green, blue)
    popup_col.append(color)

def popup_make_color(red, green, blue):

    if red > 32767:
        red = -65536 + red

    if green > 32767:
        green = -65536 + green

    if blue > 32767:
        blue = -65536 + blue

    return GdkColor(red, green, blue)


def popup_insert_string(window, text, font, string):
    global popup_col

    colour_code = 0
    code = ""

    fg = -1
    bg = -1
    bold = 0

    # Need to iterate through the string looking for colour codes.

    text.freeze()

    for char in string:
        if colour_code == 1:
            if char in ['0','1','2','3','4','5','6','7','8','9']:
                code = code + char
                continue

            if char == '[':
                continue

            (fg, bg, bold) = popup_get_colour(code, fg, bg, bold)

            code = ""

            if char == ';':
                continue
            
            # Reset the colour code subhandler if we've finished completely.
            colour_code = 0
            continue

        if ord(char) == 0x1b:
            colour_code = 1
            continue


        if bold == 1:
            if fg == -1 and bg == -1:
                text.insert(font, None, None, char)
                continue

            text.insert(font, popup_col[fg+8], popup_col[bg], char)
        else:

            if fg == -1 and bg == -1:
                text.insert(font, None, None, char)
                continue

            text.insert(font, popup_col[fg], popup_col[bg], char)

    text.thaw()

def popup_get_colour(code, fg, bg, bold):

    if code == '':
        return (fg, bg, bold)

    if code == '0':
        return (-1, -1, 0)

    if code == '1':
        return (fg, bg, 1)

    if code[0] == '3':
        return (string.atoi(code[1]), bg, bold)

    if code[0] == '4':
        return (fg, string.atoi(code[1]), bold)

    return (fg, bg, bold)

popup_init()
