#include <stdio.h>
#include <string.h>

#include "mudclient.h"

#include "PapayaList.h"
#include "PluginHandler.h"
#include "PapayaUsers.h"

#include "libusers.h"

extern PluginHandler * phandler;
static PapayaUsers * pu = NULL;

static List * userlist = NULL;

struct users {
  gint timeout;
  GtkWidget * widget;
  GtkWidget * event_box;
  GtkWidget * frame;
};

#define MAJOR "1"
#define MINOR "1"


#ifndef BUILTIN_PLUGINS
extern "C" char * plugin_query_name() {
  return "PapayaUsers";
}

extern "C" char * plugin_query_description() {
  return _("Displays an estimate of the number of people currently using Papaya version > 0.67");
}

extern "C" char * plugin_query_major() {
  return MAJOR;
}

extern "C" char * plugin_query_minor() {
  return MINOR;
}

extern "C" void plugin_init(void) {
  pu = new PapayaUsers();
}

extern "C" void plugin_cleanup(void) {
  delete pu;
}
#endif

PapayaUsers::PapayaUsers() {
  userlist = new List();

  version = 0.1;
  name =  strdup("Number of Papaya users");
  phandler->registerPlugin(this, VERSION);

}

PapayaUsers::~PapayaUsers() {
  free(name);
  name = NULL;
  delete userlist;
  userlist = NULL;

  phandler->unregisterPlugin(this);
}

int papaya_users_timeout(gpointer);

// ALl hell may break loose here if the widgets are gone...

int papaya_users_callback(int result, void * d) {
  struct users * data = (struct users *)d;
  char buf[1024];
  int t = 1000 * 60 * 10; // Every ten minutes, change to suit.

  sprintf(buf, "%d users", result);

  gtk_label_set_text(GTK_LABEL(data->widget), buf);

  data->timeout = gtk_timeout_add(t, papaya_users_timeout, (gpointer)data);

  // Tell the timer not to repeat.
  return 0;
}

int papaya_users_timeout(gpointer d) {
  struct users * data = (struct users *)d;

  count_number_of_users(papaya_users_callback, (void *)data);

  // Nuke the timeout as the papaya_users_callback will set another.
  gtk_timeout_remove(data->timeout);
  data->timeout = 0;
  return 0;
}

void PapayaUsers::onEvent(Event * e, Connection * c) {

  if (e->getType() == EvConnect) {

    struct users * data;

    ListElement * tmp = userlist->findEntry(c);
    if (!tmp)
      tmp = userlist->newEntry(c, NULL);

    data = (struct users *)tmp->getData();
    if (!data) {
      data = (struct users *)malloc(sizeof(struct users));
      tmp->setData(data);
    }

    count_number_of_users(papaya_users_callback, data);

    data->widget = gtk_label_new(_("Getting data"));
    gtk_widget_show(data->widget);

    data->event_box = gtk_event_box_new();
    gtk_container_add(GTK_CONTAINER(data->event_box), data->widget);

    GtkTooltips * t = gtk_tooltips_new();
    gtk_tooltips_set_tip(t, data->event_box, _("PapayaUsers: displays the estimated number of current Papaya users.  This plugin is not necessary from version 0.85 onwards when using the Gnome interface."), NULL);

    c->getVT()->addToTray(data->event_box, &data->frame);
    return;
  }

  if (e->getType() == EvDisconnect) {
    struct users * data;
    ListElement * tmp = userlist->findEntry(c);
    if (!tmp)
      return;

    data = (struct users *)tmp->getData();

    gtk_timeout_remove(data->timeout);
    c->getVT()->removeFromTray(data->event_box, data->frame);
    userlist->deleteEntry(c);
  }

}
