/******************************************************************************
 *                                                                            *
 * Programm:  paul                                                            *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                 *
 *            (L)aserbildern                                                  *
 * Modul:     delscanb.c                                                      *
 *            Funktions to cut of the "bright" border of an image             *
 *            This is done by cutting the "dark" border of the negative image *
 * Author:    Andreas Tille                                                   *
 * Date:      03.06.1998                                                      *
 * Copyright: Andreas Tille, 1999; GNU Public License                         *
 *                                                                            *
 ******************************************************************************/

#include <stdio.h>
#include <string.h>

#include "paul.h" 

int DeleteScannerBorder(PAUL *p)
/* cut bright border of images
 * way: negativ of image -- cut dark border -- negativ of image
 * --- parameter: ---
 * PAUL *p                    : list of images, options
 *                            : used options: 
 *                              flag : Scannerrand
 * --- return: ---
 * int   DeleteScannerBorder(): RET_ERR or RET_OK
 */
{
  PICTURE *bild;
  GList   *pl;
  int      thresh, terr;
   
  g_return_val_if_fail ( IS_PAUL(p), RET_ERR );
  g_return_val_if_fail ( CheckPicList(p->piclist), RET_ERR );

  /* Negieren */
  for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
    if ( IsMonochrom(bild) && bild->storepix == 3 ) 
      NegativBuffer(bild->DATA + 1, bild->storepix*bild->size, 3);
    else 
      NegativBuffer(bild->DATA, bild->storepix*bild->size, 1);
  }
  /* Rand abschneiden */
  thresh         = p->opt->thresh;
  terr           = p->opt->terr;
  p->opt->thresh = DEFAULT_SCAN_THRESHOLD;
  p->opt->terr   = DEFAULT_SCAN_ERROR;
  g_return_val_if_fail( !SelectPictureWithoutBorder(p), RET_ERR ); 
  p->opt->thresh = thresh;
  p->opt->terr   = terr;
  /* Nochmal Negieren */
  for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
    if ( IsMonochrom(bild) && bild->storepix == 3 ) 
       NegativBuffer(bild->DATA + 1, bild->storepix*bild->size, 3);
    else 
       NegativBuffer(bild->DATA, bild->storepix*bild->size, 1);
  }
  return RET_OK;
}



