/*  Pcsx - Pc Psx Emulator
 *  Copyright (C) 1999-2002  Pcsx Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LINUX_H__
#define __LINUX_H__

#include "config.h"

#include "PsxCommon.h"
#include "Plugin.h"
#include <gtk/gtk.h>

extern int CancelQuit;
extern int UseGui;
char cfgfile[MAXPATHLEN];
char cfgfile_basename[256];

int LoadConfig();
void SaveConfig();

void StartGui();
void RunGui();

void ConfigurePlugins();
void ConfigureMemcards();

void PADhandleKey(int key);

void UpdateMenuSlots();

typedef struct {
	GtkWidget *Combo;
	GList *glist;
	char plist[255][255];
	int plugins;
} PluginConf;

PluginConf GpuConfS;
PluginConf SpuConfS;
PluginConf CdrConfS;
PluginConf Pad1ConfS;
PluginConf Pad2ConfS;
PluginConf NetConfS;
PluginConf BiosConfS;

static int needreset = 1;

#endif /* __LINUX_H__ */
