/*
 * Copyright (C) 2002-2003  Jean-Charles Salzeber <jc@varspool.net>
 *
 * This file is part of penggy.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *                
 * $Id: check.h,v 1.5 2003/02/01 13:45:29 chupa Exp $
 *               
 */

#ifndef __P3_CHECK_H__
#define __P3_CHECK_H__

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#include "p3/header.h"

int p3_check_header (struct p3hdr *header);
int p3_check_packet (struct p3hdr *header, char *data, size_t data_size);
int p3_check_ordering (struct p3hdr *header);
u_int16_t p3_crc16 (char *buffer, int length);


#endif /* __P3_CHECK_H__ */
