/* -*- C++ -*- (but, this file is C program) */ 
#ifdef __cplusplus
extern "C" {
#endif
#if FT10
#include <freetype-1.0.h>
#elif FT11
#include <freetype-1.1.h>
#else
#include <freetype.h>
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif


#define STORE_OBJ(obj, elem, sv)\
	hv_store((obj), #elem, sizeof(#elem)-1, sv, 0)
#define STORE_OBJ_IV(obj, var, elem)\
	STORE_OBJ((obj), elem, newSViv((var)->elem))
#define STORE_OBJ_PV(obj, var, elem)\
	STORE_OBJ((obj), elem, newSVpv((var)->elem, sizeof((var)->elem)))
#define STORE_OBJ_IVs(obj, var, arrayElem)\
	{\
	    int STORE_OBJ_IVs_i;\
	    AV *STORE_OBJ_IVs_av = newAV();\
	    for (STORE_OBJ_IVs_i=0;\
	         STORE_OBJ_IVs_i<\
			sizeof((var)->arrayElem)/sizeof((var)->arrayElem[0]);\
	         STORE_OBJ_IVs_i++)\
		av_push(STORE_OBJ_IVs_av,\
			newSViv((var)->arrayElem[STORE_OBJ_IVs_i]));\
	    STORE_OBJ((obj), arrayElem, newRV_noinc((SV*)STORE_OBJ_IVs_av));\
	}
#define STORE_OBJ_IVsn(obj, var, arrayElem, items)\
	{\
	    int STORE_OBJ_IVsn_i;\
	    AV *STORE_OBJ_IVsn_av = newAV();\
	    for (STORE_OBJ_IVsn_i=0;\
	         STORE_OBJ_IVsn_i<items;\
	         STORE_OBJ_IVsn_i++)\
		av_push(STORE_OBJ_IVsn_av,\
			newSViv((var)->arrayElem[STORE_OBJ_IVsn_i]));\
	    STORE_OBJ((obj), arrayElem, newRV_noinc((SV*)STORE_OBJ_IVsn_av));\
	}
#define STORE_OBJ_IVsnp(obj, var, arrayElem, items)\
	{\
	    int STORE_OBJ_IVsn_i;\
	    AV *STORE_OBJ_IVsn_av = newAV();\
	    for (STORE_OBJ_IVsn_i=0;\
	         STORE_OBJ_IVsn_i<items;\
	         STORE_OBJ_IVsn_i++)\
		av_push(STORE_OBJ_IVsn_av,\
			newSViv((var)->arrayElem[STORE_OBJ_IVsn_i].x));\
	    for (STORE_OBJ_IVsn_i=0;\
	         STORE_OBJ_IVsn_i<items;\
	         STORE_OBJ_IVsn_i++)\
		av_push(STORE_OBJ_IVsn_av,\
			newSViv((var)->arrayElem[STORE_OBJ_IVsn_i].y));\
	    STORE_OBJ((obj), arrayElem, newRV_noinc((SV*)STORE_OBJ_IVsn_av));\
	}

#define FETCH_OBJ(obj, elem, sv, objname)\
	{\
	    SV **FETCH_OBJ_tmp;\
	    if (NULL !=\
		 (FETCH_OBJ_tmp = hv_fetch((obj), #elem, sizeof(#elem)-1, 0)))\
		(sv) = *FETCH_OBJ_tmp;\
	    else\
		croak("Illegal Object --- " #objname ".");\
	}
#define FETCH_OBJ_IV(obj, var, elem, objname)\
	{\
	    SV *FETCH_OBJ_IV_sv;\
	    FETCH_OBJ((obj), elem, FETCH_OBJ_IV_sv, objname);\
	    (var)->elem = SvIV(FETCH_OBJ_IV_sv);\
	}
#define FETCH_OBJ_IVsn(obj, var, arrayElem, items, objname)\
	{\
	    int FETCH_OBJ_IVsn_i;\
	    SV **FETCH_OBJ_tmp;\
	    SV *FETCH_OBJ_IVsn_sv;\
	    AV *FETCH_OBJ_IVsn_av;\
	    FETCH_OBJ((obj), arrayElem, FETCH_OBJ_IVsn_sv, objname);\
	    FETCH_OBJ_IVsn_av = (AV*)SvRV(FETCH_OBJ_IVsn_sv);\
	    for (FETCH_OBJ_IVsn_i=0;\
	         FETCH_OBJ_IVsn_i<items;\
	         FETCH_OBJ_IVsn_i++) {\
		if (NULL !=\
		       (FETCH_OBJ_tmp = av_fetch(FETCH_OBJ_IVsn_av,\
						 FETCH_OBJ_IVsn_i, 0)))\
		    FETCH_OBJ_IVsn_sv = *FETCH_OBJ_tmp;\
		else\
		    croak("Illegal Object --- " #objname ".");\
		(var)->arrayElem[FETCH_OBJ_IVsn_i] = SvIV(FETCH_OBJ_IVsn_sv);\
	    }\
	}
#define FETCH_OBJ_IVsnp(obj, var, arrayElem, items, objname)\
	{\
	    int FETCH_OBJ_IVsn_i;\
	    SV **FETCH_OBJ_tmp;\
	    SV *FETCH_OBJ_IVsn_sv;\
	    AV *FETCH_OBJ_IVsn_av;\
	    FETCH_OBJ((obj), arrayElem, FETCH_OBJ_IVsn_sv, objname);\
	    FETCH_OBJ_IVsn_av = (AV*)SvRV(FETCH_OBJ_IVsn_sv);\
	    for (FETCH_OBJ_IVsn_i=0;\
	         FETCH_OBJ_IVsn_i<items;\
	         FETCH_OBJ_IVsn_i++) {\
		if (NULL !=\
		       (FETCH_OBJ_tmp = av_fetch(FETCH_OBJ_IVsn_av,\
						 FETCH_OBJ_IVsn_i, 0)))\
		    FETCH_OBJ_IVsn_sv = *FETCH_OBJ_tmp;\
		else\
		    croak("Illegal Object --- " #objname ".");\
		(var)->arrayElem[FETCH_OBJ_IVsn_i].x = SvIV(FETCH_OBJ_IVsn_sv);\
	    }\
	    for (FETCH_OBJ_IVsn_i=0;\
	         FETCH_OBJ_IVsn_i<items;\
	         FETCH_OBJ_IVsn_i++) {\
		if (NULL !=\
		       (FETCH_OBJ_tmp = av_fetch(FETCH_OBJ_IVsn_av,\
						 FETCH_OBJ_IVsn_i+items, 0)))\
		    FETCH_OBJ_IVsn_sv = *FETCH_OBJ_tmp;\
		else\
		    croak("Illegal Object --- " #objname ".");\
		(var)->arrayElem[FETCH_OBJ_IVsn_i].y = SvIV(FETCH_OBJ_IVsn_sv);\
	    }\
	}

	    

/* TT_Header -> hash obj */

HV *conv_header_to_hash_obj(TT_Header *var)
{
    HV *obj = newHV();

    STORE_OBJ_IV(obj, var, Table_Version);
    STORE_OBJ_IV(obj, var, Font_Revision);
    STORE_OBJ_IV(obj, var, CheckSum_Adjust);
    STORE_OBJ_IV(obj, var, Magic_Number);
    STORE_OBJ_IV(obj, var, Flags);
    STORE_OBJ_IV(obj, var, Units_Per_EM);
    STORE_OBJ_IVs(obj, var, Created);
    STORE_OBJ_IVs(obj, var, Modified);
    STORE_OBJ_IV(obj, var, xMin);
    STORE_OBJ_IV(obj, var, yMin);
    STORE_OBJ_IV(obj, var, xMax);
    STORE_OBJ_IV(obj, var, yMax);
    STORE_OBJ_IV(obj, var, Mac_Style);
    STORE_OBJ_IV(obj, var, Lowest_Rec_PPEM);
    STORE_OBJ_IV(obj, var, Font_Direction);
    STORE_OBJ_IV(obj, var, Index_To_Loc_Format);
    STORE_OBJ_IV(obj, var, Glyph_Data_Format);

    return obj;
}


/* TT_Horizontal_Header -> hash obj */

HV *conv_horizontal_header_to_hash_obj(TT_Horizontal_Header *var)
{
    HV *obj = newHV();

    STORE_OBJ_IV(obj, var, Version);
    STORE_OBJ_IV(obj, var, Ascender);
    STORE_OBJ_IV(obj, var, Descender);
    STORE_OBJ_IV(obj, var, Line_Gap);
    STORE_OBJ_IV(obj, var, advance_Width_Max);
    STORE_OBJ_IV(obj, var, min_Left_Side_Bearing);
    STORE_OBJ_IV(obj, var, min_Right_Side_Bearing);
    STORE_OBJ_IV(obj, var, xMax_Extent);
    STORE_OBJ_IV(obj, var, caret_Slope_Rise);
    STORE_OBJ_IV(obj, var, caret_Slope_Run);
#if FT10 || FT11
    STORE_OBJ_IVs(obj, var, Reserved);
#else
    STORE_OBJ_IV(obj, var, Reserved0);
    STORE_OBJ_IV(obj, var, Reserved1);
    STORE_OBJ_IV(obj, var, Reserved2);
    STORE_OBJ_IV(obj, var, Reserved3);
    STORE_OBJ_IV(obj, var, Reserved4);
#endif
    STORE_OBJ_IV(obj, var, metric_Data_Format);
    STORE_OBJ_IV(obj, var, number_Of_HMetrics);

    return obj;
}


/* TT_OS2 -> hash obj */

HV *conv_os2_to_hash_obj(TT_OS2 *var)
{
    HV *obj = newHV();

    STORE_OBJ_IV(obj, var, version);
    STORE_OBJ_IV(obj, var, xAvgCharWidth);
    STORE_OBJ_IV(obj, var, usWeightClass);
    STORE_OBJ_IV(obj, var, usWidthClass);
    STORE_OBJ_IV(obj, var, fsType);
    STORE_OBJ_IV(obj, var, ySubscriptXSize);
    STORE_OBJ_IV(obj, var, ySubscriptYSize);
    STORE_OBJ_IV(obj, var, ySubscriptXOffset);
    STORE_OBJ_IV(obj, var, ySubscriptYOffset);
    STORE_OBJ_IV(obj, var, ySuperscriptXSize);
    STORE_OBJ_IV(obj, var, ySuperscriptYSize);
    STORE_OBJ_IV(obj, var, ySuperscriptXOffset);
    STORE_OBJ_IV(obj, var, ySuperscriptYOffset);
    STORE_OBJ_IV(obj, var, yStrikeoutSize);
    STORE_OBJ_IV(obj, var, yStrikeoutPosition);
    STORE_OBJ_IV(obj, var, sFamilyClass);
    STORE_OBJ_PV(obj, var, panose);
    STORE_OBJ_IV(obj, var, ulUnicodeRange1);
    STORE_OBJ_IV(obj, var, ulUnicodeRange2);
    STORE_OBJ_IV(obj, var, ulUnicodeRange3);
    STORE_OBJ_IV(obj, var, ulUnicodeRange4);
    STORE_OBJ_PV(obj, var, achVendID);
    STORE_OBJ_IV(obj, var, fsSelection);
    STORE_OBJ_IV(obj, var, usFirstCharIndex);
    STORE_OBJ_IV(obj, var, usLastCharIndex);
    STORE_OBJ_IV(obj, var, sTypoAscender);
    STORE_OBJ_IV(obj, var, sTypoDescender);
    STORE_OBJ_IV(obj, var, sTypoLineGap);
    STORE_OBJ_IV(obj, var, usWinAscent);
    STORE_OBJ_IV(obj, var, usWinDescent);
    STORE_OBJ_IV(obj, var, ulCodePageRange1);
    STORE_OBJ_IV(obj, var, ulCodePageRange2);

    return obj;
}


/* TT_Postscript -> hash obj */

HV *conv_postscript_to_hash_obj(TT_Postscript *var)
{
    HV *obj = newHV();

    STORE_OBJ_IV(obj, var, FormatType);
    STORE_OBJ_IV(obj, var, italicAngle);
    STORE_OBJ_IV(obj, var, underlinePosition);
    STORE_OBJ_IV(obj, var, underlineThickness);
    STORE_OBJ_IV(obj, var, isFixedPitch);
    STORE_OBJ_IV(obj, var, minMemType42);
    STORE_OBJ_IV(obj, var, maxMemType42);
    STORE_OBJ_IV(obj, var, minMemType1);
    STORE_OBJ_IV(obj, var, maxMemType1);

    return obj;
}


/* TT_Face_Properties -> hash obj */

HV *conv_face_properties_to_hash_obj(TT_Face_Properties *var)
{
    HV *obj = newHV();

    STORE_OBJ_IV(obj, var, num_Glyphs);
    STORE_OBJ_IV(obj, var, max_Points);
    STORE_OBJ_IV(obj, var, max_Contours);
    STORE_OBJ_IV(obj, var, num_Faces);
    STORE_OBJ(obj, header,
              newRV_noinc((SV*)conv_header_to_hash_obj(var->header)));
    STORE_OBJ(obj, horizontal,
              newRV_noinc(
                  (SV*)conv_horizontal_header_to_hash_obj(var->horizontal)));
    STORE_OBJ(obj, os2, newRV_noinc((SV*)conv_os2_to_hash_obj(var->os2)));
    STORE_OBJ(obj, postscript,
              newRV_noinc((SV*)conv_postscript_to_hash_obj(var->postscript)));
    /*
    av_push(obj, newSVpv((char*)var->hdmx, sizeof(*var->hdmx)));
    */

    return obj;
}


/* TT_Outline -> hash obj */

HV* conv_outline_to_hash_obj(TT_Outline *var)
{
    HV *obj = newHV();

#if FT10
    STORE_OBJ_IV(obj, var, contours);
    STORE_OBJ_IV(obj, var, points);
    STORE_OBJ_IVsn(obj, var, conEnds, var->contours);
    STORE_OBJ_IVsn(obj, var, xCoord, var->points);
    STORE_OBJ_IVsn(obj, var, yCoord, var->points);
    STORE_OBJ_IVsn(obj, var, flag, var->points);
#else
    STORE_OBJ_IV(obj, var, n_contours);
    STORE_OBJ_IV(obj, var, n_points);
    STORE_OBJ_IVsnp(obj, var, points, var->n_points);
    STORE_OBJ_IVsn(obj, var, flags, var->n_points);
    STORE_OBJ_IVsn(obj, var, contours, var->n_contours);
#endif
    STORE_OBJ_IV(obj, var, high_precision);
    STORE_OBJ_IV(obj, var, second_pass);
    STORE_OBJ_IV(obj, var, dropout_mode);

    if (var->owner) {
        TT_Done_Outline(var);
    }

    return obj;
}


/* hash obj -> TT_Outline */

TT_Error conv_hash_obj_to_outline(TT_Outline *var, HV* obj)
{
    int num_points, num_contours;
    SV *tmp;
    TT_Error err = TT_Err_Ok;

#if FT10
    FETCH_OBJ(obj, points, tmp, TT_Outline);
    num_points = SvIV(tmp);
    FETCH_OBJ(obj, contours, tmp, TT_Outline);
    num_contours = SvIV(tmp);
#else
    FETCH_OBJ(obj, n_points, tmp, TT_Outline);
    num_points = SvIV(tmp);
    FETCH_OBJ(obj, n_contours, tmp, TT_Outline);
    num_contours = SvIV(tmp);
#endif
    
    TT_New_Outline(num_points, num_contours, var);

#if FT10
    var->points = num_points;
    var->contours = num_contours;
    FETCH_OBJ_IVsn(obj, var, conEnds, var->contours, TT_Outline);
    FETCH_OBJ_IVsn(obj, var, xCoord, var->points, TT_Outline);
    FETCH_OBJ_IVsn(obj, var, yCoord, var->points, TT_Outline);
    FETCH_OBJ_IVsn(obj, var, flag, var->points, TT_Outline);
#else
    var->n_points = num_points;
    var->n_contours = num_contours;
    FETCH_OBJ_IVsnp(obj, var, points, var->n_points, TT_Outline);
    FETCH_OBJ_IVsn(obj, var, flags, var->n_points, TT_Outline);
    FETCH_OBJ_IVsn(obj, var, contours, var->n_contours, TT_Outline);
#endif
    FETCH_OBJ_IV(obj, var, high_precision, TT_Outline);
    FETCH_OBJ_IV(obj, var, second_pass, TT_Outline);
    FETCH_OBJ_IV(obj, var, dropout_mode, TT_Outline);

    return err;
}


/* TT_BBox -> hash obj */

HV *conv_bbox_to_hash_obj(TT_BBox *var)
{
    HV *obj = newHV();

    STORE_OBJ_IV(obj, var, xMin);
    STORE_OBJ_IV(obj, var, yMin);
    STORE_OBJ_IV(obj, var, xMax);
    STORE_OBJ_IV(obj, var, yMax);

    return obj;
}



MODULE = FreeType		PACKAGE = FreeType		

TT_Error
TT_Init_FreeType(engine)
	TT_Engine &engine = NO_INIT
	OUTPUT:
	engine

TT_Error
TT_Done_FreeType(engine)
	TT_Engine engine

TT_Error
TT_Set_Raster_Gray_Palette(engine, p0, p1, p2, p3, p4)
	TT_Engine engine
	int p0
	int p1
	int p2
	int p3
	int p4
	CODE:
	{
		char entity[5];
		entity[0] = (char)p0;
		entity[1] = (char)p1;
		entity[2] = (char)p2;
		entity[3] = (char)p3;
		entity[4] = (char)p4;
		RETVAL = TT_Set_Raster_Gray_Palette(engine, entity);
	}
	OUTPUT:
	RETVAL

TT_Error
TT_Open_Face(engine, fontpathname, face)
	TT_Engine engine
	char* fontpathname
	TT_Face &face = NO_INIT
	OUTPUT:
	face

TT_Error
TT_Open_Collection(engine, fontpathname, fontIndex, face)
	TT_Engine engine
	char* fontpathname
	int fontIndex
	TT_Face &face = NO_INIT
	OUTPUT:
	face

TT_Error
TT_Get_Face_Properties(face, properties)
	TT_Face face
	TT_Face_Properties &properties = NO_INIT
	OUTPUT:
	properties

# TT_Set_Face_Pointer
# TT_Get_Face_Pointer

TT_Error
TT_Flush_Face(face)
	TT_Face face

TT_Error
TT_Close_Face(face)
	TT_Face face

# TT_Get_Font_Data

TT_Error
TT_New_Instance(face, instance)
	TT_Face face
	TT_Instance &instance = NO_INIT
	OUTPUT:
	instance

TT_Error
TT_Set_Instance_Resolutions(instance, x_resolution, y_resolution)
	TT_Instance instance
	int x_resolution
	int y_resolution

TT_Error
TT_Set_Instance_CharSize(instance, charSize)
	TT_Instance instance
	TT_F26Dot6 charSize

TT_Error
TT_Set_Instance_CharSizes(instance, charWidth, charHeight)
	TT_Instance instance
	TT_F26Dot6 charWidth
	TT_F26Dot6 charHeight

TT_Error
TT_Set_Instance_PointSize(instance, ptsize)
	TT_Instance instance
	TT_F26Dot6 ptsize

TT_Error
TT_Set_Instance_PixelSizes(instance, pixelWidth, pixelHeight, pointSize)
	TT_Instance instance
	int pixelWidth
	int pixelHeight
	TT_F26Dot6 pointSize

TT_Error
TT_Set_Instance_Transform_Flags(instance, rotated, stretched)
	TT_Instance instance
	int rotated
	int stretched

TT_Error
TT_Get_Instance_Metrics(instance, metrics)
	TT_Instance instance
	TT_Instance_Metrics &metrics = NO_INIT
	OUTPUT:
	metrics

# TT_Set_Instance_Pointer
# TT_Get_Instance_Pointer

TT_Error
TT_Done_Instance(instance)
	TT_Instance instance

TT_Error
TT_New_Glyph(face, glyph)
	TT_Face face
	TT_Glyph &glyph = NO_INIT
	OUTPUT:
	glyph

TT_Error
TT_Done_Glyph(glyph)
	TT_Glyph glyph

TT_Error
TT_Load_Glyph(instance, glyph, glyph_index, load_flags)
	TT_Instance instance
	TT_Glyph glyph
	int glyph_index
	int load_flags

TT_Error
TT_Get_Glyph_Outline(glyph, outline)
	TT_Glyph glyph
	TT_Outline &outline = NO_INIT
	OUTPUT:
	outline

TT_Error
TT_Get_Glyph_Metrics(glyph, metrics)
	TT_Glyph glyph
	TT_Glyph_Metrics &metrics = NO_INIT
	OUTPUT:
	metrics

TT_Error
TT_Get_Glyph_Bitmap(glyph, raster_map, x_offset, y_offset)
	TT_Glyph glyph
	TT_Raster_Map &raster_map
	TT_F26Dot6 x_offset
	TT_F26Dot6 y_offset

TT_Error
TT_Get_Glyph_Pixmap(glyph, raster_map, x_offset, y_offset)
	TT_Glyph glyph
	TT_Raster_Map &raster_map
	TT_F26Dot6 x_offset
	TT_F26Dot6 y_offset

TT_Error
TT_New_Outline(num_points, num_contours, outline)
	int num_points
	int num_contours
	TT_Outline &outline = NO_INIT
	OUTPUT:
	outline

TT_Error
TT_Done_Outline(outline)
	TT_Outline &outline = NO_INIT
	CODE:
	;

TT_Error
TT_Copy_Outline(source, target)
	TT_Outline &source
	TT_Outline &target = NO_INIT
	OUTPUT:
	target

TT_Error
TT_Get_Outline_Bitmap(engine, outline, raster_map)
	TT_Engine engine
	TT_Outline &outline
	TT_Raster_Map &raster_map

TT_Error
TT_Get_Outline_Pixmap(engine, outline, raster_map)
	TT_Engine engine
	TT_Outline &outline
	TT_Raster_Map &raster_map

TT_Error
TT_Get_Outline_BBox(outline, bbox)
	TT_Outline &outline
	TT_BBox &bbox = NO_INIT
	OUTPUT:
	bbox

void
TT_Transform_Outline(outline, matrix)
	TT_Outline &outline
	TT_Matrix &matrix
	OUTPUT:
	outline

void
TT_Translate_Outline(outline, x_offset, y_offset)
	TT_Outline &outline
	TT_F26Dot6 x_offset
	TT_F26Dot6 y_offset
	OUTPUT:
	outline

void
TT_Transform_Vector(x, y, matrix)
	TT_F26Dot6 &x
	TT_F26Dot6 &y
	TT_Matrix &matrix
	OUTPUT:
	x
	y

# Following functions are not implemented.
#
#void
#TT_Matrix_Multiply(a, b)
#	TT_Matrix &a
#	TT_Matrix &b
#	OUTPUT:
#	b
#
#TT_Error
#TT_Matrix_Invert(matrix)
#	TT_Matrix &matrix
#	OUTPUT:
#	matrix

int
TT_Get_CharMap_Count(face)
	TT_Face face

TT_Error
TT_Get_CharMap_ID(face, charmapIndex, platformID, encodingID)
	TT_Face face
	int charmapIndex
	short &platformID = NO_INIT
	short &encodingID = NO_INIT
	OUTPUT:
	platformID
	encodingID

TT_Error
TT_Get_CharMap(face, charmapIndex, charMap)
	TT_Face face
	int charmapIndex
	TT_CharMap &charMap = NO_INIT
	OUTPUT:
	charMap

int
TT_Char_Index(charMap, charCode)
	TT_CharMap charMap
	unsigned short charCode

int
TT_Get_Name_Count(face)
	TT_Face face

TT_Error
TT_Get_Name_ID(face, nameIndex, platformID, encodingID, languageID, nameID)
	TT_Face face
	int nameIndex
	short &platformID = NO_INIT
	short &encodingID = NO_INIT
	short &languageID = NO_INIT
	short &nameID = NO_INIT
	OUTPUT:
	platformID
	encodingID
	languageID
	nameID

TT_Error
TT_Get_Name_String(face, nameIndex, string)
	TT_Face face
	int nameIndex
	char *string = NO_INIT
	CODE:
	{
		char *stringPtr;
#if FT10
		int len;
#else
		TT_UShort len;
#endif
		RETVAL = TT_Get_Name_String(face, nameIndex, &stringPtr, &len);
		sv_setpvn(ST(2), stringPtr, len);
	}
	OUTPUT:
	RETVAL

