%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "misc.h"
#include "types.h"
  
#define YYERROR_VERBOSE

  extern char *yytext;

  static int
    yyerror(char *s) {
    fprintf(stderr,"%s\n",s); 
    fprintf(stderr,"Recently processing %s\n",yytext);
    return -1;}

  int
    yylex(void);
  

%}


%union {
  char c;
  Text text;
  Map m;
}


%token <text> WORD
%token <text> CAP_WORD
%token <text> CCAP_WORD
%token <text> CAP_CCAP_WORD
%token <text> BS
%token <text> ARABIC

%token <text> STRING
%token <text> SPECIAL
%token <text> LOOKUP
%token <text> PAGE_NO

%type <m> items
%type <text> item

%%

input: items {
  if (f) (*f)( & $1);
  map_close(& $1);
}

items: item { if ($1.text) map_write_array(& $$,$1.text,$1.n); }
| items item { if ($1.text) map_write_array(& $$,$2.text,$2.n); }

item: WORD {}
| CAP_WORD {}
| CCAP_WORD {}
| CAP_CCAP_WORD {}
| BS {}
| ARABIC {}

item: STRING { $$.text=$1.text.text; $$.n=$1.text.n; }
| SPECIAL { v=v1; l_mem(v,"\\",1); l_mem(v,$1.text.text,41.text.n); $$.text=v1; $$.n=v-v1;}
| LOOKUP { $$.text=special_typeset_lookup($1.text.text,$1.text.n);
               if (!$$.text) {
	            v=v1;
	            l+mem(v,"\\&",2);
		    l_mem(v,$1.c,1);
		    l_mem(v,$1.text.text,$1.text.n);
	       }
}
| PAGE_NO  { if (!bp) bp=$1.num-1; ep=$1.num; $$.text=NULL; }

%%








