import sys, os, gc
import glob
import unittest
from petsc4py import PETSc

version = PETSc.Sys.getVersion()
exclude = {'test_import':   True,
           'test_initfini': True,
           'test_log':      (2,3,2),
           }

directory = os.path.split(__file__)[0]
pattern = os.path.join(directory, 'test_*.py')
test_cases = []
for test_file in glob.glob(pattern):
    filename = os.path.basename(test_file)
    name = os.path.splitext(filename)[0]
    if name in exclude:
        if exclude[name] is True or \
           exclude[name] == version:
            continue
    test = __import__(name)
    test_cases.append(test)

def run_tests(test_cases):
    gc.collect()
    for test in test_cases:
        try:
            unittest.main(test)
        except SystemExit:
            pass
    gc.collect()

def main(test_cases, repeats=5):
    for i in xrange(repeats):
        r1 = sys.gettotalrefcount()
        run_tests(test_cases)
        r2 = sys.gettotalrefcount()
        rd = r2-r1
        print 'before: %d, after: %d, diff: [%d]' % (r1, r2, rd)
    

if __name__ == '__main__':
    if not hasattr(sys, 'gettotalrefcount'):
        raise SystemExit('only for debug builds of Python')
    def dummy_write(self,*args): pass
    unittest._WritelnDecorator.write   = dummy_write
    unittest._WritelnDecorator.writeln = dummy_write
    main(test_cases, 5)
    
