function pfs_write_rgb( fileName, varargin )
% Write an hdr image file (formats accepted by pfsout). You can
% specify additional options in fileName, such as
% '--compression=PXR24' for OpenEXR files. Check manual pages of
% pfsout* commands for the list of available options. 
% 
% pfs_write_rgb( fileName, R, G, B )
% pfs_write_rgb( fileName, img )
%
% R, G, B - red, green and blue color channels, given as linear response
% img - 3D matrix image, where img(:,:,1:3) represents red, blue and green
%       color channels

if( nargin == 4 )
    if( ~isnumeric(varargin{1}) || ~isnumeric(varargin{2}) || ~isnumeric(varargin{1}) )
        error( 'pfs_write_rgb: matrices of the equal size expected as an arguments' );
    end
    [X Y Z] = pfs_transform_colorspace( 'RGB', varargin{1}, varargin{2}, varargin{3}, 'XYZ' );    
elseif( nargin == 2 && ndims(varargin{1}) == 3 ) 
    [X Y Z] = pfs_transform_colorspace( 'RGB', varargin{1}(:,:,1), varargin{1}(:,:,2), varargin{1}(:,:,3), 'XYZ' );
else
    error( 'pfs_write_rgb: improper usage' );
end

%cmd = sprintf( '%spfsout %s%s', pfs_shell(), fileName, pfs_shell(1) )
fid = pfspopen( sprintf( '%spfsout ''%s''%s', pfs_shell(), fileName, pfs_shell(1) ), 'w' );    
pfs = pfsopen( fid, size( X ) );

pfs.channels.X = X;
pfs.channels.Y = Y;
pfs.channels.Z = Z;

pfsput( pfs );
pfsclose( pfs );
pfspclose( fid );

end
