# Copyright (C) 2007-2008  www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

from win32com.shell import shell
import pythoncom

def create(save_as, path,arguments = "", working_dir = "", 
        description = "", icon_path = None, icon_index = 0):
    # initialize shortcut
    shortcut = pythoncom.CoCreateInstance(shell.CLSID_ShellLink, None,
        pythoncom.CLSCTX_INPROC_SERVER, shell.IID_IShellLink)
 
    # set shortcut parameters
    shortcut.SetPath(path)
    shortcut.SetArguments(arguments)
    shortcut.SetWorkingDirectory(working_dir)
    shortcut.SetDescription(description)
    if icon_path:
        shortcut.SetIconLocation(icon_path,icon_index)
 
    # save shortcut
    shortcut.QueryInterface(pythoncom.IID_IPersistFile).Save(save_as, 1)