<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:expnd="http://wohlberg.net/xml/pmlexpand"
                version="1.0">


<!--
     This file sets up the necessary definitions for using the
     defaults expansion and merging XSL for PhotoML defaults
     expansion.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
 -->


  <!-- Stylesheet parameter specifying the set of nodes upon which
       defaults expansion is desired. -->
  <xsl:param name="relevant-elements" 
             select="document('')/*/expnd:relevant-element-tree/*"/>


  <!-- Include content model validation templates -->
  <xsl:include href="valid.xsl"/>
  <!-- Include defaults expansion functions and templates -->
  <xsl:include href="defaults.xsl"/>


  <!-- Specify the output properties -->
  <xsl:output method="xml" indent="yes"
	      doctype-public="-//BW//DTD PhotoML 0.12//EN"
              doctype-system="photo.dtd"/>


  <!-- A subtree specifying which elements are subject to defaults
       expansion. When the attribute 'insert' has value 'true', the
       corresponding element should be inserted into a subtree with
       the same name as its parent, even when that subtree has no
       corresponding child (upon which the usual defaults expansion
       mechanism would operate). -->
  <expnd:relevant-element-tree>
    <photo>
      <roll>
        <film insert='true'/>
        <processing insert='true'/>
        <frame/>
        <frame-set>
          <frame/>
        </frame-set>
      </roll>
      <sheet>
        <film/>
        <processing/>
        <frame/>
      </sheet>
      <digital>
        <frame/>
        <frame-set>
          <frame/>
        </frame-set>
      </digital>
      <digimage>
        <properties insert='true'/>
        <history insert='true'/>
      </digimage>
      <digimage-set>
        <digimage>
          <properties insert='true'/>
          <history insert='true'/>
        </digimage>
      </digimage-set>
    </photo>
  </expnd:relevant-element-tree>


</xsl:stylesheet>
