#include <iostream>

#include <gtk/gtkstock.h>
#include <gtk/gtkmain.h>

#include "pp_mainwindow.h"
#include "dialogs.h"
#include "support/generaldialogs.h"
#include "support/progressbar.h"

#include "pp_menu_options.h"

#include "config.h"
#include "gettext.h"
#define _(x) gettext(x)
#define N_(x) gettext_noop(x)

using namespace std;


static void options_paths(GtkAction *act,gpointer *ob)
{
	pp_MainWindow *mw=(pp_MainWindow *)ob;	
	Paths_Dialog(GTK_WINDOW(mw),*mw->state);
	pp_mainwindow_refresh(mw);
}


static void options_colourmanagement(GtkAction *act,gpointer *ob)
{
	pp_MainWindow *mw=(pp_MainWindow *)ob;	
	ColourManagement_Dialog(GTK_WINDOW(mw),*mw->state);
	mw->state->layout->FlushThumbnails();
	pp_mainwindow_refresh(mw);
}


static void options_units(GtkAction *act,gpointer *ob)
{
	pp_MainWindow *mw=(pp_MainWindow *)ob;
	Units_Dialog(GTK_WINDOW(mw),*mw->state);
	(mw->state->layout->SetUnitFunc())(mw->layout,mw->state->GetUnits());
}


static void options_scaling(GtkAction *act,gpointer *ob)
{
	pp_MainWindow *mw=(pp_MainWindow *)ob;
	Scaling_Dialog(GTK_WINDOW(mw),*mw->state);
}


static GtkActionEntry optionsmenu_entries[] = {
  { "OptionsMenu", NULL, N_("_Options") },

  { "Paths", NULL, N_("_Paths..."), NULL, N_("Set search paths for ICC profiles, borders, etc."), G_CALLBACK(options_paths) },
  { "ColourManagement", NULL, N_("_Colour Management..."), NULL, N_("Set colour management options"), G_CALLBACK(options_colourmanagement) },
  { "Units", NULL, N_("_Units..."), NULL, N_("Select the units used throughout PhotoPrint"), G_CALLBACK(options_units) },
  { "Scaling", NULL, N_("_Scaling..."), NULL, N_("Select the preferred scaling method."), G_CALLBACK(options_scaling) },
};


static const char *optionsmenu_ui_description =
"<ui>"
"  <menubar name='MainMenu'>"
"    <menu action='OptionsMenu'>"
"      <menuitem action='Paths'/>"
"      <menuitem action='ColourManagement'/>"
"      <menuitem action='Units'/>"
"      <menuitem action='Scaling'/>"
"    </menu>"
"  </menubar>"
"</ui>";


void BuildOptionsMenu(void *userdata,GtkUIManager *ui_manager)
{
	GError *error=NULL;
	GtkActionGroup *action_group;
	action_group = gtk_action_group_new ("OptionsMenuActions");
	gtk_action_group_set_translation_domain(action_group,PACKAGE);
	gtk_action_group_add_actions (action_group, optionsmenu_entries, G_N_ELEMENTS (optionsmenu_entries), userdata);
	gtk_ui_manager_insert_action_group (ui_manager, action_group, 0);
	
	if (!gtk_ui_manager_add_ui_from_string (ui_manager, optionsmenu_ui_description, -1, &error))
		throw error->message;
}
