<?php
/**
 * German Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Norgaz Kurt
 * @author Peter Pluntke
 * @author Gerd Kroll
 * @version $Id: configure_help.de.php 1846 2007-10-08 16:00:23Z canajun2eh $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Direkter Sprach-Dateien Zugriff ist nicht erlaubt.";
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "GEDCOM Grundlagen";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["media_general_conf"]	= "Allgemeines";
$pgv_lang["media_firewall_conf"]	= "Medien-Feuerwand";
$pgv_lang["accpriv_conf"]		= "Zugang und Privatsphäre";
$pgv_lang["displ_conf"]			= "Bildschirm und Layout";
$pgv_lang["displ_names_conf"]	= "Namen";
$pgv_lang["displ_comsurn_conf"] = "Häufigste Familiennamen";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]	= "Verbergen und Zeigen";
$pgv_lang["editopt_conf"]		= "Bearbeitungsoptionen";
$pgv_lang["useropt_conf"]		= "Benutzer Optionen";
$pgv_lang["contact_conf"]		= "Kontakt Information";
$pgv_lang["meta_conf"]			= "Konfiguration META Tags";
$pgv_lang["gedconf_head"]		= "GEDCOM Konfiguration";
$pgv_lang["other_theme"]		= "Anderes Darstellungsthema. Bitte Verzeichnis eingeben.";
$pgv_lang["performing_update"]		= "Aktualisierung wird durchgeführt.";
$pgv_lang["config_file_read"]		= "Konfigurationsdatei wurde gelesen.";
$pgv_lang["does_not_exist"]		= "existiert nicht";
$pgv_lang["media_drive_letter"]		= "Der Pfad zur Medien-Datei sollte keinen Laufwerksbuchstaben enthalten. Diese Datei kann sonst eventuell nicht angezeigt werden.";
$pgv_lang["db_setup_bad"]		= "Ihre aktuelle Datenbank-Konfiguration ist unzulässig. Bitte überprüfen Sie ihre Datenbankverbindungsparameter und konfigurieren Sie diese neu.";
$pgv_lang["bad_host_user_pass"]	= "PhpGedView konnte keine Verbindung zu Ihrem Datenbank Host aufbauen. Überprüfen Sie bitte den Host, Benutzernamen und Kennwort.";
$pgv_lang["bad_database_name"]	= "PhpGedView hat eine Verbindung zu Ihrem Datenbank Host hergestellt, konnte aber den von Ihnen angegebenen Datenbanknamen nicht verwenden. Bitte prüfen Sie, dass diese Datenbank existiert und dass der angegebene Benutzername die notwendigen Zugriffsrechte hat.";
$pgv_lang["db"]				= "Datenbank";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["mysql"]			= "MySQL";
$pgv_lang["current_gedcoms"]		= "Vorhandene GEDCOMs";
$pgv_lang["ged_gedcom"]			= "GEDCOM-Datei";
$pgv_lang["ged_title"]			= "GEDCOM Bezeichnung";
$pgv_lang["ged_config"]			= "Konfigurations-Datei";
$pgv_lang["ged_search"]			= "SearchLog-Dateien";
$pgv_lang["ged_change"]			= "ChangeLog-Dateien";
$pgv_lang["ged_privacy"]		= "Datenschutzdatei";
$pgv_lang["disabled"]			= "Deaktiviert";
$pgv_lang["mouseover"]			= "Bei «Mouse Over»";
$pgv_lang["mousedown"]			= "Bei «Mouse Down»";
$pgv_lang["click"]			= "Bei «Mouse Click»";
$pgv_lang["enter_db_pass"]		= "Aus Sicherheitsgründen müssen Sie immer Datenbank-Benutzernamen und -Kennwort eingeben, wenn Sie die Konfiguration verändern.";
$pgv_lang["server_url_note"]	= "Geben Sie die URL zu Ihrem PhpGedView-Ordner an. Sie sollten diesen Wert nur ändern, wenn Sie die Bedeutung verstehen. PhpGedView hat die SERVER_URL wie folgt ermittelt: #GUESS_URL#";
$pgv_lang["DBTYPE"]			= "Datenbank-Typ";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Der Typ der Datenbank (PEAR-Unterstützung) die genutzt werden soll. Möglich sind: MySQL, PostgreSQL, Oracle und SQLite. Diese Einstellung ändert die Variable \$DBTYPE in der Datei config.php.<br /><br />";
$pgv_lang["DBHOST"]			= "Datenbank-Host";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />Die DNS- oder IP-Adresse Ihres Datenbank-Servers.<br /><br />Diese Einstellung ändert die Variable \$DBHOST in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["DBUSER"]			= "Datenbank-Benutzername";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Der Benutzername der benötigt wird, um eine Verbindung zu Ihrer Datenbank herzustellen.<br /><br />Diese Einstellung ändert die Variable \$DBUSER in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["DBPASS"]			= "Datenbank-Kennwort";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Das Kennwort das für den oben von Ihnen angegebenen Benutzernamen benötigt wird, um eine Verbindung zu Ihrer Datenbank herzustellen.<br /><br />Diese Einstellung ändert die Variable \$DBPASS in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["DBNAME"]			= "Datenbank-Name";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />Die Datenbank auf Ihrem Server, die Sie mit PhpGedView nutzen möchten.<br /><br />Der Benutzername aus dem Benutzerfeld muss über Generierungs-, Einfügungs-, Update-, Lösch- und Auswahlrechte innerhalb dieser Datenbank verfügen.<br /><br />Diese Einstellung ändert die Variable \$DBNAME in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["TBLPREFIX"]			= "Präfix der Datenbank Tabellennamen";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Ein Präfix der an die Tabellennamen angehängt wird, die von PhpGedView erstellt werden. Durch Ändern dieses Wertes können Sie mehrere PhpGedView-Sites bestimmen, die die gleiche Datenbank jedoch unterschiedliche Tabellen benutzen.<br /><br />Diese Einstellung ändert die Variable \$TBLPREFIX in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Zugang zu mehreren GEDCOMs freigeben";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Die Einstellung «Ja» erlaubt den Besuchern <b>und</b> angemeldeten Benutzern die verwendete GEDCOM-Datei selbst auszuwählen, sofern Ihre Konfiguration mehrere GEDCOM-Dateien enthält. <br /><br />Bei Einstellung «Nein», können <b>weder</b> Besucher, <b>noch</b> angemeldete Benutzer die GEDCOM-Datei auswählen können.<br /><br />Diese Einstellung ändert die Variable \$ALLOW_CHANGE_GEDCOM in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["upload_path"]			= "Pfad zur zu hochladenden Datei";
$pgv_lang["gedcom_path"]			= "Server-Pfad und Name der GEDCOM-Datei";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Bitte speichern Sie Ihre GEDCOM-Datei zunächst an einer Stelle auf Ihrem Servers, auf die man mit PHP zugreifen kann. Dann geben Sie hier den Pfad und Dateinamen dieser Datei an: z.B.: <b>./index/name.ged</b>.</br></br>Für weitere Hilfe schauen Sie in die Datei <a href=\"readme.txt\"><b>Readme.txt</b></a><br /><br />";
$pgv_lang["CHARACTER_SET"]		= "Kodierung der Schriftzeichen";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dies ist die Bezeichnung für die Kodierung, mit der Sie Ihre GEDCOM-Datei gespeichert haben. UTF-8 ist die Standardeinstellung  und sollte auf fast allen Websites funktionieren. Falls Sie ihre GEDCOM-Datei mit IBM-Windows Kodierung exportiert haben, sollten Sie hier WINDOWS angeben.<br /><br />Bitte beachten Sie: PHP unterstützt ->KEIN<- UNICODE (UTF-16)! Also versuchen Sie dies nicht und beschweren Sie sich bei den PHP-Machern.<br /><br />";
$pgv_lang["LANGUAGE"]			= "Sprache";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Bestimmen Sie die Standardsprache für Ausgaben auf dieser Site. Die Benutzer haben die Möglichkeit, diese Einstellung durch Konfiguration ihres Browsers oder durch Auswahl der Anzeigesprache im unteren Bereich der Seiten zu verändern, falls die Variable \$ENABLE_MULTI_LANGUAGE in der Datei <i>config.php</i> auf «true» steht.<br /><br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Besuchern den Wechsel der Anzeige-Sprache erlauben";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />«Ja» wählen, um den Besuchern zu ermöglichen, eine andere Anzeigesprache aus einer Dropdown-Liste auszuwählen. Als Voreinstellung wird bei «Ja» die Standardsprache ihres Browsers gewählt.<br /><br />";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalender Format";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Daten können in dieser Datenbank in verschiedenen Kalender-Systemen, wie Gregorianisch, Julianisch, oder Jüdisch vorkommen.  Diese Option bestimmt, dass alle Daten in ein gemeinsames Kalender-System übersetzt werden sollen.  Z.B., wenn Sie hier Gregorianisch wählen, werden alle in der Datenbank vorkommende Julianische oder Hebräische Daten ins Gregorianische System übersetzt.  Das übersetzte Datum wird dann in Klammern hinter dem Original-Datum gezeigt.<br /><br />Daten werden nur übersetzt wenn sie für das zweite Kalendersystem gültig sind.  Z.B., nur Daten zwischen 22&nbsp;SEP&nbsp;1792 und 31&nbsp;DEC&nbsp;1805 sind für das System der Französichen Republik gültig.  Gleichmäßig sind nur Daten nach 15&nbsp;OCT&nsbp;1582 für das Gregorianische System gültig.<br /><br />Das Hebräische System ist das gleiche als das Jüdische System, aber mit Hebräischen Schriftzeichen.  Das Arabische System ist das gleiche als das Hijri-System, aber mit Arabischen Schriftzeichen.<br /><br />Bitte beachten Sie:  Im Jüdischen und Hijri Kalendersystem fängt der neue Tag nach Sonnenuntergang an.  Ereignisse, die zwischen Sonnenuntergang und Mitternacht statt finden, werden deshalb nach der Übersetzung einen Tag früher als erwartet gezeigt.  Sie sollten außerdem auch beachten, dass manche Browser die Arabischen und Hebräischen Schriftzeichen in falscher Richtung oder überhaupt nicht zeigen.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Hebräische Tausender anzeigen";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Alafim in Hebräischen Kalendern anzeigen. Bei «Ja» wird das Jahr 1969 als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt, während es bei «Nein» als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt wird. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung. Das Jahr wird als 5729 angezeigt unabhängig von dieser Einstellung<br /><br />Bitte beachten: Diese Einstellung entspricht der php 5.0 Kalender-Einstellung CAL_JEWISH_ADD_ALAFIM.<br /><br />Diese Einstellung ändert die Variable \$DISPLAY_JEWISH_THOUSANDS in der Datei config.php.<br /><br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Hebräische Gershayim anzeigen";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Einfache und doppelte Hochkommata in Hebräischen Daten anzeigen. Bei «Ja» wird der 8. Februar 1969 als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt, bei «Nein» als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung, da Hochkommata bei der dortigen lateinischen Darstellung nicht genutzt werden.<br /><br />Bitte beachten: Diese Einstellung entspricht den php 5.0 Kalender-Einstellungen CAL_JEWISH_ADD_ALAFIM_GERESH und CAL_JEWISH_ADD_GERESHAYIM und beeinflusst BEIDE Werte.<br /><br />Diese Einstellung ändert die Variable \$DISPLAY_JEWISH_GERESHAYIM in der Datei config.php.<br /><br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jüdische Ashkenaz Schreibweise";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Jüdische Ashkenazi Schreibweise benutzen.<br /><br />Bei «Ja» werden die Monate Cheshvan und Teves in der Ashkenazi Schreibweise verwendet. Bei «Nein» werden die Monate als Hesvan und Tevet angezeigt. <br /><br />Dies beeinflusst nur die Jüdische Einstellung. Im Hebräischen wird das Hebräische Alphabet benutzt.<br /><br />Diese Einstellung ändert die Variable \$JEWISH_ASHKENAZ_PRONUNCIATION in der Datei config.php.<br /><br />";
$pgv_lang["USE_RTL_FUNCTIONS"]	= "Von rechts nach links führende Texte unterstützen";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Anzahl standardmäßig dargestellter Generationen in der Stammbaum-Darstellung";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Bestimmt die Anzahl standardmäßig dargestellter Generationen, die in der Stammbaumdarstellung gleichzeitig angezeigt werden.<br /><br />";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximale Anzahl Generationen im Stammbaum";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Ändert die Anzahl der Generationen, die maximal in der Stammbaum Ansicht angezeigt werden.<br /><br />";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximale Anzahl Generationen im Nachfahrenbaum";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Ändert die Anzahl der Generationen, die maximal im Nachfahrenbaum angezeigt werden.<br /><br />";
$pgv_lang["USE_RIN"]			= "RIN# anstelle von GEDCOM ID verwenden";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Bei «Ja» wird die RIN Nummer anstelle der GEDCOM ID verwendet, wenn in Konfigurationen, Benutzer-Einstellungen und Diagrammen nach Personen gefragt wird. Dies ist hilfreich für Genealogie Software die GEDCOM-Dateien nicht mit einheitlichen IDs  aber immer mit den gleiche RIN für Personen exportiert.<br /><br />";
$pgv_lang["GENERATE_GUID"]		= "Global einmalige ID-Nummern erstellen";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "ID-Nummer der Startperson für Stammbaum und Nachfahrenbaum";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Bestimmt die ID der Person, die standardmäßig als Startperson in der Stammbaum- und Nachfahrenbaum-Darstellung verwendet wird.<br /><br />";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Personen ID-Nummer Präfix";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />In Stammbäumen, Nachfahrenbäumen, Verwandtschafts- und anderen Darstellungen wird dieses Präfix der ID vorangestellt, die der Besucher zur Personen-Auswahl eingeben kann, sofern er das Präfix nicht selbst voranstellt.<br /><br />";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Quellen ID-Nummer Präfix";
$pgv_lang["REPO_ID_PREFIX"]		= "Archiv ID-Nummer Präfix";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Geburts- und Todesdetails im Stammbaum und Nachfahrenbaum anzeigen";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Dieses Feld bestimmt, ob die Einzelheiten der Geburts- und Sterbedaten von Personen standardmäßig dargestellt werden oder nicht.<br /><br />";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standard Stammbaum Layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Hier bestimmen Sie, ob der Stammbaum im Hochformat oder Querformat generiert werden soll.<br /><br />";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Leere Boxen im Stammbaum anzeigen";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Gibt an, ob leere Boxen im Stammbaum angezeigt werden sollen.<br /><br />";
$pgv_lang["ZOOM_BOXES"]			= "Boxen in Diagrammen zoombar";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Erlaubt dem Besucher in Boxen eines Diagramms für mehr Informationen hineinzuzoomen. Auf «Deaktiviert» stellen, um dieses Feature abzuschalten. Auf «MouseOver» stellen, um den Zoom beim Überfahren des Icons mit der Maus auszulösen. Auf «Click» stellen, um den Zoom durch Klick auf das Icon auszulösen.<br /><br />";
$pgv_lang["LINK_ICONS"]			= "PopUp Links in Diagrammen";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Erlaubt die Auswahl von Links zu anderen Diagrammen und zu nahen Verwandten einer Person. Auf «Deaktiviert» stellen, um dieses Feature abzuschalten.Auf «MouseOver» stellen, um ein Popup-Fenster mit den Links anzuzeigen, wenn der Benutzer mit der Maus über das Symbol in der Personen-Box fährt. Auf  «Click» stellen, um das Popup-Fenster durch Klick auf das Symbol aufzurufen.<br /><br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Bezeichnungen in Diagrammen abkürzen";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Legt fest, ob in den Diagrammen Bezeichnungen wie 'Geburt' nur mit dem Anfangsbuchstaben ('G') abgekürzt werden.<br /><br />";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Alter der Eltern bei der Geburt eines Kindes zeigen";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Ereignisse naher Verwandten auf der «Persönliche Informationen» Seite zeigen";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Ereignisliste naher Verwandten automatisch erweitern";
$pgv_lang["EXPAND_SOURCES"]      = "Quellenangaben automatisch erweitern";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Lebende Personen verbergen";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Diese Option dient dazu, Daten von lebenden Personen vor den Augen «gewöhnlicher» Besucher zu verbergen. Lebende Personen sind für PhpGedView diejenigen, die Einträge in Ihrem Datensatz haben, die jünger sind, als das in der Variable \$MAX_ALIVE_AGE definierte Alter und keine Kinder haben, die vor mehr als in der Variable \$MAX_ALIVE_AGE angegebenen Jahren geboren wurden.<br /><br />";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Besucher Login notwendig";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Wenn diese Einstellung aktiv ist, muss sich ein Besucher erst anmelden, bevor ihm irgendwelche Daten dieser Seite gezeigt werden.<br /><br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Begrüßungstext auf der Login-Seite";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Hier können Sie einen Text auswählen, der auf der Login-Seite erscheint. Bitte prüfen Sie welcher vordefinierte Text am geeignetsten ist.<br /><br />Sie können auch Ihren eigenen Willkommens-Text erstellen, aber dieser wird nicht in die anderen Sprachen übersetzt, es sei denn, dass in Ihrem Text Verweise auf Sprach-Variable enthält, die Sie in die verschiedenen <i>languages/extra.xx.php</i> Sprach-Dateien eingegeben haben.  Sie können im Hilfe-text des <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> Feldes mehr darüber erfahren.<br /><br />Die vordefinierten Texte lauten:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Kein vordefinierter Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Vordefinierter Text, der erklärt, dass alle Benutzer einen Zugang beantragen können";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Vordefinierter Text, der erklärt, dass der Verwalter über den Zugangs-Antrag entscheidet";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Vordefinierter Text, der erklärt, dass nur Familienmitglieder einen Zugang beantragen können";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Selbsterstellter Text wie unten angegeben";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Selbsterstellter Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Wenn Sie im vorigen Feld «Selbsterstellter Text» gewählt haben, können Sie hier diesen Text eingeben. Der Text wird NICHT in andere Sprachen übersetzt sondern erscheint für alle Benutzer nur in der Sprache, in der Sie ihn eintragen.  Trotzdem, falls Ihre Eingabe Verweise auf Sprach-Variable enthält, die Sie in den verschiedenen <i>languages/extra.xx.php</i> eingegeben haben, kann der Text unter Umstnden übersetzt werden.<br /><br />Sie können im Text HTML-tags verwenden.<br /><br />Die folgende Beschreibung, enthalten im Hilfe-Text über FAQ-Listen, ist ebenso für den selbsterstellen Text gültig.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br /><br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standard Einleitung für selbsterstellten Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Wählen Sie, ob ein (mehrsprachiger) Kopf für Ihren selbsterstellten Willkommens-Text angezeigt werden soll.<br /><br />Wenn Sie «Ja» wählen, wird folgender Kopf angezeigt:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Bedingungen auf der «Benutzer Antrag» Seite zeigen";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Wenn Sie <b>#pgv_lang[yes]#</b> wählen, wird folgende Notiz als Überschrift auf der «#pgv_lang[requestaccount]#» Seite gezeigt:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Daten der Kinder überprüfen";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Überprüft die Daten der Kinder einer Person, um zu bestimmen, ob eine Person schon verstorben ist oder nicht. Falls sich Ihre Website auf einem älteren Server befindet und Sie eine große GEDCOM-Datenbanken nutzen, kann die Einstellung «Ja» bewirken, dass die Antwortzeit Ihres Servers verzögert wird.<br /><br />";
$pgv_lang["MAX_ALIVE_AGE"]		= "Alter, ab dem angenommen wird, dass eine Person verstorben ist";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Das maximale Alter einer Person, das maximale Alter eines persönlichen Eintrages einer Person oder das maxiamale Alter der Kinder dieser Person, damit angenommen wird, dass diese Person mittlerweile verstorben ist und ihr Datensatz nicht mehr dem Datenschutz unterliegt.<br /><br />";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Besuchern erlauben die GEDCOM-Roh-Daten anzusehen";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Bei «Ja» wird eine Verknüpfung auf den Seiten von Personen, Quellen und Familien eingefügt, die ein neues Fenster mit den jeweiligen Roh-Daten aus der GEDCOM-Datei öffnet.<br /><br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Online Editieren erlauben";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Ermöglicht das Online Editieren für diese GEDCOM-Datei, mittels dessen Besucher mit Edit-Rechten die GEDCOM-Datei online verändern können.<br /><br />";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Editier-Fenster automatisch schließen";
$pgv_lang["INDEX_DIRECTORY"]		= "Verzeichnis der Index-Dateien";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Der Pfad zu einem Verzeichnis mit Lese- und Schreibrechten, in dem PhpGedView die Index-Dateien speichern soll (einschließlich des führenden «/»).<br /><br />Dieses Feld definiert den Inhalt der Variable \$INDEX_DIRECTORY in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["POSTAL_CODE"]  = "Position der Postleitzahl";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maximale Nachnamen";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange Listen von Personen mit gleichem Nachnamen können nach dem Anfangsbuchstaben dessen Vornamen in kleinere Listen aufgeteilt werden.<br /><br />Mit dieser Option geben Sie die maximale Nachnamens-Listenlänge ein.  Wenn Sie diese Länge auf Null stellen, werden Nachnamenslisten nie in kleinere Listen aufgeteilt.<br /><br />";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maximale Familiennamen";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange Listen von Familien mit gleichem Namen können nach dem Anfangsbuchstaben dessen Vornamen in kleinere Listen aufgeteilt werden.<br /><br />Mit dieser Option geben Sie die maximale Familiennamens-Listenlänge ein.  Wenn Sie diese Länge auf Null stellen, werden Familiennamenslisten nie in kleinere Listen aufgeteilt.<br /><br />";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Darstellung der Nachnamenslisten";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Nachnamen, wie sie im #pgv_lang[block_top10]# Block, in der #pgv_lang[individual_list]#, und in der #pgv_lang[family_list]# erscheinen, können verschieden dargestellt werden.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;In dieser Darstellung sind Nachnamen in einer Tabelle aufgezeichnet.  Diese Tabelle kann entweder nach den Namen oder nach deren Anzahl sortiert werden.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;In dieser Darstellung sind Nachnamen in einer Liste aufgezeichnet.  Die Größe der Namen hängt von deren Anzahl in der Datenbank ab.  Je öfter der Name vorkommt, desto größer ist seine Darstellung.  Die Liste kann nicht sortiert werden.</li></ul><br /><br />";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Namen aus GEDCOM ermitteln";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "~#pgv_lang[NAME_FROM_GEDCOM]#~<br /><br />Normalerweise verwendet PhpGedView für Personen den Namen, der in der Index-Datei gespeichert wurde. Bei manchen GEDCOM-Formaten oder -Sprachen wird dieser Name aus der Index-Datei nicht korrekt angezeigt und der beste Weg für eine korrekte Darstellung wäre direkt aus der GEDCOM-Datei. Z.B. bestehen Spanische Nachnamen oft aus Vornamen - Nachname des Vaters - Nachname der Mutter. Bei Verwendung der Indexdateien würden die Nachnamen des Vaters und der Mutter vertauscht. Nur durch Auslesen des Namens aus der GEDCOM-Datei  würde dieser korrekt dargestellt. Allerdings wird das Programm und die Anzeige dadurch etwas langsamer.<br /><br />";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Anzeige der ID Nummern in Klammern hinter den Personen-Namen in den Diagrammen.<br /><br />";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Letztes Ändergungsdatum in Listen zeigen";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Anzahl der angezeigten Ebenen der hierarchischen Orts-Angaben";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Hier stellen Sie ein, wie viele Informationen zu den Orts-Angaben in den Personen-Boxen im Diagramm angezeigt werden. Die Einstellung «9» sorgt für vollständige Orts-Angaben. Die Einstellung «0» unterdrückt die Orts-Angabe komplett. Die Einstellung «1» zeigt nur eine Ebene, die Einstellung «2» zeigt die ersten beiden Ebenen usw. (bezieht sich auf die Unterteilung durch Kommata, z.B. Bonn, Rheinland-Pfalz, Deutschland).<br /><br />";
$pgv_lang["MULTI_MEDIA"]		= "Multimediaunterstützung aktivieren";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />Die Spezifikation von GEDCOM 5.5 erlaubt Ihnen Fotos, Videos und andere Multimedia-Objekte in Ihre GEDCOM-Datenbank hinzuzufügen. Falls Sie keine Multimedia-Objekte in ihre GEDCOM-Datenbank hinzugefügt haben, können Sie die Multimedia-Unterstützung von PhpGedView durch Setzen dieses Feldes auf N(ein) abschalten.<br /><br />Lesen Sie im Abschnitt «multimedia» der Datei <a href=\"readme.txt\"><b>readme.txt</b></a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.<br /><br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "Links beibehalten";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Ein vorkommender Multimedia-Link, der z.B. mit http://, ftp://, mms:// beginnt, wird nicht ändert, wenn Sie «Links bebehalten» auf «Ja» setzen. Wenn Sie diesen Wert auf «Nein» setzen, dann wird der Link wie ein Verweis auf die Multimedia-Daten behandelt und die Einstellung bezüglich Multimedie-Verzeichnis etc. werden berücksichtigt. z.B.: http://www.meinefamilie.de/foto/papa.jpg wird geändert zu .media/papa.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Verzeichnis der Multimedia-Dateien";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Der Pfad zu einem Verzeichnis mit Leserechten auf einem Server, in dem PhpGedView nach den Multimedia-Dateien suchen soll, die in den jeweiligen Datensätzen der enthaltenen Personen einer GEDCOM-Datenbank definiert wurden (einschließlich des führenden «/»).<br /><br />";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Multimedia Verzeichnis-Tiefe";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Ein Wert von 0 wird alle Unterverzeichniss im Verzeichnis für Multimedia-Objekte ignorieren. Ein Wert von 1 wird zusätzlich das erste Unterverzeichnis dieses Multimedia-Verzeichnisses beachten. Die Erhöhung dieser Zahl, wird die Anzahl der übergeordneten zu überwachenden Verzeichnisse dieses Pfades erhöhen.<br /><br />Ein Beispiel: Wenn Sie innerhalb Ihrer GEDCOM-Datei auf ein Foto mit folgenden Pfad verlinken: C:\\Dokumente und Einstellungen\\BENUTZER\\Eigene Dateien\\Eigene Bilder\\Genealogie\\Nachname\\grossvater.jpg dann wird ein Wert von 0 diesen Pfad folgendermaßen interpretieren: ./media/grossvater.jpg. Ein Wert von 1 jedoch, wird diesen Pfad folgendermaßen interpretieren: ./media/Nachname/grossvater.jpg, usw. Den meisten Verwaltern von PhpGedView wird hier ein eingestellter Wert von 0 ausreichen. Es kann jedoch sein, dass einige Multimedia-Objekte den gleichen Namen haben können und sich somit gegenseitig aufheben. Dieses Wert ermöglicht Ihnen, Ihre Multimedia-Objekte zu verwalten, ohne einen Namenskonflikt zu erzeugen.<br /><br />";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Falls Sie die Darstellung für Multimedia-Dateien auf Ihrer Website aktiviert haben, können Sie PhpGedView veranlassen, neben dem Namen der in den Boxen eines Stammbaumes oder Nachfahrenbaumes dargestellten Personen eine verkleinerte Darstellung eines Bildes (english Thumbnail) anzuzeigen.<br /><br />Aktuell benutzt PhpGedView hierfür (highlighted image) das erste Multimedia-Objekt (Foto), das im GEDCOM-Datensatz der dargestellten Person vorkommt. Denjenigen, die mehrere Fotos als Multimedia-Objekte dem Datensatz einer Person hinzugefügt haben, sei empfohlen, die Liste der Multimedia-Objekte in einem Datensatz so anzuordnen, dass das darzustellende Foto an erster Stelle der Multimedia-Objekte der Person erscheint.<br /><br />Für Benutzer von PAF 5.5 sei angemerkt, dass PhpGedView in der aktuellen Version die Definition des darzustellenden Fotos einer Person, die von PAF durch die Anweisung «_PRIM» definiert wird, unterstützt. Somit haben Sie innerhalb des Fensters «Multimedia-Sammlung» von PAF die Möglichkeit mehrere Fotos zu einer Person hinzuzuspeichern und durch die Anweisung «festlegen» das Foto zu bestimmen, das in der Stammbaum- oder Nachfahrenbaum-Darstellung und auch im jeweiligen persönlichen Datenblatt der jeweiligen Person angezeigt wird, zu bestimmen.<br /><br />Lesen Sie im Abschnitt «multimedia» der Datei <a href=\"readme.txt\"><b>readme.txt</b></a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.<br /><br />";
$pgv_lang["USE_THUMBS_MAIN"]	= "Miniaturbilder verwenden";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Diese Option bestimmt, ob Miniaturbilder oder Bilder in Original-Größe als Bilder von Personen, Familien, oder Quellen verwendet werden sollen.  Diese Option wird auch von einigen anderen Seiten, wie zum Beispiel der Diabetrachter, berücksichtigt. Die Seite für Medien-Verwaltung und die Medien-Liste benutzen jedoch immer Miniaturbilder.<br /><br />Die Wahl <b>#pgv_lang[yes]#</b> bestimmt daß das Miniaturbild überall, außer in Diagrammen, ohne Verifikation dessen Größe, benutzt werden soll.  Falls das Miniaturbild zu groß ist, wird die Seiten-Darstellung wahrscheinlich falsch sein.<br /><br />Die Wahl <b>#pgv_lang[no]#</b> bestimmt, daß Ihr Browser das Hauptbild in Miniaturbild-Größe auf den Personen-, Familien-, und Quellen-Seiten zeigen soll.  Das vom Browser reduzierte Bild wird auf diesen Seiten mit einer Breite von 150 Pixel mit Rahmen dargestellt.  Wenn das eigentliche Miniaturbild verwendet wird, fehlt der Rahmen.  Auf Diabetrachter-Seiten werden Hauptbilder mit einer maximalen Breite von 300 Pixel dargestellt.<br /><br />Sie sollten die Wahl <b>#pgv_lang[no]#</b> vermeiden, da PhpGedView immer das Hauptbild in Original-Größe dem Browser sendet, obwohl der Browser das Bild in kleinerem Format zeigen soll.  Diese Wahl kann also unter Umständen zu langen Datenübertragungen führen.<br /><br />";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Diabetrachter erlauben, Dateinamen zu zeigen";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Der Diabetrachter kann den Namen der aktuellen Medien-Datei zeigen.  Diese Option bestimmt, ob der Diabetrachter diesen Namen zeigen darf oder nicht.<br /><br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Diabetrachter erlauben, Download-Links zu zeigen";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Der Diabetrachter kann ein Link zeigen, der eine Übertragung der aktuellen Medien-Datei ermöglicht.<br /><br />Diese Option bestimmt, ob der Diabetrachter diesen Link zeigen darf oder nicht.<br /><br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Ausschnittssammelbehäter aktivieren";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Der Ausschnittssammelbehälter ermöglicht Besuchern Ihrer Website Datensätze zu ausgewählten Personen aus ihrer gesamten GEDCOM-Datenbank in eine neue GEDCOM-Datenbank zu exportieren, die diese dann als Datei auf ihren Computer übertragen (downloaden) können, um diese Datensätze in ihr eigenes Genealogie-Programm zu importieren.<br /><br />";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "GEDCOM-Fehler verbergen";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Bei «Ja» werden alle Fehlermeldungen, die von PhpGedView verursacht werden, nicht dargestellt. Solche Fehler können dann entstehen, wenn PhpGedView eine Anweisung innerhalb der von Ihnen gewählten GEDCOM-Datenbank nicht interpretieren kann. PhpGedView wurde so programmiert, dass möglichst alle Anweisungen des GEDCOM 5.5 Standards unterstützt werden. Jedoch verwenden einige Genealogie-Programme ihre eigenen Anweisungen (TAGS). Schauen Sie in die Datei <a href=\"readme.txt\"><b>readme.txt</b></a> um mehr hierüber zu erfahren.<br /><br />";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Leerzeichen an umgebrochene Notizinformationen anfügen";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Manche Genealogie-Programme kappen die Notizen zu Datensätzen am Ende von ganzen Wörtern, während andere an einer beliebigen Stelle des Textes einen Zeilenumbruch einfügen. Dies kann PhpGedView veranlassen, Wörter aneinander anzuhängen, ohne ein Leerzeichen zwischen diese zu setzen. Bei «Ja» wird PhpGedView bei der Ausgabe von Notizen ein Leerzeichen zwischen zwei Wörter einfügen, die durch einen Zeilenumbruch getrennt wurden.<br /><br />";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "«?»-Hilfe-Links standardmäßig anzeigen";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Diese Option aktiviert Fragezeichen als Hilfe-Links auf den Seiten, auf die die Besucher klicken können, um einen Hilfe-Text für die jeweilige Funktion angezeigt zu bekommen.<br /><br />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Tageslimit des «Bevorstehende Ereignisse» Blocks";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Mindestanzahl eines Nachnamens, der in der Liste der häufigsten Nachnamen erscheinen soll";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Dies ist die Anzahl, wie oft ein Nachname vorkommen muss, damit er in der Liste der häufigsten Nachnamen auf der Hauptseite genannt wird.<br /><br />";
$pgv_lang["COMMON_NAMES_ADD"]	= "Namen, die zu der Liste der häufigsten Nachnamen hinzugefügt werden sollen (durch Komma getrennt)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Wenn ein Name nicht genügend oft vorkommt, erscheint er nicht in der Liste der häufigsten Nachnamen. Hier können Sie solche Namen manuell zur Liste hinzufügen. Wenn Sie mehrere Namen angeben, trennen Sie diese jeweils durch ein Komma. Groß- und Kleinschreibung bitte beachten.<br /><br />";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Namen, die aus der Liste der häufigsten Nachnamen entfernt werden sollen";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Wenn Sie einen Nachnamen aus der Liste der häufigsten Nachnamen entfernen möchten, ohne den Grenzwert für die Anzahl des Vorkommens verändern zu wollen, können Sie den Namen hier eingeben. Wenn Sie mehrere Namen angeben, trennen Sie diese jeweils durch ein Komma. Groß- und Kleinschreibung bitte beachten.<br /><br />";
$pgv_lang["HOME_SITE_URL"]		= "URL der Hauptseite der WebSite";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Eine URL die in den Kopfbereich des gewählten Darstellungsthemas hinzugefügt wird, um eine Verknüpfung zur Startseite Ihrer Homepage zu erstellen.<br /><br />";
$pgv_lang["HOME_SITE_TEXT"]		= "Text für Hauptseite der WebSite";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Textausgabe für die Verknüpfung, die zur Startseite Ihrer Homepage verweist.<br /><br />";
$pgv_lang["CONTACT_EMAIL"]		= "Ihre Kontakt Mail-Adresse für genealogische Fragen";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Die Mail-Adresse die Ihre Besucher kontaktieren sollen, falls sie Fragen zu den genealogischen Daten auf Ihrer Website haben.<br /><br />";
$pgv_lang["CONTACT_METHOD"]		= "Kontakt Methode für genealogische Fragen";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Die Methode, mit der die Kontakt-Links für genealogische Fragen arbeiten. Mit «Mail» wird eine Link eingefügt, mit der eine gewöhnliche Mail versendet werden kann. Mit «interne Nachrichten-Funktion» wird der in PhpGedView integrierte Nachrichten-Transfer benutzt und es wird keine gewöhnliche Mail Versendet. Bei «interne Nachrichten und Mail» werden beide vorgenannten Methoden parallel genutzt.  Mit «PhpGedView sendet Mails ohne sie zu speichern» werden die Nachrichten über PhpGedView abgewickelt und als Mail gesendet, aber sie werden nicht intern gespeichert. Mit «keine Nachrichten-Funktion» wird die Möglichkeit, dass Besucher Ihnen Nachrichten von diesen Seiten aus senden, unterbunden.<br /><br />";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Mail Antwort-Adresse";
$pgv_lang["WEBMASTER_EMAIL"]		= "Mail-Adresse des Webmasters";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Die Mail-Adresse die Ihre Besucher kontaktieren sollen, falls sie technische Fragen haben oder Fehler auf Ihrer Website finden und diese Ihnen mitteilen möchten.<br /><br />";
$pgv_lang["SUPPORT_METHOD"]		= "Support Kontakt Methode";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Die Methode, mit der die Kontakt-Links für Support-Fragen arbeiten. Mit «Mail» wird eine Verknüfung eingefügt, mit der eine gewöhnliche Mail versendet werden kann. Mit «interne Nachrichten-Funktion» wird der in PhpGedView integrierte Nachrichten-Transfer benutzt und es wird keine gewöhnliche Mail Versendet. Bei «interne Nachrichten und Mail» werden beide vorgenannten Methoden parallel genutzt. Mit «PhpGedView sendet Mails ohne sie zu speichern» werden die Nachrichten über PhpGedView abgewickelt und als Mail gesendet, aber sie werden nicht intern gespeichert. Mit «keine Nachrichten-Funktion» wird die Möglichkeit, dass Besucher Ihnen Nachrichten von diesen Seiten aus senden, unterbunden.<br /><br />";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Ereignis-Ikone zeigen";
$pgv_lang["FAVICON"]			= "Pfad und Dateiname der FavIcon-Grafik";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Ändern Sie diesen Wert, um auf die ICON-Grafik zu verweisen, die in der Liste der Favoriten/Lesezeichen derjenigen erscheinen, die ihre Website zur Liste ihrer Favoriten/Lesezeichen hinzufügen.<br /><br />";
$pgv_lang["THEME_DIR"]			= "Themen Verzeichnis";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />Das Verzeichnis in dem Ihr gewünschtes Darstellungsthema für PhpGedView-Seiten abgelegt ist. Sie können ein beliebiges Standardthema, das mit PhpGedView geliefert wurde, so anpassen, dass Ihre Website ein einzigartiges Erscheinungsbild abgibt. Lesen Sie im Abschnitt «customization» der Datei <a href=\"readme.txt\"><b>readme.txt</b></a>, um mehr darüber zu erfahren.<br /><br />";
$pgv_lang["TIME_LIMIT"]			= "PHP Zeitlimit";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Die maximale Dauer in Sekunden die Sie PhpGedView zur Beendigung eines Prozesses zur Vefügung stellen möchten. Die Standardeinstellung beträgt 60 Sekunden. Abhängig von der Größe Ihrer GEDCOM-Datenbank müssen Sie diese Zeit vielleicht erhöhen, falls Sie die Index-Dateien neu erstellen sollten. Setzen Sie diesen Wert auf 0, falls PhpGedView unendlich lange laufen soll.<br /><br />VORSICHT: Sollten Sie diesen Wert auf 0 oder zu hoch ansetzen, könnte dies das «HÄNGEN» Ihrer Website auf einigen Systemen bewirken, bis das Script endgültig fertiggestellt ist. Das Setzen dieses Wertes auf 0 bedeutet, dass das Script nie beendet wird, bis der Verwalter Ihres Servers den Prozess manuell löscht.<br /><br />Diese Einstellung definiert den Wert der Variable \$TIME_LIMIT in der Datei <i>config.php</i>.<br /><br />";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Pfad für die Session-Speicherung";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Der Pfad zum Speichern der «Session»-Dateien. Auf einigen Hosts ist PHP nicht sorgfältig konfiguriert und die Sitzungs-Daten werden zwischen den Seiten-Aufrugen nicht gespeichert. Hier können Sie die Standard-Einstellung überschreiben um ein eigenes lokales Verzeichnis zu verwenden. Ein geeignetes Verzeichnis wäre ./index/, falls eine Änderung notwendig ist. Normalerweise bleibt dieses Feld leer und es wird ein Pfad verwendet, der in der php.ini-Datei eingetragen ist.<br /><br />Diese Einstellung ändert die Variable \$PGV_SESSION_SAVE_PATH in der Datei config.php.<br /><br />";
$pgv_lang["SERVER_URL"]			= "PhpGedView URL";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Wenn Sie https oder einen anderen Port benutzen, müssen Sie hier die URL eingeben, über die Ihr Server erreicht werden kann.<br /><br />Diese Einstellung ändert die Variable \$SERVER_URL in der Datei config.php.<br /><br />";
$pgv_lang["LOGIN_URL"]			= "Login URL";
$pgv_lang["LOGIN_URL_help"]		= "Die Login URL muss nur dann angegeben werden, wenn Sie zu einer anderen Seite umleiten möchten, wenn die Benutzer sich anmelden. Dies ist dann sinnvoll, wenn Sie beim Benutzer-Login z.B. von http auf https wechseln möchten. Geben Sie die vollständige URL zur login.php-Datei an (z.B. https://www.ihrserber.de/phpgedview/login.pgp).<br /><br />";
$pgv_lang["PGV_SESSION_TIME"]		= "Session Timeout";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Die Zeit nach der man sich für eine PhpGedView-Sitzung erneut anmelden muss (login). Der Standard-Wert ist 2 Stunden.<br /><br />Diese Einstellung ändert die Variable \$PGV_SESSION_TIME in der Datei config.php.<br /><br />";
$pgv_lang["SHOW_STATS"]			= "Aufruf-Statistik anzeigen";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Ablauf-Statistiken und Datenbank-Abfragen am unteren Seitenrand aller Seiten einblenden.<br /><br />";
$pgv_lang["SHOW_COUNTER"]		= "Besucher-Zähler anzeigen";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Den Besucher-Zähler auf der Portalseite und auf anderen Seiten anzeigen.<br /><br />";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Besuchern erlauben, einen Zugang anzufordern";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Erlaubt den Benutzern, sich selbst für einen Benutzerzugang zu diesen Seiten zu registrieren. <br /><br />Der Benutzer wird eine Mail erhalten mit einem Code zur Bestätigung der Anmeldung.<br /><br />Danach muss der Verwalter diese Registrierung freischalten, bevor sie aktiv wird<br /><br />Diese Einstellung ändert die Variable \$USE_REGISTRATION_MODULE in der Datei config.php.<br /><br />";
$pgv_lang["ALLOW_USER_THEMES"]		= "Besuchern die Auswahl eines Themes erlauben";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Erlaubt den Benutzern eigene Themes auszuwählen.<br /><br />Diese Einstellung ändert die Variable \$ALLOW_USER_THEMES in der Datei config.php.<br /><br />";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Einfache Mail-Header bei Mails verwenden";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />Normalerweise enthält der Mail-Header die Mail-Adresse und den Namen des Absenders. Einige Mailsysteme akzeptieren diese Angaben nicht. Setzen Sie diesen Wert auf «Ja», damit nur die Mail-Adresse verwendet wird.<br /><br />Diese Einstellung ändert die Variable \$PGV_SIMPLE_MAIL in der Datei config.php.<br /><br />";
$pgv_lang["gedcom_title"]				= "GEDCOM-Datei Bezeichnung";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Geben Sie eine Bezeichnung ein, die erscheint, wenn Besucher zwischen mehreren GEDCOM-Dateien auf Ihrer Seite wählen.<br /><br />";
$pgv_lang["new_gedcom_title"]			= "Genealogische Daten aus [#GEDCOMFILE#]";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Suchmaschinen-Namen zeigen";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Verwandtschaft zu privaten Personen zeigen";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Änderungen sofort in der GEDCOM-Datei synchronisieren";
$pgv_lang["COMMIT_COMMAND"] 			= "Versions-Kontrolle Speicherbefehl";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Mehrere Webseiten durchsuchen";
$pgv_lang["LOGFILE_CREATE"]		= "Log-Dateien erzeugen";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Bestimmt, in welchem Rhythmus eine neue Log-Datei erzeugt wird.<br /><br />Diese Einstellung ändert die Variable \$LOGFILE_CREATE in der Datei config.php.<br /><br />";
$pgv_lang["PGV_MEMORY_LIMIT"]		= "Max. Speicher Begrenzung";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Stellt die maximale Menge an Arbeitsspeicher ein, die den PhpGedView Scripts zur Verfügung steht. Standardwert ist 16MB.  Viele Host haben diese Option in der PHP-Konfiguration deaktiviert, so dass eine Veränderung dieses Wertes möglicherweise keinen Einfluss hat.<br /><br />Diese Einstellung ändert die Variable \$PGV_MEMORY_LIMIT in der Datei config.php.<br /><br />";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Erlauben Nachrichten online zu speichern";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Stellt eine, ob Nachrichten, die über PhpGedView gesendet werden, in der Datenbank gespeichert werden. Bei «Ja» können Benutzer ihre Nachrichten wiederfinden, wenn sie sich bei PGV anmelden. Bei «Nein»  werden die Nachrichten nur per Mail verschickt.<br /><br />Diese Einstellung ändert die Variable \$PGV_STORE_MESSAGES in der Datei config.php file.<br /><br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Themen Wechsel erlauben";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Gibt Benutzern die Möglichkeit, ihr eigenes Theme zu wählen.<br /><br />(falls im Theme implementiert) von einem Drop-Down-Menü<br /><br />Erfordert, dass auch die Variable ALLOW_USER_THEMES auf «Ja» gesetzt ist.<br /><br />Diese Einstellung ändert die Variable \$ALLOW_THEME_DROPDOWN in der Datei config.php.<br /><br />";
$pgv_lang["MAX_VIEW_RATE"]		= "Geschwindigkeitslimit der Seiten-Darstellung";
$pgv_lang["META_AUTHOR"]		= "META Tag Autor";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Der Wert für das META Tag Feld «Autor» im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br /><br />Diese Einstellung ändert die Variable \$META_AUTHOR in der Datei config.php.<br /><br />";
$pgv_lang["META_AUTHOR_descr"]	= "Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br /><br />";
$pgv_lang["META_PUBLISHER"]		= "META Tag Publisher";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Der Wert für das META Tag Feld «Publisher» im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br /><br />Diese Einstellung ändert die Variable \$META_PUBLISHER in der Datei config.php.<br /><br />";
$pgv_lang["META_PUBLISHER_descr"]	= "Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br /><br />";
$pgv_lang["META_COPYRIGHT"]		= "META Tag Copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Der Wert für das META Tag Feld «Copyright» im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br /><br />Diese Einstellung ändert die Variable \$META_COPYRIGHT in der Datei config.php.<br /><br />";
$pgv_lang["META_COPYRIGHT_descr"]	= "Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br /><br />";
$pgv_lang["META_DESCRIPTION"]		= "META Tag Description";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Der Wert für das META Tag Feld «description» im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den Titel der aktuellen GEDCOM-Datei zu verwenden.<br /><br />Diese Einstellung ändert die Variable \$META_DESCRIPTION in der Datei config.php.<br /><br />";
$pgv_lang["META_DESCRIPTION_descr"]	= "Lassen Sie dieses Feld leer, um den Titel der aktiven GEDCOM-Datei zu verwenden.<br /><br />";
$pgv_lang["META_PAGE_TOPIC"]		= "META Tag Page-Topic";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Der Wert für das META Tag Feld «Page-Topic» im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den Titel der aktuellen GEDCOM-Datei zu verwenden.<br /><br />Diese Einstellung ändert die Variable \$META_PAGE_TOPIC in der Datei config.php.<br /><br />";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Lassen Sie dieses Feld leer, um den Titel der aktiven GEDCOM-Datei zu verwenden.<br /><br />";
$pgv_lang["META_AUDIENCE"]		= "META Tag Audience";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Der Wert für das META Tag Feld «Audience» im HTML-Seiten-Kopf.<br /><br />Diese Einstellung ändert die Variable \$META_AUDIENCE in der Datei config.php.<br /><br />";
$pgv_lang["META_PAGE_TYPE"]		= "META Tag Page Type";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Der Wert für das META Tag Feld «Page-Type» im HTML-Seiten-Kopf.<br /><br />Diese Einstellung ändert die Variable \$META_PAGE_TYPE in der Datei config.php.<br /><br />";
$pgv_lang["META_ROBOTS"]		= "META Tag Robots";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Der Wert für das META Tag Feld «Robots» im HTML-Seiten-Kopf. Viele Robots und Crawler missachten diesen Wert.<br /><br />Diese Einstellung ändert die Variable \$META_ROBOTS in der Datei config.php.<br /><br />";
$pgv_lang["META_REVISIT"]		= "Gibt an, wie oft Suchmaschinen die META Tags untersuchen sollen";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Der Wert für das META Tag Feld «Revisit» im HTML-Seiten-Kopf. Viele Crawler missachten diesen Wert.<br /><br />Diese Einstellung ändert die Variable \$META_REVISIT in der Datei config.php.<br /><br />";
$pgv_lang["META_KEYWORDS"]		= "META Tag Keywords";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Der Wert für das META Tag Feld «Keywords» im HTML-Seiten-Kopf. Viele Suchmaschinen nutzen die Keyword-Meta-Tags zur Indizierung von Webseiten. Ihre Angabe hier wird ergänzt durch die Liste der häufigsten Nachnamen, so wie sie auf der Willkommens-Seite erscheint.<br /><br />Diese Einstellung ändert die Variable \$META_KEYWORDS in der Datei config.php.<br /><br />";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Häufigst vorkommende Nachnamen dem «Keywords» META Feld hinzufügen";
$pgv_lang["META_TITLE"]		= "Zu 'TITLE'-Kennung im Kopfbereich hinzufügen";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Was Sie hier eingeben wird in der TITLE-Kennung (title-tag) hinter dem regulären Seitentitel und vor dem PhpGedView-Hinweis eingefügt.<br /><br />Diese Einstellung ändert die Variable \$META_TITLE in der Datei config.php.<br /><br />";
$pgv_lang["ENABLE_RSS"]				= "RSS erlauben";
$pgv_lang["RSS_FORMAT"]				= "RSS Format";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kann nicht heruntergeladen werden.<br /><br />";
$pgv_lang["welcome_new_help"]	= "~#pgv_lang[welcome_new]#~<br /><br />Dieses Hilfe-Fenster wird Ihnen bei der Konfiguration zur Seite stehen. Wenn Sie das Eingabe-Feld wechseln erscheint hier jeweils ein Hilfetext zu dem Feld, in dem sie die Eingabemarke befindet. Sie können das Fenster schließen; um es wieder zu öffnen klicken Sie auf das «?» neben einem Eingabefeld.<br /><br />";
$pgv_lang["return_editconfig"]		= "Sie können jederzeit diese Konfigurationsseite aufrufen, indem Sie auf der <b>Verwaltungsseite</b> auf <b>Konfiguration</b> klicken (oder im Browser die Seite editconfig.php aufrufen ).<br /><br />";
$pgv_lang["return_editconfig_gedcom"]	= "Sie können zu dieser Konfiguration jederzeit zurückkehren, indem Sie auf den Link <b>Bearbeiten</b> in der Tabelle <b>Vorhandene GEDCOMs</b> auf der Seite <b>GEDCOM Verwaltung</b> klicken, oder indem Sie in Ihrem Browser die Datei editconfig_gedcom.php aufrufen.<br /><br />";
$pgv_lang["save_config"]	= "Konfiguration speichern";
$pgv_lang["download_gedconf"]	= "GEDCOM Konfiguration herunterladen.<br /><br />";
$pgv_lang["not_writable"]	= "Die Konfiguration lässt sich nicht speichern. Mit dem Download-Button können Sie Ihre Einstellungen in eine Datei speichern, die Sie anschließend manuell hochladen müssen.<br /><br />";
$pgv_lang["upload_to_index"]	= "Datei kann anschließend auch manuell in Ihr Index-Verzeichnis hochgeladen werden: ";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Konfiguration der Datenschutzdatei";
$pgv_lang["edit_privacy_title"]			= "Konfiguration der Datenschutzdatei";
$pgv_lang["save_changed_settings"]		= "Änderungen speichern";
$pgv_lang["add_new_pp_setting"]			= "Neue Einstellung für eine Person hinzufügen";
$pgv_lang["add_new_up_setting"]			= "Neue Einstellung für einen Benutzer hinzufügen";
$pgv_lang["add_new_gf_setting"]			= "Neue globale Einstellung hinzufügen";
$pgv_lang["add_new_pf_setting"]			= "Neue Einstellung für Ereignisse hinzufügen";
$pgv_lang["file_read_error"]			= "F E H L E R !!! Die Datenschutz-Datei konnte nicht gelesen werden!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Vorhandene Einstellungen für Personen bearbeiten";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Vorhandene Einstellungen für Benutzer bearbeiten";
$pgv_lang["edit_exist_global_facts_settings"]	= "Vorhandene globale Einstellungen bearbeiten";
$pgv_lang["edit_exist_person_facts_settings"]	= "Vorhandene Ereignis-Einstellungen bearbeiten";
$pgv_lang["general_privacy"]			= "Allgemeine Privatsphären Einstellungen";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Diese Einstellungen sind die Grundeinstellungen für die jeweilige GEDCOM-Datei.<br /><br />Prüfen Sie, ob Sie die richtige GEDCOM-Datei bearbeiten, den Namen finden Sie unter der Überschrift.<br /><br />Sie können also für jede GEDCOM-Datei (sofern Sie mehrere auf Ihrer Seite haben) eigene Einstellungen vornehmen.<br /><br />Sie können diese Grundeinstellungen überschreiben, indem Sie die anderen Bereiche auf der Seite «#pgv_lang[edit_privacy_title]#» benutzen.<br /><br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]				= "Privatsphären Einstellungen der Person";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Diese Einstellung ermöglicht dem Verwalter, voreingestellte Datenschutz-Einstellungen für Personen aus der GEDCOM-Datenbank zu überschreiben.<br /><br />Wenn z.B. einer Person in der Datenbank ein Kind zugeordnet ist, das im Kleinkindalter verstarb, dann werden normalerweise die Daten dieses Kindes allen (auch nichteingetragenen) Besuchern der Website angezeigt, da es schon verstorben ist.<br /><br />Aber die Daten der Eltern sind nicht öffentlich zugänglich, da diese noch leben.<br /><br />Nun möchten Sie den Sterbe-Eintrag dieses Kindes nicht aus der Datenbank entfernen, jedoch alle Daten dieses Kindes unter Datenschutz stellen.<br /><br />Hat dieses Kind z.B. die ID 100, dann geben Sie auf dieser Seite zur Bearbeitung der Datenschutz-Einstellungen folgendes ein:<br /><br />Identifikationsnummer: I100<br /><br />Wem zeigen: «Nur angemeldeten Benutzern anzeigen»<br /><br />Dann bekommen nur registrierte Besucher der Website, nach einem Login, die Daten dieses Kindes zu sehen.<br /><br />Dies funktioniert natürlich auch anders herum:<br /><br />Um alle Daten einer Person (ID 101), die z.B. nicht mehr lebt aber deren Sterbedaten unbekannt sind, dennoch für alle Benutzer sichtbar zu machen, bearbeiten Sie die Datenschutz-Einstellungen wie folgt:<br /><br />Identifikationsnummer: I101<br /><br />Wem zeigen: «Allen Besuchern anzeigen»<br /><br />Dann bekommen ALLE Besucher der Website die Daten dieser Person zu sehen.<br /><br />Diese Einstellung ändert die Variablen \$person_privacy in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["user_privacy"]				= "Privatsphären Einstellungen des Benutzers";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Diese Einstellung ermöglicht dem Verwalter, voreingestellte Datenschutz-Einstellungen zur Anzeige der Daten von Personen für ausgewählte registrierte Besucher zu verändern.<br /><br />Wenn z.B. ein registierter Benutzer mit dem Benutzernamen «John» nach seinem Login die Daten einer bestimmten Person (z.B. ID 100) nicht sehen können soll, dann geben Sie auf der Seite zur Bearbeitung der Datenschutz-Einstellungen folgendes ein:<br /><br />Benutzername: John<br /><br />Identifikationsnummer: I100<br /><br />Anzeigen?: «Verbergen»<br /><br />Dadurch erreichen Sie, dass alle Details der Person mit der ID 100 NUR vor den Augen des Besuchers «John» verborgen werden.<br /><br />Dies funktioniert natürlich auch anders herum:<br /><br />Um alle Daten einer Person (ID 101), die normalerweise verborgen blieben (Person lebt noch oder Verwandschaftsgrad zu gering), dennoch für Benutzer «John» sichtbar zu machen, bearbeiten Sie die Datenschutz-Einstellungen wie folgt:<br /><br />Benutzername: John<br /><br />Identifikationsnummer: I101<br /><br />Anzeigen?: «Anzeigen»<br /><br />Dann werden alle Details der Person mit der ID 101 dem Besucher «John» angezeigt.<br /><br />Diese Einstellung ändert die Variablen \$user_privacy in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["global_facts"]				= "Globale Einstellungen für Privatsphärenereignisse";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Diese Einstellung ermöglicht dem Verwalter, voreingestellte Datenschutz-Einstellungen zur Anzeige von Ereignissen GLOBAL zu verändern.<br /><br />Die Einstellung «Ereignis-Bezeichnung» legt fest, welches Ereignis angezeigt/unterdrückt werden soll.<br /><br />Die Einstellung «Auswahl» legt fest, ob Sie das Ereignis selbst, oder zusätzlich gespeicherte Daten meinen.<br /><br />Die Einstellung «Wem zeigen ?» legt fest, wem die Details des Ereignisses angezeigt werden.<br /><br />Diese Einstellungen sind hauptsächlich vorgesehen, um bestimmte Ereignisse lebender und verstorbener Personen aus der GEDCOM-Datenbank grundsätzlich zu verbergen.<br /><br />Standardmäßig ist die Unterdrückung der SSN (Sozialversicherungsnummer-vor allem in den USA relevant) voreingestellt.<br /><br />Falls Sie z.B. alle Eheschließungen innerhalb der GEDCOM-Datenbank vor nicht authentifizierten Besuchern verbergen möchten, könnten Sie folgende Eingaben auf der Seite zur Bearbeitung der Datenschutz-Einstellungen machen:<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br /><br />Auswahl: «Ereignis zeigen»<br /><br />Wem zeigen?: «Nur angemeldeten Besuchern zeigen»<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br /><br />Auswahl: «Ereignis-Details zeigen»<br /><br />Wem zeigen?: «Nur angemeldeten Besuchern zeigen»<br /><br />Dann werden alle Eheschließungen inklusive ihrer Details nur den Besuchern angezeigt, die authentifiziert (eingeloggt) sind.<br /><br />Unter «global_facts» können Sie - im Gegensatz zu den übrigen Einstellungen - bestimmte Ereignisse sogar vor dem Verwalter verbergen. Dies dient dazu überflüssige Angaben komplett zu unterdrücken.<br /><br />Diese Einstellung ändert die Variablen \$global_facts in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["person_facts"]				= "Privatsphären Einstellungen für Personenereignisse";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Diese Einstellung ermöglicht dem Verwalter, voreingestellte Datenschutz-Einstellungen zur Anzeige von personenbezogenenereignissen zu verändern.<br /><br />Das erste Element ist die ID der Person, das Zweite ist das Ereignis.<br /><br />Die Einstellung «Auswahl» legt fest, ob Sie das Ereignis selbst, oder zusätzlich gespeicherte Daten meinen.<br /><br />Die Einstellung «Wem zeigen?» legt fest, wem das Ereignis angezeigt wird.<br /><br />Die \$person_facts-Einstellung funktioniert genauso, wie die \$global_facts-Einstellung nur mit dem Unterschied, dass Sie zusätzlich die ID-Nummer der Person aus der GEDCOM-Datenbank auswählen müssen, derenereignisse Sie verbergen oder zeigen möchten.<br /><br />Das Eheschließungs-Ereignis (einschließlich Details) der Person mit der ID-Nummer 100 verbergen Sie z.B. vor nicht authentifizierten (nicht eingeloggten) Besuchern durch:<br /><br />Identifikationsnummer: I100<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br /><br />Auswahl: «Ereignis zeigen»<br /><br />Wem zeigen?: «Nur angemeldeten Besuchern zeigen»<br /><br />Identifikationsnummer: I100<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br /><br />Auswahl: «Ereignis-Details zeigen»<br /><br />Wem zeigen?: «Nur angemeldeten Besuchern zeigen»<br /><br />Diese Einstellung ändert die Variablen \$person_facts in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["accessible_by"]			= "Wem zeigen?";
$pgv_lang["hide"]				= "Verbergen";
$pgv_lang["show_question"]			= "Anzeigen?";
$pgv_lang["user_name"]				= "Benutzername";
$pgv_lang["name_of_fact"]			= "Ereignis-Bezeichnung";
$pgv_lang["choice"]				= "Auswahl";
$pgv_lang["fact_show"]				= "Ereignis zeigen";
$pgv_lang["fact_details"]			= "Ereignis-Details zeigen";
$pgv_lang["privacy_header"]			= "Datenschutz-Einstellungen bearbeiten in";
$pgv_lang["unable_to_find_privacy_indi"]	= "Zu folgender ID kann keine Person gefunden werden:";
$pgv_lang["save_and_import"]			= "Nach dem Speichern dieser GEDCOM Konfiguration müssen Sie die Daten importieren, indem  Sie auf den <strong>Diese GEDCOM-Datei importieren</strong> Button klicken oder über fogende Menüpunkte: <strong>Verwalten->GEDCOM-Datei Management->GEDCOM Import</strong>";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Namen lebender Personen anzeigen";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Verwandtschafts-Datenschutz einschalten";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. Länge der Verwandtschaft";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Verwandtschaft anhand von Eheschließungen überprüfen";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Verstorbene Personen anzeigen";
$pgv_lang["help_info"]				= "Hilfe erhalten Sie, wenn Sie auf das jeweilige rote Fragezeichen (?) hinter der Einstellungsbezeichnung klicken.<br /><br />";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Namen lebender Personen anzeigen<br /><br />Mit dieser Einstellung können Sie definieren, wem die Namen lebender Personen angezeigt werden.<br /><br />Üblicherweise sollte diese Variable die Einstellung «Nur angemeldeten Benutzern zeigen» haben. Dies dient dem Datenschutz lebender Personen, die in Ihrer GEDCOM-Datenbank enthalten sind, denn Sie können selber bestimmen, wem Sie den allgemeinen Zugriff auf Ihre Ahnenforschungsdaten geben.<br /><br />Die Einstellung «Nur Verwaltern zeigen» verhindert die Anzeige der Namen lebender Personen auch für angemeldete Besucher, die jedoch keinen Verwalterstatus haben.<br /><br />Diese Einstellung ändert die Variable \$SHOW_LIVING_NAMES in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Forschungs-Assistent zeigen";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br />Verwandtschafts-Datenschutz einschalten.<br /><br />«Nein» bedeutet, dass alle authentifizierten Benutzer alle Daten lebender Personen zu sehen bekommen.<br /><br />«Ja» bedeutet, dass authentifizierte Benutzer nur die Daten lebender Personen zu sehen bekommen, mit denen sie verwandt sind.<br /><br />Der Verwandtschaftsgrad wird mit der Einstellung «Max. Länge der Verwandtschaft» eingestellt.<br /><br />Diese Einstellung ändert die Variable \$USE_RELATIONSHIP_PRIVACY in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Maximalen Verwandtschaftsgrad einstellen<br /><br />Diese Einstellung ändert die Variable \$MAX_RELATION_PATH_LENGTH in der gewählten Datenschutz-Datei.<br /><br />Wenn '#pgv_lang[USE_RELATIONSHIP_PRIVACY]#' aktiv ist, können angemeldete Benutzer nur die Daten lebender Personen bis zu diesem Verwandschaftsgrad ansehen oder bearbeiten.<br /><br />";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Verwandtschaft anhand von Eheschließungen überprüfen<br /><br />Soll der Verwandtschaftsgrad auch durch Zurhilfenahme von Eheschließungsdaten geprüft werden?<br /><br />Diese Einstellung ändert die Variable \$CHECK_MARRIAGE_RELATIONS in der gewählten Datenschutz-Datei.<br /><br />";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Verstorbene Personen anzeigen<br /><br />Setzt die Datenschutz-Einstellungen für alle verstorbenen Personen.<br /><br />";
$pgv_lang["select_privacyfile_button"]		= "Datenschutzdatei auswählen";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Datenschutz mittels Alter eines Ereignisses begrenzen";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Wenn Sie den Datenschutz mittels des Alters eines Ereignisses begrenzen, werden Details von Personen angezeigt oder verborgen in Abhängigkeit davon, wie alt die Person zum Zeitpunkt des Ereignisses war (unabhängig davon, ob die Person noch lebt oder inzwischen verstorben ist). Verwenden Sie diese Einstellung in Verbindung mit «Alter, ab dem angenommen wird, dass eine Person verstorben ist». Wenn Sie z.B. den Alters-Wert auf 100 einstellen und die eben genannte Option auf «Ja», werden alle Personen (lebend oder verstorben), die vor weniger als 100 Jahren geboren wurden, als privat behandelt. Personen, die vor weniger als 85 Jahren geheiratet haben und Personen, die vor weniger als 75 Jahren verstorben sind, werden ebenfalls als privat behandelt. Beachten Sie bitte, dass diese Option den Seitenaufbau etwas verlangsamt.<br /><br />Diese Einstellung ändert die Variable \$PRIVACY_BY_YEAR in der Datenschutzdatei.<br /><br />";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Sprach-Dateien bearbeiten und konfigurieren";
$pgv_lang["bom_check"]		= "Sprach-Datei BOM-Test";
$pgv_lang["bom_check_help"]		= "Dieser Test untersucht die Sprach-Datei auf eine BOM (Byte Order Mark: Kennzeichnung von ANSI-Dateien, die aber den PHP-Interpreter stört). Gegebenenfalls wird die BOM entfernt.<br /><br />";
$pgv_lang["lang_debug"]			= "Debug-Option für Hilfe-Texte";
$pgv_lang["lang_debug_use"]		= "Benutze Hilfe-Text Debug-Option";
$pgv_lang["bom_not_found"]		= "Es wurde keine BOM gefunden.<br /><br />";
$pgv_lang["bom_found"]			= "BOM wurde gefunden in ";
$pgv_lang["edit_lang_utility"]		= "Bearbeitungsmodul für Sprach-Dateien";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />Dieses Modul dient zum Bearbeiten der Sprachdateien.<br /><br />Es zeigt den Inhalt der englischen Original-Datei und den Inhalt der ausgewählten Sprachdatei an.<br /><br />Durch einen Klick auf den Inhalt der ausgewählten Datei öffnet sich ein neues Fenster, in dem die Übersetzung geschrieben oder der vorhandene Text bearbeitet und anschließend gespeichert werden kann.<br /><br />";
$pgv_lang["edit_lang_utility_warning"]	= "ACHTUNG!<br /><br />Wenn Sie den Button &laquo;#pgv_lang[close_window_without_refresh]#&raquo; benutzen, werden Sie die Ihre Änderungen nicht sehen, es sei denn, Sie laden die Seite manuell neu. Außerdem kann die Sprachdatei zerstört werden, wenn Sie dann einen Eintrag hinzufügen, der noch nicht existierte, oder wenn Sie einen unmittelbar zuvor geänderten Eintrag erneut ändern!<br /><br />Dieser Button ist also nur für fortgeschrittene Anwender, die genau wissen, was sie tun.<br /><br />";
$pgv_lang["language_to_edit"]		= "Zu bearbeitende Sprache";
$pgv_lang["file_to_edit"]		= "Zu bearbeitende Sprachdatei";
$pgv_lang["check"]			= "Prüfen";
$pgv_lang["lang_save"]			= "Speichern";
$pgv_lang["contents"]			= "Inhalt";
$pgv_lang["listing"]			= "Einträge";
$pgv_lang["no_content"]			= "kein Inhalt";
$pgv_lang["editlang"]			= "Bearbeite";
$pgv_lang["editlang_help"]		= "Sprachdatei bearbeiten";
$pgv_lang["savelang"]			= "speichern";
$pgv_lang["savelang_help"]		= "Änderung speichern";
$pgv_lang["original_message"]		= "Original Inhalt";
$pgv_lang["message_to_edit"]		= "Zu ändernder Inhalt";
$pgv_lang["changed_message"]		= "Geänderter Inhalt";
$pgv_lang["message_empty_warning"]	= "-&gt; Achtung!!! Dieser Eintrag ist in der Datei [#LANGUAGE_FILE#] leer &lt;-";
$pgv_lang["language_to_export"]		= "Zu exportierende Sprache";
$pgv_lang["export_lang_utility"]	= "Exportmodul für Sprach-Dateien";
$pgv_lang["export"]			= "Exportieren";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />Mit diesem Modul können Sie eine Sprache auswählen und auf den Export-Button klicken, um die Hilfetexte der gewählten 'configuration_help' Sprachdatei zwecks Erstellung einer Anleitung in Ihrer Sprache zu exportieren.<br /><br />";
$pgv_lang["export_ok"]			= "Die Hilfetexte wurden exportiert";
$pgv_lang["compare_lang_utility"]	= "Vergleichsmodul für Sprach-Dateien";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />Dieses Modul vergleicht zwei Sprachdateien und zeigt die Unterschiede an.<br /><br />Beachten Sie auch die Datei [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>], bezüglich weiterer Änderungen.<br /><br />";
$pgv_lang["new_language"]		= "Referenz-Sprache";
$pgv_lang["old_language"]		= "Zweite Sprache";
$pgv_lang["compare"]			= "Vergleichen";
$pgv_lang["comparing"]			= "Die Sprach-Dateien werden verglichen";
$pgv_lang["additions"]			= "Ergänzungen";
$pgv_lang["no_additions"]		= "Keine Ergänzungen";
$pgv_lang["subtractions"]		= "Entfernte Teile";
$pgv_lang["no_subtractions"]		= "Keine entfernten Teile";
$pgv_lang["config_lang_utility"]	= "Konfiguration der unterstützten Sprachen";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Dieses Modul hilft Ihnen die Sprachen-spezifischen Einstellungen in PhpGedView vorzunehmen.<br /><br />Bitte beachten: Wenn Sie die Grundeinstellungen für Sprachen in PhpGedView verändern, wird eine neue Datei (#INDEX_DIRECTORY#lang_settings.php) im #INDEX_DIRECTORY#-Verzeichnis erstellt.<br /><br />Alle weiteren Änderungen werden in dieser Datei gespeichert und PhpGedView wird auch nur noch DIESE Datei verwenden.<br /><br />Wenn Sie also Schwierigkeiten mit den Spracheinstellungen haben, so teilen Sie dem Support bitte auch unbedingt mit, wenn diese neue Datei in Ihrem #INDEX_DIRECTORY#-Verzeichnis existiert!";
$pgv_lang["active"]			= "Aktiviert";
$pgv_lang["active_help"]		= "Erlauben Sie den Besuchern, diese Sprache auszuwählen, sofern der Sprachwechsel generell erlaubt ist.<br /><br />";
$pgv_lang["edit_settings"]		= "Einstellungen bearbeiten";
$pgv_lang["lang_edit"]			= "Bearbeiten";
$pgv_lang["lang_language"]		= "Sprache";
$pgv_lang["export_filename"]		= "Name der Datei, welche die exportierten Daten enthält:";
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[lang_edit]#~<br /><br />Auf dieser Seite können Sie Ihre Sprachdateien verwalten.<br /><br />Sie können Sprachdateien übersetzen, vergleichen und exportieren. Außerdem können Sie auswählen, welche Sprachen vom Programm unterstützt werden.<br /><br />Sie können die folgenden Optionen und Tools nutzen:";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />Hier können Sie die Sprache auswählen, deren Texte Sie <b>bearbeiten</b> möchten.<br /><br />";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />Hier können Sie den Typ der Sprachdatei auswählen, die Sie ändern möchten.<br /><br />Folgende Typen sind vorhanden:<br /><br />admin.xx.php<br /><br />configure_help.xx.php<br /><br />edit.xx.php<br /><br />facts.xx.php<br /><br />help_text.xx.php<br /><br />lang.xx.php<br /><br />Hierbei steht xx für den Sprachcode der von Ihnen gewählten Sprache und wird automatisch eingefügt.<br /><br />";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Wenn auf 'Ja' eingestellt, sehen Sie nur die Meldungen der gewählten Sprache, die noch nicht übersetzt wurden, d.h. die Meldungen, die in der Sprachdatei noch fehlen.  Nachdem Sie die Übersetzung eines Textes eingegeben haben, wird diese folglich dann auch sofort ausgeblendet.<br /><br />";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Hier können Sie die Sprache wählen, aus der Sie Texte <b>exportieren</b> möchten.<br /><br />";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Hier können Sie die Sprache einstellen, die Sie als Referenz für den Vergleich mit einer anderen Datei verwenden möchten.<br /><br />Alle Änderungen und Ergänzungen werden vom Programmiererteam zuerst in den <u>englischen</u> Dateien vorgenommen.<br /><br />";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Hier können Sie die Sprache einstellen, deren Texte Sie mit der zuvor ausgewählten Sprache vergleichen möchten.<br /><br />Nachdem Sie die Auswahl getroffen haben, klicken Sie auf den Button <b>Vergleichen</b> und Sie erhalten eine Liste der Unterschiede.<br /><br />Zum Verständnis:<br /><br /><b>Ergänzungen</b> bedeutet: Dieser Text <b>besteht</b> in der Referenz-Datei aber <b>nicht</b> in der zweiten Datei.<br /><br /><b>Entfernte Teile</b> bedeutet: Der Text besteht <b>nicht</b> in der Referenzdatei aber <b>ist</b> in der zweiten Datei vorhanden.<br /><br />";
$pgv_lang["lang_back"]			= "Zurück zum Hauptmenü, um die Sprach-Dateien zu bearbeiten und zu konfigurieren";
$pgv_lang["lang_back_admin"]		= "Zurück zum Verwaltungs-Menü";
$pgv_lang["lang_back_manage_gedcoms"]	= "Zurück zum GEDCOM Verwaltungs-Menü";
$pgv_lang["lang_name_czech"]		= "Tschechisch";
$pgv_lang["lang_name_chinese"]		= "Chinesisch";
$pgv_lang["lang_name_danish"]		= "Dänisch";
$pgv_lang["lang_name_dutch"]		= "Holländisch";
$pgv_lang["lang_name_english"]		= "Englisch";
$pgv_lang["lang_name_finnish"]		= "Finnisch";
$pgv_lang["lang_name_french"]		= "Französisch";
$pgv_lang["lang_name_german"]		= "Deutsch";
$pgv_lang["lang_name_hebrew"]		= "Hebräisch";
$pgv_lang["lang_name_hungarian"]	= "Ungarisch";
$pgv_lang["lang_name_italian"]		= "Italienisch";
$pgv_lang["lang_name_norwegian"]	= "Norwegisch";
$pgv_lang["lang_name_polish"]		= "Polnisch";
$pgv_lang["lang_name_portuguese"]	= "Portugiesisch";
$pgv_lang["lang_name_portuguese-br"]	= "Portugiesisch (Brasilien)";
$pgv_lang["lang_name_russian"]		= "Russisch";
$pgv_lang["lang_name_spanish"]		= "Spanisch";
$pgv_lang["lang_name_spanish-ar"]	= "Spanisch (Latein-Amerika)";
$pgv_lang["lang_name_swedish"]		= "Schwedisch";
$pgv_lang["lang_name_turkish"]		= "Türkisch";
$pgv_lang["lang_name_greek"]		= "Griechisch";
$pgv_lang["lang_name_arabic"]		= "Arabisch";
$pgv_lang["lang_name_lithuanian"]	= "Litauisch";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamesisch";
$pgv_lang["lang_name_slovak"]		= "Slowakisch";
$pgv_lang["lang_name_estonian"]		= "Estnisch";
$pgv_lang["lang_new_language"]		= "Neue Sprache";
$pgv_lang["original_lang_name"]		= "Original-Name der Sprache auf #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~#pgv_lang[original_lang_name]#~<br /><br />Wie heißt die Sprache in dieser Sprache?<br /><br />Englisch heißt in Englisch: English<br /><br />Deutsch heißt in Deutsch: Deutsch<br /><br />Niederländisch heißt in Niederländisch: Nederlands<br /><br />etc.<br /><br />";
$pgv_lang["lang_shortcut"]		= "Abkürzung für Sprachdateien";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Dieses Kürzel wird verwendet, um die Sprachdateien dieser Sprache in PhpGedView zu benennen.<br /><br />Normalerweise ist dies der selbe Code, wie der erste unter 'Sprachen Kenncodes' genannte, der im nächsten Feld definiert werden kann.<br /><br />";
$pgv_lang["lang_langcode"]		= "Sprachen Kenncodes";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Diese Codes ermöglichen PhpGedView, die Spracheinstellung des Browsers zu erkennen, mit dem ein Besucher Ihre PhpGedView Seiten betrachtet. Die Codes müssen mit Semikolons ';' getrennt werden";
$pgv_lang["lang_filenames"]		= "Sprach-Datei";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Flaggendatei";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Name und Pfad der Bilddatei für die Nationalflagge der ausgewählten Sprache.<br /><br />";
$pgv_lang["text_direction"]		= "Schreibrichtung";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Gibt an, in welcher Richtung der Text in der gewählten Sprache ausgegeben wird.<br /><br />Die Westlichen Sprachen nutzen normalerweise die Richung 'von links nach rechts'.<br /><br />In Arabischen Sprachen oder z.B. Hebräisch wird aber 'von rechts nach links' geschrieben und gelesen.<br /><br />";
$pgv_lang["date_format"]			= "Datumsformat";
$pgv_lang["date_format_help"] = "~#pgv_lang[date_format]#~<br /><br />Dieses Feld beschreibt das Datumsformat für genealogische Angaben. Durch die Wahl entsprechender Buchstaben entweder aus der <b>Standard</b> oder aus der <b>Erweiterten</b> Liste, ist es möglich, das Datumsformat genau zu beschreiben.<ul><li><b>Standard</b><br />Folgende Buchstaben symbolisieren verschiedene Teile der Datumsangabe.  Bitte beachten Sie, dass die Buchstaben <b>D</b> und <b>M</b> in diesem Format andere Bedeutungen haben als im <b>Erweiterten</b> Format.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;Tag des Monats, ohne Null; d.h. 1 bis 31<br /><b>M</b>&nbsp;&nbsp;Monatsname; d.h. Januar, Februar, etc.<br /><b>Y</b>&nbsp;&nbsp;Jahreszahl; z.B. 1999 oder 44v.Chr.<br /><b>R</b>&nbsp;&nbsp;Kalender Umrechnung.  Bitte lesen Sie das Thema <b>Kalender Umrechnung</b>, unten.</p>Diese Buchstaben können in beliebiger Reihenfolge, zusammen mit Leerzeichen und anderer Punktierung angegeben werden.  Als Beispiel nehmen wir an, dass die Datenbank das Datum 20&nbsp;AUG&nbsp;1965 enthält.<p style=\"padding-left: 25px\"><b>Englische</b> Benutzer könnten das Datumsformat mit <b>D&nbsp;M&nbsp;Y</b> beschreiben, um dadurch Datumsangaben wie <b>20&nbsp;August&nbsp;1965</b> zu erhalten.<br /><b>Amerikanische</b> Benutzer könnten das Datumsformat mit <b>M&nbsp;D,&nbsp;Y</b> beschreiben, um dadurch Datumsangaben wie <b>August&nbsp;20,&nbsp;1965</b> zu erhalten.<br /><b>Deutsche</b> Benutzer könnten das Datumsformat mit <b>D.&nbsp;M&nbsp;Y</b> beschreiben, um dadurch Datumsangaben wie <b>20.&nbsp;August&nbsp;1965 zu erhalten.</b><br /><b>Ungarische</b> Benutzer könnten das Datumsformat mit <b>Y.&nbsp;M&nbsp;D.</b> beschreiben, um dadurch Datumsangaben wie <b>1965.&nbsp;augusztus&nbsp;20.</b> zu erhalten.</p><br /></li><li><b>Erweitert</b><br />Komplizierte Datendarstellungen können durch die Wahl anderer Buchstaben bewirklicht werden.  Wenn Sie in Ihrer Format-Angabe andere Buchstaben als nur <b>D</b>, <b>M</b>, <b>Y</b>, oder <b>R</b> benutzen, nimmt das Programm an, dass Sie das <b>Erweiterte</b> Datenformat benutzen möchten.<br /><br />Folgende Buchstaben symbolisieren verschiedene Teile der Datumsangabe.  Bitte beachten Sie, dass die Buchstaben <b>D</b> und <b>M</b> in diesem Format andere Bedeutungen haben als im <b>Standard</b> Format.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;Tag des Monats, mit Null; d.h. 01 bis 31<br /><b>j</b>&nbsp;&nbsp;Tag des Monats, ohne Null; d.h. 1 bis 31<br /><b>S</b>&nbsp;&nbsp;Ordinalangabe des Tages; in Deutschen Daten bedeutungslos, aber als Englisches Beispiel: <b>th</b> wie im Datum <b>4th&nbsp;July</b>.<br /><b>l</b> (klein geschriebenes \"L\")&nbsp;&nbsp;Wochentag; d.h. Montag, Dienstag, etc.<br /><b>D</b>&nbsp;&nbsp;gekürzter Wochentag; d.h. Mo, Di, Mi, Do, F, Sa, So<br /><b>N</b>&nbsp;&nbsp;Wochentag, nach dem ISO-Standard; d.h. 0 bis 6<br /><b>w</b>&nbsp;&nbsp;Wochentag, als Ziffer; d.h. 1 bis 7<br /><b>z</b>&nbsp;&nbsp;Jahrestag; d.h. 1 bis 365<br /><b>F</b>&nbsp;&nbsp;Monatsname; d.h. Januar, Februar, etc.<br /><b>M</b>&nbsp;&nbsp;gekürzter Monatsname, d.h. Ja, Fe, etc.<br /><b>m</b>&nbsp;&nbsp;Monat, mit Null; d.h. 01 bis 12<br /><b>n</b>&nbsp;&nbsp;Monat, ohne Null; d.h. 1 bis 12<br /><b>Y</b>&nbsp;&nbsp;Jahreszahl; z.B. 1999 oder 44v.Chr.<br /><b>y</b>&nbsp;&nbsp;gekürztes Jahr.  Manche Kalender erlauben das Kürzen der Jahreszahl.  Im Jüdischen Kalender kann die Tausender-Zahl fortgelassen werden.  Im Gregorianischen Kalender ist die Kürzung der Jahreszahl nicht erlaubt, und deshalb funktioniert <b>y</b> genau wie <b>Y</b> wenn solche Daten dargestellt werden sollen.<br /><b>R</b>&nbsp;&nbsp;Kalender Umrechnung.  Bitte lesen Sie das Thema <b>Kalender Umrechnung</b>, unten.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;Darstellung der einzelnen Datumsteile im internen Format der Datenbank.</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;Kalender-Code, z.B. @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;Tag des Monats, mit Null; d.h. 01 bis 31<br /><b>O</b>&nbsp;&nbsp;Monat, z.B. JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;Jahreszahl; z.B. 1999<br /><br />Um die rohen Daten zu sehen, sollten Sie <b>A&nbsp;O&nbsp;E</b> or <b>@&nbsp;A&nbsp;O&nbsp;E</b> als Datumsformat eingeben.</p><b>Einige Beispiele</b> des Datums 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8&nbsp;September&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Sep&nbsp;65<br><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Mittwoch&nbsp;-&nbsp;08&nbsp;-&nbsp;September&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] = "<li><b>Kalender Umrechnung</b><br />Das <b>R</b> Code hat eine etwas ungewöhnliche Funktion.  Wenn dieses Code im Datums-Format vorhanden ist, wird das normale Datum ein zweites Mal, aber in einem anderen Kalendersystem dargestellt.  Die Elemente dieser zweiten Darstellung, die immer zwischen Klammern gezeigt wird, folgen den Regeln wie sie vom restlichen Datums-Format bestimmt sind.  Die Beispiele des Themas <b>Kalender der Französchen Republik</b> erklären dieses hoffentlich etwas besser.<br /><br />Die Umrechnung des Kalenders wird von der momentan gültigen Sprache bestimmt.  Wenn die Hebräische Sprache gewählt ist, werden alle normale Daten ein zweites mal im <b>Jüdischen Kalender</b> gezeigt.  Wenn die Arabische Sprache gewählt ist, werden alle normale Daten ein zweites mal im <b>Hijri Kalender</b> gezeigt.  In allen anderen Fällen, folgt die zweite Darstellung im <b>Kalender der französchen Republik</b>.<br /><br />Das <b>R</b> Code hat eine ähnliche Folge wie die die Kalender-Wahl in der GEDCOM Konfiguration.  Der Unterschied ist dass das <b>R</b> Code, da es in den Sprachen konfiguriert wird, nur in gewählten Sprachen, aber in allen Datenbanken funktioniert, während die Kalender-Wahl, da sie in einzelnen GEDCOM-Konfigurationen gemacht wird, in allen Sprachen der jeweiligen GEDCOM funktioniert.<br /><ul><li><b>Kalender der französichen Republik</b><br />Außer einer kurzen Zeit im Mai 1871, war dieses Kalendersystem nur in Frankreich und zwischen dem 22.&nbsp;September&nbsp;1792 und dem 31.&nbsp;Dezember&nbsp;1805 in täglichem Gebrauch.  Deshalb sind nur Daten aus diesem Bereich im Kalender der französischen Republik möglich.<br /><br />Angenommen daß die Englische Sprache aktuell ist, hier sind einige Beispiele:<br />Das Datumsformat <b>Y.m.d&nbsp;R</b> könnte <b>1805.04.26&nbsp;(XIII.08.06)</b> oder <b>1806.01.01</b> als Resultat haben;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> könnte <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> or <b>1&nbsp;January&nbsp;1806</b> als Resultat haben.</li></ul><br /></li><li><b>Sprachen Änderungen</b>&nbsp;&nbsp;&nbsp;Die gekürzten Texte der Codes <b>D</b> und <b>M</b> des erweiterten Formats befinden sich in der Datei <i>languages/lang.xx.php</i> wie, zum Beispiel, <code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";</code>&nbsp;&nbsp; und&nbsp;&nbsp; <code>\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Sie haben die Möglichkeit, diese Abkürzungen durch Einträge in der Datei <i>languages/extra.xx.php</i> zu ändern.  Diese besondere Datei, und wie sie genutzt werden kann, ist auführlich in Wiki und der readme Datei beschrieben.  Zum Beispiel:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sonn\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code><br /><br /><br /></li><li><b>Besondere Regeln</b>&nbsp;&nbsp;&nbsp;Besondere Regeln über Daten sind in einigen Sprachen üblich.  Diese besonderen Regeln sind durch verschiedene <i>includes/extras/functions.xx.php</i> programm bewirklicht.</li></ul>";
$pgv_lang["time_format"]		= "Uhrzeitformat";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />Dieses Feld definiert das Uhrzeitformat, das in der ausgewählten Sprache benutzt wird.<br /><br />Variablen, die Sie in diesem Feld benutzen können:<br /><br />a - Kleingeschrieben: Ante meridiem und Post meridiem (am oder pm)<br /><br />A - Großgeschrieben: Ante meridiem und Post meridiem (AM oder PM)<br /><br />B - Swatch-Internet-Zeit (000 bis 999)<br /><br />c - ISO 8601 Datum (hinzugefügt in PHP 5) 2004-02-12T15:19:21+00:00<br /><br />d - Tag des Monats, 2-stellig mit führender Null (01 bis 31)<br /><br />D - Tag der Woche als mit drei Buchstaben (Mon bis Sun)<br /><br />F - Monat als ganzes Wort, wie January oder March (January bis December)<br /><br />g - 12-Stunden-Format, ohne führende Nullen (1 bis 12)<br /><br />G - 24-Stunden-Format, ohne führende Nullen (0 bis 23)<br /><br />h - 12-Stunden-Format, mit führenden Nullen (01 bis 12)<br /><br />H - 24-Stunden-Format, mit führenden Nullen (00 bis 23)<br /><br />i - Minuten mit führenden Nullen (00 bis 59)<br /><br />I - (großes i) Fällt ein Datum in die Sommerzeit (1 bei Sommerzeit, ansonsten 0)<br /><br />j - Tag des Monats ohne führende Nullen (1 bis 31)<br /><br />l - (kleines 'L') Ausgeschriebener Tag der Woche (Sunday bis Saturday)<br /><br />L - Schaltjahr oder nicht (1 für ein Schaltjahr, ansonsten 0)<br /><br />m - Monat als Zahl, mit führenden Nullen (01 bis 12)<br /><br />M - Monatsname mit drei Buchstaben (Jan bis Dec)<br /><br />n - Monatszahl, ohne führende Nullen (1 bis 12)<br /><br />O - Zeitunterschied zur Greenwich time (GMT) in Stunden (Beispiel: +0200)<br /><br />r - RFC 2822 formatiertes Datum (Beispiel: Thu, 21 Dec 2000 16:01:07 +0200)<br /><br />s - Sekunden, mit führenden Nullen (00 bis 59)<br /><br />S - Anhang der englischen Aufzählung für einen Monatstag, zwei Zeichen (st, nd, rd oder th. Zur Verwendung mit j empfohlen)<br /><br />t - Anzahl der Tage des angegebenen Monats (28 bis 31)<br /><br />T - Zeitzoneneinstellung des Rechners (Beispiele: CEST, EST, MDT ...)<br /><br />U - Sekunden seit Beginn der UNIX-Epoche - January 1 1970 00:00:00 GMT)<br /><br />w - Numerischer Tag einer Woche (0 - für Sonntag bis 6 - für Samstag)<br /><br />W - ISO-8601 Wochennummer des Jahres, die Woche beginnt am Montag (hinzugefügt in PHP 4.1.0) (Beispiel: 42 - die 42 Woche im Jahr)<br /><br />Y - Vierstellige Jahreszahl (Beispiel: 1999 oder 2003)<br /><br />y - Jahreszahl, zweistellig (Beispiele: 99 oder 03)<br /><br />z - Der Tag eines Jahres (0 bis 365)<br /><br />Z - Offset der Zeitzone in Sekunden. Der Offset für Zeitzone West nach UTC ist immer negativ und für Zeitzone Ost nach UTC immer positiv. (-43200 bis 43200)<br /><br />Sie können die Reihenfolge dieser Variablen ändern und auch Trennungszeichen einfügen.<br /><br />Z.B. hat das Feld in der deutschen Sprache standardmäßig folgenden Inhalt: 'H:i:s' welches folgende Ausgabe erzeugt: '09:01:25'.<br /><br />In Englisch is die Standard-Definition in diesem Feld: 'g:i:sa' welches folgende Ausgabe erzeugt: '9:01:25am'.<br /><br />";
$pgv_lang["week_start"]			= "1. Tag der Woche";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Der Tag der Woche, mit dem in diesem Sprachraum eine neue Woche beginnt. In vielen Sprachen beginnt die Woche Sonntags, aber in anderen auch am Montag oder an anderen Tagen.<br /><br />";
$pgv_lang["name_reverse"]		= "Nachname zuerst";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />In einigen Sprachen wird üblicherweise der Nachname vor den Vornamen gestellt, währen er normalerweise hinten steht. Wählen Sie diese Option, um den Nachnamen zuerst anzuzeigen.<br /><br />";
$pgv_lang["ltr"]			= "Links nach rechts";
$pgv_lang["rtl"]			= "Rechts nach links";
$pgv_lang["file_does_not_exist"]	= "FEHLER! Diese Datei existiert nicht...<br /><br />";
$pgv_lang["optional_file_not_exist"]	= "Diese nicht erforderliche Datei fehlt.";
$pgv_lang["alphabet_upper"]		= "Alphabet Großbuchstaben";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Großbuchstaben-Alphabet. Dieses Alphabet wird benutzt, um die groß geschriebenen Namen in den Namen-Listen von PhpGedView zu sortieren (in der gewählte Sprache).<br /><br />";
$pgv_lang["alphabet_lower"]		= "Alphabet Kleinbuchstaben";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Kleinbuchstaben-Alphabet. Dieses Alphabet wird benutzt, um die klein geschriebenen Namen in den Namen-Listen von PhpGedView zu sortieren (in der gewählte Sprache).<br /><br />";
$pgv_lang["multi_letter_alphabet"]		= "Mehrstelliges Alphabet";
$pgv_lang["dictionary_sort"]		= "Benutze Wörterbuch-Regeln zum Sortieren";
$pgv_lang["lang_config_write_error"]	= "Fehler beim Versuch, die Spracheinstellungen in die Datei [language_settings.php] zu schreiben. Prüfen Sie die Zugriffsrechte und probieren Sie es erneut.<br /><br />";
$pgv_lang["translation_forum"]		= "Link zum PhpGedView Übersetzungs-Forum bei SourceForge.net";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />Dieser Link öffnet ein neues Browserfenster, in dem Sie zum Übersetzungs-Forum von PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245) geleitet werden, wo Probleme bezüglich der Übersetzung von PhpGedView besprochen werden können.<br /><br />";
$pgv_lang["lang_set_file_read_error"]	= "F E H L E R !!! Die Datei [language_settings.php] konnte nicht gelesen werden!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />Hiermit können Sie neue Sprachdateien (für eine bisher nicht unterstützte Sprache) zu PhpGedView hinzufügen.<br /><br />Bitte füllen Sie alle erforderlichen Felder im folgenden Fenster aus.<br /><br />Sobald diese neuen Dateien erstellt sind, können Sie die Texte für diese Sprache ändern.<br /><br />";
$pgv_lang["add_new_lang_button"]	= "Neue Sprache hinzufügen";
$pgv_lang["hide_translated"]		= "Übersetzte verstecken";
$pgv_lang["lang_file_write_error"]	= "F E H L E R !!!<br /><br />Die Änderungen können nicht in die gewählte Sprachdatei geschrieben werden!<br /><br />Prüfen Sie die Schreibrechte für (#lang_filename#).<br /><br />";
$pgv_lang["no_open"]	= "F E H L E R !!!<br /><br />Die Datei #lang_filename# kann nicht geöffnet werden.<br /><br />";
$pgv_lang["users_langs"]			= "Sprache des Benutzers";
$pgv_lang["configured_languages"]	= "Benutzte Sprachen";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Benutzerdaten Migrations-Tool";
$pgv_lang["um_proceed"] = "Mit Export der Benutzerdaten fortfahren ?<br /><br />";
$pgv_lang["um_creating"] = "Erstellen";
$pgv_lang["um_file_create_fail1"] = "Die neue Datei konnte nicht erstellt werden, weil eine Datei mit gleichem Namen bereits existiert:";
$pgv_lang["um_file_create_fail2"] = "Erstellen fehlgeschlagen";
$pgv_lang["um_file_create_fail3"] = "Prüfen Sie die Zugriffsrechte für dieses Verzeichnis.<br /><br />";
$pgv_lang["um_file_create_succ1"] = "Erstellen der neuen Datei abgeschlossen:";
$pgv_lang["um_file_not_created"] = "Datei wurde nicht erstellt.<br /><br />";
$pgv_lang["um_nomsg"] = "Es liegen keine Nachrichten vor.<br /><br />";
$pgv_lang["um_nofav"] = "Es sind keine Lesezeichen vorhanden.<br /><br />";
$pgv_lang["um_nonews"] = "Es liegen keine Neuigkeiten vor.<br /><br />";
$pgv_lang["um_noblocks"] = "Es sind keine Blöcke vorhanden.<br /><br />";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Export";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Benutzer-Datei auf den Index-Modus umstellen~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Benutzer-Datei auf den SQL Modus umstellen~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importierte Benutzer";
$pgv_lang["um_imp_blocks"] = "Importierter Block";
$pgv_lang["um_imp_favorites"] = "Importierte Lesezeichen";
$pgv_lang["um_imp_messages"] = "Importierte Mitteilung";
$pgv_lang["um_imp_news"] = "Importierte Nachrichten";
$pgv_lang["um_imp_succ"] = "Import erfolgreich";
$pgv_lang["um_imp_fail"] = "Import gescheitert";
$pgv_lang["um_backup"] = "Backup";
$pgv_lang["um_zip_succ"] = "ZIP-Datei erstellt.<br /><br />";
$pgv_lang["um_zip_dl"] = "ZIP Sicherheits-Kopien herunterladen";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView Konfigurationsdatei";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM-Dateien";
$pgv_lang["um_bu_gedsets"] = "GEDCOM Einstellungen-, Konfiguration-, und Privatsphären-Dateien";
$pgv_lang["um_bu_logs"] = "GEDCOM Zähler-, SearchLog-, und LogFile-Dateien";
$pgv_lang["um_bu_usinfo"] = "Benutzer-Dateien, Konfiguration der Blöcke, Lesezeichen, Nachrichten, und Notizen";
$pgv_lang["um_bu_media"]	= "Medien-Dateien";
$pgv_lang["um_mk_bu"] = "Erstelle Backup";
$pgv_lang["um_nofiles"] = "Keine Dateien für Sicherheitskopie gefunden.<br /><br />";
$pgv_lang["um_files_exist"] = "Möchten Sie bereits bestehenden Ausgangs-Dateien überschreiben?";
$pgv_lang["um_results"]		= "Ergebnis";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Maximale Import-Laufzeit.<br /><br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Breite des erstellten Miniaturbildes";
$pgv_lang["SHOW_SOURCES"]			= "Zeige Quellen";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Verwalterzustimmung zu neuen Benutzeranträgen erforderlich";
$pgv_lang["SPLIT_PLACES"]			= "Orte im Bearbeitungsmodus teilen";
$pgv_lang["ALLOW_REMEMBER_ME"]		= "<b>Automatische Anmeldung</b> Option auf der Login-Seite zeigen";
$pgv_lang["UNDERLINE_NAME_QUOTES"]	= "Namen zwischen Anführungszeichen unterstreichen";
$pgv_lang["PRIVACY_BY_RESN"]		= "Datenschutz je GEDCOM (RESN) benutzen";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "HLT Ordinanz-Codes in Boxen zeigen";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Auf der «Persönliche Informationen» Seite zu zeigendes Standard-Register";
$pgv_lang["SHOW_MARRIED_NAMES"]		= "Ehenamen in der Personenliste zeigen";
$pgv_lang["SHOW_QUICK_RESN"]		= "Datenschutz-Felder im Schnell-Edit Formular zeigen";
$pgv_lang["USE_QUICK_UPDATE"]		= "Schnell-Edit Formular benutzen";
$pgv_lang["SEARCHLOG_CREATE"]		= "SearchLog-Dateien Archiv";
$pgv_lang["CHANGELOG_CREATE"]		= "ChangeLog-Dateien Archiv";
$pgv_lang["CHART_BOX_TAGS"]		= "Andere auf Diagrammen zu zeigende Ereignisse";
$pgv_lang["FAM_FACTS_ADD"] 			= "Familienereignisse hinzufügen";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Ereignisse die diesem Familien-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Ereignis-Codes nach Ihren Wünschen ändern.  Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 		= "Einmal vorkommende Familienereignisse";
$pgv_lang["FAM_FACTS_UNIQUE_help"]	= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Ereignisse die im Familien-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn DATE hier eingegeben ist, darf jeder Familien-Datensatz nur eine DATE Zeile enthalten. Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[FAM_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["FAM_FACTS_QUICK"] 		= "Schnell hinzugefügte Familienereignisse";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der komplettenereignisliste gezeigt wird, bestimmt welche Ereignisse durch klicken des jeweiligen Links leicht zu dieser Familie hinzugefügt werden können.<br /><br />";
$pgv_lang["SOUR_FACTS_ADD"] 		= "Quellendaten hinzufügen";
$pgv_lang["SOUR_FACTS_ADD_help"]	= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Ereignisse die diesem Quellen-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Ereignis-Codes nach Ihren Wünschen ändern.  Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 		= "Einmal vorkommende Quellendaten";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]	= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Ereignisse die im Quellen-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn DATE hier eingegeben ist, darf jeder Quellen-Datensatz nur eine DATE Zeile enthalten. Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[SOUR_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["SOUR_FACTS_QUICK"] 		= "Schnell hinzugefügte Quellendaten";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der komplettenereignisliste gezeigt wird, bestimmt welche Ereignisse durch klicken des jeweiligen Links leicht zu dieser Quelle hinzugefügt werden können.<br /><br />";
$pgv_lang["REPO_FACTS_ADD"] 		= "Archivdaten hinzufügen";
$pgv_lang["REPO_FACTS_ADD_help"]	= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Ereignisse die diesem Archiv-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Ereignis-Codes nach Ihren Wünschen ändern.  Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 		= "Einmal vorkommende Archivdaten";
$pgv_lang["REPO_FACTS_UNIQUE_help"]	= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Ereignisse die im Archiv-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn DATE hier eingegeben ist, darf jeder Archiv-Datensatz nur eine DATE Zeile enthalten. Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[REPO_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["REPO_FACTS_QUICK"] 		= "Schnell hinzugefügte Archivdaten";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der komplettenereignisliste gezeigt wird, bestimmt welche Ereignisse durch klicken des jeweiligen Links leicht zu diesem Archiv hinzugefügt werden können.<br /><br />";
$pgv_lang["LANG_SELECTION"] 			= "Unterstützte Sprachen";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Medien ID-Nummer Präfix";
$pgv_lang["FAM_ID_PREFIX"]		= "Familien ID-Nummer Präfix";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Immer im Schnell-Edit Formular zu zeigende Familienereignisse";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Im Schnell-Edit Formular zu zeigende Familienereignisse";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Immer im Schnell-Edit Formular zu zeigende Ereignisse";
$pgv_lang["QUICK_ADD_FACTS"]			= "Im Schnell-Edit Formular zu zeigende Ereignisse";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Wenn Sie neue Familienmitglieder hinzufügen, kann PhpGedView je nach der gewählten Nachnamenstradition den Nachnamen der neuen Person automatisch ermitteln.<br /><br /><ul><li>Nach der <b>väterlichen</b> Tradition, erhalten alle Kinder den Nachnamen des Vaters</li><li>Nach den <b>spanischen</b> und <b>portugiesischen</b> Traditionen, erhalten Kinder einen doppelten Nachnamen von beiden Eltern</li><li>Nach der <b>islandischen</b> Tradition, erhalten Kinder den väterlichen Vornamen als Nachname, mit Suffix der das Geschlecht des Kindes andeutet.</li></ul><br /><br />";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dies ist eine, durch Komma getrennte, Liste von GEDCOM Tags die in dem Bearbeitungsformular für Namen gezeigt werden.  Wenn Sie Alphabete benutzen, die nicht vom lateinischen Alphabet stammen, z.B., die hebräischen, griechischen, russischen, oder arabischen Alphabete, möchten Sie wahrscheinlich Tags wie _HEB, ROM, FONE, usw. dem Formular hinzufügen.  Solche Tags ermöglichen es Ihnen, Namen in verschiedenen Alphabeten zu speichern.<br /><br />";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dies ist eine, durch Komma getrennte, Liste von GEDCOM Tags die in dem Bearbeitungsformular für Ortsnamen gezeigt werden.  Wenn Sie Alphabete benutzen, die nicht vom lateinischen Alphabet stammen, z.B., die hebräischen, griechischen, russischen, oder arabischen Alphabete, möchten Sie wahrscheinlich Tags wie _HEB, ROM, FONE, usw. dem Formular hinzufügen.  Solche Tags ermöglichen es Ihnen, Ortsnamen in verschiedenen Alphabeten zu speichern.<br /><br />";
$pgv_lang["INDI_FACTS_ADD"] 		= "Personenereignisse hinzufügen";
$pgv_lang["INDI_FACTS_ADD_help"]	= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Ereignisse die diesem Personen-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Ereignis-Codes nach Ihren Wünschen ändern.  Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 		= "Einmal vorkommende Personenereignisse";
$pgv_lang["INDI_FACTS_UNIQUE_help"]	= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Ereignisse die im Personen-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn DATE hier eingegeben ist, darf jeder Personen-Datensatz nur eine DATE Zeile enthalten. Ereignis-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[INDI_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Ereignis-Code darf in nur einer Liste vorkommen.<br /><br />";
$pgv_lang["INDI_FACTS_QUICK"] 		= "Schnell hinzugefügte Personenereignisse";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der komplettenereignisliste gezeigt wird, bestimmt welche Ereignisse durch klicken des jeweiligen Links leicht zu dieser Person hinzugefügt werden können.<br /><br />";
$pgv_lang["DBPERSIST"]				= "Benutze dauernde Datenbankverbindungen";
$pgv_lang["DBPERSIST_help"]			= "~#pgv_lang[DBPERSIST]#~<br /><br />Bestimmt ob PhpGedView dauerhafte Datenbank-Verbindungen benutzen soll oder nicht.<br /><br />Falls auf <b>#pgv_lang[yes]#</b> gestellt, darf PhpGedView momentan unbenutzte Datenbank-Verbindungen erneut benutzen.  Das kann den ersten Zugriff zur Datenbank beschleunigen.  Falls die maximale Anzahl der Datenbank-Verbindungen im Host zu niedrig ist, kann diese Option Fehler verursachen.  Wenn Sie sich nicht über die richtige Konfiguration des Hosts sicher sind, sollten Sie <b>#pgv_lang[no]#</b> wählen.<br /><br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]	= "Automatisch Miniaturbilder erstellen";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Bestimmt ob PhpgedView automatisch fehlende Miniaturbilder erstellen soll oder nicht.  Es ist aber möglich dass Ihr PHP-Betriebsystem die Miniaturbilder-Erstellung nicht unterstützt.<br /><br />";
$pgv_lang["more_config_hjaelp"]			= "<br /><br /><b>Mehr Hilfe</b><br /><br />Wenn sie das <b>?</b> neben den Elementen klicken, können Sie mehr Hilfe erhalten.<br /><br />";


$pgv_lang["preview_faq_item"] = "FAQ-Einträge vorschauen";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Diese Option ermöglicht Ihnen, die FAQ Liste ohne Bearbeitungsoptionen zu sehen.<br /><br />Abgesehen von einem <b>Bearbeiten</b> Link als Überschrift vor dem ersten FAQ Eintrag, ist die Darstellung der FAQ-Seite genau wie sie einem gewöhnlichen Benutzer gezeigt wird. Mit diesem <b>Bearbeiten</b> Link können Sie alle FAQ-Bearbeitungsoptionen wiederherstellen.<br /><br />";
$pgv_lang["restore_faq_edits"] = "FAQ-Editieren erlauben";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Diese Option stellt die FAQ-Seite zurück auf die normale Verwalter-Ansicht, mit allen FAQ-Bearbeitungsoptionen.<br /><br />";
$pgv_lang["add_faq_item"] = "FAQ Eintrag hinzufügen";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Mit dieser Option können Sie einen Eintrag der FAQ-Liste hinzufügen.<br /><br />";
$pgv_lang["edit_faq_item"] = "FAQ-Eintrag bearbeiten";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Mit dieser Option können Sie einen bereits bestehenden FAQ-Eintrag bearbeiten.<br /><br />";
$pgv_lang["delete_faq_item"] = "FAQ-Eintrag löschen";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Mit dieser Option können Sie einen FAQ-Eintrag löschen.<br /><br />";
$pgv_lang["moveup_faq_item"] = "FAQ-Eintrag nach oben verschieben";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Diese Option ermöglicht es Ihnen, die Reihenfolge der FAQ-Einträge zu ändern.<br /><br />Jedes Mal, wenn Sie diese Option benutzen, wird die Ordnungsnummer dieses Eintrags um <b>1</b> verringert.  Anstatt dieser Option, können Sie auch den Eintrag bearbeiten, und das Feld «FAQ Reihenfolge» direkt ändern.  Wenn mehrere Einträge die selbe Ordnugsnummer haben, ist nur einer dieser Einträge sichtbar.  Welcher Eintrag dann sichtbar ist, ist unbestimmt.<br /><br />";
$pgv_lang["movedown_faq_item"] = "FAQ-Eintrag nach unten verschieben";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Diese Option ermöglicht es Ihnen, die Reihenfolge der FAQ-Einträge zu ändern.<br /><br />Jedes Mal, wenn Sie diese Option benutzen, wird die Ordnungsnummer dieses Eintrags um <b>1</b> erhöht.  Anstatt dieser Option, können Sie auch den Eintrag bearbeiten, und das Feld «FAQ Reihenfolge» direkt ändern.  Wenn mehrere Einträge die selbe Ordnugsnummer haben, ist nur einer dieser Einträge sichtbar.  Welcher Eintrag dann sichtbar ist, ist unbestimmt.<br /><br />";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Titel oder Thema des FAQ-Eintrags.<br /><br />Ihre Eingabe kann formatiert werden. HTML tags wie &lt;b&gt; und &lt;br&gt; sowie HTML entities wie &amp;amp; und &amp;nbsp; sind erlaubt.  Es ist nicht möglich, HTML tags so einzugeben dass sie als gewöhnlicher Text erkannt werden.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br /><br />";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />Text des FAQ-Eintrags.<br /><br />Ihre Eingabe kann formatiert werden. HTML tags wie &lt;b&gt; und &lt;br&gt; sowie HTML entities wie &amp;amp; und &amp;nbsp; sind erlaubt.  Es ist nicht möglich, HTML tags so einzugeben dass sie als gewöhnlicher Text erkannt werden.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br /><br />";
$pgv_lang["add_faq_pgvLangRefs"] = "Sie können im Text Einträge der Sprach-Dateien oder die aktuelle Stellung von verschiedenen Global-Variablen einfügen.  Beispiele:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp; erwähnt den Sprach-Variable \$pgv_lang[\"add_to_cart\"], und wenn so erwähnt, wird der Text mit <b>#pgv_lang[add_to_cart]#</b> ergänzt wenn die FAQ-Seite in der aktuellen Sprache angesehen wird.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;erwähnt den Fakt-Namen \$factarray[\"AFN\"], und wenn so erwähnt, wird der Text mit <b>#factarray[AFN]#</b> ergänzt wenn die FAQ-Seite in der aktuellen Sprache angesehen wird.</li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;erwähnt den globalen Variable \$VERSION, ein Leerzeichen, und dann den globalen Variable \$VERSION_RELEASE, und wenn so erwähnt, wird der Text mit <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b> ergänzt wenn die FAQ-Seite in der aktuellen Sprache angesehen wird.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23</b>&nbsp;&nbsp;&nbsp;erwähnt den globalen Variable \$GEDCOM, (Name der aktuellen GEDCOM-Datei), und wenn so erwähnt, wird der Text mit <b>#GLOBALS[GEDCOM]#</b> ergänzt.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23</b>&nbsp;&nbsp;&nbsp;erwähnt den globalen Variable \$GEDCOM_TITLE, (Titel der aktuellen GEDCOM-Datei), und wenn so erwähnt, wird der Text mit <b>#GLOBALS[GEDCOM_TITLE]#</b> ergänzt.</li></ul><br /><br />So können Sie FAQ-Listen erstellen, die sich nach der aktuellen Sprache richten.  Sie sollten Ihre eigenen FAQ-Titel und FAQ-Hauptteile in die <i>languages/extra.xx.php</i> Dateien (<i>xx</i> ist das Code der jeweiligen Sprache) im folgenden Format eingeben:<br /><br />\$pgv_lang[\"faq_title1\"] = \"Beispiel eines FAQ-Titels\";<br /><br />\$pgv_lang[\"faq_body1\"] = \"Beispiel eines FAQ-Hauptteils.\";<br /><br />";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Dieser Eintrag bestimmt die Reihenfolge, in der die FAQ-Einträge auf der FAQ-Seite dargestellt werden.<br /><br />Es ist nicht nötig, die Nummern sequentiell und ohne Löcher einzutragen.  Wenn die Reihenfolge der von Ihnen eingetragen Ordnungsnummern Löcher enthält, können Sie dann später andere Einträge in die FAQ-Liste einfügen. Zum Beispiel, wenn Sie die Ordnungsnummern 1, 6, 11, 16 benutzen, können Sie später andere Einträge mit den fehlenden Ordnungsnummern hinzufügen.  Negative Nummern und Null sind erlaubt, und ermöglichen Ihnen, Einträge <u>vor</u> dem jetzigen ersten Eintrag hinzuzufügen.<br /><br />Wenn mehrere Einträge die selbe Ordnugsnummer haben, ist nur einer dieser Einträge sichtbar.  Welcher Eintrag dann sichtbar ist, ist unbestimmt.<br /><br />";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Sie können bestimmen, ob diese FAQ (oft gestellte Frage) immer sichtbar ist, oder ob sie nur der aktuellen GEDCOM-Datei sichtbar ist.<br /><br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Die FAQ ist in allen FAQ-Listen sichtbar, ohne Rücksicht auf die aktuelle GEDCOM-Datei.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;Die FAQ ist nur in der FAQ-Liste der aktuellen GEDCOM-Datei sichtbar.</li></ul><br /><br />";
$pgv_lang["index_gedcom_news_adm_help"]		= "Im Textbereich dieses Blocks können Sie <b>HTML tags</b> und <b>HTML entities</b> einfügen. HTML sollte im Titelbereich nicht benutzt werden.<br /><br />Bitte achten Sie darauf, die Start- und End-Tags korrekt einzutragen. Dieses Programm verwendet <i>Style Sheets</i> (CSS). Jedes Theme hat seine eigene style sheet-Datei. Sie können auch «Klassen» aus diesen Style-Sheets verwenden.<br /><br />Wenn Sie weitere Hilfe benötigen: Auf der PhpGedView Webseite werden Sie einige Beispiele finden, wie Sie solche Tags in Ihren eigenen Blöcken verwenden.<br /><br />Folgender Text, der Eingaben der FAQ-Liste beschreibt, ist auch für Eingaben der GEDCOM-Neuigkeiten gültig.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br /><br />";


$pgv_lang["USE_MEDIA_VIEWER"]			= "Diabetrachter benutzen";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Wenn <b>#pgv_lang[yes]#</b> gewählt ist, wird durch das Klicken auf Bildern die Diabetrachter-Seite gezeigt.  Diese Seite enthält Einzelheiten über das Bild, und falls erlaubt, können die Einzelheiten auch bearbeitet werden.<br /><br />Wenn <b>#pgv_lang[no]#</b> gewählt ist, wird das Bild in voller Größe gezeigt, wenn Sie auf dem Miniaturbild klicken.<br /><br />";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Medien-Feuerwand benutzen";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Die Medien-Feuerwand ist im Wikipedia beschrieben. <a href=\"http://wiki.phpgedview.net/en/index.php/Media_Firewall\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/Media_Firewall</a><br /><br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Medien-Feuerwand Hauptverzeichnis";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Verzeichnis, worin das geschützte Medien-Verzeichnis erstellt werden kann.  Der leere Eintrag bedeutet, dass das <b>#GLOBALS[INDEX_DIRECTORY]#</b> Verzeichnis benutzt wird.<br /><br />";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Miniaturbilder schützen";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Wenn das große Bild sich im geschützen Medien-Verzeichnis befindet, soll das dazugehörende Miniaturbild auch geschützt werden?<br /><br />";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Wem Bilder ohne Wasserzeichen zeigen";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Wenn die Medien-Feuerwand benutzt wird, werden Bilder mit Wasserzeichen versehen, wenn der Benutzer nicht genügende Rechte hat.<br /><br />";
$pgv_lang["WATERMARK_THUMB"]			= "Miniaturbilder mit Wasserzeichen versehen";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Wenn die Medien-Feurwand benutzt wird, sollen Miniaturbilder auch mit Wasserzeichen versehen werden?  Medien-Listen laden langsamer wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist.<br /><br />";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Mit Wasserzeichen versehene Bilder auf dem Server bewahren";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Wenn die Medien-Feurwand benutzt wird und hier <b>#pgv_lang[yes]#</b> gewählt ist, sind alle mit Wasserzeichen versehene Bilder auf dem Server bewahrt.<br /><br />Der Vorteil dieser Option ist ein schnelleres Zeigen der Bilder;  der Nachteil ist ein erhöhter Festplatten-Speicherbedarf, da dann jedes Bild zweimal gespeichert werden muss.<br /><br />";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Mit Wasserzeichen versehene Miniaturbilder auf dem Server bewahren";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Wenn die Medien-Feurwand benutzt wird und hier <b>#pgv_lang[yes]#</b> gewählt ist, sind alle mit Wasserzeichen versehene Miniaturbilder auf dem Server bewahrt.<br /><br />Der Vorteil dieser Option ist ein schnelleres Zeigen der Medienlisten;  der Nachteil ist ein erhöhter Festplatten-Speicherbedarf, da dann jedes Miniaturbild zweimal gespeichert werden muss.<br /><br />";

?>
