<?php
/**
 * Greek Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Nicholas G. Antimisiaris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Nicholas G. Antimisiaris
 * @version $Id: configure_help.el.php 1777 2007-09-30 20:43:59Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "You cannot access a language file directly.";
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]					= "Διαμόρφωση PhpGedView";
$pgv_lang["standard_conf"]				= "Βασικές Επιλογές Διαμόρφωσης";
$pgv_lang["advanced_conf"]				= "Προχωρημένες Επιλογές Διαμόρφωσης";
$pgv_lang["meta_conf"]					= "META Tag Επιλογές Διαμόρφωσης";
$pgv_lang["configure_head"]				= "PhpGedView Διαμόρφωση";
$pgv_lang["gedconf_head"]				= "GEDCOM Διαμόρφωση";
$pgv_lang["default_user"]				= "Δημιουργία αρχικού χρήστη διαχείρισης.";
$pgv_lang["about_user"]					= "Πρέπει πρώτα να δημιουργήστε τον βασικό χρήστη διαχείρισης.  Ο χρήστης αυτός θα έχει αρμοδιότητες αλλαγών στα αρχεία διαμόρφωσης, απεικόνισης προσωπικών δεδομένων, και δημιουργία άλλων χρηστών.";
$pgv_lang["can_admin"]					= "Χρήστης με δικαιώματα Διαχείρισης";
$pgv_lang["can_edit"]					= "Επίπεδα Πρόσβασης";
$pgv_lang["access"]						= "Απλή Πρόσβαση";
$pgv_lang["accept"]						= "Αποδοχή Αλλαγών";
$pgv_lang["none"]						= "Καμμία";
$pgv_lang["add_user"]					= "Προσθήκη νέου χρήστη";
$pgv_lang["current_users"]				= "Επικαιροποιημένος Κατάλογος Χρηστών";
$pgv_lang["leave_blank"]				= "Αφήστε κενό τον κωδικό πρόσβασης για να κρατήστε το ήδη υπάρχοντα.";
$pgv_lang["other_theme"]				= "Άλλο, παρακαλώ πληκτρολογήστε";
$pgv_lang["performing_update"]			= "Σε διαδικασία ενημέρωσης.";
$pgv_lang["config_file_read"]			= "Ανάγνωση αρχείου προσαρμογής.";
$pgv_lang["does_not_exist"]				= "δεν υπάρχει";
$pgv_lang["media_drive_letter"]			= "Το path των εικόνων δεν πρέπει να έχει driver letter, εικόνα δεν μπορεί να απεικονιστεί.";
$pgv_lang["pgv_config_write_error"]		= "Σφάλμα!!! Αδυναμία εγγραφής στο αρχείο προσαρμογών του PhpGedView. Παρκαλώ ελέγξτε τα δικαιώματα πρόσβασης του αρχείου και του φακέλλου και δοκιμάστε ξανά.";
$pgv_lang["db_setup_bad"]				= "Your current database configuration is bad.  Please check your database connection parameters and configure again.";
$pgv_lang["bad_host_user_pass"]			= "PhpGedView was unable to make a connection to your database host.  Check the host, username, and password to make sure they are correct.";
$pgv_lang["bad_database_name"]			= "PhpGedView made a connection to your database host, but was unable to use the database with the name you entered.  Check that the database exists and that the usename you entered has the appropriate permissions on that database.";
$pgv_lang["click_here_to_continue"]		= "Επιλέξτε εδώ για να συνεχίστε.";
$pgv_lang["config_help"]				= "Βοήθεια Προσαρμογών";
$pgv_lang["index"]						= "Αρχεία Ευρετηρίων";
$pgv_lang["mysql"]						= "MySQL";
$pgv_lang["db"]							= "Βάση Δεδομένων";
$pgv_lang["dbase"]						= "dBase";
$pgv_lang["fbsql"]						= "FrontBase";
$pgv_lang["ibase"]						= "InterBase";
$pgv_lang["ifx"]						= "Informix";
$pgv_lang["msql"]						= "Mini SQL";
$pgv_lang["mssql"]						= "Microsoft SQL Server";
$pgv_lang["mysqli"]						= "MySQL 4.1+ and PHP 5";
$pgv_lang["oci8"]						= "Oracle 7+";
$pgv_lang["pgsql"]						= "PostgreSQL";
$pgv_lang["sqlite"]						= "SQLite";
$pgv_lang["sybase"]						= "Sybase";
$pgv_lang["admin_gedcoms"]				= "Επιλέξτε εδώ για την διαχείριση GEDCOMS.";
$pgv_lang["current_gedcoms"]			= "Υπάρχοντα GEDCOMs";
$pgv_lang["gedcom_adm_head"]			= "GEDCOM Διαχείριση";
$pgv_lang["ged_download"]				= "Download";
$pgv_lang["ged_gedcom"]					= "GEDCOM Αρχείο";
$pgv_lang["ged_title"]					= "GEDCOM Τίτλος";
$pgv_lang["ged_config"]					= "Αρχείο Προσαρμογών";
$pgv_lang["ged_privacy"]				= "Privacy File";
$pgv_lang["show_phpinfo"]				= "Εμφάνιση σελίδας PHPInfo";
$pgv_lang["confirm_gedcom_delete"]		= "Are you sure you want to delete this GEDCOM";
$pgv_lang["disabled"]					= "Disabled";
$pgv_lang["mouseover"]					= "On Mouse Over";
$pgv_lang["mousedown"]					= "On Mouse Down";
$pgv_lang["click"]						= "On Mouse Click";
$pgv_lang["mailto"]						= "Mailto Link";
$pgv_lang["messaging"]					= "PhpGedView Εσωτερική Επικοινωνία";
$pgv_lang["messaging2"]					= "Εσωτερική Επικοινωνία μέσω Ηλεκτρονικού Ταχυδρομείου";
$pgv_lang["messaging3"]					= "PhpGedView sends Emails with no storage";
$pgv_lang["no_messaging"]				= "No contact method";
$pgv_lang["no_logs"]					= "Disable Logging";
$pgv_lang["daily"]						= "Ημερήσια";
$pgv_lang["weekly"]						= "Εβδομαδιαία";
$pgv_lang["monthly"]					= "Μηνιαία";
$pgv_lang["yearly"]						= "Ετήσια";
$pgv_lang["enter_db_pass"]				= "For security, you must enter the Database Username and Database Password before changing configuration values.";
$pgv_lang["config_still_writable"]		= "Your config.php file is still writeable.  If you are done configuring your site you should set the permissions of this file back to read-only for security.";
$pgv_lang["admin_verification_waiting"]	= "Useraccount(s) awaiting verification by admin";
$pgv_lang["DEFAULT_GEDCOM"]				= "Default GEDCOM";
$pgv_lang["privileges"]					= "Privileges";
$pgv_lang["date_registered"]			= "Date Registered";
$pgv_lang["last_login"]					= "Τελευταία πρόσβαση";
$pgv_lang["server_url_note"]			= "This should be the URL to your PhpGedView folder.  You should only change this setting if you are sure you know what you are doing.  PhpGedView has calculated the SERVER_URL to be #GUESS_URL#";

$pgv_lang["PGV_DATABASE"]				= "PhpGedView DataStore";
$pgv_lang["PGV_DATABASE_help"]			= "This tells PhpGedView what type of datastore you want to use for the GEDCOM files you import into the system.  Select 'Index Files' to use index files stored in the index directory, or select 'DB' to use a database like MySQL.  This sets the \$PGV_DATABASE variable in the config.php file.";
$pgv_lang["DBTYPE"]						= "Τύπος Βάσης Δεδομένων";
$pgv_lang["DBTYPE_help"]				= "The type of PEAR supported database to connect to.  Options are MySQL, PostgreSQL, Oracle, and SQLite.  This sets the \$DBTYPE variable in the config.php file.";
$pgv_lang["DBHOST"]						= "Database Host";
$pgv_lang["DBHOST_help"]				= "The DNS or IP address of the computer hosting your database server.  This sets the \$DBHOST variable in the config.php file.";
$pgv_lang["DBUSER"]						= "Όνομα Χρήστη Βάσης Δεδομένων";
$pgv_lang["DBUSER_help"]				= "The database username required to login to your database.  This sets the \$DBUSER variable in the config.php file.";
$pgv_lang["DBPASS"]						= "Κωδικός Βάσης Δεδομένων";
$pgv_lang["DBPASS_help"]				= "The database password for the user you entered in the Username field.  This sets the \$DBPASS variable in the config.php file.";
$pgv_lang["DBNAME"]						= "Όνομα Βάσης Δεδομένων";
$pgv_lang["DBNAME_help"]				= "The Database in the server you want PhpGedView to use.  The Username you enter in the user field must have create, insert, update, delete, and select privileges on this database.  This sets the \$DBNAME variable in the config.php file.";
$pgv_lang["TBLPREFIX"]					= "Πρόθεμα Πινάκων Βάσης Δεδομένων";
$pgv_lang["TBLPREFIX_help"]				= "A prefix to append to the tables created by PhpGedView.  By changing this value you can setup multiple PhpGedView sites to use the same database but different tables.  This sets the \$TBLPREFIX variable in the config.php file.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]		= "Allow GEDCOM Switching";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "Setting this value to <b>Yes</b> allows your site visitors <b>and</b> users to have the option of changing GEDCOMs if you have a multiple GEDCOM environment setup.<br /><br />Setting it to <b>No</b> disables GEDCOM switching for both visitors <b>and</b> logged in users.<br /><br />This sets the \$ALLOW_CHANGE_GEDCOM variable in the config.php file.";
$pgv_lang["GEDCOM"]						= "Τοποθεσία και όνομα αρχείου GEDCOM";
$pgv_lang["gedcom_path_help"]			= "First upload your GEDCOM file to a location accessible by php on your server.  Then enter the path and file name like: <b>./index/name.ged</b>.<br /><br />See the <a href=\"readme.txt\">Readme.txt</a> file for more help.";
$pgv_lang["CHARACTER_SET"]				= "Κωδικοποίηση Χαρακτήρων (encoding)";
$pgv_lang["CHARACTER_SET_help"]			= "This is the character set of your GEDCOM file.  UTF-8 is the default and should work for almost all sites.  If you export your GEDCOM using ibm windows encoding, then you should put WINDOWS here.<br /><br />NOTE: PHP does NOT support UNICODE (UTF-16) so don't try it and complain to the PHP folks :-)";
$pgv_lang["LANGUAGE"]					= "Γλώσσα";
$pgv_lang["LANGUAGE_help"]				= "Assign the default language for the site.  Users have the ability to override this setting using their browser preferences or the form at the bottom of the page if ENABLE_MULTI_LANGUAGE = true.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]		= "Επιτρέπεται στο χρήστη να αλλάζει γλώσσα";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "Set to 'yes' to give users the option of selecting a different language from a dropdown list in the footer and default to the language they have set in their browser settings.";
$pgv_lang["CALENDAR_FORMAT"]			= "Μορφή Ημερολογίου";
$pgv_lang["CALENDAR_FORMAT_help"]		= "Allows you to specify the type of Calendar you would like to use with this GEDCOM file.  Hebrew is the same as the Jewish Calendar using Hebrew characters.  Note: The values used for Jewish / Hebrew dates are calculated from the Gregorian / Julian dates. Since the Jewish calendar day starts at dusk, any even taking place from dusk till midnight will display as one day prior to the correct Jewish date. The display of Hebrew can be problematic in old browsers. Some old browsers will display the Hebrew backwards or not at all.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Display Hebrew Thousands";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "Show Alafim in Hebrew Calendars. Setting this to yes will display the year of 1969 as <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; while setting it to no will display the year as <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. This has no impact on the Jewish year setting. The year will display as 5729 regardless of this setting.<br />Note: This setting is similar to the php 5.0 Calendar constant CAL_JEWISH_ADD_ALAFIM.<br />This sets the \$DISPLAY_JEWISH_THOUSANDS variable in the config.php file.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "Display Hebrew Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Show single and double quotes when displaying Hebrew dates. Setting this to yes will display February 8th 1969 as  <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; while setting it to no will display it as <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. This has no impact on the Jewish year setting since quotes are not used in jewish dates displayed with Latin characters.<br />Note: This setting is similar to the php 5.0 Calendar constants CAL_JEWISH_ADD_ALAFIM_GERESH and CAL_JEWISH_ADD_GERESHAYIM. This single setting effects both.<br />This sets the \$DISPLAY_JEWISH_GERESHAYIM variable in the config.php file.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jewish Ashkenaz Pronunciation";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "Use Jewish Ashkenazi pronunciations.<br />If set to yes the months of Cheshvan and Teves will be spelled with Ashkenazi pronunciation. Setting it to no will change the months to Hesvan and Tevet. <br />This only affects the Jewish setting. Using the Hebrew setting will use the Hebrew alphabet.<br />This sets the \$JEWISH_ASHKENAZ_PRONUNCIATION variable in the config.php file.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]		= "Pedigree Generations";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "Set the default number of generations to display on the pedigree charts.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]			= "Maximum Pedigree Generations";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]		= "Set the maximum number of generations to display on the pedigree charts.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]		= "Maximum Descendancy Generations";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Set the maximum number of generations to display on the descendancy charts.";
$pgv_lang["USE_RIN"]							= "Χρήση RIN# αντί GEDCOM ID";
$pgv_lang["USE_RIN_help"]						= "Set to YES to use the RIN number instead of the GEDCOM ID when asked for Individual IDs in configuration files, user settings, and charts.  This is useful for genealogy programs that do not export GEDCOMs with concurrent individual IDs but always use the same RIN.";
$pgv_lang["PEDIGREE_ROOT_ID"]					= "Default person for pedigree and descendency charts";
$pgv_lang["PEDIGREE_ROOT_ID_help"]				= "Set the ID of the default person to display on the pedigree and descendency charts.";
$pgv_lang["GEDCOM_ID_PREFIX"]					= "Πρόθεμα GEDCOM ID";
$pgv_lang["GEDCOM_ID_PREFIX_help"]				= "On pedigree, descendancy, relationship, and other charts when users are prompted to enter an ID, if they do not add a prefix to the ID, this prefix will be added.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]				= "Show Birth and Death Details on Pedigree and descendency charts";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]			= "Tells whether or not to show the birth and death details of an individual by default.";
$pgv_lang["PEDIGREE_LAYOUT"]					= "Default Pedigree Chart Layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]				= "This tells whether the pedigree chart should be generated in landscape or portrait mode.";
$pgv_lang["SHOW_EMPTY_BOXES"]					= "Εμφάνιση άδειων κουτιών στα γενεαλογικά διαγράμματα";
$pgv_lang["SHOW_EMPTY_BOXES_help"]				= "Tells whether or not to show empty boxes on pedigree charts.";
$pgv_lang["ZOOM_BOXES"]							= "Zoom Boxes on Charts";
$pgv_lang["ZOOM_BOXES_help"]					= "Allows a user to zoom the boxes on the charts and get more information.  Set to \"Disabled\" to disable this feature.  Set to \"MouseOver\" to zoom boxes when the user mouses over the icon in the box.  Set to \"Click\" to zoom boxes when the user clicks on the icon in the box.";
$pgv_lang["LINK_ICONS"]							= "PopUp Links on Charts";
$pgv_lang["LINK_ICONS_help"]					= "Allows the user select links to other charts and close relatives of the person.  Set to \"Disabled\" to disable this feature.  Set to \"MouseOver\" to popup the links when the user mouses over the icon in the box.  Set to \"Click\" to popup the links when the user clicks on the icon in the box.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Abbreviate chart labels";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "Whether or not to abbreviate labels like 'Birth' on charts with just the first letter like 'B'.";
$pgv_lang["AUTHENTICATION_MODULE"]				= "Authentication Module File";
$pgv_lang["AUTHENTICATION_MODULE_help"]			= "File from which to load authentication functions.  By implementing the functions in this file, users can customize PhpGedView to use a different method to authenticate users and store users in a different user database.  Hopefully users will be willing to share their custom authentication modules with other PhpGedView users.<br /><br /><br />This sets the \$AUTHENTICATION_MODULE variable in the config.php file.";
$pgv_lang["HIDE_LIVE_PEOPLE"]					= "Ενεργοποίηση Προστασίας Προσωπικών Δεδομένων";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]				= "This option will enable all privacy settings and hide the details of living people. Living people are defined to be those who do not have an event more than in variable \$MAX_ALIVE_AGE defined years ago, and who do not have any children born more than \$MAX_ALIVE_AGE years ago.";
$pgv_lang["REQUIRE_AUTHENTICATION"]				= "Require Visitor Authentication";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]		= "Enabling this option will force all visitors to login before the can view any data on the site.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]				= "Welcome text on login page in Authentication mode";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]		= "Here you can choose a text which will appear on the login screen when authentication mode is set to yes. Please try which predefined text is most appropriate.<br />You can also choose to enter your own custom welcome text, but this will not be translated in the language of your users.<br /><br />The predefined texts are:<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_1]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_2]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]		= "Predefined text that states all users can apply for a user account";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]		= "Predefined text that states admin will decide if applied for a user account";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]		= "Predefined text that states only family members can apply for a user account";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]		= "Choose user defined welcome text typed below";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]		= "Custom welcome text for authentication mode";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "If you have chosen for custom welcome text in the above option, you can type the text here.<br />The text will NOT be translated in the language of the visitor, but will be shown exactely as you typed it.<br />If you wish, you can use HTML-tags in the text.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"]	= "Standard header for custom welcome text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]	= "Choose to display a (multilingual) header for your custom welcome text.<br /><br />If set to yes, the header will look look this:<br /><br />#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["CHECK_CHILD_DATES"]						= "Check child dates";
$pgv_lang["CHECK_CHILD_DATES_help"]					= "Checks the dates of the children when determining whether to a person is dead.  On older systems and large GEDCOMs this can slow down the response time of your site.";
$pgv_lang["MAX_ALIVE_AGE"]							= "Age at which to assume a person is dead";
$pgv_lang["MAX_ALIVE_AGE_help"]						= "The maximum age that a person can have an event or the maximum age of their children to determine if they are dead or not.";
$pgv_lang["SHOW_GEDCOM_RECORD"]						= "Allow users to see raw GEDCOM records";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]				= "Setting this to yes will place links on individuals, sources, and families allowing users to bring up another window with the raw GEDCOM taken right out of the GEDCOM file.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]						= "Enable online Editing";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]					= "Enables the online editing features for this GEDCOM so that users with the edit privileges may update this GEDCOM online.";
$pgv_lang["INDEX_DIRECTORY"]						= "Index file directory";
$pgv_lang["INDEX_DIRECTORY_help"]					= "The path to a readable and writeable Directory where PhpGedView should store index files (include the trailing \"/\")<br /><br />This sets the \$INDEX_DIRECTORY variable in the config.php file.";
$pgv_lang["ALPHA_INDEX_LISTS"]						= "Break up long lists by the first letter";
$pgv_lang["ALPHA_INDEX_LISTS_help"]					= "For very long individual and family lists, set this to true to split the list into pages by the first letter of their last name.";
$pgv_lang["NAME_FROM_GEDCOM"]						= "Get Display name from GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"]					= "By default PhpGedView uses the name stored in the indexes to get a person's name.  With some GEDCOM formats and languages the sortable name stored in the indexes does not get displayed properly and the best way to get the correct display name is from the GEDCOM.  Spanish names are a good example of this.  A Spanish name can take the form Given Names Father's Surname Mother's Surname.  Using the Indexes for sorting and display, the name would display like this Given Names Mother's Surname Father's Surname which is incorrect.  Going back the GEDCOM for the name will return the correct name.  However, retrieving the name from the GEDCOM will slow the program down.";
$pgv_lang["SHOW_ID_NUMBERS"]						= "Show ID numbers next to names";
$pgv_lang["SHOW_ID_NUMBERS_help"]					= "Show ID numbers in parenthesis after person names on charts.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]					= "Place levels to show in person boxes";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]				= "This sets how much of the place information is shown in the person boxes on charts.  Setting the value to 9 will guarentee to show all places levels.  Setting the value to 0 will hide places completely.  Setting the value to 1 will show the first level, setting it to 2 will show the first 2 levels, etc.";
$pgv_lang["MULTI_MEDIA"]							= "Enable multimedia features";
$pgv_lang["MULTI_MEDIA_help"]						= "GEDCOM 5.5 allows you to link pictures, videos, and other multimedia objects into your GEDCOM.  If you do not include multimedia objects in your GEDCOM then you can disable the multimedia features by setting this value to 'no'. <br />See the multimedia section in the <a href=\"readme.txt\">readme.txt</a> file for more information about including media in your site.";
$pgv_lang["MEDIA_EXTERNAL"]							= "Keep links";
$pgv_lang["MEDIA_EXTERNAL_help"]					= "When a multimedia link is found starting with for example http://, ftp://, mms:// it will not be altered when set to yes. For example: http://www.myfamily.com/photo/dad.jpg will stay http://www.myfamily.com/photo/dad.jpg. When set to no, the link will be handled as a standard reference and the mediadepth will be used. For example: http://www.myfamily.com/photo/dad.jpg will be changed to ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]						= "MultiMedia directory";
$pgv_lang["MEDIA_DIRECTORY_help"]					= "The mediapath must be a relative path within the PGV website, like ./media/ (include the trailing \"/\").";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]					= "Multi-Media Directory Levels to Keep";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]			= "A value of 0 will ignore all directories in the file path for the media object.  A value of 1 will use also use the first directory containing this image.  Increasing the numbers increases number of parent directories to include in the path.  <br />For example: If you link an image in your GEDCOM with a path like this C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg then a value of 0 will translate this path to ./media/grandpa.jpg.  A value of 1 will translate this to ./media/Surname Line/grandpa.jpg, etc.  Most people will only need to use a 0.  But it is possible that some media objects will have the same name and would overwrite each other.  This allows you to keep some organization in your media and prevents name clashing.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]					= "Show highlight images in people boxes";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]				= "If you have enabled multimedia in your site, then you can have PhpGedView display a thumbnail image next to the person's name in charts and boxes.  Currently PhpGedView uses the first multimedia object listed in the GEDCOM record as the highlight image.  For people with multiple images, you should arrange the multimedia objects such that the one you wish to be highlighted appears first, before any others.<br />See the multimedia section in the <a href=\"readme.txt\">readme.txt</a> file for more information about including media in your site.";
$pgv_lang["USE_THUMBS_MAIN"]						= "Use thumbnail for main picture on individual page";
$pgv_lang["USE_THUMBS_MAIN_help"]					= "Depending on how you want to store your images it may be better for you to use the thumbnails for the picture next to the name on the individual page.  If your main images are very large, they can take a long time to download and if your thumbnails are high enough quality then they can be used in place of the full resolution image.  Set this item to \"yes\" to use thumbnails or leave it as \"no\" to use the full resolution image.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]					= "Enable Clippings Cart";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]				= "The clippings cart allows visitors to your site to be able to add people to a GEDCOM clippings file that they can download as a GEDCOM file and import into their genealogy software.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]						= "Hide GEDCOM errors";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]				= "Setting this to 'yes' will hide error messages produced by PhpGedView when it doesn't understand a GEDCOM tag in your GEDCOM file.  PhpGedView makes every effort to conform to the GEDCOM 5.5 standard, but many genealogy software programs include their own custom tags.  See the <a href=\"readme.txt\">readme.txt</a> file for more information.";
$pgv_lang["WORD_WRAPPED_NOTES"]						= "Add spaces where notes were wrapped";
$pgv_lang["WORD_WRAPPED_NOTES_help"]				= "Some genealogy programs wrap notes at word boundaries while others wrap notes anywhere.  This can cause PhpGedView to run words together.  Setting this to 'yes' will add a space between words where they are wrapped in the GEDCOM.";
$pgv_lang["SHOW_CONTEXT_HELP"]						= "Show contextual ? help by default";
$pgv_lang["SHOW_CONTEXT_HELP_help"]					= "This option will enable question mark help links on pages next to options on those pages so that visitors can get contextual help about the options on the pages.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]					= "Min. number of surnames before occuring in Common Surnames";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]			= "This is the number of times that a surname must occur, before it shows up in the Common Surname list on the Welcome Page.";
$pgv_lang["COMMON_NAMES_ADD"]						= "Names to add to Common Surnames (comma separated)";
$pgv_lang["COMMON_NAMES_ADD_help"]					= "If the number of times that a certain surname occurs is lower than the threshold, it will not appear in the list. It can be added here manually. If more than one surname is entered, they must be separated by a comma. Surnames are case-sensitive.";
$pgv_lang["COMMON_NAMES_REMOVE"]					= "Names to remove from Common Surnames (comma separated)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]				= "If you want to remove a surname from the Common Surname list without increasing the threshold value, you can do that by entering the surname here. If more than one surname is entered, they must be separated by a comma. Surnames are case-sensitive.";
$pgv_lang["HOME_SITE_URL"]							= "Main WebSite URL";
$pgv_lang["HOME_SITE_URL_help"]						= "A URL included in the supplied theme headers used to generate a link to your main home page.";
$pgv_lang["HOME_SITE_TEXT"]							= "Main WebSite Text";
$pgv_lang["HOME_SITE_TEXT_help"]					= "The text used to generate the link to your main home page.";
$pgv_lang["CONTACT_EMAIL"]							= "Genealogy Contact User";
$pgv_lang["CONTACT_EMAIL_help"]						= "The User visitors should contact about the genealogical data on this site.";
$pgv_lang["CONTACT_METHOD"]							= "Contact Method";
$pgv_lang["CONTACT_METHOD_help"]					= "The method visitors will use to contact the \"Contact User\" about genealogy questions.  The 'mailto' option will add use a mailto link that the visitor may click on to send you an email using their mail client.  The 'messaging' option will use the builtin PhpGedView messaging system and no emails will be sent.  The 'messaging with emails' option is the default and will use the PhpGedView messaging system, but will also send copies of the messages via email.  The 'Emails with no storage' option, allows PhpGedView to handle the messaging and will send the messages as emails, but will not store the messages internally.  Choosing the option for no messaging will provide no option for visitors to contact you.";
$pgv_lang["WEBMASTER_EMAIL"]						= "Support Contact User";
$pgv_lang["WEBMASTER_EMAIL_help"]					= "The User visitors should contact about technical questions or errors they might encounter while on your site.";
$pgv_lang["SUPPORT_METHOD"]							= "Support Method";
$pgv_lang["SUPPORT_METHOD_help"]					= "The method visitors will use to contact the \"Support User\" about genealogy questions.  The 'mailto' option will add use a mailto link that the visitor may click on to send you an email using their mail client.  The 'messaging' option will use the builtin PhpGedView messaging system and no emails will be sent.  The 'messaging with emails' option is the default and will use the PhpGedView messaging system, but will also send copies of the messages via email.  The 'Emails with no storage' option, allows PhpGedView to handle the messaging and will send the messages as emails, but will not store the messages internally.  Choosing the option for no messaging will provide no option for visitors to contact you.";
$pgv_lang["FAVICON"]								= "Favorites Icon";
$pgv_lang["FAVICON_help"]							= "Change this to point to the icon you want to display in peoples favorites menu when they bookmark your site.";
$pgv_lang["THEME_DIR"]								= "Theme directory";
$pgv_lang["THEME_DIR_help"]							= "The directory where your PhpGedView theme files are kept.  You may customize any of the standard themes that come with PhpGedView to give your site a unique look and feel.  See the theme customization section of the <a href=\"readme.txt\">readme.txt</a> file for more information.";
$pgv_lang["TIME_LIMIT"]								= "PHP Time Limit";
$pgv_lang["TIME_LIMIT_help"]						= "The maximum time in seconds that PhpGedView should be allowed to run.  The default is 1 minute.  Depending on the size of your GEDCOM file, you may need to increase this time limit when you need to build the indexes.  Set this value to 0, to allow PHP to run forever.<br />CAUTION: Setting this to 0, or setting it too high could cause your site to hang on certain operating systems until the script finishes.  Setting it to 0 means it may never finish until a server administrator kills the process or restarts the server.  A large pedigree chart can take a very long time to run, leaving this value as low as possible ensures that someone cannot crash your webserve by requestion a 1000 generation chart.";
$pgv_lang["PGV_SESSION_SAVE_PATH"]					= "Session Save Path";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]				= "The path to store PhpGedView session files.  Some hosts do not have PHP configured properly and sessions are not maintained between page requests.  This allows site administrators to override this by saving files in one of their local directories.  The ./index/ directory is a good choice if you need to change this.  The default is to leave the field empty, which will use the save path as configured in the php.ini file.<br /><br />This sets the \$PGV_SESSION_SAVE_PATH variable in the config.php file.";
$pgv_lang["SERVER_URL"]								= "PhpGedView URL";
$pgv_lang["SERVER_URL_help"]						= "If you use https or a different port other than the default, you will need to enter the URL to access your server here.<br /><br />This sets the \$SERVER_URL variable in the config.php file.";
$pgv_lang["LOGIN_URL"]								= "Login URL";
$pgv_lang["LOGIN_URL_help"]							= "You only need to enter a Login URL if you want to redirect to a different site or location when your users login.  This is very useful for example, if you want to switch from http to https when your users login.  Include the full URL to the login.php file (e.g. https://www.yourserver.com/phpgedview/login.php).";
$pgv_lang["PGV_SESSION_TIME"]						= "Session Timeout";
$pgv_lang["PGV_SESSION_TIME_help"]					= "The time in seconds that a PhpGedView session remains active before requiring a login.  The default is 2 hours.<br /><br />This sets the \$PGV_SESSION_TIME variable in the config.php file.";
$pgv_lang["SHOW_STATS"]								= "Show Execution Statistics";
$pgv_lang["SHOW_STATS_help"]						= "Show runtime statistics and database queries at the bottom of every page.";
$pgv_lang["SHOW_COUNTER"]							= "Εμφάνιση Μετρητών Θέασης";
$pgv_lang["SHOW_COUNTER_help"]						= "Show hit counters on portal and individual pages.";
$pgv_lang["USE_REGISTRATION_MODULE"]				= "Allow visitors to request account registration";
$pgv_lang["USE_REGISTRATION_MODULE_help"]			= "Gives visitors the option of registering themselves for an account on the site.<br /><br />The visitor will receive an email message with the code to verify the application.<br />After verification, the Administrator will have to approve the registration before it becomes active.<br /><br />This sets the \$USE_REGISTRATION_MODULE variable in the config.php file.";
$pgv_lang["ALLOW_USER_THEMES"]						= "Allow users to select their own theme";
$pgv_lang["ALLOW_USER_THEMES_help"]					= "Gives users the option of selecting their own theme.<br /><br />This sets the \$ALLOW_USER_THEMES variable in the config.php file.";
$pgv_lang["PGV_SIMPLE_MAIL"]						= "Use simple mailheaders in external mails";
$pgv_lang["PGV_SIMPLE_MAIL_help"]					= "In normal mailheaders for external mails, email address as well as the name are used. Some mailsystems will not accept this. Set to yes, only the email adress will be used.<br /><br />This sets the \$PGV_SIMPLE_MAIL variable in the config.php file.";
$pgv_lang["CREATE_GENDEX"]							= "Create Gendex Files";
$pgv_lang["CREATE_GENDEX_help"]						= "Show PhpGedView generate Gendex files whenever a GEDCOM is imported.  Gendex files are stored in the index directory.";
$pgv_lang["gedcom_title_help"]						= "Enter a descriptive title to be displayed when visitors are choosing among GEDCOM datasets at your site.";
$pgv_lang["LOGFILE_CREATE"]							= "Archive Log Files";
$pgv_lang["LOGFILE_CREATE_help"]					= "How often should the program archive log files.<br /><br />This sets the \$LOGFILE_CREATE variable in the config.php file.";
$pgv_lang["PGV_MEMORY_LIMIT"]						= "Max Memory Limit";
$pgv_lang["PGV_MEMORY_LIMIT_help"]					= "The maximum amount of memory that can be consumed by PhpGedView scripts.  The default is 16M.  Many hosts disable this option in their PHP configuration, so changing this value may not have any actual affect of the maximum memory setting.<br /><br />This sets the \$PGV_MEMORY_LIMIT variable in the config.php file.";
$pgv_lang["PGV_STORE_MESSAGES"]						= "Allow messages to be stored online";
$pgv_lang["PGV_STORE_MESSAGES_help"]				= "Specifies whether messages sent through PhpGedView can be stored in the database.  If set to 'Yes' then users will be able to retrieve their messages when they login to PGV.  If set to 'No' then messages will only be emailed.<br /><br />This sets the \$PGV_STORE_MESSAGES variable in the config.php file.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]					= "Display Theme Dropdown selector for theme changes";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]				= "Gives users the option of selecting their own theme.<br />from a drop down menu (if implemented in the theme)<br />Requires ALLOW_USER_THEMES to be true as well<br />This sets the \$ALLOW_THEME_DROPDOWN variable in the config.php file.";

$pgv_lang["META_AUTHOR"]							= "Author META tag";
$pgv_lang["META_AUTHOR_help"]						= "The value to place in the author meta tag in the HTML page header.  Leave this field empty to use the GEDCOM contact user's full name for this value.<br />This sets the \$META_AUTHOR variable in the config.php file.";
$pgv_lang["META_AUTHOR_descr"]						= "Leave this field empty to use the GEDCOM contact user's full name for this value.";
$pgv_lang["META_PUBLISHER"]							= "Publisher META tag";
$pgv_lang["META_PUBLISHER_help"]					= "The value to place in the publisher meta tag in the HTML page header.  Leave this field empty to use the GEDCOM contact user's full name for this value.<br />This sets the \$META_PUBLISHER variable in the config.php file.";
$pgv_lang["META_PUBLISHER_descr"]					= "Leave this field empty to use the GEDCOM contact user's full name for this value.";
$pgv_lang["META_COPYRIGHT"]							= "Copyright META tag";
$pgv_lang["META_COPYRIGHT_help"]					= "The value to place in the copyright meta tag in the HTML page header.  Leave this field empty to use the GEDCOM contact user's full name for this value.<br />This sets the \$META_COPYRIGHT variable in the config.php file.";
$pgv_lang["META_COPYRIGHT_descr"]					= "Leave this field empty to use the GEDCOM contact user's full name for this value.";
$pgv_lang["META_DESCRIPTION"]						= "Description META tag";
$pgv_lang["META_DESCRIPTION_help"]					= "The value to place in the description meta tag in the HTML page header.  Leave this field empty to use the currently active GEDCOM's title for this value.<br />This sets the \$META_DESCRIPTION variable in the config.php file.";
$pgv_lang["META_DESCRIPTION_descr"]					= "Leave this field empty to use the currently active GEDCOM's title for this value.";
$pgv_lang["META_PAGE_TOPIC"]						= "Page-Topic META tag";
$pgv_lang["META_PAGE_TOPIC_help"]					= "The value to place in the page-topic meta tag in the HTML page header.  Leave this field empty to use the currently active GEDCOM's title for this value.<br />This sets the \$META_PAGE_TOPIC variable in the config.php file.";
$pgv_lang["META_PAGE_TOPIC_descr"]					= "Leave this field empty to use the currently active GEDCOM's title for this value.";
$pgv_lang["META_AUDIENCE"]							= "Audience META tag";
$pgv_lang["META_AUDIENCE_help"]						= "The value to place in the audience meta tag in the HTML page header.<br />This sets the \$META_AUDIENCE variable in the config.php file.";
$pgv_lang["META_PAGE_TYPE"]							= "Page Type META tag";
$pgv_lang["META_PAGE_TYPE_help"]					= "The value to place in the page-type meta tag in the HTML page header.<br />This sets the \$META_PAGE_TYPE variable in the config.php file.";
$pgv_lang["META_ROBOTS"]							= "Robots META tag";
$pgv_lang["META_ROBOTS_help"]						= "The value to place in the robots meta tag in the HTML page header.  Many robots or web crawlers do not listen to this value.<br />This sets the \$META_ROBOTS variable in the config.php file.";
$pgv_lang["META_REVISIT"]							= "How often should crawlers revisit META tag";
$pgv_lang["META_REVISIT_help"]						= "The value to place in the revisit meta tag in the HTML page header.  Many web crawlers do not listen to this value.<br />This sets the \$META_REVISIT variable in the config.php file.";
$pgv_lang["META_KEYWORDS"]							= "Keywords META tag";
$pgv_lang["META_KEYWORDS_help"]						= "The value to place in the keywords meta tag in the HTML page header.  Many search engines will use the keywords meta tag to help index your page.  The most common surnames list that appears in the GEDCOM statistics block on your welcome page will be appended to anything you enter here.<br />This sets the \$META_KEYWORDS variable in the config.php file.";
$pgv_lang["META_KEYWORDS_descr"]					= "The most common surnames list that appears in the GEDCOM statistics block on your welcome page will be appended to anything you enter here.";
$pgv_lang["META_TITLE"]								= "Add to TITLE header tag";
$pgv_lang["META_TITLE_help"]						= "Anything on this line will be added to the TITLE tag in the HTML page header after the regular page title and before the PhpGedView credit.<br />This sets the \$META_TITLE variable in the config.php file.";

$pgv_lang["welcome_new"]							= "Welcome to your new PhpGedView website.  Since you are seeing this page you have successfully installed PhpGedView on your webserver and are ready to begin configuring it the way you want it.<br />";
$pgv_lang["welcome_new_help"]						= "This help window will help guide you through the configuration process.  As you enter different fields, this window will provide you with help information about the field you are in.  You may close this window, to open it again click on one of the \"?\" question marks next to the field label.";
$pgv_lang["review_readme"]							= "You should first review the <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> file before continuing to configure PhpGedView.<br /><br />";
$pgv_lang["return_editconfig"]						= "You may return to this configuration at any time by pointing your browser to the editconfig.php file, or by clicking the link for <b>Configuration</b> on the <b>Adminstration</b> Page.<br />";
$pgv_lang["return_editconfig_gedcom"]				= "You may return to this configuration at any time, by clicking the link: <b>Edit</b> in the <b>Current GEDCOMs</b> table, on the <b>GEDCOM Adminstration</b> Page, or by pointing your browser to the editconfig_gedcom.php file.<br />";
$pgv_lang["save_config"]							= "Save Configuration";
$pgv_lang["download_here"]							= "Click here to download file.";
$pgv_lang["download_gedconf"]						= "Download GEDCOM configuration.";
$pgv_lang["not_writable"]							= "We have detected that you configuration file is not writable by PHP.  You can use the download button to save your settings to a file that you can upload manually.";
$pgv_lang["download_file"]							= "Download File";
$pgv_lang["upload_to_index"]						= "Upload the file to your index directory: ";

//-- edit privacy messages
$pgv_lang["edit_privacy"]							= "Edit Privacy";
$pgv_lang["edit_privacy_title"]						= "Edit GEDCOM Privacy Settings";
$pgv_lang["PRIV_PUBLIC"]							= "Show to public";
$pgv_lang["PRIV_USER"]								= "Show only to authenticated users";
$pgv_lang["PRIV_NONE"]								= "Show only to admin users";
$pgv_lang["PRIV_HIDE"]								= "Hide even from admin users";
$pgv_lang["save_changed_settings"]					= "Save changes";
$pgv_lang["add_new_pp_setting"]						= "Add new setting for Person Privacy";
$pgv_lang["add_new_up_setting"]						= "Add new setting for User Privacy";
$pgv_lang["add_new_gf_setting"]						= "Add new setting for Global Fact Privacy";
$pgv_lang["add_new_pf_setting"]						= "Add new setting for Person Facts Privacy";
$pgv_lang["add_new_pf_setting_indi"]				= "Add new setting for Person Facts Privacy for individuals";
$pgv_lang["add_new_pf_setting_source"]				= "Add new setting for Person Facts Privacy for sources";
$pgv_lang["privacy_indi_id"]						= "Individual - ID";
$pgv_lang["privacy_source_id"]						= "Source - ID";
$pgv_lang["privacy_indi_source"]					= "Individual / Source";
$pgv_lang["privacy_indi"]							= "Individual";
$pgv_lang["privacy_source"]							= "Πηγή";
$pgv_lang["file_read_error"]						= "E R R O R !!! Could not read privacy-file!";
$pgv_lang["general_settings"]						= "General Privacy settings";
$pgv_lang["person_privacy_settings"]				= "Person Privacy settings";
$pgv_lang["edit_exist_person_privacy_settings"]		= "Edit existing settings for Person Privacy ";
$pgv_lang["user_privacy_settings"]					= "User Privacy settings";
$pgv_lang["edit_exist_user_privacy_settings"]		= "Edit existing settings for User Privacy";
$pgv_lang["global_facts_settings"]					= "Global Fact Privacy settings";
$pgv_lang["edit_exist_global_facts_settings"]		= "Edit existing settings for Global Fact Privacy";
$pgv_lang["person_facts_settings"]					= "Person Facts Privacy settings";
$pgv_lang["edit_exist_person_facts_settings"]		= "Edit existing settings for Person Facts Privacy";
$pgv_lang["general_privacy_help"]					= "The <b>#pgv_lang[general_settings]#.</b><br />These settings will be your default settings for the particular GEDCOM.<br />Check under the page title whether you are editting the correct GEDCOM.<br /><br />This also means that for each GEDCOM (if you have more than one) on your PhpGedView web site, you can have different settings.<br /><br />You can override these general settings by use of the other Privacy Forms on the #pgv_lang[edit_privacy_title]# page.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy_help"]					= "The <b>#pgv_lang[person_privacy_settings]#.</b><br />These settings provide administrators the ability to override default privacy settings for a particular person in the GEDCOM. Suppose for example you have a child who died in infancy. Normally because the child is dead, its details would be shown to public users. But you and everyone else in your family is still private. You don't want to remove the death record for the child but you want to hide the details and make them private. If this child had the ID of I100 you should enter the following privacy settings: <br /><br />ID: I100<br />Show to: \"Show only to authenticated users\"<br /><br />This works the other way as well. If I wanted to make public the details of someone (ID 101) who I know is dead but don't have a death date for I could add the following:<br /><br />ID: I101<br />Show to: \"Show to public\"<br /><br />This sets the \$person_privacy variables in the chosen privacy file.";
$pgv_lang["user_privacy_help"]						= "The <b>#pgv_lang[user_privacy_settings]#.</b><br />These settings provide administrators the ability to override default privacy settings for individuals in the GEDCOM based on the users username.<br /><br />So if I don't want the Username \"John\" to be able to see my details, and I have the ID 100 in the GEDCOM I could configure it like this:<br /><br />Username: John<br />ID: I100<br />Show?: \"Hide\"<br /><br />and my details would be hidden for the Username \"John\" only.<br /><br />To show the details of I101 (which usually would be hidden because I101 is still alive) to the username \"John\" set:<br /><br />Username: John<br />ID: I101<br />Show?: \"Show\"<br /><br />This sets the \$user_privacy variables in the chosen privacy file.";
$pgv_lang["global_facts_help"]						= "The <b>#pgv_lang[global_facts_settings]#.</b><br />These settings define facts on a global level that should be hidden for all individuals in the GEDCOM.<br /><br />The [\"Name of fact\"] element determines which fact should be hidden. The [\"Choice\"] element choses the fact itself or related details. The [\"Show to\"] element determines at what access level the fact is shown.<br /><br />The \$global_facts array is meant to hide certain facts for all individuals alive or dead by GEDCOM tag. By default the SSN tag is hidden to public users. This is to prevent people from stealing social security numbers and commiting identify theft of your dead relatives which probably is mostly relevant for the USA. <br />If I wanted to hide all marriages from public users in my GEDCOM I could set:<br /><br />Name of fact: (MARR) - Marriage<br />Choice: \"Show fact\"<br />Show to?: \"Show only to authenticated users\"<br /><br />Name of fact: (MARR) - Marriage<br />Choice: \"Show fact details\"<br />Show to?: \"Show only to authenticated users\"<br /><br />These settings would hide marriages (and related details) to everyone who wasn't an admin.<br /><br />Different from all other settings, in \"global_facts\" you can hide facts even from admin users. This is to suppress unwanted facts completely.<br /><br />This sets the \$global_facts variables in the chosen privacy file.";
$pgv_lang["person_facts_help"]						= "The <b>#pgv_lang[person_facts_settings]#.</b><br />These settings define facts that are hidden for a specific individual in the GEDCOM and the level at which they are hidden.<br /><br />The first element is the ID of the person, the second element is the fact.<br />The [\"Choice\"] element choses the fact itselt or related details. The [\"Show to\"] element determines at what access level the fact is shown.<br /><br />The \$person_facts array works the same as the \$global_facts array except that you also specify the GEDCOM ID of the person you want to hide facts for. So I could hide the marriage record for a specific person.<br /><br />This sets the \$person_facts variables in the chosen privacy file.";
$pgv_lang["accessible_by"]							= "Show to?";
$pgv_lang["hide"]									= "Απόκρυψη";
$pgv_lang["show_question"]							= "Εμφάνιση?";
$pgv_lang["user_name"]								= "Username";
$pgv_lang["name_of_fact"]							= "Name of fact";
$pgv_lang["choice"]									= "Επιλογή";
$pgv_lang["fact_show"]								= "Show fact";
$pgv_lang["fact_details"]							= "Show fact details";
$pgv_lang["privacy_header"]							= "Edit privacy settings inside";
$pgv_lang["unable_to_find_privacy_indi"]			= "Unable to find individual with id";
$pgv_lang["save_and_import"]						= "After you save this GEDCOM configuration you will need to import the GEDCOM by clicking the <b>Import GEDCOM</b> button or by going to <b>Admin->Manage GEDCOMs->Import</b>";
$pgv_lang["SHOW_LIVING_NAMES"]						= "Show living names";
$pgv_lang["SHOW_RESEARCH_LOG"]						= "Show research log";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]				= "Use relationship privacy";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]				= "Max. relation path length";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]				= "Check marriage relations";
$pgv_lang["SHOW_DEAD_PEOPLE"]						= "Show dead people";
$pgv_lang["help_info"]								= "You can get help for each item by clicking on the red &quot;?&quot; by the label for each cell.";
$pgv_lang["SHOW_LIVING_NAMES_help"]					= "Show living names<br /><br />Should the names of living people be shown to the public.<br /><br />This sets the \$SHOW_LIVING_NAMES variable in the chosen privacy file.";
$pgv_lang["SHOW_RESEARCH_LOG_help"]					= "Show research log<br /><br />What type of user can view the research log if it is installed.<br /><br />This sets the \$SHOW_RESEARCH_LOG variable in the chosen privacy file.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]			= "Use relationship privacy<br /><br />A 'No' value means authenticated users can see the details of all living people.<br />A 'Yes' value means users can only see the private information of living people they are related to.<br /><br />This sets the \$USE_RELATIONSHIP_PRIVACY variable in the chosen privacy file.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]			= "Max. relation path length<br /><br />This sets the \$MAX_RELATION_PATH_LENGTH variable in the selected privacy file.<br /><br />If #pgv_lang[USE_RELATIONSHIP_PRIVACY] is turned on, logged in users will only be able to see and edit individuals within this number of relationship steps.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]			= "Check marriage relations<br /><br />Check related by marriage relationships.<br /><br />This sets the \$CHECK_MARRIAGE_RELATIONS variable in the chosen privacy file.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]					= "Show dead people<br /><br />Set the privacy access level for all dead people";
$pgv_lang["select_privacyfile_button"]				= "Select privacy file";
$pgv_lang["PRIVACY_BY_YEAR"]						= "Limit Privacy by age of Event";
$pgv_lang["PRIVACY_BY_YEAR_help"]					= "The Limit Privacy by age of Event setting will hide the details of people based on how old they were at specific events regardless of whether they are dead or alive.  Use this setting along with the \"Age at which to assume a person is dead\" setting.  For example, if you set the Age setting to 100 and turned this setting to \"Yes\", then all persons, alive or dead, born less than 100 years ago would be set to private.  People who were married less than 85 years ago, and people who died less than 75 years ago would also be marked as private.  Please note that using this option will slow down your performance somewhat.<br /><br />This sets the \$PRIVACY_BY_YEAR variable in the privacy settings file.";

//-- language edit utility
$pgv_lang["edit_langdiff"]							= "Edit and configure language files";
$pgv_lang["edit_lang_utility"]						= "Language File Edit Utility";
$pgv_lang["edit_lang_utility_help"]					= "You can use this utility to edit the content of a language file by using the content of the english one.<br />It will list you the the content of the original english language file and the content of your chosen language<br />After clicking on the message of your chosen file a new window will open where you can change and save the message of your chosen language.";
$pgv_lang["edit_lang_utility_warning"]				= "ATTENTION!<br /><br />If you should decide to use the button >#close_window_without_refresh#< you should be informed that you will not directly see your changes on the screen of the language editor until you make a manual page-reload and it could be that your language file may be destroyed if you add a message which has not been inside the language file yet or if you just edit a message you have edited directly before.<br /><br />So if you don't really know what you do, please do not use the button >#close_window_without_refresh#.<";
$pgv_lang["language_to_edit"]						= "Language to edit";
$pgv_lang["file_to_edit"]							= "Language file type to edit";
$pgv_lang["lang_save"]								= "Save";
$pgv_lang["contents"]								= "Contents";
$pgv_lang["listing"]								= "Listing";
$pgv_lang["no_content"]								= "No Content";
$pgv_lang["editlang_help"]							= "Edit message from language file";
$pgv_lang["cancel"]									= "Ακύρωση";
$pgv_lang["savelang_help"]							= "Save edited message";
$pgv_lang["original_message"]						= "Original message";
$pgv_lang["message_to_edit"]						= "Message to edit";
$pgv_lang["changed_message"]						= "Changed content";
$pgv_lang["message_empty_warning"]					= "-> Warning!!! This message is empty inside [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]						= "Language to export";
$pgv_lang["export_lang_utility"]					= "Language File Export Utility";
$pgv_lang["export"]									= "Εξαγωγή-Export";
$pgv_lang["export_lang_utility_help"]				= "In this module you can choose a language and click on the export button to export the help messages from the chosen configuration_help language file to create a documentation.";
$pgv_lang["export_ok"]								= "Help messages were exported";
$pgv_lang["compare_lang_utility"]					= "Language File Comparison Utility";
$pgv_lang["compare_lang_utility_help"]				= "This module will compare two language files and provide a list of the additions and subtractions between them.<br />Read also the file [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>] for all changes.";
$pgv_lang["new_language"]							= "Source language";
$pgv_lang["old_language"]							= "Secondary language";
$pgv_lang["compare"]								= "Compare";
$pgv_lang["comparing"]								= "Language files that are compared";
$pgv_lang["additions"]								= "Additions";
$pgv_lang["no_additions"]							= "No Additions";
$pgv_lang["subtractions"]							= "Subtractions";
$pgv_lang["no_subtractions"]						= "No Subtractions";
$pgv_lang["config_lang_utility"]					= "Configuration of supported languages";
$pgv_lang["config_lang_utility_help"]				= "This module will help you to edit the language specific settings for the usage inside PhpGedView.<br />Please note that if you have made a change to the original language settings of PhpGedView a new file (#INDEX_DIRECTORY#lang_settings.php) is created inside your #INDEX_DIRECTORY#-directory.<br />All your further changes will be made to this new file and PhpGedView will use only THIS file.<br />So if you have problem with your language settings please report that you have this new file inside your #INDEX_DIRECTORY#-directory!";
$pgv_lang["active"]									= "Active";
$pgv_lang["active_help"]							= "Allow users to select this language if change of language is allowed.";
$pgv_lang["edit_settings"]							= "Edit settings";
$pgv_lang["lang_edit"]								= "Edit";
$pgv_lang["lang_language"]							= "Language";
$pgv_lang["export_filename"]						= "Name of the file including the exported data:";
$pgv_lang["lang_back"]								= "Go back to the main menu to edit and configure language files";
$pgv_lang["lang_back_admin"]						= "Go back to the Admin menu";
$pgv_lang["lang_back_manage_gedcoms"]				= "Go back to the GEDCOM management menu";
$pgv_lang["lang_name_czech"]						= "Czech";
$pgv_lang["lang_name_chinese"]						= "Κινέζικα";
$pgv_lang["lang_name_danish"]						= "Danish";
$pgv_lang["lang_name_dutch"]						= "Dutch";
$pgv_lang["lang_name_english"]						= "Αγγλικά";
$pgv_lang["lang_name_finnish"]						= "Finnish";
$pgv_lang["lang_name_french"]						= "Γαλλικά";
$pgv_lang["lang_name_german"]						= "Γερμανικά";
$pgv_lang["lang_name_hebrew"]						= "Hebrew";
$pgv_lang["lang_name_hungarian"]					= "Hungarian";
$pgv_lang["lang_name_italian"]						= "Ιταλικά";
$pgv_lang["lang_name_norwegian"]					= "Norwegian";
$pgv_lang["lang_name_polish"]						= "Polish";
$pgv_lang["lang_name_portuguese"]					= "Portuguese";
$pgv_lang["lang_name_portuguese-br"]				= "Brasilian Portuguese";
$pgv_lang["lang_name_russian"]						= "Ρώσικα";
$pgv_lang["lang_name_spanish"]						= "Ισπανικά";
$pgv_lang["lang_name_spanish-ar"]					= "Latin American Spanish";
$pgv_lang["lang_name_swedish"]						= "Swedish";
$pgv_lang["lang_name_turkish"]						= "Τούρκικα";
$pgv_lang["lang_name_greek"]						= "Ελληνικά";
$pgv_lang["lang_new_language"]						= "Νέα Γλώσσα";
$pgv_lang["original_lang_name"]						= "Original name of language in #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]				= "How is this language named in this language?<br /><br />English is called in the English language: English<br />German is called in the German language: Deutsch<br />Dutch is called in Dutch language: Nederlands<br />etc.";
$pgv_lang["lang_shortcut"]							= "Shortcut for language files";
$pgv_lang["lang_shortcut_help"]						= "This code defines the shortcut which is used to name the language files for the chosen language inside PhpGedView.<br />Normally it is the first code of the 'Language detection codes' which can be defined in the next field of the language settings window.";
$pgv_lang["lang_langcode"]							= "Language detection codes";
$pgv_lang["lang_langcode_help"]						= "This codes enables PhpGedView to detect the language setting of the browser which the actual user is using to view your PhpGedView pages. They need to be seperated by a semikolon ';'";
$pgv_lang["lang_filename"]							= "Αρχείου Γλώσσας";
$pgv_lang["lang_filename_help"]						= "Name and path of standard language translations file.";
$pgv_lang["config_filename"]						= "Configure-Help Filename";
$pgv_lang["config_filename_help"]					= "Name and path of configure language translations file.";
$pgv_lang["facts_filename"]							= "Facts file";
$pgv_lang["facts_filename_help"]					= "Name and path of the file with the translations of the GEDCOM Facts.";
$pgv_lang["help_filename"]							= "Αρχείο Βοήθειας";
$pgv_lang["help_filename_help"]						= "Name and path of the file with the translations of the Help text.";
$pgv_lang["flagsfile"]								= "Όνομα αρχείου σημαίας";
$pgv_lang["flagsfile_help"]							= "Name and path of the national flag imagefile for the selected language.";
$pgv_lang["text_direction"]							= "Φορά γραφής";
$pgv_lang["text_direction_help"]					= "Defines which direction the text is written in the chosen language.<br /><br />Normally all western languages use the direction left to right if they read or write a text.<br />But there are languages like Arabic or Hebrew which use right to left instead of left to right.";
$pgv_lang["date_format_help"]						= "This field defines the date format which is generally used in genelogic works of the chosen language.<br /><br />Variables you may use are:<br />D for day<br />M for month<br />Y for year.<br /><br />You can change the order of this variables and also add delimiter chars into it.<br /><br />The standard setting of this var is 'D M Y', which means that a date inside a GEDCOM record like 'DATE 20 Nov 1965' is shown inside PhpGedView as '20 November 1965'.<br /><br />For example in Germany this field has the content: 'D. M Y' which means that the date shown above will be in the german language: '20. November 1965'.<br /><br />Another example is the hungarian language which defines the date 'Y. M D.' and the date above will be '1965. November 20.' inside PhpGedView. (if November would be the name of the 11. month in Hungarian)<br />Another example is the finnish language which defines the date 'D. M#ta# Y'. This definition means that in finnish all months which have a day in the GEDCOM record will be shown as 20. Novemberta 1965 (if November would be the name of the 11. month in Finnish).";
$pgv_lang["time_format"]							= "Μορφή ώρας";
$pgv_lang["time_format_help"]						= "This field defines the time format which is used in the selected language.<br /><br />Variables you may use are:<br />a - Lowercase Ante meridiem and Post meridiem - 'am' or 'pm'<br />A - Uppercase Ante meridiem and Post meridiem - 'AM' or 'PM'<br />B - Swatch Internet time 000 through 999<br />c - ISO 8601 date (added in PHP 5) 2004-02-12T15:19:21+00:00<br />d - Day of the month, 2 digits with leading zeros 01 to 31<br />D - A textual representation of a day, three letters Mon through Sun<br />F - A full textual representation of a month, such as January or March January through December<br />g - 12-hour format of an hour without leading zeros 1 through 12<br />G - 24-hour format of an hour without leading zeros 0 through 23<br />h - 12-hour format of an hour with leading zeros 01 through 12<br />H - 24-hour format of an hour with leading zeros 00 through 23<br />i - Minutes with leading zeros 00 to 59<br />I - (capital i) Whether or not the date is in daylights savings time 1 if Daylight Savings Time, 0 otherwise.<br />j - Day of the month without leading zeros 1 to 31<br />l - (lowercase 'L') A full textual representation of the day of the week Sunday through Saturday<br />L - Whether it's a leap year 1 if it is a leap year, 0 otherwise.<br />m - Numeric representation of a month, with leading zeros 01 through 12<br />M - A short textual representation of a month, three letters Jan through Dec<br />n - Numeric representation of a month, without leading zeros 1 through 12<br />O - Difference to Greenwich time (GMT) in hours Example: +0200<br />r - RFC 2822 formatted date Example: Thu, 21 Dec 2000 16:01:07 +0200<br />s - Seconds, with leading zeros 00 through 59<br />S - English ordinal suffix for the day of the month, 2 characters st, nd, rd or th. Works well with j<br />t - Number of days in the given month 28 through 31<br />T - Timezone setting of this machine Examples: CEST, EST, MDT ...<br />U - Seconds since the Unix Epoch (January 1 1970 00:00:00 GMT)<br />w - Numeric representation of the day of the week 0 (for Sunday) through 6 (for Saturday)<br />W - ISO-8601 week number of year, weeks starting on Monday (added in PHP 4.1.0) Example: 42 (the 42nd week in the year)<br />Y - A full numeric representation of a year, 4 digits Examples: 1999 or 2003<br />y - A two digit representation of a year Examples: 99 or 03<br />z - The day of the year (starting from 0) 0 through 365<br />Z - Timezone offset in seconds. The offset for timezones west of UTC is always negative, and for those east of UTC is always positive. -43200 through 43200<br /><br />You can change the order of this variables and also add delimiter chars into it.<br />For example in Germany this field has the content: 'H:i:s' which makes an output like: '09:01:25'.<br />In English the standard definition of this field is: 'g:i:sa' which makes an output like: '9:01:25am'.";
$pgv_lang["week_start"]								= "Αρχική ημέρα της εβδομάδας";
$pgv_lang["week_start_help"]						= "The day of the week that starts a new week in this language.  Most languages start the week on Sunday, but some start on Monday or other days.";
$pgv_lang["name_reverse"]							= "Επώνυμο πρώτα";
$pgv_lang["name_reverse_help"]						= "In some languages the surname should be displayed first instead of the default to display it last.  Enabling this option will display the surname first.";
$pgv_lang["ltr"]									= "Αριστερά προς δεξιά";
$pgv_lang["rtl"]									= "Δεξιά προς αριστερά";
$pgv_lang["file_does_not_exist"]					= "ΣΦΑΛΜΑ! Το αρχείο δεν υπάρχει...";
$pgv_lang["alphabet_upper"]							= "Αλφάβητο κεφαλαία γράμματα";
$pgv_lang["alphabet_upper_help"]					= "Upper case alphabet letters in this language. This alphabet is used to do the sorting of the uppercase names in the names lists of PhpGedView in the selected language.";
$pgv_lang["alphabet_lower"]							= "Αλφάβητο μικρά γράμματα";
$pgv_lang["alphabet_lower_help"]					= "Lower case alphabet letters in this language. This alphabet is used to do the sorting of the lowercase names in the names lists of PhpGedView in the selected language.";
$pgv_lang["lang_config_write_error"]				= "Error writing language settings into the file [language_settings.php]. Check permissions and try again.";
$pgv_lang["lang_save_success"]						= "Succesfully saved changes of #PGV_LANG#";
$pgv_lang["translation_forum"]						= "Link to the PhpGedView translations forum on SourceForge";
$pgv_lang["translation_forum_help"]					= "This link opens a new browser window where you are redirected to the translation forum of PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245) where you can talk about translation specific problems :-)";
$pgv_lang["system_time"]							= "Current System Time:";
$pgv_lang["gedcom_not_imported"]					= "This GEDCOM has not been imported yet.";
$pgv_lang["lang_set_file_read_error"]				= "E R R O R !!! Could not read [language_settings.php]!";
$pgv_lang["add_new_language"]						= "Add files and settings for a new language";
$pgv_lang["add_new_language_help"]					= "You can use this utility to add a new and yet not supportet language to PhpGedView.<br />Please fill out all needed fields in the next window.<br />After creating the new files you will be able to change the messages for that language.";
$pgv_lang["add_new_lang_button"]					= "Προσθήκη νέας γλώσσας";
$pgv_lang["hide_translated"]						= "Hide translated";
$pgv_lang["lang_file_write_error"]					= "E R R O R !!!<br /><br />Could not write changes into the selected language file!<br />Check write permissions on (#lang_filename#)";
$pgv_lang["never"]									= "Ποτέ";

//-- User Migration Tool messages
$pgv_lang["um_header"]								= "User Information Migration Tool";
$pgv_lang["um_proceed"]								= "Proceed with export of user data files?<br /><br />";
$pgv_lang["um_creating"]							= "Creating";
$pgv_lang["um_sql_index1"]							= "This tool will create .dat files in your index directory:";
$pgv_lang["um_sql_index2"]							= "After succesful creation, you can switch to index mode with all current users and their messages, favorites, news and MyGedview layout available.<br />Note: After switching to index mode it will be neccessary to import your GEDCOM files(s) again.<br /><br />";
$pgv_lang["um_file_create_fail1"]					= "Creation of new file failed, a file with that name already exists:";
$pgv_lang["um_file_create_fail2"]					= "Cannot create";
$pgv_lang["um_file_create_fail3"]					= "Check access rights on this directory.";
$pgv_lang["um_file_create_succ1"]					= "Creation of new file succeful:";
$pgv_lang["um_file_not_created"]					= "File is not created.";
$pgv_lang["um_nomsg"]								= "No messages seem to be present in the system.";
$pgv_lang["um_nofav"]								= "No favorites seem to be present in the system.";
$pgv_lang["um_nonews"]								= "No news seems to be present in the system.";
$pgv_lang["um_noblocks"]							= "No blocks seems to be present in the system.";
$pgv_lang["um_index_sql1"]							= "This tool will create a set of SQL queries in your index directory:";
$pgv_lang["um_index_sql2"]							= "These files can be run as a query on your SQL database, after installation of or switching to the SQL version of PhpGedView.<br /><br />After switching to SQL mode, you will have to import your GEDCOM files again.";
$pgv_lang["um_query_not_created"]					= "Query is not created.";


?>
