<?php
/**
 * Spanish language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @translator: Julio Sánchez Fernández
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: facts.es.php 1624 2007-09-10 20:09:01Z canajun2eh $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Usted no puede acceder a este archivo de idioma directamente.";
	exit;
}

// -- Define a fact array to map GEDCOM tags with their English values
$factarray["ABBR"]	= "Abreviatura";
$factarray["ADDR"]	= "Dirección";
$factarray["ADR1"]	= "Dirección 1";
$factarray["ADR2"]	= "Dirección 2";
$factarray["ADOP"]	= "Adopción";
$factarray["AFN"]	= "(AFN)";
$factarray["AGE"]	= "Edad";
$factarray["AGNC"]	= "Agencia";
$factarray["ALIA"]	= "Alias";
$factarray["ANCE"]	= "Antepasados";
$factarray["ANCI"]	= "Antepasados de Interés";
$factarray["ANUL"]	= "Anulación";
$factarray["ASSO"]	= "Asociados";
$factarray["AUTH"]	= "Autor";
$factarray["BAPL"]	= "Bautismo SUD";
$factarray["BAPM"]	= "Bautismo";
$factarray["BARM"]	= "Bar Mitzvah";
$factarray["BASM"]	= "Bas Mitzvah";
$factarray["BIRT"]	= "Nacimiento";
$factarray["BLES"]	= "Bendición";
$factarray["BLOB"]	= "Objeto de Datos Binarios";
$factarray["BURI"]	= "Entierro";
$factarray["CALN"]	= "Referencia";
$factarray["CAST"]	= "Estatus Social";
$factarray["CAUS"]	= "Causa";
$factarray["CEME"]  = "Cementerio";
$factarray["CENS"]	= "Censo";
$factarray["CHAN"]	= "último cambio";
$factarray["CHAR"]	= "Juego de Caracteres";
$factarray["CHIL"]	= "Hijo";
$factarray["CHR"]	= "Bautismo";
$factarray["CHRA"]	= "Bautismo en edad adulta";
$factarray["CITY"]	= "Ciudad";
$factarray["CONF"]	= "Confirmación";
$factarray["CONL"]	= "Confirmación SUD";
$factarray["COPR"]	= "Copyright";
$factarray["CORP"]	= "Corporación / Compañía";
$factarray["CREM"]	= "Cremación";
$factarray["CTRY"]	= "País";
$factarray["DATA"]	= "Datos";
$factarray["DATE"]	= "Fecha";
$factarray["DEAT"]	= "Defunción";
$factarray["DESC"]	= "Descendientes";
$factarray["DESI"]	= "Descendientes de Interés";
$factarray["DEST"]	= "Destino";
$factarray["DIV"]	= "Divorcio";
$factarray["DIVF"]	= "Divorcio Archivado";
$factarray["DSCR"]	= "Descripción";
$factarray["EDUC"]	= "Educación";
$factarray["EMIG"]	= "Emigración";
$factarray["ENDL"]	= "Investidura SUD";
$factarray["ENGA"]	= "Compromiso matrimonio";
$factarray["EVEN"]	= "Evento";
$factarray["FAM"]	= "Familia";
$factarray["FAMC"]	= "Familia como hijo";
$factarray["FAMF"]	= "Fichero Familia";
$factarray["FAMS"]	= "Familia como cónyuge";
$factarray["FCOM"]	= "Primera Communión";
$factarray["FILE"]	= "Fichero Externo";
$factarray["FORM"]	= "Formato";
$factarray["GIVN"]	= "Nombre de pila";
$factarray["GRAD"]	= "Graduación";
$factarray["HUSB"]  = "Esposo";
$factarray["IDNO"]	= "Numero de Identificación";
$factarray["IMMI"]	= "Immigración";
$factarray["LEGA"]	= "Herencia";
$factarray["MARB"]	= "Amonestaciones";
$factarray["MARC"]	= "Contrato Matrimonial";
$factarray["MARL"]	= "Licencia Matrimonial";
$factarray["MARR"]	= "Matrimonio";
$factarray["MARS"]	= "Dote";
$factarray["MEDI"]	= "Tipo de objeto";
$factarray["NAME"]	= "Nombre";
$factarray["NATI"]	= "Nacionalidad";
$factarray["NATU"]	= "Natural";
$factarray["NCHI"]	= "Número de Hijos";
$factarray["NICK"]	= "Apodo";
$factarray["NMR"]	= "Número de matrimonios";
$factarray["NOTE"]	= "Nota";
$factarray["NPFX"]	= "Prefijo";
$factarray["NSFX"]	= "Sufijo";
$factarray["OBJE"]	= "Objeto audiovisual";
$factarray["OCCU"]	= "Ocupación";
$factarray["ORDI"]	= "Ordenanza";
$factarray["ORDN"]	= "Ordenación";
$factarray["PAGE"]	= "Detalles de la cita";
$factarray["PEDI"]	= "Antepasados";
$factarray["PLAC"]	= "Lugar";
$factarray["PHON"]	= "Telef.";
$factarray["POST"]	= "Código Postal";
$factarray["PROB"]	= "Certificado Testamento";
$factarray["PROP"]	= "Propiedad";
$factarray["PUBL"]	= "Publicación";
$factarray["QUAY"]	= "Calidad de los datos";
$factarray["REPO"]	= "Repositorio";
$factarray["REFN"]	= "Número Ref";
$factarray["RELA"]	= "Relación";
$factarray["RELI"]	= "Religión";
$factarray["RESI"]	= "Residencia";
$factarray["RESN"]	= "Restricción";
$factarray["RETI"]	= "Jubilación";
$factarray["RFN"]	= "Número de archivo del registro";
$factarray["RIN"]	= "Número ID del registro";
$factarray["ROLE"]	= "Rol";
$factarray["SEX"]	= "Sexo";
$factarray["SLGC"]	= "Sellam. SUD hijo";
$factarray["SLGS"]	= "Sellam. SUD cónyuge";
$factarray["SOUR"]	= "Fuente";
$factarray["SPFX"]	= "Prefijo del Apellido";
$factarray["SSN"]	= "Número Seguridad Social";
$factarray["STAE"]	= "Estado/Provincia";
$factarray["STAT"]	= "Estatus";
$factarray["SUBM"]	= "Remitente";
$factarray["SUBN"]	= "Envío";
$factarray["SURN"]	= "Apellidos";
$factarray["TEMP"]	= "Templo";
$factarray["TEXT"]	= "Texto";
$factarray["TIME"]	= "Hora";
$factarray["TITL"]	= "Título";
$factarray["TYPE"]	= "Tipo";
$factarray["WIFE"]  = "Esposa";
$factarray["WILL"]	= "Testamento";
$factarray["_EMAIL"]	= "Correo electrónico";
$factarray["EMAIL"]	= "Correo electrónico";
$factarray["_TODO"]	= "Pendiente de hacer";
$factarray["_UID"]	= "Identificador Universal";
$factarray["_PRIM"]	= "Imagen resaltada";
$factarray["_DBID"] = "ID en la base de datos enlazada";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Fecha del cambio de estado";

//These facts are compounds for the view probabilities page
$factarray["FAMC:HUSB:SURN"] = "Apellido del padre";
$factarray["FAMC:WIFE:SURN"] = "Apellido de la madre";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Lugar de nacimiento del padre";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Lugar de nacimiento de la madre";
$factarray["FAMC:MARR:PLAC"] = "Lugar de matrimonio de los padres";
$factarray["FAMC:HUSB:OCCU"] = "Ocupación del padre";
$factarray[":BIRT:PLAC"] = "Lugar de nacimiento";
$factarray["FAMS:MARR:PLAC"] = "Lugar de matrimonio";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Lugar de defunción del cónyuge";
$factarray["FAMC:HUSB:GIVN"] = "Nombre de pila del padre";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Lugar de nacimiento del cónyuge";
$factarray["FAMC:WIFE:GIVN"] = "Nombre de pila de la madre";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Nombre de pila del abuelo paterno";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Nombre de pila de la abuela materna";


// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Lugar de nacimiento";
$factarray["DEAT:PLAC"] = "Lugar de defunción";
$factarray["CHR:PLAC"] = "Lugar del bautismo";
$factarray["BAPM:PLAC"] = "Lugar del bautismo adulto";
$factarray["BURI:PLAC"] = "Lugar del entierro";
$factarray["MARR:PLAC"] = "Lugar del matrimonio";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]	= "Médico";
$factarray["_DEG"]	= "Grado";
$factarray["_MILT"]	= "Servicio Militar";
$factarray["_SEPR"]	= "Separado";
$factarray["_DETS"]	= "Fallecimiento de un cónyuge";
$factarray["CITN"]	= "Ciudadanía";
$factarray["_FA1"]	= "Acontecimiento 1";
$factarray["_FA2"]	= "Acontecimiento 2";
$factarray["_FA3"]	= "Acontecimiento 3";
$factarray["_FA4"]	= "Acontecimiento 4";
$factarray["_FA5"]	= "Acontecimiento 5";
$factarray["_FA6"]	= "Acontecimiento 6";
$factarray["_FA7"]	= "Acontecimiento 7";
$factarray["_FA8"]	= "Acontecimiento 8";
$factarray["_FA9"]	= "Acontecimiento 9";
$factarray["_FA10"]	= "Acontecimiento 10";
$factarray["_FA11"]	= "Acontecimiento 11";
$factarray["_FA12"]	= "Acontecimiento 12";
$factarray["_FA13"]	= "Acontecimiento 13";
$factarray["_MREL"]	= "Relación con la madre";
$factarray["_FREL"]	= "Relación con el padre";
$factarray["_MSTAT"]	= "Comienzo del matrimonio";
$factarray["_MEND"]	= "Final del matrimonio";

// GEDCOM 5.5.1 related facts
$factarray["FAX"] = "FAX";
$factarray["FACT"] = "Evento";
$factarray["WWW"] = "Página Web";
$factarray["MAP"] = "Mapa";
$factarray["LATI"] = "Latitud";
$factarray["LONG"] = "Longitud";
$factarray["FONE"] = "Fonética";
$factarray["ROMN"] = "Romanizado";

// PAF related facts
$factarray["_NAME"] = "Nombre de correo";
$factarray["URL"] = "Dirección URL";
$factarray["_URL"] = "URL Web";
$factarray["_HEB"] = "Hebreo";
$factarray["_SCBK"] = "Libreta de notas";
$factarray["_TYPE"] = "Tipo de objeto";
$factarray["_SSHOW"] = "Presentación";

// Rootsmagic
$factarray["_SUBQ"]= "Versión corta";
$factarray["_BIBL"] = "Bibliografía";

// Reunion
$factarray["EMAL"]	= "Dirección de correo electrónico";

// Other common customized facts
$factarray["_ADPF"]	= "Adoptado por el padre";
$factarray["_ADPM"]	= "Adoptado por la madre";
$factarray["_AKAN"]	= "También conocido como";
$factarray["_AKA"] 	= "También conocido como";
$factarray["_BRTM"]	= "Brit mila";
$factarray["_COML"]	= "Derecho matrimonial";
$factarray["_EYEC"]	= "Color de ojos";
$factarray["_FNRL"]	= "Funeral";
$factarray["_HAIR"]	= "Color de pelo";
$factarray["_HEIG"]	= "Altura";
$factarray["_HOL"]  = "Holocaust";
$factarray["_INTE"]	= "Entierro";
$factarray["_MARI"]	= "Proposición de matrimonio";
$factarray["_MBON"]	= "Lazo matrimonial";
$factarray["_MEDC"]	= "Estado médico";
$factarray["_MILI"]	= "Militar";
$factarray["_NMR"]	= "Soltero";
$factarray["_NLIV"]	= "Fallecido";
$factarray["_NMAR"]	= "Nunca contrajo matrimonio";
$factarray["_PRMN"]	= "Número fijo";
$factarray["_WEIG"]	= "Peso";
$factarray["_YART"]	= "Yartzeit";
$factarray["_MARNM"] = "Nombre de casada";
$factarray["_MARNM_SURN"] = "Apellido de casada";
$factarray["_STAT"]	= "Estado de matrimonio";
$factarray["COMM"]	= "Comentario";

// Aldfaer related facts
$factarray["MARR_CIVIL"] = "Matrimonio civil";
$factarray["MARR_RELIGIOUS"] = "Matrimonio religioso";
$factarray["MARR_PARTNERS"] = "Pareja registrada";
$factarray["MARR_UNKNOWN"] = "Tipo desconocido de pareja";

$factarray["_HNM"] = "Nombre hebreo";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Fallecimiento de un cónyuge";

$factarray["_BIRT_CHIL"] = "Nacimiento de un hijo";
$factarray["_MARR_CHIL"] = "Matrimonio de un hijo";
$factarray["_DEAT_CHIL"] = "Defunción de un hijo";

$factarray["_BIRT_GCHI"] = "Nacimiento de un nieto";
$factarray["_MARR_GCHI"] = "Matrimonio de un nieto";
$factarray["_DEAT_GCHI"] = "Defunción de un nieto";

$factarray["_MARR_FATH"] = "Matrimonio del padre";
$factarray["_DEAT_FATH"] = "Defunción del padre";

$factarray["_MARR_MOTH"] = "Matrimonio de la madre";
$factarray["_DEAT_MOTH"] = "Defunción de la madre";

$factarray["_BIRT_SIBL"] = "Nacimento de un hermano";
$factarray["_MARR_SIBL"] = "Matrimonio de un hermano";
$factarray["_DEAT_SIBL"] = "Defunción de un hermano";

$factarray["_BIRT_HSIB"] = "Nacimiento de un medio hermano";
$factarray["_MARR_HSIB"] = "Matrimonio de un medio hermano";
$factarray["_DEAT_HSIB"] = "Defunción de un medio hermano";

$factarray["_DEAT_GPAR"] = "Defunción de un abuelo";

$factarray["_BIRT_FSIB"] = "Nacimiento de un tío paterno";
$factarray["_MARR_FSIB"] = "Matrimonio de un tío paterno";
$factarray["_DEAT_FSIB"] = "Defunción de un tío paterno";

$factarray["_BIRT_MSIB"] = "Nacimiento de un tío materno";
$factarray["_MARR_MSIB"] = "Matrimonio de un tío materno";
$factarray["_DEAT_MSIB"] = "Defunción de un tío materno";

$factarray["_BIRT_COUS"] = "Nacimiento de un primo hermano";
$factarray["_MARR_COUS"] = "Matrimonio de un primo hermano";
$factarray["_DEAT_COUS"] = "Defunción de un primo hermano";

//-- PGV Only facts
$factarray["_THUM"]	= "¿Usar esta imagen como la miniatura?";
$factarray["_PGVU"]	= "Última modificación realizada por"; // last changed by
$factarray["SERV"] = "Servidor remoto";
$factarray["_GEDF"] = "Archivo GEDCOM";

?>
