<?php
/**
 * Latin American Spanish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Eduardo Cociña
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Eduardo Cociña
 * @version $Id: help_text.es-ar.php 981 2007-03-21 13:24:38Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Usted no puede acceder a este archivo de idioma directamente.";
	exit;
}

$pgv_lang["help_header"]	= "Información extra de:";
$pgv_lang["privacy_error_help"]	= "<b>DETALLES PRIVADOS</b><br /><br />Existen varios motivos posibles para este mensaje:<br /><br />1. Es un visitante no registrado.<br /><br />La información de las personas vivas en este GEDCOM se estableció como \"Privada\". Los visitantes no registrados y los visitantes que no han ingresado pueden ver la información completa de las personas fallecidas solamente. Si está permitido por el Administrador, puede registrarse para una cuenta presionando el botón \"Ingresar\" y luego el vínculo #pgv_lang[requestpassword]#.<br /><br /><b>2. Ud. es un usuario con Nombre de Usuario y contraseña...</b><br />Pero olvidó ingresar o estuvo inactivo por un tiempo prolongado y su sesión finalizó.<br /><br /><b>3. Información establecida como \"Privada\"</b><br />La persona cuyo nombre seleccionó, solicitó al administrador definirla como como \"Privado\"<br />Cuando una persona es definida como Privado, sus detalles sólo pueden ser vistos por administradores.<br /><br /><b>4. No relacionada</b><br />Aún siendo un usuario regular <b>y</b> habiendo Ingresado, puede ocurrir que aparezca este mensaje si la persona que está tratando de ver no está relacionada con Ud. dentro del número de grados de parentesco fijados en este sitio por el administrador de este GEDCOM. <br />Ejemplos: <br />Cuando el grado de parentesco se fija en <b>1</b>, sólo podrá ver los detalles de su propia familia, padre, madre, hermanos(as) (pero no las/los esposas(os) e hijos de sus hermanos(as))<br /><br />Cuando el grado de parentesco se fija en <b>2</b>, podrá ver también los detalles de la esposa(o) de su hermano(a) pero no las esposas(os) de sus hijos.<br />Cuanto mayor sea el grado de parentesco fijado, mayor será el número de parientes que podrá ver.<br /><br />Si piensa que califica para ver determinados detalles, contáctese con el administrador presionando el vínculo siguiente en cualquier pantalla.";
$pgv_lang["more_help"]	= "<br />Si desea obtener ayuda contextual (específica) asegúrese que <b>#pgv_lang[show_context_help]#</b> esté seleccionado (en el menú Ayuda) y presione <b>?</b> a continuación del tema.<br />";
$pgv_lang["more_config_help"]	= "<br /><b>Más ayuda</b><br />Mayor ayuda disponible en la página.<br />Presione <b>?</b> junto a las etiquetas.<br />";
$pgv_lang["start_admin_help"]	= "+++ Comienzo de información extra de Administración +++";
$pgv_lang["end_admin_help"]	= "--- Fin de información extra de Administración ---";
$pgv_lang["multiple_help"]	= "<center>--- Este es un texto de ayuda general para múltiples páginas ---</center>";
$pgv_lang["header_general_help"]	= "<div class=\"name_head\"><center><b>INFORMACIÓN GENERAL</b></center></div><br />";
$pgv_lang["best_display_help"]	= "~Resolución de Pantalla~<br />PhpGedView está diseñado para una resolución de pantalla de 1024x768 pixels.<br />Esta es la resolución mínima para que todas las páginas se exhiban en forma completa.<br />Si ha fijado la resolución en un valor inferior (p.ej. 800x600 pixels), deberá realizar desplazamientos horizontales para poder observar el contenido completo de la pantalla.<br />";
$pgv_lang["preview_help"]	= "~Impresión~<br />Presionando esta opción se redibujará la pantalla, desechando todo aquello que sea irrelevante para una impresión adecuada (menús, \"cajas de ingreso\", vínculos \"extra\", los signos de interrogación para la ayuda contextual, etc.).<br />En la versión \"amistosa\" de la página para impresión, encontrará un vínculo al final de la página. Presiónelo y aparecerá una ventana de diálogo. Después de la impresión presione \"volver\" y la pantalla se redibujará en el modo normal.<br /><br />Nota: Aunque en la versión \"amistosa\" para impresión se han removido vínculos de la pantalla;, los que permanecen todavía son presionables.<br />";
$pgv_lang["readme_help"]	= "<center>Para mayor información, consulte <a href=\"readme.txt\"><b>Readme.txt</b></a>.</center>";
$pgv_lang["is_user_help"]	= "--- Este texto de ayuda es similar al que el usuario (o visitante) leerá. ---<br />--- Para ahorrar espacio no se ha hecho una versión especial de administración para este ítem. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~EDITAR GEDCOM EN BRUTO~<br><br>Cuando presione este vínculo, se abrirá una ventana conteniendo los datos de esta página correspondientes al archivo GEDCOM \"en bruto\".<br>Aquí podrá editar directamente los datos del GEDCOM. Asegúrese de ingresar datos válidos según el standard GEDCOM 5.5, ya que no se realiza ningún tipo de control adicional.<br>Los datos modificados/cambiados se mostrarán como \"cambios\" en PhpGedView y deberán ser aceptados por un usuario con que posea tal privilegio.";
$pgv_lang["index_help"]	= "~LA PÁGINA DE BIENVENIDA</b><br /><br />Esta es la página de Beinvenida. Lo recibe con el archivo <a href=\"#def_gedcom\">GEDCOM</a> . Podrá retornar a esta página presionando \"Página de Bienvenida\" en el primer menú. De existir múltiples GEDCOMs en el sitio, podrá elegir el GEDCOM desde el menú descolgable.<br><b>Dado que esta es la primer página del programa, esta página de ayuda contiene información sobre:</b><ul><li><a href=\"#index_portal\">Página de Bienvenida</a><li><a href=\"#header\">Área de Encabezamiento</a><li><a href=\"#menu\">Menúes</a><li><a href=\"#header_general\"> Información General</a><li><a href=\"#def\">Definiciones</a></ul><br />La versión #VERSION# proporciona novedades para <a href=\"#def_pgv\">PhpGedView</a>. Los menúes, la página de inicio, y muchar otras características están mejoradas y/o perfeccionadas.<br><br>";
$pgv_lang["menu_help"]	= "<div class=\"name_head\"><center><b>MENUES</b></center></div><br />En los encabezamientos existen menús del tipo \"descolgables\".<br />Desplazando el cursor sobre el icono del menú, de existir para el ítem, obtendrá un submenú.<br />Presionando el icono del menú será conducido a la página correspondiente al primer ítem del submenú.<br />Puede elegir de los siguientes ítems principales:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\"> Portal  MyGedView</a><br /><li><a href=\"#menu_charts\">Gráficos</a><br /><li><a href=\"#menu_lists\">Listas</a><br /><li><a href=\"#menu_annical\"> Calendario de Aniversarios</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Búsqueda</a><br /><li><a href=\"#menu_rslog\">Registro de Investigación</a><br /><li><a href=\"#menu_help\">Help</a></ul><br />";
$pgv_lang["menu_famtree_help"]	= "~Menú de la Página de Bienvenida~<br />Todos los archivos GEDCOM disponibles se listan en este menú.<br />Cada archivo GEDCOM tiene su propia página de inicio, como esta.<br />De existir sólo un archivo GEDCOM en el sitio, no aparecerán submenúes bajo el ícono de la Página de Bienvenida.<br />";
$pgv_lang["menu_myged_help"]	= "~Menú Portal Mi GedView~<br />Si ha ingresado registrándose, este menú puede incluir los siguientes ítems:<dl><dt>Portal Mi GedView</dt><dd>Lo lleva a su propia \"Página de Inicio\".</dd><dt>Mi Cuenta</dt><dd>Puede editar aquí su información personal.</dd><dt>Mis Antepasados</dt><dd>Si ha elegido una persona inicial para este GEDCOM, lo llevará al Gráfico de Antepasados, para esa persona</dd><dt>Mi Cuenta</dt><dd>Este vínculo lo llevará a su Página Individual, donde se muestra toda su información personal y la de su familia.</dd></dl>";
$pgv_lang["menu_charts_help"]	= "~Menú de Gráficos~<br />En el este menú, se listan todos los gráficos disponibles:<dl><dt>Árbol Genealógico</dt><dd>Este vínculo lo conducirá al Gráfico de Antepasados de este archivo GEDCOM. El árbol comenzará con la persona inicial del GEDCOM. Cuando ha ingresado, sin embargo, la persona inicial puede ser Ud, o alguien de su preferencia.</dd><dt>Gráfico de Descendientes</dt><dd>El Gráfico de Descendientes es en cierta forma, un Gráfico de Antepasados en orden inverso.<br />Esta comparación no es del todo correcta pero, mientras que el Gráfico de Antepasados muestra todos los antepasados de una persona inicial, el Gráfico de Descendientes mostrará todos los descendientes de una persona inicial.</dd><dt>Cronología</dt><dd>Aquí podrá ver los acontecimientos de una persona a lo largo de una línea de tiempo.</dd><dt>Parentesco</dt><dd>Aquí podrá controlar el parentesco de una persona consigo mismo o con otra persona.</dd></dl>";
$pgv_lang["menu_lists_help"]	= "~Menú Listas~<br />Están disponibles las siguientes Listas en este menú:<dl><dt>Lista de individuos</dt><dt>Lista de Familias</dt><dt>En estas dos listas podrá buscar a las personas por orden alfabético en este GEDCOM.<br />La primera producirá una lista de individuos, la segunda una lista de familias.</dd><dt>Lista de Fuentes</dt><dd>Estos ítems generan una lista de todas las fuentes citadas en el GEDCOM.</dd><dt>Jerarquía de Lugares</dt><dd>Aquí podrá ver personas por Lugar. Obtendrá una lista a dos columnas. Los individuos se listan a la izquierda, las familias a la derecha.</dd><dt>Lista MultiMedios</dt><dd>Podrá ver este ítem, sólo si está habilitado por el administrador del sitio.<br />Mostrará los vínculos a todos los archivos MultiMedio utilizados en este GEDCOM.</dd></dl>";
$pgv_lang["menu_annical_help"]	= "~Menú Calendario de Aniversarios~<br />El Calendario de Aniversarios muestra los eventos para un día, mes o año determinado.<dl><dt>Ver día</dt><dd>Presionando este menú lo llevará al Calendario de Aniversarios, mostrando los acontecimientos del día actual.</dd><dt>Ver mes</dt><dd>Lo llevará al Calendario de Aniversarios, mostrando un calendario con los eventos correspondientes al mes corriente.</dd><dt>Ver año</dt><dd>Lo llevará al Calendario de Aniversarios, mostrando un calendario con los eventos correspondientes al año corriente.</dd></dl>";
$pgv_lang["menu_clip_help"]	= "~Menú del Carrito Genealógico~<br />Si está habilitado por el administrador de este sitio GEDCOM, verá a este ítem en la barra de menús.<br />El Carrito Genealógico le permite seleccionar individuos, familias y fuentes y almacenarlos para luego poder descargarlos en formato GEDCOM 5.5.<br /><br />";
$pgv_lang["menu_search_help"]	= "~Menú de Búsqueda~<br />La Página de Búsqueda, adonde será conducido si presiona este vínculo, es una versión más poderosa del vínculo <b>Buscar</b> ubicado en el encabezamiento.<br /><br />";
$pgv_lang["menu_rslog_help"]	= "~Menú Registro de Investigación~<br />Como el Carrito Genealógico, esta opción debe ser habilitada por el administrador del sitio.<br />El Registro de Investigación le permite guardar un registro de sus actividades de búsqueda.<br />Otros usuarios podrán utilizar el mismo o diferentes registros.<br />";
$pgv_lang["menu_help_help"]	= "~Menú Ayuda~<br />#pgv_lang[help_help_items]#";
$pgv_lang["index_portal_head_help"]	= "<div class=\"name_head\"><center><b>LA PÁGINA DE BIENVENIDA</b></center></div><br />";
$pgv_lang["index_portal_help"]	= "La Página de Bienvenida consiste en varios bloques que pueden ser personalizados. De tal forma, para cada GEDCOM de este sitio (esto es, si existe más de un archivo GEDCOM) podrá ver distintas Páginas de Bienvenida.<br />Dependiendo cómo el administrador haya configurado el sitio, podrá ver los siguientes bloques en la Página de Bienvenida:</b><ul><li><a href=\"#index_welcome\">Bienvenida</a><li><a href=\"#index_login\">Ingreso</a><li><a href=\"#index_events\">Eventos por suceder</a><li><a href=\"#index_onthisday\">En este día en su Historia</a><li><a href=\"#index_favorites\">Favoritos GEDCOM</a><li><a href=\"#index_stats\">Estadísticas del GEDCOM</a><li><a href=\"#index_common_surnames\">Apellidos más comunes</a><li><a href=\"#index_media\">Imagen al azar</a><li><a href=\"#index_loggedin\">Usuarios registrados</a><li><a href=\"#gedcom_news\">Novedades del GEDCOM</a><li><a href=\"#recent_changes\">Modificaciones recientes</a></ul>";
$pgv_lang["index_welcome_help"]	= "~BLOQUE DE BIENVENIDA~<br />Este bloque de Bienvenida le mostrará:<br />El archivo GEDCOM actual, la fecha y la hora y (si está habilitado por el administrador) el <b>Contador de Aciertos</b>.<br />A este Contador de Aciertos sólo lo encontrará en el bloque de Bienvenida y en la página de detalles del individuo.<br />Este contador cuenta los \"aciertos\" de las páginas, o sea, la cantidad de veces que estas páginas son visitadas.<br />El contador no controla el URL del visitante de forma tal que cuando alguien visita la página después de algún tiempo, se incrementará el contador.<br />";
$pgv_lang["index_login_help"]	= "~BLOQUE DE INGRESO~<br />Aunque puede \"Ingresar\" prácticamente en cualquier página del programa, normalmente querrá hacerlo en la primer página, dado que sólo podrá acceder a la información restringida cuando haya ingresado.<br />Podrá hacerlo ingresando su <b>Nombre de Usuario</b> y <b>Contraseña</b> presionando luego el botón <b>Ingresar</b>.<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]	= "~BLOQUE DE ACONTECIMIENTOS POR SUCEDER~<br />Este bloque muestra los acontecimientos que ocurrirán en el próximo mes, a partir del día actual.<br />";
$pgv_lang["index_onthisday_help"]	= "~EN ESTE DÍA EN SU HISTORIA~<br />Este bloque funciona en forma similar al bloque \"Acontecimientos por Suceder\", solo que aquí se muestran los acontecimientos del día actual (en su historia) el el GEDCOM.<br />";
$pgv_lang["index_favorites_help"]	= "~BLOQUE DE FAVORITOS DEL GEDCOM~<br />De alguna forma similar a \"Mis Favoritos\" en el Portal Personal. En este caso, sólo el administrador del sitio o un usuario con privilegios de administrador, puede agregar, quitar o modificar estos Favoritos.<br />El propósito de este bloque Favoritos del GEDCOM es focalizar la atención del visitante en la persona (o personas) de especial interés.<br />\"Mis Favoritos\" está disponible en el encabezamiento de cada página del sitio en la forma de una lista \"descolgable\".<br />La selección lo llevará a la página individual de la persona.<br /><br />Para ahorrar espacio, las cajas se muestran con información limitada.<br />A la derecha de la caja verá una lupa para revelar información adicional.<br />Presionando el nombre lo llevará a la página individual de la persona.<br />También a la derecha, encontrará un menú que lo conducirá a páginas con mayor información o gráficos.<br />";
$pgv_lang["index_stats_help"]	= "~BLOQUE DE ESTADÍSTICAS GEDCOM~<br />En este bloque verá algunas estadísticas del GEDCOM actual.<br />Si desea mayor información que la desplegada, puede enviar una nota a la persona de contacto al final de la página.<br /><br />";
$pgv_lang["index_common_names_help"]	= "~APELLIDOS MÁS COMUNES~<br />En este bloque se muestra una lista de los apellidos más comunes en este GEDCOM. La cantidad de nombres mostrados es configurada por el administrador del sitio.<br />(Las opciones actuales son apellidos que aparecen en el GEDCOM más de #COMMON_NAMES_THRESHOLD# veces)<br /><br />Los nombres son presionables. Una vez presionado un nombre, será conducido a la #pgv_lang[individual_list]#, donde obtendrá detalles adicionales del nombre.<br />";
$pgv_lang["index_media_help"]	= "~BLOQUE DE IMAGEN AL AZAR~<br />Ee este bloque, PhpGedView elegirá aleatoriamente una imagen que será vista cada vez que visite esta página.<br />Presionando en la imagen, o en su nombre, obtendrá la versión a tamaño completo.<br />Bajo la imagen tendrá un vínculo a la persona relacionada con la imagen,<br />Presionando el nombre de la persona será conducido a su página individual.<br />";
$pgv_lang["index_loggedin_help"]	= "~BLOQUE DE USUARIOS REGISTRADOS~<br />Este bloque le mostrará el número de usuarios que actualmente han ingresado al sistema.<br />";
$pgv_lang["index_gedcom_news_help"]	= "~BLOQUE DE NOVEDADES GEDCOM~<br />Este bloque de novedades es como un boletín para este GEDCOM.<br />El administrador del sitio podrá publicar aquí anuncios importantes o novedades interesantes.<br />Si tiene algo interesante para publicar, contáctese con el administrador del sitio y él podrá publicar su mensaje en el boletín.";
$pgv_lang["index_gedcom_news_adm_help"]	= "El Bloque de Novedades GEDCOM permite el uso de <b>etiquetas HTML</b>.<br />Sea cuidadoso y utilice siempre las etiquetas de comienzo y fin.<br />Sería de ayuda tener un conocimiento de HTML adecuado a un administrador de sitio.<br /><br />Este programa también utiliza <b>Style Sheets (CSS)</b>. Para cada tema se aplica una 'style sheet' diferente.<br />También puede utilizar las clases definidas en estas style sheets.<br /><br />Si necesita mayor ayuda, la página WEB de PhpGedView contiene algunos ejemplos de cómo utilizar estas \"etiquetas\" en su Bloque de Novedades GEDCOM.<br />";
$pgv_lang["recent_changes_help"]			= "~BLOQUE DE MODIFICACIONES RECIENTES~<br>Este bloque indicará los cambios más recientes realizados al GEDCOM mediante la etiqueta <b>CHAN</b>.";
$pgv_lang["help_help"]	= "Por supuesto, sería perfecto hacer un programa tan simple de utilizar que no necesite de ningún tipo de explicación.<br />Sería tan simple como leer un libro.<br />Aunque el programa es bastante complicado, no lo notará en su interfase de usuario. Casi cualquier cosa puede ser utilizada sin una explicación especial.<br />Pero como existe una gran cantidad de usuarios sin experiencia en el uso de computadoras o de Internet, se ofrecerá ayuda en algunos lugares.<br />En el menú de ayuda, encontrará los siguientes ítems:<br />";
$pgv_lang["help_page_help"]	= "<dl><dt><b>Ayuda con esta página*</b></dt><dd>Para todas la páginas existe una \"Página de Ayuda\" disponible.<br />Cuando se encuentre en una página, puede presionar este ítem en el menú y obtendrá la \"Página de Ayuda\" que le informará acerca de los ítems que encontrará en esa página<br />La Página de Ayuda es breve en muchos casos.<br />Si necesita mayor ayuda o información sobre un determinado ítem en una página, existe la tercera opción del Menú de Ayuda: la <b>Ayuda Contextual</b>.</dd></dl>";
$pgv_lang["help_content_help"]	= "<dl><dt><b>Contenido de Ayuda</b></dt><dd>Presionando este ítem del menú obtendrá una ventana de ayuda desplegable, mostrando un índice de los principales ítems de ayuda.<br />Este índice tendrá mayor contenido en un futuro cercano ya que también se indexarán los ítems menores de ayuda.</dd></dl>";
$pgv_lang["help_qm_help"]	= "<dl><dt><b>ítem *Mostrar/Ocultar Ayuda Contextual*</b></dt><dd>Este último ítem del menú puede resultarle el más útil. Presionando en él, habilitará o no la \"Ayuda Contextual\".<br />Qué es la \"Ayuda Contextual\"?.<br />Cuando se encuentre habilitada, verá un signo de interrogación a la derecha de algunos vínculos, cajas \"descolgables\" o botones. Presionando este <b>?</b> hará que aparezca esta pequeña ventana de ayuda con información adicional acerca del ítem.<br />Por supuesto, al presionar \"Ocultar Ayuda Contextual\" desaparecerán todos los signos de interrogación, hasta que presione nuevamente \"Mostrar...\".</dd></dl>";
$pgv_lang["def_help"]	= "<div class=\"name_head\"><center><b>DEFINICIONES</b></center></div><br />Algunas definiciones de palabras utilizadas en este texto de ayuda:<br />";
$pgv_lang["def_portal_help"]	= "~Portal~<br />En este sitio, el Portal es como el salón de recepción de un restaurante. Es el lugar en el que se ingresa, pero en el que encontrará información importante, como explicaciones, menús, etc.<br />";
$pgv_lang["def_gedcom_help"]	= "~Archivo GEDCOM~<br />El Archivo GEDCOM es el archivo que contiene toda la información sobre la familia.<br />Todos los acontecimientos, fechas, eventos, etc. están almacenados en el archivo GEDCOM.<br />Un archivo GEDCOM debe seguir reglas estrictas, dado que es intercambiable entre muchos programas, en forma independiente de las plataformas y/o sistemas.<br />";
$pgv_lang["def_gedcom_date_help"]	= "~Fechas en el Archivo GEDCOM~<br />Dado que los formatos en los archivos GEDCOM deben seguir normas internacionales, hay un acuerdo respecto de la notación utilizada en las fechas.<br /><br />Aunque el campo de la fecha en un archivo GEDCOM es un campo libre (significando que puede ingresar cualquier texto), a continuación se explican los formatos de fecha correctos:<br />La fecha completa se ingresa en la forma \"DD MMM YYYY\", por ejemplo:<br />01 Mar 1801 o 14 Dec 1950<br />Si desconoce parte de la fecha, puede omitirla, por ejemplo:<br />Mar 1801 o 14 Dec<br />Si no está seguro, o la fecha no está confirmada, podría ingresar:<br />abt Mar 1801 (abt = alrededor de)<br />bef Dec 1950 (bef = antes de)<br />aft 1949 (aft = después de)<br />Asegúrese de ingresar las fechas y abreviaturas en Inglés, ya que los archivos GEDCOM son intercambiables y el programa traducirá correctamente todas la fechas y abreviaturas al idioma deseado.<br />El programa debe realizar también cálculos con las fechas. Si se ingresan fechas incorrectas en los campos de fecha de el archivo GEDCOM, el programa no podrá realizar los cálculos adecuadamente.<br />";
$pgv_lang["def_pgv_help"]	= "~PhpGedView~<br />PhpGedView (o PGV) es un programa diseñado por John Finlay, para ver archivos GEDCOM en línea.<br />Como podrá observar, PGV no sólo muestra páginas estáticas sino también dinámicas y puede ser personalizado en muchas formas.<br />John comenzó desarrollando un programa propio, pero en el ínterin un importante equipo internacional de programadores y traductores se han vinculado con él y trabajan juntos para mejorar el programa.<br />Además de ver los archivos GEDCOM, PGV ahora también permite agregar y editar eventos en línea.<br />";
$pgv_lang["def_theme_help"]	= "~Tema~<br />Este sitio puede tener diferentes \"aspectos\", llamados Temas.<br />El Administrador del Sitio elige un tema básico de comienzo.<br />Toda persona que acceda al sitio, lo verá con el mismo aspecto (Tema). Cuando el Administrador haya configurado el sitio de forma tal que los usuarios registrados puedan elegir su propio tema, éstos podrán optar por el que más les agrade.<br />Si el usuario ha elegido un Tema diferente al básico definido por el Administrador, lo verá tan pronto haya ingresado con su nombre/contraseña.<br />";
$pgv_lang["mygedview_portal_help"]	= "~#pgv_lang[upper_mygedview]#~<br />Esta es su Página Personal #pgv_lang[mgv]#.<br />Encontrará aquí los vínculos a su información personal, tales como <b>Mi Cuenta</b>, <b>Mi Página Personal</b>, <b>Mi Árbol Genealógico</b>.<br />Además puede tener un bloque con <b>Mensajes</b>, un <b>Boletín</b> (como un anotador) y muchos otros.<br /><br />El diseño de esta página es similar al de la Página de Bienvenida.<br />Mientras que la Página de Bienvenida es configurada por el Administrador, Ud. podrá configurar esta página a su gusto seleccionando qué partes incluir.<br /><br />Puede seleccionar los siguientes bloques:<br /><br />";
$pgv_lang["mygedview_customize_help"]	= "~PERSONALICE SU #pgv_lang[upper_mygedview]#~<br />Cuando ingrese aquí por primera vez, tendrá algunos bloques básicos en esta página.<br />Si lo desea, podrá personalizar este Portal.<br />Presionando este vínculo, se abrirá una ventana en la cual podrá agregar, quitar o mover bloques.<br />En esa ventana tendrá disponible mayor explicación.<br />";
$pgv_lang["mygedview_message_help"]	= "~BLOQUE DE MENSAJES~<br />En este bloque, encontrará los mensajes que le hayan enviado otros usuarios o el Administrador.<br />Por supuesto, también podrá enviar sus propios mensajes a otros usuarios o al Administrador.<br />El sistema de correo PhpGedView está diseñado para proteger su privacidad. No deberá dejar su dirección de correo electrónico en el sitio, por lo que otras personas no podrán verla.<br /><br />Para expandir un mensaje, presione en el tema del mensaje o en el signo \"+\" junto a él. Puede borrar múltiples mensajes, seleccionando las cajas próximas a los mensajes que desa eliminar, presionando luego el botón \"Borrar mensajes seleccinados\".<br />";
$pgv_lang["mygedview_favorites_help"]	= "~BLOQUE MIS FAVORITOS~<br />Mis Favoritos opera de forma similar a la creación de vínculos.<br />Suponga que existe una persona en su Árbol Genealógico que desea verificar regularmente.<br />Diríjase a la página individual de la persona y presione el vínculo \"Agregar a Mis Favoritos\". Esta persona será seleccionada y agregada a su lista de Favoritos.<br />Siempre que esté en el sitio, podrá presionar un nombre en la lista Mis Favoritos del encabezamiento.<br />Será conducido a la página individual de la persona.<br /><br />Para ahorrar espacio, las listas se mostrarán con información reducida. A la derecha de la caja del nombre, verá una lupa que le revelará información adicional.<br />Presionando el nombre será conducido a la página individual de la persona.<br />También, a la derecha encontrará un menú que lo conducirá a páginas o gráficos con mayor información.<br />";
$pgv_lang["mygedview_myjournal_help"]	= "~BLOQUE DE BOLETÍN~<br />Podrá utilizar este boletín para escribir notas (o recordatorios) para su propio uso.<br /> Por supuesto, cuando escriba una nota, ésta permanecerá allí la próxima oportunidad que visite el sitio.<br />Estas notas no serán visibles a otros usuarios.<br />";
$pgv_lang["mygedview_welcome_help"]	= "<dl>~BLOQUE DE BIENVENIDA~<dt>El bloque de Bienvenida le muestra:</dt><dd>- El GEDCOM actual</dd><dd>- La fecha y la hora</dd><dd>- Vínculos con:</dd><dd>- -#pgv_lang[myuserdata]#</dd><dd>- -#pgv_lang[my_pedigree]# (vea comentario)</dd><dd>- -#pgv_lang[my_indi]# (vea comentario)</dd><dd>- -#pgv_lang[customize_page]# (vea comentario)</dd></dl><b>Comentario</b><br />Verá los vínculos a \"Mi Cuenta\" y a \"Mi Árbol Genealógico\" sólo si tiene un registro en el GEDCOM actual.</br> Por tanto, puede ocurrir que en un GEDCOM tenga un registro y vea los vínculos \"Mi Cuenta\" y \"Mi Árbol Genealógico\", mientras que en otro GEDCOM no tenga un registro, entonces no se mostrarán \"Mi Cuenta\" y \"Mi Árbol Genealógico\".<br />";
$pgv_lang["help_pedigree.php"]	= "~EL GRÁFICO DE ANTEPASADOS~<br /><br />Muchos usuarios y visitantes sabrán qué es un árbol genealógico. A continuación, se brinda información adicional:<br />Un Árbol Genealógico es de hecho, una enumeración de todos los antepasados a partir de una persona inicial.<br />Cuando ingresó a este sitio, la persona definida como inicial, es la persona en la caja a la izquierda de la página (al registrarse, puede elegir la persona inicial que desee).<br /><br />Así, \"Todos los antepasados\" significa padre, madre, sus padres y así sucesivamente.<br />En este sitio se verá al árbol genealógico en una forma gráfica. No tendrá que \"luchar\" con páginas de texto para encontrar a sus antepasados. Todos los individuos se muestran en cajas de nombre en la pantalla.<br /><br />*CAJAS DE NOMBRE EN EL ÁRBOL GENEALÓGICO<br />Si las opciones para la página del Gráfico de Antepasados están prefijadas para mostrar detalles, verá los nombres de las personas junto con su fecha de nacimiento y (eventualmente) defunción.<br />Podrá presionar el nombre de la persona y será conducido directamente a la página de información personal.<br />Cuando esté activado \"Mostrar detalles\", verá dos iconos dentro de la caja de nombre.<br /><br />* ICONOS DE ÁRBOL GENEALÓGICO DENTRO DE LA CAJA DE NOMBRES<br />Si esté activada la opción \"Mostrar detalles\", verá un icono de árbol genealógico dentro de la caja de nombres. Dependiendo de las opciones del sitio, deberá \"pasar\" sobre el icono o presionarlo. Al hacerlo, aparecerá un pequeño submenú.<br />Los ítems \"Árbol Genealógico\" y \"Descendientes\" son similares a los del menú principal, con la diferencia que la persona inicial, será la que se encuentra en la caja de nombre.<br />Adicionalmente verá \"Familia con el cónyuge\" con el nombre del cónyuge seguido por el/los nombre/s de el/los hijo/s o hija/s.<br />Todos los nombres son presionables.<br /><br />* LUPA DENTRO DE LA CAJA DE NOMBRE<br />También dependiendo de las opciones del sitio, deberá \"pasar\" por encima o presionarla.<br />Así se ampliará la caja de nombre mostrando mayor información.<br />Verá más fechas y acontecimientos. Los nombres son presionables.<br /><br />* LAS FLECHAS<br />A la izquierda o derecha de la de las cajas de nombre a la extrema izquierda o derecha de la pantalla podrá ver flechas.<br />Presionándolas el gráfico se desplazará en el sentido de la flecha.<br /><br />Obtendrá información adicional presionando los <b>?</b> próximos a las cajas o vínculos de la página.";
$pgv_lang["header_help"]	= "<div class=\"name_head\"><center><b>ENCABEZAMIENTO</b></center></div><br />El encabezamiento es la parte superior de la página y se exhibe en cada página.<br />El encabezamiento contiene vínculos útiles que puede utilizar en todo el sitio.<br />Ya que este sitio puede tener diferentes aspectos seleccionando diferentes Temas #pgv_lang[redast]#, los encabezamientos de diferentes Temas pueden contener diferentes vínculos.<br />Los vínculos que podrá encontrar son:<br />";
$pgv_lang["help_descendancy.php"]	= "~LA PÁGINA DE DESCENDIENTES~<br /><br />Esta página mostrará los descendientes de una persona.<br />Puede elegir la persona inicial para este gráfico de descendencia, o puede ser conducido a esta página presionando el vínculo \"Gráfico de Descendientes\" en otra página.<br />Presione en la flecha hacia arriba para desplazarse en el árbol hacia arriba. Presione en el ícono del gráfico en la caja de la persona, para que el árbol comience con esa persona como inicial.";
$pgv_lang["header_favorites_help"]	= "~Encabezamiento: Mis Favoritos~<br />Esta lista \"descolgable\" le mostrará los Favoritos que haya seleccionado en su Portal Personal.<br />También muestra los Favoritos que el Administrador ha elegido para el GEDCOM actualmente activo.<br />Presionando en alguno de sus Favoritos, será llevado directamente a la Página de Detalles Personales de ese individuo.<br />Más ayuda acerca del agregado de Favoritos, está disponible en su Portal Personal.<br />";
$pgv_lang["header_theme_help"]		= "~Área de Encabezamiento: Cambiar Tema~<br>Cuando esté habilitado por el administrador del sitio, la lista descolgable de Cambiar Tema mostrará los temas que podrá utilizar para ver el sitio. Seleccionando un tema en la lista, modificará el tema del sitio. Estando registrado, tambien modificará la opción del tema de usuario a aquel seleccionado.<br>";
$pgv_lang["header_search_help"]	= "~Encabezamiento: Buscar~<br />Esta caja de ayuda es pequeña pero poderosa.<br />Puede hacer que PhpGedView busque prácticamente cualquier cosa. Cuando presione el botón <b>></b> o <b>Buscar</b>, será llevado a la página principal de búsqueda donde podrá ver los resultados de ella.</b> Encontrará ayuda extensiva en la página principal de búsqueda.<br />";
$pgv_lang["header_lang_select_help"]	= "~Encabezamiento: Selector de Idiomas~<br />Una de las características más importantes de este programa es que soporta múltiples idiomas y se seleccionan automáticamente cuando alguien visita el sitio según las preferencias de su navegador.<br />Si el cambio no se realiza en forma automática (probablemente por un ajuste incorrecto del \"Idioma Preferido\" en el navegador), puede cambiar el idioma usando el <b>Selector de Idiomas</b>.<br />El Selector de Idiomas puede visualizarse de dos formas distintas:<br />1. El selector clásico con una lista del tipo \"descolgable\".<br />2. Versión a todo color con las Banderas Nacionales.<br />";
$pgv_lang["header_user_links_help"]	= "~Encabezamiento: Vínculos de Usuario~<br />Vínculos de Usuario es un pequeño bloque con vínculos útiles, que el usuario puede encontrar en el mismo lugar en todas las páginas del sitio (tan pronto como el usuario no cambie el Tema)<br />Cuando no se haya registrado verá sólo el vínculo <b>Ingresar</b>.<br />Cuando se haya registrado verá: <b>Registrado como (su nombre)</b>. Presionando este vínculo será llevado a su Cuenta. <br />Presione <b>Salir</b> para abandonar el sitio.<br />Si tiene privilegios de administración, también verá <b>Administrar</b>. Presionando este vínculo, será automáticamente conducido a la Página Principal de Administración.<br />";
//-- Pages Help-messages
//-- Index-page//Maybe this one can left blank, and leave it to the user to add something in his lang.xx.extra (is it an option to omit the "?" when the string is empty?"
$pgv_lang["show_full_help"]	= "~OCULTAR O MOSTRAR DETALLES~<br /><br />Con esta opción puede ocultar o mostrar todos los detalles en la caja de nombres.<br /> Con los detalles ocultos es posible mostrar algunas cajas más en una pantalla.<br /><br />Si elige ocultar detalles, todavía podrá verlos, si la opción de la lupa está habilitada.<br />Depende cómo el administrador haya configurado el programa.<br />Si normalmente debe presionar en la lupa, podrá revelar los detalles presionando en el nombre.<br />Si normalmente hace un zoom pasando con el cursor sobre la lupa, funcionará del mismo modo cuando pase sobre la caja \"simple\".";
$pgv_lang["talloffset_help"]	= "~ORIENTACIÓN DE PANTALLA~<br /><br />Con esta opción puede determinar la orientación de la página.<br />El cambio de este ajuste puede ser de utilidad si desea realizar una impresión de pantalla, o si desea tener un ajuste diferente de la pantalla. Seleccionando <b>vertical</b> hará que el árbol sea más alto de forma tal que un gráfico de 4 generaciones entrará en una página en sentido vertical.<b> Apaisado</b>, hará que el árbol sea más ancho y debería imprimir en una página simple en modo apaisado.";
$pgv_lang["rootid_help"]	= "~NUEVA PERSONA INICIAL~<br /><br />Si desea mostrar el árbol con una nueva persona inicial, puede ingresar aquí el ID de la nueva persona.<br />Si desconoce el ID de esta persona, utilice el vínculo <b>Buscar ID</b>.<br /><br /><b>Número ID</b><br />Los números ID utilizados dentro de PhpGedView no son los números de una cédula de identidad!<br />Es sólo un número usado en el GEDCOM proporcionado por el programa de genealogía utilizado para crear el GEDCOM!";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~NÚMERO DE GENERACIONES~<br /><br />Puede definir el número de generaciones que se muestran en esta página.<br />La mejor opción dependerá del tamaño de la pantalla y si desea o no mostrar los detalles.";
$pgv_lang["login_page_help"]	= "~LA PÁGINA DE INGRESO~<br /><br />En esta página puede ingresar, solicitar una nueva Contraseña o solicitar una nueva Cuenta de Usuario.<br />";

//-- LOGIN-page
$pgv_lang["username_help"]	= "~NOMBRE DE USUARIO~<br /><br />En esta caja ingresa su Nombre de Usuario.<br />El Nombre de Usuario es sensible a mayúsculas y minúsculas.";
$pgv_lang["password_help"]	= "~CONTRASEÑA~<br /><br />En esta caja ingresa su contraseña.<br />La contraseña es sensible a mayúsculas y minúsculas.";
$pgv_lang["login_buttons_help"]	= "~BOTONES DE INGRESO~<br /><br />Aquí observa dos botones para ingresar al sistema.<br />La página a la que irá dependerá del botón elegido después de ingresar su Nombre de Usuario y la contraseña.<br /><br />>* El Botón <b>#pgv_lang[login]#</b><br /><b>Si</b> presiona este botón, regresará a la página de la que proviene.<br />De tal forma, si presionó \" #pgv_lang[login]# \" cuando estaba en la Página de Antepasados, volverá a ésta página.<br /><br />* El Botón <b> #pgv_lang[admin]# </b><br />Si tiene privilegios de administrador, puede presionar este botón para ir directamente a la página principal de Administración.";
$pgv_lang["login_buttons_aut_help"]	= "~TIPO DE VERIFICACIÓN~<br /><br />BOTONES DE INGRESO<br /><br />Aquí verá dos botones para ingresar al sistema.<br />La página a la que será direccionado dependerá del botón elegido después de ingresar su Nombre de Usuario y la Contraseña.<br /><br />* El Botón <b>#pgv_lang[login]#</b><br />SI presiona este botón, ingresará e irá directamente a su página Mi GedView, donde podrá editar sus parámetros, agregar o editar favoritos, enviar y leer mensajes, etc.<br /><br />* El Botón <b>#pgv_lang[admin]#</b><br />Si tiene privilegios de administrador, puede presionar este botón para ir directamente a la página principal de Administración.";
$pgv_lang["new_password_help"]	= "~SOLICITAR NUEVA CONTRASEÑA~<br />Si ha extraviado su contraseña, seleccione este vínculo para solicitar una nueva contraseña.<br />Será conducido a la \"Página de solicitud de Contraseña extraviada\".";
$pgv_lang["new_user_help"]	= "~SOLICITAR NUEVA CUENTA~<br /><br />Si es un visitante de este sitio que desea solicitar una Cuenta de Usuario, seleccione este vínculo.<br />Será conducido a la \"Página de Registración\".";
$pgv_lang["mygedview_login_help"]	= "Para acceder al Portal Mi GedView, debe ser un usuario registrado en el sistema.<br /><br />Con el Portal Mi GedView puede marcar sus personas favoritas, guardar un boletín del usuario, administrar mensajes, ver otros usuarios registrados y personalizar su experiencia con PhpGedView.<br /><br />Ingrese su Nombre de Usuario y Contraseña en los campos con ese nombre, para ingresar a Mi GedView.";
$pgv_lang["new_user_fullname_help"]	= "~#pgv_lang[fullname]#~<br /><br />En esta caja debe ingresar su nombre completo.<br /><br />Será también el nombre visible a otros miembros de la familia y usuarios registrados.<br /><br />Por supuesto el nombre completo es necesario para el control de la calificación para obtener una cuenta de usuario.";

//-- Descendancy-page
$pgv_lang["desc_rootid_help"]	= "~NUEVA PERSONA INICIAL~<br />Si desea visualizar un Gráfico de Descendientes con una nueva persona inicial, puede ingresar en esta caja el ID de esta nueva persona.<br />Si desconoce el ID de la persona utilice el vínculo \"Buscar ID\".";
$pgv_lang["desc_generations_help"]	= "~NÚMERO DE GENERACIONES~<br /><br />Aquí puede definir el número de generaciones a exhibir en esta página.<br />La mejor opción dependerá del tamaño de su pantalla y si se muestran o no los detalles.";
$pgv_lang["help_timeline.php"]	= "~CRONOLOGÍA~<br /><br />En esta página podrá ver una o más personas a lo largo de una línea de tiempo.<br />De esta forma podrá (por ejemplo) visualizar la situación de dos o más personas en un determinado momento.<br /><br />Si presiona el vínculo <b>Cronología</b> en otra página, verá a una persona en la línea de tiempo.<br />Si presionó el ítem en menú del encabezamiento, para comenzar deberá ingresar el \"ID\" de la persona en la caja.";

//-- other varibles can be the same as index-page//-- Time line-page
$pgv_lang["add_person_help"]	= "~AGREGAR PERSONA AL GRÁFICO~<br /><br />Puede tener varias personas en la Cronología.<br />Use esta caja para completar el ID de la persona.<br />Si desconoce el ID de la persona puede presionar el vínculo \"Buscar ID\" próximo a la caja.";
$pgv_lang["remove_person_help"]	= "~ELIMINAR PERSONA DEL GRÁFICO~<br /><br />Presione este vínculo para quitar a la persona de la Cronología.";
$pgv_lang["show_age_marker_help"]	= "~MOSTRAR GRÁFICO DE CRONOLOGÍA~<br /><br />Si selecciona esta opción verá un indicador de edades, que puede desplazar hacia arriba o hacia abajo a lo largo de la línea de tiempo. El Gráfico de Cronología es una buena herramienta para controlar la edad de una persona en un determinado acontecimiento.<br />Para cada persona en el gráfico, puede habilitar o deshabilitar el Gráfico de Cronología";
$pgv_lang["help_relationship.php"]	= "~PÁGINA DE PARENTESCO~<br /><br />En esta página podrá ver el parentesco entre dos personas.<br />No significa que las personas deban tener relación sanguínea.<br />Se encontrará cualquier parentesco.";
$pgv_lang["add_custom_facts_help"]	= "~Agregar Acontecimiento personalizado~<br />Si no halla el acontecimiento que desea agregar en la lista GEDCOM de acontecimientos, puede ingresar también un <b>Acontecimiento personalizado</b>.<br />Ingresar un Acontecimiento personalizado es tan simple como ingresar un acontecimiento predefinido.<br />La única diferencia es que deberá asignar un nombre al acontecimiento. Deberá hacerlo en el campo superior: <b>#pgv_lang[type]#</b><br />";
//-- Relationship-page
$pgv_lang["relationship_id_help"]	= "~IDs DE PERSONA 1 Y PERSONA 2~<br /><br />Si llegó a esta página direccionado por otra (por ejemplo: presionando el vínculo \"Parentesco conmigo\", verá aquí el parentesco entre estos dos individuos.<br />De otra forma, debería escribir los ID de las dos personas de las cuales desea ver su parentesco.<br />Si desconoce el ID de esta persona, utilice el vínculo \"Buscar ID\".";
$pgv_lang["line_up_generations_help"]	= "~OPCIÓN - ALINEAR GENERACIONES~<br><br>Con esta opción seleccionada, el gráfico contendrá las generaciones del mismo nivel alineadas horizontalmente en la página. Con la opción deseleccionada, cada generación aparecerá alineada en forma vertical sin importar su relación padre/hijo.";
$pgv_lang["next_path_help"]	= "~PRÓXIMA LÍNEA~<br /><br />Puede presionar este botón para ver si existe otra relación entre estas dos personas.<br />La relación previamente encontrada puede mostrarse presionando el vínculo con el número de línea.";
$pgv_lang["follow_spouse_help"]	= "~OPCIÓN CONTROLAR PARENTESCO POR MATRIMONIO~<br /><br />Con esta opción <b>de-</b>seleccionada, se controla el parentesco únicamente por relaciones sanguíneas.<br />Con esta opción seleccionada, también se controla el parentesco político por matrimonio. Encontrará más parientes dejando esta opción seleccionada.";
$pgv_lang["help_indilist.php"]	= "~PÁGINA DE INDIVIDUOS~<br /><br />En esta página podrá obtener una lista de individuos.<br /><br />Los nombres se mostrarán comenzando por el apellido y ordenados alfabéticamente.<br />El formato de la lista obtenida dependerá de:<br /><b>1.</b> La letra presionada en el índice alfabético.<br /><b>2.</b> La opción \"Mostrar\" u \"Ocultar\" la lista de apellidos.<br /><br />Si necesita ayuda adicional, presione los <b>?</b> próximos a los ítems.";

//-- Individuals-page
$pgv_lang["alpha_help"]	= "~ÍNDICE ALFABÉTICO~<br /><br />Seleccionando una letra en el alfabeto mostrará una lista con nombres, comenzando con la letra elegida.<br />El penúltimo ítem en el índice alfabético, puede ser <b>Desconocido</b>.<br /><br />Se muestra si existen personas cuyo apellido no ha sido ingresado en el registro GEDCOM o no contiene ningún carácter de los idiomas soportados.<br />También una persona desconocida.<br /><br /><b>Atención</b><br />Si en el registro GEDCOM de una persona se ingresa un apellido como p.ej.: Nn, NN, Desconocido o aún N.N., el nombre de esa persona <b>no</b> se mostrará presionando <b>Desconocido</b>. Encontrará a estas personas, presionando \"<b>N</b>\" o \"<b>D</b>\" (para los ejemplos de esta línea).<br />Ocurre así porque el programa controla si existe un ingreso de apellido en el registro de la persona en el archivo GEDCOM.<br /><br />Al final de la lista verá \"<b>TODOS</b>\". Seleccionando esta opción verá la lista de todas las personas en el archivo GEDCOM.<br /><br />CARACTERES FALTANTES?<br />Puede ocurrir que en el índice alfabético \"falten\" uno o más caracteres.<br />No faltan, simplemente significa que en la lista no existen registros con apellidos que comiencen con los caracteres faltantes.";
$pgv_lang["name_list_help"]	= "~LISTA DE NOMBRES~<br /><br />Esta caja mostrará una lista de apellidos o de nombres completos.<br />En ambos casos, los apellidos comenzarán con la letra presionada en el índice alfabético, a no ser que haya presionado \"Todos\".<br /><br />Dependiendo de la selección bajo la caja, verá una lista completa o sólo de apellidos.";

//pgv_lang["name_list_help"]	= "<b>LISTA DE NOMBRES</b><br /><br />Esta opción le mostrará alternativamente una lista de apellidos o de nombres completos.<br />En ambos casos los apellidos comenzarán con el carácter inicial seleccionado en el índice alfabético. La excepción es haber seleccionado \"todos\".<br /><br />Dependiendo del estado de la opción del vínculo debajo de la caja, verá una lista completa o sólo de apellidos.";
$pgv_lang["skip_sublist_help"]	= "~OMITIR SUBLISTA~<br /><br />La configuración standard permite obtener una sublista con los apellidos, después de haber presionado una letra del alfabeto.<br />Si presiona este vínculo, se mostrará alternativamente una lista de apellidos con o sin los nombres completos.";
$pgv_lang["add_fam_clip_help"]		= "~AGREGAR FAMILIA AL CARRITO GENEALÓGICO~<br><br>Presionando este enlace, podrá agregar la información de la familia tal como está almacenada en el GEDCOM a su Carrito Genealógico. En la próxima página podrá seleccionar específicamente qué información desea agregar: sólo sus padres, o tambien sus padres y/o sus hijos y/o todos sus descendientes.";
$pgv_lang["show_fam_timeline_help"]	= "~MOSTRAR A LA PAREJA EN EL GRÁFICO CRONOLÓGICO~<br><br>presionando este vínculo será conducido a la página de la Cronología, donde todos los acontecimientos de la pareja se mostrarán en una escala cronológica.";
$pgv_lang["show_fam_gedcom_help"]	= "~MOSTRAR REGISTRO GEDCOM~<br><br>Presionando este enlace, se mostrará en una ventana \"popup\" la información de la familia tal como está almacenada en el GEDCOM.";
$pgv_lang["help_famlist.php"]	= "~PÁGINA DE LA LISTA DE FAMILIAS~<br /><br />En esta página obtendrá una lista de familias.<br />Los nombres se mostrarán comenzando por el apellido y ordenados alfabéticamente.<br />El formato de la lista obtenida dependerá de:<br /><b>1.</b>La letra presionada en el índice alfabético.<b>2.</b>La opción \"Mostrar\" u \"Ocultar\" la lista de apellidos.<br /><br />Puede buscar por apellidos del marido o de la esposa. Ambos se incluyen en el listado.<br><br>Si necesita ayuda adicional, presione los <b>?</b> próximos a los ítems.";
$pgv_lang["help_family.php"]	= "~PÁGINA DE DETALLES FAMILIARES~<br /><br />Esta página le mostrará un resumen de la familia elegida en la página previa.<br />Desde arriba hacia abajo, verá las cajas de nombres de:<br />El esposo y sus padres.<br />La esposa y sus padres.<br />Los hijos<br /><br />La distribución y contenido de las cajas de nombres es similar al ya conocido en la página del Árbol Genealógico y l página del Gráfico de Descendientes.<br />Ala derecha de las cajas de nombres de los padres, verá una flecha (si existen más ancestros en el archivo). Si presiona en la flecha, será conducido a la Página Familiar de esa familia.<br />Bajo las cajas de nombres de el/los hijo/s o hija/s encontrará la opción \"Agregar un hijo(a) a esta familia\".<br />Próximo a las cajas de nombres de los hijos, verá la \"Información del Grupo Familiar\".<br />Si posee suficientes atribuciones, podrá editar, borrar y agregar aquí datos y acontecimientos.<br /><br />A la derecha de la pantalla verá iconos y vínculos de \"Mostrar a la pareja en la Cronología\", \"Ver registro GEDCOM\" y (si está habilitado) \"Agregar al Carrito Genealógico\".<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]	= "~AGREGAR HIJOS/AS A ESTA FAMILIA~<br /><br />Presionando este vínculo, podrá agregar hijos/as a esta familia.<br />El agregado de hijos es simple: Sólo presione el vínculo y complete la información en la ventana que aparece.<br />";
$pgv_lang["help_sourcelist.php"]	= "~LISTA DE FUENTES~<br /><br />En esta página se muestra una lista de fuentes.<br />A diferencia de las listas de Individuos y Familias, no aparece un índice alfabético. Ocurre así porque si bien las fuentes pueden ser individuos con nombre y apellido, también pueden ser bases de información de acceso público, instituciones, etc.<br />Por ello, es difícil encontrar un tipo de ordenamiento. Los nombres de las Fuentes se clasifican en orden alfabético, tal como se encuentran archivados en el GEDCOM.<br /><br /><b>FUENTES</b><br />Sin Fuentes no es posible realizar una base de datos. Toda información almacenada en una base de datos es una fuente. Puede ser relativa a una persona, bases de información de acceso público, instituciones, etc.<br />Una fuente puede estar relacionada a varias personas. En forma opuesta, una persona puede estar relacionada con varias fuentes. Pueden existir distintas fuentes para cada acontecimiento, ya sea nacimiento, profesión, matrimonio, hijos, etc.";

//-- Families-page
$pgv_lang["sourcelist_listbox_help"]	= "~LISTA DE FUENTES~<br /><br />En esta caja verá los nombres de las Fuentes tal como están archivadas en el GEDCOM.<br />Los nombres se muestran en orden alfabético.<br /><br />Cuando seleccione un nombre en la lista, irá a la página de Fuentes donde se muestra qué personas y/o familias están relacionadas con la fuente seleccionada.";
$pgv_lang["help_source.php"]	= "~PÁGINA DE DETALLES DE LA FUENTE~<br /><br />En esta página se podrán ver los detalles de la Fuente. Las Fuentes son muy importantes para los investigadores de Genealogía y le permitirán seguir los pasos que otro investigador recorrió para encontrar la información.<br />En esta página verá los detalles del título de la Fuente, el autor, la publicación y el depositario de la información. Por los variados tipos de Fuentes, algunas tendrán más información que otras.<br /><br />Si un objeto multimedio está vinculado al a Fuente (tal como un documento  escaneado) podrá ver al objeto en una ventana de mayor tamaño presionando el objeto o su nombre.<br /><br />A continuación de los detalles de la Fuente, aparecerá un listado de todos los individuos y familias vinculados a la Fuente.<br /><br />Esto le permitirá ver toda la información obtenida de una Fuente en particular.<br /><br />Si está habilitado por el Administrador, habrá uno o dos íconos de menú más en la página:<br /><b>Ver registro GEDCOM</b>, que mostrará la información en formato GEDCOM.<br /><b>Agregar al Carrito Genealógico<b>, que le permitirá almacenar esta información en su carrito. Desde aquí la podrá descargar e importarla en su propio programa de genealogía.<br /><br />Mayor ayuda disponible presionando los <b>?</b>";

//-- same variable as individuals page//-- Sources-page
$pgv_lang["sources_listbox_help"]	= "~REGISTROS RELACIONADOS A ESTA FUENTE~<br /><br />En esta caja verá los nombres de los individuos y las familias relacionadas a la fuente.<br />Los nombres se muestran en orden alfabético.<br /><br />Cuando seleccione un nombre en la lista, irá a la página de detalles del individuo o la familia.";
$pgv_lang["show_source_gedcom_help"]	= "~MOSTRAR REGISTRO GEDCOM~<br /><br />Seleccionando este vínculo, se mostrará la información de la fuente en una ventana desplegable, tal como está archivada en el GEDCOM.";
$pgv_lang["add_source_clip_help"]	= "~AGREGAR FUENTE AL CARRITO GENEALÓGICO~<br /><br />Seleccionando esta opción, podrá agregar la fuente al carrito, tal como está archivada en el GEDCOM.";
$pgv_lang["delete_source_help"]	= "~ELIMINAR FUENTE DEL GEDCOM~<br /><br />Seleccionando esta opción indicará que esta fuente debe ser eliminada del GEDCOM.<br />Qué significa?<br />Supongamos que se tiene un buen motivo para eliminar esta fuente del GEDCOM. Seleccione la opción y obtendrá una ventana desplegable preguntando si está seguro o desea cancelar esta acción.<br /><br />Si acepta podrá demorar unos instantes desplegar una ventana confirmando la eliminación de la fuente.<br /><br />Cuando continúe su visita, notará que la fuente todavía es visible, como antes.<br /><br /> Esto <b>no</b> es un error.<br />El administrador tendrá un mensaje que se ha realizado un cambio al GEDCOM y que Ud. ha removido la fuente.<br />El administrador puede aceptar o rechazar el cambio. Sólo entonces el proceso no podrá ser revertido.<br />En caso de duda, el administrador lo contactará.";
$pgv_lang["help_placelist.php"]	= "~JERARQUÍA DE LUGARES~<br />(o Personas por Lugar)<br /><br />En esta pantalla podrá ver qué personas o familias están relacionadas con un Lugar.<br /><br />Si existe alguna conexión entre un individuo o familia y un acontecimiento en un determinado lugar, el programa lo encontrará.<br /><br />Los resultados se muestran en una lista a doble columna:<br />Una para los individuos y otra para las familias.<br /><br />#pgv_lang[more_help]#";

//-- Persons per Place-page
$pgv_lang["ppp_default_form_help"]	= "~ORDEN DE LOS LUGARES~<br /><br /><b>ORDEN POR OMISIÓN</b><br />Los lugares se encuentran en el orden por omisión.<br />Significa que no se ha encontrado un orden especificado en este archivo GEDCOM.<br />Así, el orden por omisión es el seleccionado para el sitio.<br /><br />Si existe definido otro orden en este GEDCOM, se mostrará entre los (...) al final de la línea.";
$pgv_lang["ppp_match_one_help"]	= "~ORDEN DE LOS LUGARES~<br /><br />ORDEN GEDCOM<br />Los lugares se hallan en el orden encontrado en el archivo GEDCOM.<br />Tiene precedencia sobre el orden por omisión, que se utiliza cuando no se encuentra nada específico en el GEDCOM.";
$pgv_lang["ppp_numfound_help"]	= "~RELACIONES DE LUGAR HALLADAS~<br /><br />Se indica el número de coincidencias encontradas al momento.<br />Si todavía puede ver una lista con Lugares, significa que aún no ha alcanzado el nivel inferior.<br />Puede seleccionar un nombre de la <b>Lista de Nombres</b> o perfeccionar la búsqueda, seleccionando otra ubicación en la <b>Lista de Lugares</b> arriba de la Lista de Nombres.";
$pgv_lang["ppp_levels_help"]	= "~NIVELES DE UBICACIÓN~<br /><br />Indica los niveles mostrados.<br />La lista que muestra los lugares, es de hecho una sublista del nivel superior izquierdo.<br /><br />EJEMPLO:<br />El orden (por omisión) es: #pgv_lang[default_form]#<br />Si el nivel actual es \"Nivel principal\" se mostrarán todos los países en el GEDCOM.<br />Si el nivel actual indica \"Argentina, Nivel principal\", entonces la caja mostrará todas los lugares en Argentina, etc.<br /><br />Puede seleccionar un nivel y retroceder uno o más pasos.";
$pgv_lang["ppp_placelist_help"]	= "~LISTA DE LUGARES~<br /><br />En esta lista podrán verse los Lugares encontrados al momento.<br />Los nombres de los Lugares en la lista son presionables.<br />La selección de lugares funciona como un filtro. Lo llevará al próximo nivel inferior.<br />Sólo cuando se encuentre en el nivel superior, no se mostrará la lista de nombres. En todos los otros niveles inferiores, obtendrá una lista de personas y/o familias encontradas en ese Lugar.";
$pgv_lang["ppp_view_records_help"]		= "~VER TODOS LOS REGISTROS~<br><br>Presionando este vínculo, se mostrará una lista conteniendo a todos los individuos y familias con acontecimientos ocurridos en este lugar. Cuando llegue al final de una jerarquía de lugares, tal como Pueblo o Ciudad, se mostrará automáticamente la lista.";
$pgv_lang["ppp_name_list_help"]	= "~LISTA DE NOMBRES~<br /><br />Esta opción proporcionará una lista completa de individuos y/o familias relacionadas (de alguna forma) con la ubicación.<br /><br />Los nombres en las listas son presionables.<br />Cuando presione un nombre, verá la página de detalles del individuo o familia.<br /><br />Puede también cambiar su selección presionando otra ubicación al tope de esta lista.";
$pgv_lang["help_medialist.php"]	= "~LISTADO DE OBJETOS MULTIMEDIO~<br /><br />Esta página lista todos los objetos MultiMedio (OMM) que se encuentran en este GEDCOM.<br /><br />Para cada ítem encontrará el título o el nombre del archivo, nombres de la persona o familia con que está relacionada el objetoy todas las notas acerca del ítem.<br /><br />Presionando el nombre del archivo del ítem tiene el mismo efecto que presionar sobre su miniatura.<br />Dependiendo del formato del archivo (*.gif, *.jpg) el ítem se abirá en el visualizador interno o en el visualizador vinculado a su navegador.<br /><br />Presionando el vínculo \"Ver\" próximo a las personas o familias será conducido a su página Individual o a la página de detalles de la familia.<br /><br />";
$pgv_lang["help_uploadmedia.php"]	= "~CARGAR ARCHIVOS DE MEDIOS~<br /><br />La carga de archivos de Medios es simple; aquí encontrará información adicional.<br /><br /><b>Miniaturas</b><br />Las miniaturas deberán tener un tamaño de alrededor de 100 pixels de ancho.<br />El nombre del archivo debe ser el mismo que el original.<br /><br /><b>Cargando</b><br />Los archivos se cargarán automáticamente en el directorio ./media para las copias de tamaño normal y en ./media/thumbs para las miniaturas.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["help_calendar.php"]	= "~CALENDARIO DE ANIVERSARIOS~<br /><br />La función de este Calendario de Aniversarios es mostrar a las personas y familias relacionadas con un evento en un determinado día (\"Modo Día\"), en un determinado mes (\"Modo Mes\") o en un determinado año (\"Modo Año\").<br /><br />El Calendario de Aniversarios a exhibir, posee algunas poderosas funciones adicionales. Tiene un sistema de filtro avanzado para seleccionar los acontecimientos adecuados.<br /><br />En el <b>Modo Día</b> o en el <b>Modo Año</b> desplegará un listado simple con los nombres de los individuos o familias, o bien un listado a dos columnas con los Individuos en una columna y las Familias en la otra.<br /><br />En el <b>Modo Mes</b> se muestra como un <b>Calendario</b> con los nombres de los Individuos como así también los nombres de las Familias dentro de las cajas.<br /><br />El calendario se muestra tal como era en el año ingresado en la caja \"Año\". Se mostrarán todos los eventos ocurridos hasta ese año.<br>En combinación con la opción \"Años recientes\" le proporcionará una visión realista de cómo se veía el calendario de sus antepasados.<br /><br />Al tope de la página, existe una tabla con vínculos presionables y una caja para ingresar el año para seleccionar el día, mes, año y los acontecimientos a desplegar. <br />Las opciones de día/mes actuales y la opción de mostrar Acontecimientos se verán en un color destacado.<br /><br />Al final de las líneas: Día y Mes, verá dos <b>\"vínculos rápidos\"</b>.<br />Estos vínculos rápidos le permitirán desplegar la lista para el día o el calendario para el mes actual.<br /><br />Los nombres que aparecen en la lista o en el calendario, son presionables. <br />Presionando en un nombre lo conducirá a la página de detalles de la persona o familia, presionando en una fecha será conducido a el modo \"Día\", que mostrará los eventos para el día y el mes correspondientes a la fecha presionada.<br /><br />#pgv_lang[more_help]#";

//-- Mulitmedia-page

//-- I did not work multimedia yet, so at this moment I cannot add something here ;-) (Jans)//-- Anniversaries-page
$pgv_lang["annivers_date_select_help"]	= "~SELECTOR DE FECHAS~<br /><br />La línea superior de la \"Tabla de Selección\" es el <b>Selector de Días</b>.<br />Su significado es obvio: permite seleccionar un día.<br />El resultado de presionar un determinado día depende de si se está en el modo \"Ver día\" o en el modo \"Ver mes\".<br /><br />El modo <b>Ver día</b>:<br />En este modo, al haber presionado un día, la pantalla se redibujará y se visualizará la lista con el día seleccionado.<br /><br />El modo <b>Ver mes</b>:<br />Cuando en la pantalla se halla un determinado mes y se presiona u día determinado en la línea \"Día\", la pantalla se redibujará, pero aún verá mes que tenía en la pantalla previamente.<br />El motivo es que todavía podría cambiar el mes, año o acontecimiento a mostrar, antes de presionar los botones <b>#pgv_lang[viewday]#</b> o <b>#pgv_lang[viewmonth]#</b>.<br /><br />Al final de la línea Día, verá un <b>vínculo rápido</b> con la fecha del día de hoy.<br />Presionando ese \"vínculo rápido\" mostrará la lista del día de hoy, en el modo \"Ver día\", sin importar si está en el modo \"Ver mes\" o en el \"Ver día\".<br />";
$pgv_lang["annivers_month_select_help"]	= "~SELECTOR DE MESES~<br /><br />La fila central de la \"Tabla de Selección\" es el <b>Selector de Meses</b>.<br /><br />Tal como en el \"Selector de Días\" su significado es obvio: Selecciona un mes.<br /><br />También como en el Selector de Días el resultado obtenido dependerá de si se presiona en el modo \"Ver día\" o en el modo \"Ver mes\".<br /><br />El modo <b>Ver día</b>: <br />En este modo, al haber presionado en un mes, la pantalla se redibujará y se mostrará una lista con las fechas para el nuevo mes seleccionado. <br />Todas las otras opciones, tales como día, año y acontecimientos permanecen sin modificación.<br /><br />El modo <b>Ver mes</b>: <br />Cuando tenga un calendario en la pantalla y presione un mes en la línea \"Mes\" de la \"Tabla de Selección\", se mostrará un nuevo mes.<br /><br />Al final de la línea Mes, verá un <b>vínculo rápido</b> con el mes actual.<br />Presionando ese \"vínculo rápido\" mostrará el calendario de este mes, sin importar que se encuentre en el modo \"Ver Mes\" o en el modo \"Ver día\".<br />";
$pgv_lang["annivers_year_select_help"]	= "~INGRESO DEL AÑO~<br /><br />Esta caja se utiliza para el cambio del año del calendario en el modo \"Ver mes\" o la lista en el modo \"Ver Año\".<br>En el modo \"Ver Día\" el cambio del año no producirá diferencia ya que se muestran los eventos para cualquier año.<dl><dt><b>Opciones avanzadas</b> para <b>#pgv_lang[viewyear]#:<br>:Más de un año</b></dt><dd>Puede buscar para más de un año ingresando en el campo Año:<br>- Ej. 1: <b>1992-5</b> para todos los eventos desde 1992 hasta 1995.<br>- Ej. 2: <b>1972-89</b> para todos los eventos desde 1972 hasta 1989.<br>- Ej. 3: <b>1610-759</b> para todos los eventos desde 1610 hasta 1759.<br>- Ej. 4: <b>1880-1905</b> para todos los eventos desde 1880 hasta 1905.<br>- Ej. 5: <b>880-1105</b> para todos los eventos desde 880 hasta 1105.<br><br>Tambien puede omitir el último dígito del año para obtener todos los eventos en una fecha en una determinada década.<br>- Ej.: <b>197</b> para todos los eventos desde 1970 hasta 1979.</dd><dt><br><b>Abreviaturas</b></dt><dd>En algunas oportunidades no está bien definida la fecha exacta de ocurrencia de un evento. En tal caso los términos \"after\" (después), \"before\" (antes) y \"about\" (alrededor de) pueden agregarse a una fecha. Las fechas se almacenan en el GEDCOM junto con la abreviatura del término. En el modo \"Ver Año\" se pueden realizar búsquedas en los términos con o sin la fecha. Algunos ejemplos de estas búsquedas son: <br><b>abt</b> 1800 (abt = about)<br><b>bet</b> 1950-1959 (bet = between) ingrese: bet 1950 o sólo: 1950-59<br><b>bef</b> 1950 (bef = before)<br><b>aft</b> 1900 (aft = after)<br><br><b>Nota: </b>PhpGedView realizará un búsqueda exacta de la frase ingresada. Cuando busque \"abt 1850\", una fecha tal como \"abt oct 1850\" almacenada en el GEDCOM <b>no</b> se incluirá en los resultados de la búsqueda. - Puede ingresar la abreviatura sin el año, para obtener todos los eventos que contienen esa abreviatura.</dd></dl>Ingresando otro año no refrescará directamente la pantalla.<br>Dado que esta caja de ingreso no es un vínculo, deberá presionar los botones <b>#pgv_lang[viewmonth]#</b> o <b>#pgv_lang[viewyear]#</b> para ver la nueva situación.<br>";
$pgv_lang["annivers_show_help"]	= "~MOSTRAR ACONTECIMIENTOS DE...~<br /><br />Cuando aún no se ha ingresado como usuario, puede elegir entre dos opciones:<br /><br /><b>1. Todas las personas</b><br />Con esta opción, se muestran todas las personas y familias.<br /><br /><b>2. Años recientes (<100 años)</b><br />Con esta opción, verá todos los eventos en el día/mes elegido, pero no se listarán los eventos de más de 100 años de antigüedad.<br /><br />También hay una tercera opción. Para ella deberá haberse registrado, o el administrador debe haber permitido que las personas vivas sean visibles a todos los visitantes.<br /><br /><b>3. Personas vivas</b><br />Con esta opción seleccionada, sólo se mostrarán las personas vivas.<br />Las opciones de día, mes año y el modo \"Ver día\" o \"Ver mes\", permanecen sin cambios.<br />";
$pgv_lang["annivers_tip_help"]	= "~CONSEJO~<br />Suponga que tiene un pariente que nació el 25 de Enero de 1875. <br />Ajuste el selector de fechas a ese día. <br />Cuando presione alguno de los botones \"Ver...\", verá una lista o un calendario para esa fecha. <br />Todas las edades, aniversarios, etc. se recalculan en función de la fecha ingresada en el selector. <br />De hecho estará viendo, en la lista o en el calendario, lo mismo que su pariente muchos años atrás.<br />";
$pgv_lang["day_month_help"]	= "~BOTONES VER DÍA / VER MES / VER AÑO~<br /><br />El botón <b>Ver día</b>, exhibirá los eventos correspondientes a la fecha elegida en la lista. Todos los años son rastreados de tal forma que sólo se podrán ingresar el día y el mes; el cambio del año no tendrá efecto.<br />Puede limitar la lista seleccionando \"Años Recientes\" o, si está disponible, \"Personas Vivas\".<br />Las edades en el listado se calculan a partir del año actual.<br /><br />El botón <b>Ver mes</b> mostrará un calendario del mes y año seleccionado. Aquí tambien puede acotar el listado prsionando \"Personas Vivas\" o \"Años Recientes\".<br />Seleccionando un año en el pasado, en combinación con \"Años Recientes\" obtendrá una impresión real de como se veía en la pared el calendario de sus antecesores. Todas las edades en el calendario son relativas al año ingresado.<br /><br />El botón <b>Ver año</b> mostrará un listado de los eventos correspondientes al año seleccionado.<br />Nuevamente, podrá limitar la lista seleccionando \"Años Recientes\" o, si está disponible, \"Personas Vivas\".<br />Una característica atractiva es la posibilidad de exhibir eventos para más de un año: Sólo ingrese el último número del año en el segundo año a la derecha del primero, separado por un \"-\" (p.ej. 1992-4 para todos los eventos desde 1992 hasta 1994, o 1976-1984 para todos los eventos desde 1976 hasta 1984.<br />- Tambien podrá ingresar sólo los primeros dígitos del año y exhibir todos los eventos que comienzan con esos números (p.ej. 197 para todos los eventos desde 1970 hasta 1979)<br /><br />Cuando desee <b>cambiar el año<b> note que <b>deberá<b> presionar uno de estos tres botones.<br /><br />Todas las otras opciones permanecerán sin cambios cuando presione alguno de estos tres botones.<br />";
$pgv_lang["help_clippings.php"]	= "~El Carrito Genealógico~<br />Le permite generar \"recortes\" del árbol de esta familia y reunirlos en un archivo GEDCOM único para grabar.<br /><br />*Cómo crear los recortes? <br />Es realmente simple. Siempre que vea el vínculo presionable de un nombre (individuo, familia o fuente) puede dirigirse a la página de detalles de ese nombre. Desde aquí verá la opción \"Añadir al Carrito Genealógico\".<br /><br />* Cómo grabar el archivo? <br />Una vez que haya agregado ítems al carrito, podrá grabarlo simplemente presionando el vínculo \"Grabar ahora\".<br />Entonces siga las instrucciones y los vínculos.";

//-- Clipping Cart-page
$pgv_lang["clip_download_help"]	= "~GRABAR los RECORTES~<br /><br />Seleccionando este vínculo, será direccionado a la página siguiente.<br />Todas las opciones de grabación, se visualizarán en esta página.<br />Simplemente siga las instrucciones.";
$pgv_lang["empty_cart_help"]	= "~VACIAR EL CARRITO GENEALÓGICO~<br />Seleccionando este vínculo, se vaciará completamente su carrito.<br /><br />Si no desea eliminar a todas las personas, familias, etc. del carrito, puede removerlas individualmente presionando el vínculo \"Eliminar\" en las cajas de nombre.";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]	= "~MOSTRAR LOS CAMBIOS DEL GEDCOM~<br /><br />Cuando aparezca este mensaje, puede significar dos cosas:<br /><br />1. Alguien realizó cambios en el GEDCOM.<br />Se han agregado, borrado o cambiado registros.<br /><br />2. Las modificaciones aún no han sido aceptadas por el Administrador.<br />Una vez que las modificaciones se han aceptado (o rechazado), no verá el mensaje nuevamente.<br /><br />Presionando el vínculo puede controlar las modificaciones realizadas.<br />Si observa una modificación que no sea correcta, notifique al Administrador.";
$pgv_lang["help_search.php"]	= "~La PÁGINA DE BÚSQUEDA~<br /><br />Aunque esta página se ve muy simple, detrás de ella se oculta una poderosa máquina de búsqueda.<br /><br />La mayoría de los sitios de genealogía, sólo permiten realizar búsquedas por nombre y apellido.<br />En este sitio se pueden realizar búsquedas prácticamente por cualquier concepto.<br /><br />La caja de búsqueda a la izquierda de la pantalla, es la misma que la que se encuentra en el encabezamiento.<br /><br />Si busca personas en relación a un determinado año, solamente ingrese el año. El programa encontrará todas las relaciones.<br /><br />Buscando un nombre o un lugar?<br />Sólo ingréselo en forma total o parcial y el programa hará el resto.<br /><br /><b>Método de búsqueda SOUNDEX</b>.<br />Con la caja de búsqueda a la derecha, puede realizar búsquedas por nombres, aún si no sabe cómo escribirlos.<br /><br />Encontrará más ayuda acerca de estas dos cajas, presionando los <b>?</b> junto a ellas.";

//-- Search-page
$pgv_lang["search_enter_terms_help"]	= "~INGRESAR TÉRMINOS DE BÚSQUEDA~<br /><br />En esta caja de búsqueda puede ingresar criterios tales como fechas, nombre, apellido, lugares, multimedio, etc.<br /><br /><b>Comodines</b><br />Los comodines que probablemente conozca (tales como <b>*</b> ó <b>?</b>), no están permitidos, pero el programa los asume automáticamente.<br />Qué significa?<br />Suponga que escribe \"<b>Pete</b>\" en la caja de búsqueda. <br />El resultado será (suponiendo que los nombres existen en la base):<br /><b>Pete</b> Smith<br /><b>Pete</b>r Jones<br />Will <b>Pete</b>rson<br />desconocido -- Nacido 01 enero 1901 en <b>Pete</b>rsburg<br />etc., etc.<br /><br /><b>Fechas</b><br />Ingresando un año en la caja de búsqueda, se mostrarán los nombres de todas las personas que de alguna forma están relacionadas con ese año.<br />Si ingresa 1950, el resultado será las personas nacidas en 1950, o fallecidas, o casadas, o ... cualquier otro evento relacionado con el año 1950.<br /><br />Si ingresa \"4 Dec\", se listarán todas las personas relacionadas con algún evento el 4 de diciembre de cualquier año. Pero también las personas relacionadas con un evento el 14 o el 24 de diciembre.<br />Como se observa, también aquí se asumen los comodines, de manera tal que no es necesario ingresarlos.<br /><br /><b>Fechas correctas</b><br />El programa busca la información tal como está almacenada en el archivo GEDCOM.<br />De tal forma, si desea buscar un evento el 14 de diciembre, debería ingresar:<br /><b>14 dec</b> (los nombres de los meses deben estar en inglés, 3 letras)<br />porque esta es la forma en que la fecha está almacenada en el archivo GEDCOM.<br />Sin embargo, de haber ingresado \"dec 14\", el resultado será una persona relacionada con un evento el p.ej. 08 <b>dec</b>ember 18<b>14</b>. Tambien puede utilizar expresiones regulares en las búsquedas, si está familiarizadas con ellas. Por ejemplo, si desea buscar a todas la personas con fechas en el siglo 20, podría ingresar la búsqueda 19[0-9][0-9] y obtendrá a todas las personas con fechas entre 1900 - 1999.<br /><br />De necesitar más ayuda con el sistema de búsqueda, háganoslo saber, de forma tal de mejorar este archivo de ayuda.";
$pgv_lang["soundex_search_help"]	= "~BÚSQUEDA SOUNDEX POR NOMBRE~<br /><br />La búsqueda Soundex es también bastante poderosa.<br /><br />Primero una pequeña explicación de Soundex:<br />Soundex al clasificar, reúne apellidos que \"suenan\" similar pero se escriben distinto. Un código Soundex comienza con la primer letra del apellido seguida por un código de tres dígitos que representa las primeras tres consonantes restantes. Se le agregarán ceros a los nombres que no tienen suficientes letras para ser codificados.<br /><br />En inglés esto significa:<br />Si está buscando \"Smith\" puede obtener como resultado:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead, Sneed, Smoote etc.<br /><br />No tiene que preocuparse por los códigos Soundex.<br />Sólo ingrese el nombre que está buscando y el programa hará el resto.<br /><br />El método Soundex es muy útil: a veces se conoce un nombre pero se desconoce su escritura exacta.<br />También puede ocurrir que se cometan errores al ingresar nombres a la base de datos. Usando el método Soundex todavía le será posible encontrar el nombre.<br /><br />Para familiarizarse con él, trate de encontrar un nombre (conocido) pero escrito en forma diferente.<br /><br />En la búsqueda Soundex, un apellido es suficiente para iniciar la búsqueda.<br />Si desea buscar por el primer nombre, también debe ingresar el apellido.";
$pgv_lang["help_individual.php"]	= "~PÁGINA DE DETALLES DEL INDIVIDUO~<br /><br />En esta página se encuentran todos los detalles de la persona.<br /><br />Si existe disponible una imagen, aparecerá arriba y a la izquierda.<br />Junto a la imagen (si está disponible), verá los detalles de la persona.<br />Bajo los detalles del nombre verá la(s) fuente(s) y la(s) nota(s).<br />Una persona puede tener un apodo (tal vez se lo conozca por otro nombre o alias). Si es el caso, también se mostrará.<br /><br />Si posee los privilegios de edición en esta persona, verá vínculos para editar y borrar junto a los ítems que puede editar.<br><br>En esta página verá tabuladores para \"Eventos y Detalles Personales\", \"Notas\", \"Fuentes\", \"Multimedios\", \"Familiares Cercanos\" y (si se encuentra habilitado) \"Registro de Investigación\".<br><br>En estos tabuladores encontrará la información almacenada en el GEDCOM.<br><br>El tabulador de \"Detalles Personales\" le mostrará los eventos y detalles de esta persona y cualquier evento relacionado con su(s) matrimonio(s). Presionando una fecha en este tabulador le conducirá al Calendario de Aniversarios para esa fecha, de forma tal que podrá ver otros eventos almacenados en el GEDCOM que ocurrieron el mismo día. Presionando en un Lugar le conducirá a la Jerarquía de Lugares donde podrá ver otras personas que tuvieron acontecimientos en el mismo lugar. Para matrimonios y otros eventos familiares, está disponible el nombre del(la) esposo(a) de tal forma que podrá ver a el(la) esposo(a) y tambien un vínculo a su registro familiar.<br><br>El tabulador \"Notas\" le mostrará notas generales relativas a la persona.<br><br>El tabulador \"Fuentes\" le mostrará fuentes generales para esta persona. Presionando en el título de una fuente le conducirá a una página con mayores detalles de las fuentes que mostrará tambien otras personas relacionadas con la misma fuente.<br><br>El tabulador \"MultiMedio\" listará todas las imagenes y otros medios relacionados con lel individuo. Presionando en la miniatura de una imagen abrirá una vista de mayor tamaño de la imagen.<br><br>El tabulador de \"Familiares Cercanos\" lista los padres y hermanos(as), así como tambien todos(as) los(as) esposos(as) e hijos(as) que la persona haya tenido. Las personas se listarán en cajas similares a las que ya haya visto.<br><br>A la derecha de la pantalla, verá una caja con vínculos.<br />Muchos de los vínculos en la caja, son los mismos que los menúes. Por ejemplo, presionando el vínculo \"Árbol Genealógico\" lateral le llevará  al Árbol Genealógico de la persona. Es diferente de los vínculos en los menúes ya que presionando el vínculo \"Árbol Genealógico\" le llevará al Árbol Genealógico por omisión definido para el GEDCOM.<br><br>En los vínculos que pueden aparecer en esta lista si ha sido habilitado por el Administrador, está el \"Ver Registro GEDCOM\". Este vínculo le mostrará el registro GEDCOM \"en bruto\" del individuo.<br><br>Si el Administrador ha habilitado el \"Carrito Genealógico\", tambien tendrá un vínculo que le permitirá agregar a esta persona a su carrito.<br><br>El vínculo \"Parentesco conmigo\" aparecerá sólo si se ha registrado (e ingresado) al sistema y tiene un ID asignado en el GEDCOM. Este vínculo le llevará al Árbol Genealógico y le mostrará como está relacionado con esta persona.<br><br>Obtendrá información adicional en la página, presionando los <b>?</b> junto a los vínculos o ítems.";
$pgv_lang["delete_person_help"]	= "~BORRAR INDIVIDUO DEL GEDCOM~<br /><br />Presionando esta opción, señalará a este INDIVIDUO para ser borrado del GEDCOM.<br /><br />Qué significa?<br />Suponga que tiene un buen motivo para borrar a esta persona del GEDCOM. Presione el vínculo y luego aparece una ventana desplegable, preguntando si está seguro o desea cancelar la acción.<br /><br />Si continúa, luego de unos instantes aparecerá otra ventana desplegable indicando que la persona ha sido borrada.<br /><br />Cuando continúe su visita, notará que la persona todavía es visible y puede ser \"utilizada\" como antes.<br /><br />Esto <b>no</b> es un error.<br />El Administrador del sitio recibirá un mensaje indicando que se han realizado cambios en el GEDCOM y que Ud. ha borrado a la persona en cuestión.<br />El Administrador podrá aceptar (o rechazar) su modificación. Sólo entonces, el proceso es irreversible.<br />En caso de dudas, el Administrador se pondrá en contacto con Ud.";
$pgv_lang["delete_name_help"]	= "~EDITAR O BORRAR NOMBRE DEL GEDCOM~<br /><br /><b>EDITAR NOMBRE</b><br />Presionando este vínculo, abrirá una ventana desplegable en la cual podrá editar el nombre de la persona.<br />Es muy simple; ingrese las modificaciones en las cajas y presione el botón, cierre la ventana desplegable y es todo.<br /><br /><b>BORRAR NOMBRE</b><br />Presionando este vínculo, marcará a este nombre a ser borrado del GEDCOM.<br />Tenga presente que borrar el nombre es completamente diferente a borrar el individuo.<br />Borrando el nombre, sólo elimina al nombre de la persona. La persona no será borrada.<br />Si desea borrar el alias, la persona todavía tiene sus otros nombres. Si está borrando un único nombre, la persona no será borrada y continuará como \"Desconocido\".<br />La persona seguirá manteniendo las relaciones con sus parientes, fuentes, notas, etc.<br /><br />Cómo funciona?<br />Supongase que se tiene un buen motivo para eliminar a este nombre del GEDCOM. Presiona el vínculo y obtendrá una ventana desplegable preguntando si está seguro o desea cancelar esta acción.<br /><br />Si continúa borrando el nombre, luego de unos instantes se desplegará una ventana confirmando la eliminación del nombre.<br /><br />Cuando continúe su visita, notará que el nombre todavía es visible y puede ser \"utilizado\" como antes.<br /><br />Esto <b>no</b> es un error.<br />El Administrador del sitio recibirá un mensaje indicando que se han realizado cambios en el GEDCOM y que Ud. ha borrado al nombre de la persona en cuestión.<br />El Administrador podrá aceptar (o rechazar) su modificación. Sólo entonces, el proceso es irreversible.<br />En caso de dudas, el Administrador se pondrá en contacto con Ud.";
$pgv_lang["add_sibling_help"]	= "~AGREGAR HERMANO O HERMANA~<br /><br />Presionando este vínculo, puede agregar un hijo a esta familia.<br />En este caso,\"Esta familia\" serán el padre y la madre de la principal persona de esta ventana.<br />Tenga presente que estará agregando un hermano o hermana a esta familia.<br />El agregado de un hermano o hermana es simple: Sólo presione el vínculo y complete las cajas en la ventana; es todo.<br /><br />Si tiene que agregar un hijo o una hija de la persona principal, desplácese un poco hacia abajo y presione el vínculo en \"Familia con el Cónyuge\".";
$pgv_lang["add_son_daughter_help"]	= "~AGREGAR HIJO O HIJA~<br /><br />Presionando este vínculo, puede agregar un(a) hijo(a) a esta familia.<br />\"Esta familia\", en este caso, serán el padre y la madre de la principal persona de esta ventana y su cónyuge.<br />Tenga presente que estará agregando un hijo o una hija a esta familia.<br />El agregado de un hijo o una hija es simple: Sólo presione el vínculo y complete las cajas en la ventana; es todo.<br /><br />Si tiene que agregar un hermano o hermana de la persona principal, desplácese un poco hacia arriba y presione el vínculo \"Familia con los Padres\".";
$pgv_lang["link_child_help"]	= "~RELACIONE A ESTA PERSONA COMO HIJO(A) DE UNA FAMILIA EXISTENTE~<br /><br />Presionando este vínculo, puede relacionar a esta persona como hijo(a) de una familia existente.<br /><br />Suponga que los padres de una persona eran desconocidos, y descubrió que ellos (los padres) tienen un registro en este GEDCOM.<br /><br />Sólo presione el vínculo, ingrese el ID de la familia (si desconoce el ID, puede buscarlo en la ventana desplegable) y habrá realizado la tarea.";
$pgv_lang["link_husband_help"]	= "~RELACIONAR ESTA PERSONA COMO ESPOSO A UNA FAMILIA EXISTENTE~<br /><br />Esta opción le permitirá vincular al individuo actual como esposo de una familia ya existente en el GEDCOM. Presionando este vínculo, podrá agregar a esta persona a una familia existente, cuyo esposo es desconocido hasta el momento. La persona tomará la ubicación de la persona desconocida. Todos los eventos, información de matrimonio e hijos, mntendrán sus actuales relaciones con la familia.<br><br>Sólo presione el vínculo, ingrese el ID de la familia (si no lo conoce, puede buscarlo en la ventana \"pop-up\") y habrá completado la tarea. Esta es una opción de edición avanzada, que sólo debe ser utilizada si la familia que desea vincular ya existe. Si sólo desea agregar una nueva famila, utilice la opción <b>agregar una nueva esposa</b>.";
$pgv_lang["add_husband_help"]	= "~AGREGAR UN NUEVO ESPOSO~<br /><br />Presionando este vínculo, puede agregar una nueva persona (masculino) y relacionarla a la persona principal como un nuevo esposo.<br /><br />Sólo presione el vínculo y obtendrá una ventana desplegable para agregar a la nueva persona.<br />Complete toda la información que le sea posible y presione el botón \"Guardar\".<br /><br />Es todo.";
$pgv_lang["link_wife_help"]	= "~RELACIONAR ESTA PERSONA COMO ESPOSA A UNA FAMILIA EXISTENTE~<br /><br />Este ítem le permitirá relacionar a la persona como esposa de una familia ya existente en el GEDCOM. Esta es una opción de edición avanzada que sólo debe usarse si la familia que desea relacionar ya existe. Si desea agregar una familia nueva, use el vínculo <b>agregar un nuevo esposo</b>.";
$pgv_lang["add_wife_help"]	= "~AGREGAR UNA NUEVA ESPOSA~<br /><br />Presionando este vínculo, puede agregar una nueva persona (femenina) y relacionarla a la persona principal como una nueva esposa.<br /><br />Sólo presione el vínculo y obtendrá una ventana desplegable para agregar a la nueva persona.<br />Complete toda la información que le sea posible y presione el botón \"Guardar\".<br /><br />Es todo.";
$pgv_lang["add_new_parent_help"]	= "#pgv_lang[multiple_help]#<br />~AGREGAR NUEVO PADRE O MADRE~<br /><br />De seguro existirán muchos individuos en el GEDCOM sin registros de padre o madre.<br /><br />En este caso, en la sección <b>Familia con los padres</b> en el tabulador <b>Familiares cercanos</b> de la página de <b>Detalles del Individuo</b>, encontrará los vínculos para agregar un nuevo padre y/o madre a la persona.<br /><br /><b>NOTA:</b> Tenga presente que estos vínculos son para el agregado de un/a <b>nuevo/a</b> padre/madre</b>.<br />Si el padre o la madre ya tienen un registro en el GEDCOM, debe utilizar el vínculo <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, que también encontrará en la página de Detalles del Individuo bajo la última sección de la página.";
$pgv_lang["add_facts_help"]	= "~AGREGAR NUEVOS ACONTECIMIENTOS~<br /><br />Aquí puede agregar nuevos acontecimientos a la persona (o personas).<br /><br />Primero elija el acontecimiento en la lista \"descolgable\" y presione el botón \"Agregar\".<br />En la lista \"descolgable\" se encuentran todos los acontecimientos posibles para agregar al archivo GEDCOM.<br />";
$pgv_lang["add_note_help"]	= "#pgv_lang[multiple_help]#<br />~AGREGAR UNA NUEVA NOTA~<br />Si debe agregar una nota a esta persona (o personas), este es el lugar para hacerlo.<br />El proceso es simple, sólo presione el vínculo y aparecerá una ventana desplegable, donde podrá ingresar la nota.<br /><br />Cuando haya finalizado el ingreso, solamente presione el botón bajo la caja y cierre la ventana desplegable.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]	= "#pgv_lang[multiple_help]#<br />~AGREGAR NUEVA CITA DE FUENTE~<br />Presionando este vínculo, podrá agregar una <b>Cita</b> a esta persona (o personas).<br />Se abrirá una ventana desplegable y podrá elegir una Fuente de la lista (Encontrar ID) y agregar la \"Cita\".<br /><br />Al momento no es posible agregar una nueva Fuente completa, por lo tanto deberá elegir una Fuente desde la lista.<br /><br />Si la Fuente que desea agregar no aparece en la lista, notifique al Administrador, informándole los detalles de la Fuente y él la agregará a la lista.<br /><br />Probablemente en alguna nueva versión de PhpGedView, sea posible el agregado directo de nuevas Fuentes.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]	= "~AGREGAR NUEVOS ARCHIVOS DE MEDIOS~<br />El agregado de archivos MultiMedio (MM) al GEDCOM, es una característica muy atractiva.<br />Aunque este programa es de un gran atractivo sin los MultiMedios, el agregado de imágenes u otro MM a sus parientes, aumentará el atractivo.<br /><br /><b>Qué debe conocer acerca de MM</b>.<br />Como seguramente es de su conocimiento, existe una infinidad de formatos MM. Aunque PhpGedView soporta a la mayoría de ellos, es necesario realizar algunas consideraciones.<br /><br /><b>Formatos</b><br />Las imágenes pueden grabarse y editarse en una variedad de formatos.<br />p.ej. foto.jpg / foto.png / foto.bmp / foto.gif / etc.<br />Todas la imágenes tendrán el mismo aspecto cuando las vea, pero habrá grandes diferencias en el tamaño de los archivos.<br /><br /><b>Resolución</b><br />La resolución de una imagen se expresa en \"dpi\" (dots per inch). Es válida la comparación por ejemplo con la sensibilidad de las películas fotográficas 25ASA - 200ASA - 800ASA.<br />A mayor resolución, mejor calidad de imagen, pero también será mayor el tamaño de los archivos.<br />Normalmente 75dpi es una calidad aceptable para sitios WEB.<br /><br /><b>Cantidad de colores</b><br />La tercer forma de mantener archivos pequeños , es limitar la cantidad de colores utilizados.<br />La cantidad de colores puede variar desde blanco y negro, hasta colores verdaderos (millones).<br />Nuevamente, cuanto más colores se utilizan, mayor será el tamaño resultante de los archivos.<br /><br /><b>Porqué es importante mantener el tamaño de archivos pequeño?</b><br /><br />Primero: El espacio es limitado.<br />Cuanto mayores sean los archivos, más espacio se necesitará en el servidor. Cuanto mayor sea el espacio necesario, mayor será su costo.<br /><br />Tiempo de grabación. Si los archivos son de gran tamaño, el usuario (y también Ud.) tendrá que esperar más tiempo para que la página sea cargada desde el servidor.<br />No todo el mundo posee una conexión de cable, banda ancha o DSL.<br /><br /><b>Cómo grabar sus archivos MM</b><br />Para ser breve: no es posible.<br />Por todas las razones mencionadas previamente, no es posible grabar directamente los archivos MM en la base de datos.<br /><br /><b>Y entonces?</b><br />Contacte al Administrador, indicando que desea agregar MM al GEDCOM. Él le indicará qué formato es necesario.<br />Cuando tenga las imágenes en el formato adecuado, puede enviarlas por correo electrónico al Administrador. Él verificará los formatos y tamaños y los grabará en el directorio MM del sitio.<br />Puede añadir MM a sus parientes por medio de este vínculo";
$pgv_lang["add_facts_general_help"]	= "~Información general acerca de agregar~<br />Cuando haya agregado un hecho, nota, fuente o archivo mutimedio a una persona o personas, dicho agregado debe ser aprobado por un usuario que tienga privilegios de aceptación, otorgados por el Administrador del sitio.<br />Mientras tanto, para los usuarios con privilegios de edición los cambios son visibles en las páginas marcados con un borde de diferente color, pero no serán visibles para los usuarios públicos. Cuando el agregado haya sido aprobado, los bordes desaparecerán y los nuevos datos se exhibirán normalmente.";
$pgv_lang["edituser_my_account_help"]	= "En esta página puede modificar sus opciones y preferencias.<br /><br />Puede cambiar el nombre de usuario, el nombre completo, la contraseña, la dirección de correo electrónico, el tema del sitio y el método de contacto preferido.<br /><br />El ítem que específicamente no puede cambiar es el ID del registro INDI del GEDCOM.<br /><br />";
$pgv_lang["edituser_username_help"]	= "~#pgv_lang[username]#~<br /><br />En esta caja puede modificar su Nombre de Usuario.<br />Si no le agrada más o por otras razones, puede cambiarlo usando este formulario.<br /><br />El Nombre de Usuario distingue mayúsculas y minúsculas.<br />Significa que \"Juan\" no es lo mismo que \"juan\" o que \"JUAN\".<br /><br />Debe utilizar <b>solamente</b> caracteres de alfabetos soportados por el programa (mayúsculas y minúsculas) y números.<br /><br /><b>No</b> utilice símbolos de puntuación, espacios u otros caracteres que no pertenezcan a los alfabetos soportados.";
$pgv_lang["edituser_fullname_help"]	= "~#pgv_lang[fullname]#~<br />Aquí puede modificar su Nombre Completo.<br />Aunque es su decisión cambiar el nombre completo, probablemente sea adecuado informar, al menos, al Administrador del sitio.<br />Así como Ud. puede ver los nombres de otras personas que han ingresado al sistema, ellos también pueden verlo. Si de pronto ven un nombre desconocido, podrán dudar quién está en el sitio.<br />";
$pgv_lang["edituser_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Es una relación interna (ID GEDCOM) que vincula su información en el archivo GEDCOM.<br /><br />No puede modificar este ID.<br />Este vínculo está definido por el Administrador del sitio.<br />Si piensa que es incorrecto, contáctelo para que lo modifique.<br />";
$pgv_lang["edituser_rootid_help"]	= "~#pgv_lang[rootid]#~<br /><br />Esta es la persona inicial en todos sus gráficos.<br />La persona inicial es la persona de comienzo.<br />Si presiona p.ej. el vínculo del Árbol Genealógico, verá a esta persona inicial en la caja de la extrema izquierda.<br />Por supuesto, esta persona inicial no tiene que ser Ud. Puede definir a cualquier individuo como persona inicial con tal que tenga la posibilidad de ver a esta persona.<br />En algunos gráficos, puede modificar la persona inicial, pero su aplicación será sólo para esas páginas en particular.<br />";
$pgv_lang["edituser_password_help"]	= "~#pgv_lang[password]#~<br /><br />Es una buena costumbre modificar la contraseña a intervalos regulares.<br />Debe tener presente que todo aquel que conozca su Nombre de Usuario y Contraseña, tendrá acceso a su información.<br />Elija una contraseña de por lo menos 6 caracteres. Cuanto mayor sea su longitud, mejor. Puede utilizar todos los caracteres del alfabeto, números y cualquier otro carácter que encuentre en su teclado.<br /><br /><b>Nota: </b>Mejor no utilizar comillas simples (') o dobles (\") ya que si bien pueden operar bien, no se garantiza su funcionamiento.<br /><br /><b>Haga una combinación de mayúsculas, minúsculas, números y otros caracteres</b>. Por ejemplo: 5Z_q\$P4=r9.<br /><br />Como el Nombre de Usuario, la Contraseña es <b>sensible a mayúsculas y minúsculas</b>. Significa que \"Ju5an\" no es lo mismo que \"ju5an\" o que \"JU5AN\".";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Si ha modificado su Contraseña, deberá confirmarla.<br />Esto es para asegurar que no se han cometido errores de tipeo al ingresarla.<br />Si el programa detecta que la Contraseña y su confirmación no son coincidentes, producirá el mensaje de error <b>#pgv_lang[password_mismatch]#</b><br />Ambos campos serán borrados y deberá ingresar la Contraseña y su confirmación nuevamente.<br />";
$pgv_lang["edituser_change_lang_help"]	= "~#pgv_lang[change_lang]#~<br /><br />Aquí puede definir el Idioma por Omisión para el sitio.<br />El programa puede reconocer el <b>Idioma Preferido</b> de su navegador, por lo tanto no hay muchas razones para modificar aquí su preferencia de idioma para el programa.<br />Sin embargo, si su navegador tiene fijado al Inglés como idioma preferido pero desea que el <b>Idioma del Sitio</b> sea el Holandés o el Hebreo, podrá modificarlo aquí.<br />";
$pgv_lang["edituser_email_help"]	= "~#pgv_lang[emailadress]#~<br /><br />La dirección de correo electrónico es importante para poder contactarse con Ud.<br />Si obtiene una nueva dirección de correo electrónico, p.ej. al cambiar de proveedor de Internet, no olvide modificar aquí su dirección.<br />Tal vez posea más de una dirección de correo y desee recibir la correspondencia de este sitio en otra dirección; modifíquela aquí.<br />";
$pgv_lang["edituser_user_theme_help"]	= "~#pgv_lang[user_theme]#~<br /><br />Este sitio dispone de vario <b>Temas</b>.<br />También podrían llamarse \"Aspectos del Sitio\". En cada Tema se verá la misma información pero con un aspecto distinto.<br />Es como poner una foto con diferentes marcos, o colgarla en diferentes habitaciones. La fotografía no cambia, pero la forma en que la ve, es completamente diferente.<br />Experimente. Cambie el tema. Examínelo, pruebe otro. Elija el que más le agrade.<br />Toda vez que ingrese, el programa recordará <b>su</b> opción.<br />";
$pgv_lang["edituser_contact_meth_help"]	= "~#pgv_lang[user_contact_method]#~<br /><br />El sistema de correo, ofrece distintas alternativas de contacto.<br />El método de contacto por envío de correo electrónico es definido por el Administrador; por lo tanto no es modificable.<br />El método de contacto de <b>recibir correo</b> puede ser modificado por Ud.<br />Al momento, puede elegir entre 4 métodos distintos.";
$pgv_lang["mail_option1_help"]	= "Seleccionando esta opción se utilizará el sistema interno de mensajería PhpGedView y no se enviarán correos electrónicos.<br />Sólo recibirá <b>mensajes internos</b> de otros usuarios.<br />Cuando otro usuario le envíe un mensaje, éste aparecerá en el Bloque de Mensajes de la página <b>Mi GedView</b> (siempre y cuando no haya quitado este bloque en su página)<br />";
$pgv_lang["mail_option2_help"]	= "Esta opción es como la #pgv_lang[messaging]#, con un anexo.<br />Una copia extra del mensaje se enviará por correo electrónico a la dirección indicada en su Cuenta.<br />Este método de contacto es la opción por omisión.<br />";
$pgv_lang["mail_option3_help"]	= "Con esta opción, sólo recibirá mensajes en su dirección de correo electrónico.<br />Los otros usuarios no podrán contactarlo por medio del sistema de correo interno.<br />";
$pgv_lang["mail_option4_help"]	= "Con esta opción no recibirá ningún tipo de mensajes.<br />";
$pgv_lang["admin_help"]	= "Aquí se encuentran los vínculos a las páginas de configuración, administración, documentación y archivos de registro.<br /><br />La <b>Hora del Sistema</b>, bajo el título de la página, muestra la hora del servidor en el que su sitio está alojado. Esta es la correspondiente al momento que se accedió a la página (o cuando se la refrescó).<br /><br /><b>ATENCIÓN</b><br />Cuando vea un mensaje bajo la hora del sistema, significa que su archivo <b>config.php</b> todavía es modificable!<br />Después de configurar su sitio debería, por razones de <b>seguridad</b>, establecer los permisos de este archivo como de \"sólo lectura\".<br />Deberá realizarlo <b>manualmente</b> ya que PhpGedView (aún) no puede hacerlo por Ud.<br /><br />Además de las opciones <b>Lea la documentación, Manual del Usuario</b> y <b>Archivos de registro</b>, obtendrá más ayuda en las páginas que seleccione.";
$pgv_lang["useradmin_help"]	= "~ADMINISTRACIÓN DE USUARIOS~<br /><br />En esta página puede administrar tanto a los usuarios actuales como a los nuevos usuarios.<br /><br /><b>Lista de Usuarios actuales</b><br />En esta tabla se muestran los usuarios actuales, su estado y sus privilegios.<br />Puede <b>eliminar</b> o <b>editar</b> usuarios.<br /><br />Formulario de <b>Agregado de Nuevo Usuario</b><br />Este formulario es prácticamente similar al ya conocido de \"Mi Cuenta\".<br />Por distintos motivos no se ha redactado un texto de ayuda especial para el Administrador. En aquellos casos, verá el siguiente mensaje:";
$pgv_lang["useradmin_gedcomid_help"]	= "~REGISTRO INDI DEL GEDCOM~<br /><br />Este registro ID de GEDCOM para el usuario, debe ser definido por el Administrador.<br />Identificará al usuario.<br />También proveerá acceso a sus páginas \"Mi cuenta\" y \"Mi Árbol Genealógico\".<br /><br />Para cada GEDCOM utilizado en el programa, podrá definir el registro ID del GEDCOM para el usuario.<br />Si el usuario no tiene un registro en el GEDCOM, puede dejar el texto vacío.";
$pgv_lang["useradmin_rootid_help"]	= "~PERSONA INICIAL DEL ÁRBOL GENEALÓGICO~<br /><br />Para cada GEDCOM del programa, se puede asignar como <b>Persona Inicial a un usuario.</b><br />Probablemente, al usuario le gustaría encabezar su propio Árbol, pero no es una necesidad imperiosa.<br /><br />Todo usuario puede modificar por sí mismo esta opción en su cuenta.";
$pgv_lang["useradmin_can_admin_help"]	= "~OPCIÓN USUARIO PUEDE ADMINISTRAR~<br /><br />Si esta opción está seleccionada, el usuario tendrá sus mismos privilegios dentro del programa.<dl><dt>No sólo podrá:</dt><dd>Agregar/Eliminar/Editar usuarios.</dd><dd>Enviar mensajes en bloque a todos los usuarios.</dd><dd>Editar Mensajes de Bienvenida.</dd><dd>Editar y configurar archivos de Idioma.</dd><br /><dt>Sino también:</dt><dd>Actualizar el programa.</dd><dd>Modificar la configuración.</dd><dd>Administrar los GEDCOMs.</dd><dd>Modificar las opciones de Privacidad.</dd><dd>Cualquier otra operación no mencionada aquí.</dd><br />Pero no podrá modificar las opciones del sitio, fuera del ámbito del programa.</dt><dl>";
$pgv_lang["useradmin_can_edit_help"]	= "~USUARIO PUEDE EDITAR~<br /><br />Para cada GEDCOM en el sistema, el usuario puede tener determinados privilegios de edición.<br><br>Seleccionando <b>No</b> implica que el usuario no podrá editar o aceptar datos en la base de datos.<br><br>Seleccionando <b>Si</b> implica que el usuario podrá editar o aceptar datos pero otro usuario con privilegio de <b>Aceptar</b> deberá aprobar los cambios antes de ser agregados en la base de datos y hechos públicos.<br><br>Seleccionando <b>Aceptar</b> proporcionará al usuario la posibilidad de editar y aprobar cambios realizados por otros usuarios.<br><br><br />Los Administradores automáticamente poseen privilegios de <b>Aceptar</b>.";
$pgv_lang["useradmin_verified_help"]	= "~AUTOVERIFICACIÓN DEL USUARIO~<br /><br /><b>Autoverificación</b><br />Un usuario puede solicitar una nueva cuenta, por medio del módulo de <b>Autoverificación</b>.<br />De haberlo hecho así, él recibirá un correo electrónico con las instrucciones para verificar su solicitud.<br />Cuando así lo haya realizado, verá la caja de control tildada, pudiendo proceder al próximo paso: <b>Usuario aprobado por el Administrador</b>.<br />Si el usuario no se ha autoverificado, deberá esperar para su aprobación.<br /><br /><b>Agregar usuario manualmente</b><br />Si usa el formulario para agregar usuarios en forma manual, encontrará preseleccionada la opción.";
$pgv_lang["useradmin_verbyadmin_help"]	= "~APROBADO POR EL ADMINISTRADOR~<br /><br />Si un usuario ha utilizado el Módulo de Autoverificación, habiéndolo hecho, el último paso, antes que su cuenta sea efectiva, es su aprobación.<br /><br />Después de haber aprobado la solicitud de la nueva cuenta, el usuario recibirá un correo electrónico informándole que su cuenta está efectiva y que puede ingresar con el Nombre de Usuario y Contraseña que utilizó cuando solicitó la cuenta.";
$pgv_lang["useradmin_edit_user_help"]	= "~EDITAR USUARIO~<br /><br />Este formulario es usado por el Administrador para modificar una cuenta de usuario.<br /><br />El formulario es bastante similar al formulario \"Agregar Usuario\" o al formulario \"Mi Cuenta\".";
$pgv_lang["how_upgrade_help"]	= "~UTILITARIO DE ACTUALIZACIÓN~<br /><br />El utilitario de actualización se ocupa de actualizar la versión existente de PhpGedView, a una nueva versión que haya grabado.<br /><br /><b>Grabado de una nueva versión</b><br />La nueva versión puede grabarse directamente de http://sourceforge.net/projects/phpgedview/ o puede hacer que el utilitario de actualización controle la existencia de una nueva versión. Si existe una nueva versión, mostrará las posibilidades de grabación. Estas pueden ser <b>zip, gz</b> o ambas.<br /><br /><b>Qué actualizar?</b><br /><br />* PhpGedView<br />Esta opción actualizará los archivos principales de PhpGedView excluyendo los archivos config.php, privacy.php y authenticate.php. También actualizará el directorio de imágenes.<br /><br />* Archivos Índice<br />Esta opción actualiza el directorio /index. Úsela con precaución, ya que sobreescribirá cualquier archivo existente.<br /><br />* Idiomas<br />Esta opción actualiza el directorio /languages.<br /><br />* Temas<br />Esta opción actualiza el directorio /themes. Úsela con precaución, ya que sobreescribirá cualquier personalización que haya realizado.<br /><br />* Archivo de configuración<br />Esta opción compara su archivo de configuración con la versión nueva encontrada y actualizará su archivo según todos los cambios encontrados en el nuevo archivo de configuración. Esto le asegura que dispondrá de la última versión, configurada con sus opciones.<br /><br />* Archivos de Privacidad<br />Esta opción compara su/s archivo/s de Privacidad con la nueva versión encontrada y actualizará su/s archivo/s según todos los cambios encontrados en el nuevo archivo de Privacidad. Esto le asegura que dispondrá de la última versión configurada con sus opciones de Privacidad.<br /><br />* Manuales<br />Esta opción actualiza el directorio /doc.<br /><br />* Registro de Investigación<br />Esta opción actualiza el módulo de Investigación.<br /><br />* Crear respaldo<br />Esta opción crea una copia de respaldo del archivo actual en el directorio /backup.<br /><br /><b>Cómo actualizar?</b><br />1. Seleccione las partes que desea actualizar.<br />2. Presione Guardar.<br /><br />La evolución del proceso se indicará al final de la página.";
$pgv_lang["add_upload_gedcom_help"]	= "~OPCIONES AÑADIR versus GRABAR~<dl><dt>Grabado de archivos GEDCOM</dt><dd>El grabado de archivos puede hacerse \"en línea\".<br />La grabación puede realizarse desde cualquier lugar, sin la necesidad de un programa FTP.</dd><dt>Añadiendo archivos GEDCOM</dt><dd>Si el archivo ya existe en su directorio GEDCOM, puede usarlo sin necesidad de grabarlo nuevamente.<br />Algunas veces es necesario utilizar Añadir en lugar de Grabar ya sea por cuestiones de tamaño o por limitaciones en la grabación. </dd></dl>Los procesos Añadir y Grabar se realizan en 4 pasos simples.<br />Sólo es diferente el Paso 1 de ambos procedimientos.<br />";
$pgv_lang["gedcom_configfile_help"]	= "~ARCHIVO DE CONFIGURACIÓN GEDCOM~<br /><br />En este archivo se almacenan todas las opciones básicas del archivo GEDCOM.<br /><br />En la columna \"Archivo de Configuración\" de la Página de Administración del GEDCOM, se muestran la ruta y el nombre del archivo de configuración.";
$pgv_lang["default_gedcom_help"]	= "~GEDCOM POR OMISIÓN~<br /><br />Si tiene más de un archivo GEDCOM, puede establecer aquí cuál será usado <b>por omisión</b>.<br /><br />Será el GEDCOM visto por todos los visitantes y usuarios que aún no hayan ingresado.<br /><br />Los usuarios pueden alterar esta opción, cuando la modifiquen en su cuenta.<br />";
$pgv_lang["delete_gedcom_help"]	= "~BORRAR GEDCOM~<br /><br />PhpGedView importa registros desde un archivo GEDCOM. Cuando presiona <b>Borrar</b>, el programa eliminará los registros importados desde el GEDCOM.<br />El archivo GEDCOM real permanecerá en el directorio en el que fue grabado.<br /><br />Si posteriormente desea trabajar nuevamente con ese archivo GEDCOM, no tiene que grabarlo nuevamente. Puede elegir en cambio, la opción <b>Añadir GEDCOM</b>.<br /><br />Después de presionar Borrar, debe <b>confirmar</b> su elección en un diálogo \"autodesplegable\".";
$pgv_lang["add_GEDCOM_help"]	= "~AÑADIR GEDCOM~<br /><br />Cuando utilice la opción Añadir GEDCOM, se asume que ya ha grabado el archivo GEDCOM en su servidor, <i>usando un programa externo</i>, por ejemplo <b>ftp</b> o conexión de <b>red</b>.<br />Si el archivo GEDCOM aún no está en su servidor, <b>debe</b> grabarlo antes de comenzar con el Añadido.<br /><br />Será guiado paso a paso a través del procedimiento.<br />";
$pgv_lang["add_new_gedcom_help"]	= "~CREAR UN NUEVO GEDCOM~<br /><br />Tiene la posibilidad de comenzar un nuevo GEDCOM desde cero.<br /><br />Puede realizar este procedimiento en unos pocos pasos. El primer paso es diferente de lo que ya conoce acerca de cargar y agregar archivos. Los otros pasos son similares.<dl><dt>Paso 1: Nombrando el nuevo GEDCOM.</dt><dd>Ingrese el nombre del nuevo GEDCOM sin la extensión \".ged\". El nuevo archivo se creará en el directorio indicado arriba del campo de texto para ingresar el nombre.<br />Presione <b>Agregar</b>.</dd><dt>Paso 2: Página de Configuración.</dt><dd>Esta es la página ya conocida en la configuración de las opciones de los archivos GEDCOM.</dd><dt>Paso 3: Validar</dt><dd>Este paso también es conocido. El nuevo GEDCOM es controlado y resultará OK.</dd><dt>Paso 4: Importación de registros</dt><dd>Dado que existe un sólo registro para importar, este paso se realizará muy rápido.</dd><dt>Creación concluida.</dt><dd>Ahora puede dirigirse al árbol genealógico e ingresar la primer persona en el nuevo GEDCOM. Presione el nombre de la persona y comience a editar. Luego puede agregar nuevos individuos a la primer persona.</dd></dl>";
$pgv_lang["download_gedcom_help"]	= "~CARGAR GEDCOM~<br /><br />Tiene la opción de cargar un archivo GEDCOM en su sitio.<br /><br />En la página \"Cargar GEDCOM\" tiene la opción de convertir el archivo de formato <b>UTF-8</b> a <b>ANSI (ISO-8859-1)</b>.<br />El formato necesario depende del programa que utilice para trabajar con el archivo GEDCOM cargado.<br />Si tiene dudas, consulte la documentación del programa en cuestión.";
$pgv_lang["edit_gedcoms_help"]	= "~ADMINISTRACIÓN DEL GEDCOM~<br /><br />La página de Administración del GEDCOM es el centro de control para administrar sus GEDCOMs <b>actuales</b> y <b>nuevos</b>.<br /><dl><b>GEDCOMs ACTUALES</b><br /><dt>En la tabla <b>GEDCOMs Actuales</b> tiene las siguientes opciones:</dt><dd>Borrar GEDCOM</dd><dd>Editar GEDCOM</dd><dl><dt>Editar Archivo de Privacidad</dt><dd>La edición de la Privacidad es parte de esta tabla, ya que cada GEDCOM tiene su propio archivo de Privacidad.</dd></dl><dd>GEDCOM por omisión</dd><dd>Importar GEDCOM</dd><dd>Descargar GEDCOM.</dd><dt>Hay 3 columnas con la siguiente información:</dt><dd>Archivo GEDCOM</dd><dd>Título del GEDCOM</dd><dd>Archivo de Configuración </dd></dl><dl><b>ARCHIVOS GEDCOM NUEVOS</b><dt>En esta página tiene las siguientes opciones para agregar al sistema un archivo GEDCOM <b>nuevo</b> o <b>existente</b>.</dt><dd>Añadir otro archivo GEDCOM</dd><dd>Cargar GEDCOM</dd><dd>Crear un nuevo GEDCOM </dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	= "~CONFIGURAR GEDCOM~<br /><br />Cada archivo GEDCOM que utilice en este programa, tiene su <b>propio</b> archivo de configuración.<br /><br />En este formulario, se establecen las opciones básicas, p.ej. idioma, tipo de calendario, opciones de correo electrónico, etc.<br />";
$pgv_lang["import_gedcom_help"]	= "~IMPORTAR GEDCOM~<br /><br />En muchos casos la importación de un GEDCOM es un paso de un procedimiento, como por ejemplo, grabar, añadir o añadir un nuevo GEDCOM.<br /><br />Los pasos se hallan en una secuencia lógica y deben realizarse para poder operar con el GEDCOM.<br />En el caso que no haya completado la secuencia, como se indicó previamente, verá un mensaje de <b>atención</b> indicando que el GEDCOM aún no se ha importado. En tal caso presione el vínculo para (re-)importar el archivo GEDCOM.<br /><br /><b>Importando</b><br />Si Ud. o alguno de los usuarios ha realizado modificaciones <b>en-línea</b>, deberá re-importar el GEDCOM para que los cambios se hagan permanentes.<br /><br />Los parámetros de Configuración del GEDCOM no variarán cuando re-importe un GEDCOM.<br />Se sobreescribirán los datos existentes.";
$pgv_lang["upload_gedcom_help"]	= "~GRABAR GEDCOM~<br /><br />A diferencia de la opción \"Añadir GEDCOM\", no necesita aún disponer en su servidor del archivo GEDCOM.<br /><br />En el paso 1 se selecciona el archivo GEDCOM en su computadora local. Ingrese la ruta y el nombre completo, o utilice el botón <b>Buscar</b>.<br /><br />Encontrará más ayuda en las otras páginas durante el procedimiento.<br />";
$pgv_lang["validate_gedcom_help"]	= "~VALIDAR GEDCOM~<br /><br />La validación del GEDCOM que está cargando o agregando, es el 3er. paso en el procedimiento de operaciones para que el programa opere con ese archivo.<br /><br />El programa controlará el correcto uso de: Formatos de Fechas, Formatos de Lugares, Juego de Caracteres y más.<br />Algunas de las desviaciones se corregirán automáticamente. Por ejemplo los fines de línea en computadoras Macintosh y el uso incorrecto del formato de Lugares.<br />En esos casos, verá un mensaje indicando que la información ha sido modificada.<br />Para otros desvíos verá un mensaje de advertencia con la solución adecuada.<br /><br /><b>Herramientas opcionales</b><br />Al momento existen dos herramientas opcionales:<br /><b>Cambiar el ID individual a ...</b> y <b>Agregar Herramienta de Medios</b>.<br />Esta última herramienta sólo está disponible en el modo-<b>MySQL</b>. Si su GEDCOM opera en el modo-<b>Índice</b>, la opción no aparecerá.<br /><br />Mayor ayuda disponible en el formulario #pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]	= "~CONVERTIR ANSI A UTF-8~<br /><br />Para asegurarse que el programa opera correctamente con sus archivos GEDCOM, deberían estar codificados en UTF-8.<br /><br />Muchos programas de Genealogía tienen la opción de exportar un archivo GEDCOM con esta codificación UTF-8.<br />Si el programa que utiliza no ofrece la opción, PhpGedView puede convertirlo.<br /><br />Cuando PhpGedView valida un archivo grabado (o añadido) detectará si el archivo tiene codificación ANSI.";
$pgv_lang["detected_ansi2utf_help"]	= "~CODIFICACIÓN ANSI DETECTADA~<br />El archivo GEDCOM que está siendo validado, tiene codificación ANSI.<br />Se recomienda enfáticamente que esta codificación se convierta a UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]	= "~SE DETECTÓ UN FORMATO DE FECHA INCORRECTO:~<br /><b>SE MODIFICARÁ EL FORMATO DE LA FECHA</b><br /><br />El formato standard PhpGedView conforme al <b>standard GEDCOM 5.5</b> es: DD MMM YYYY (p.ej. 02 JAN 2004)<br /><br />Si observa, después de la validación del GEDCOM, un mensaje indicando la detección de formatos de fecha incorrectos, el programa modificará las fechas conforme al standard.<br /><br />No obstante tiene la opción de elegir \"<b>día</b> antes del mes\" (DD MMM YYYY) o bien el \"<b>mes</b> antes del día\" (MMM DD YYYY).<br />Se recomienda la elección de la primera opción.";
$pgv_lang["addmedia_tool_help"]	= "~AGREGAR HERRAMIENTA DE MEDIOS~<br /><b>Solamente modo MySQL</b><br /><br />El agregado de herramienta de Medios fue diseñado para aquellos usuarios cuyos programas de genealogía no exportan GEDCOMs con vínculos de Medios. El \"Family Tree Maker\" es el más notorio.<br /><br />El agregado de herramienta de Medios permite mantener una lista de vínculos de Medios fuera del archivo GEDCOM y en una tabla separada de la tablas PhpGedView normales. Dado que la información se guarda en una tabla separada, sólo debe ingresar la información una vez. Esto facilita la tarea de administradores de trabajar con información genealógica, exportar un nuevo archivo GEDCOM y ejecutar entonces el \"agregado de herramienta de Medios\"como parte del proceso de importación agregando los mismos vínculos a las imágenes cada vez que se cree un nuevo GEDCOM.<br /><br />Para usar el \"agregado de herramienta de Medios\", primero cree una lista de medios completando los campos y presionando el botón <b>Agregar Medios</b> por cada ítem que desea incluir en el GEDCOM. El campo \"#pgv_lang[gedcomid]#\" contiene el ID del registro GEDCOM al cual quiere agregar la imagen, p.ej. I100. En el campo\"Archivo Externo\" ingrese el nombre de la imagen que desea usar. Ingrese la extensión del archivo en el campo \"#pgv_lang[extension]#\". Utilice el campo \"#pgv_lang[highlighted]#\" para indicar si esta es la imagen primaria o destacada del individuo. La primer imagen primaria o destacada se usará en los gráficos y destacada en la página individual de la persona próxima a su nombre. En el campo \"#pgv_lang[title]#\" ingrese un nombre descriptivo de la imagen. Use el campo \"#pgv_lang[order]#\" para especificar el orden en que las imágenes deben aparecer en el tabulador de la página personal del individuo. Finalmente, el campo \"#pgv_lang[gedcom_file]#\" indica a qué GEDCOM pertenece este ítem de medios. Esto permite utilizar la herramienta con múltiples archivos GEDCOM.<br /><br />Cuando la lista esté completa, presione el botón \"#pgv_lang[click_to_add_media]#\" para almacenar los cambios en el archivo GEDCOM. La próxima oportunidad que actualice su GEDCOM, sólo deberá ejecutar el \"agregado de herramienta de Medios\" y presionar este botón.<br /><br />";
$pgv_lang["change_indi2id_help"]	= "<b>CAMBIAR EL ID DE LA PERSONA A ....</b><br /><br />#pgv_lang[sorry]#<br /><br />";
$pgv_lang["edit_privacy_help"]	= "En esta página podrá definir todas las Opciones de Privacidad para el GEDCOM elegido (si tiene más de uno).<br />Puede controlar si está editando el archivo adecuado, bajo el título de la página.<br />Se indica como (ruta/nombredesugedcom_priv.php)<br /><br />Si desea efectuar más cambios que los que manualmente pueda realizar al archivo de Privacidad, puede obtener mayor información en el sitio WEB de PhpGedView.<br />";
$pgv_lang["invalid_header_help"]		= "~ENCABEZAMIENTO GEDCOM INVÁLIDO~<br>Un archivo GEDCOM debe contener en su primer registro <b>0 HEAD</b>. PhpGedView detectó que su archivo no comienxa con el registro <b>0 HEAD</b>. Después de presionar el botón Limpieza, se eliminarán todos los registros previos a <b>0 HEAD</b>.<br><br>Este error usualmente significa que el programa utilizado para crear el archivo GEDCOM no funciona adecuadamente o que éste no es un archivo GEDCOM. Deberá asegurarse que ha cargado el archivo GEDCOM adecuado y que éste comienza con el registro <b>0 HEAD</b> y finaliza con el registro <b>0 TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~ARCHIVO MACINTOSH DETECTADO~<br>PhpGedView detectó que su archivo GEDCOM fue creado en una computadora Macintosh. Los archivos Macintosh utilizan caracteres de fin de línea diferentes (r) a los utilizados por Unix (n) o Windows (rn). Las funciones PHP utilizadas por PhpGedView requieren que los archivos contengan fines de línea Unix o DOS. Cuando presione el botón Limpieza, su archivo se convertirá al formato DOS.<br>";
$pgv_lang["cleanup_places_help"]		= "~LMPIEZA DE LUGARES~<br>PhpGedView detectó que su archivo GEDCOM contiene lugares en etiquetas GEDCOM que no deberían tenerlos. Muchos programas de genealogía, tales como el Family Tree Maker, crean archivos GEDCOM de este tipo. PhpGedView funciona con este tipo de archivos pero mostrará algunos lugares incorrectos en la jerarquía de lugares.<br><br>Por ejemplo, su archivo GEDCOM puede contener la siguiente codificación:<br>1 SSN<br>2 PLAC 123-45-6789<br>Según la especificación GEDCOM esto debería estar escrito así:<br>1 SSN 123-45-6789<br>Al seleccionar <b>Sí</b> PhpGedView automáticamente detectará y corregirå estos errores de codificación.";
$pgv_lang["empty_lines_detected_help"]	= "~REGISTROS VACÍOS DETECTADOS~<br>PhpGedView detectó que hay registros vacíos en su archivo GEDCOM. Estos registros pueden causar errores y se eliminarán antes de importar el archivo GEDCOM.";
$pgv_lang["help_editconfig.php"]	= "~CONFIGURAR PhpGedView~<br /><br />En esta página debe definir los parámetros globales de PhpGedView, cuando lo ejecute por primera vez, después de haberlo instalado en su servidor.<br />#pgv_lang[review_readme]#<br /><br />Como estos parámetros son <b>globales</b> su aplicación es válida para todo el programa y para todos los archivos GEDCOM utilizados en el programa.<br />Es posible definir parámetros individuales para cada archivo GEDCOM utilizado.<br />Dado que se encuentra en la página de Administración, puede presionar el vínculo para Administrar GEDCOMs, inmediatamente arriba.<br />En cualquier parte del programa, encontrará el vínculo en el menú bajo el icono Mi GedView.";
$pgv_lang["help_gdbi_changes.php"]	= "<b>#pgv_lang[review_changes]#</b><br /><br />La lista es simple y clara. No es necesaria mayor explicación.<br /><br />La opción <b>Deshacer</b> le da una segunda oportunidad. No aparecerá una nueva ventana desplegable de confirmación!.<br /><br />Cuando un usuario ha realizado algún cambio y una <b>fecha</b> está involucrada, controle que la fecha se encuentre en el formato adecuado.<br />El campo <b>fecha</b> es un campo de texto de forma tal que se puede realizar cualquier ingreso.<br />Fechas con un formato erróneo pueden posteriormente producir mensajes de error en alguna parte del programa.<br />Para mayor información sobre fechas en el GEDCOM, lea <b>Información del GEDCOM</b> en el Menú de Ayuda.<br />";
$pgv_lang["lang_edit_help"]	= "En esta página se administran los archivos de idioma.<br />Puede traducir, comparar y exportar archivos de idioma.<br />Más aún, puede seleccionar los archivos de idioma que serán soportados por el programa.<br /><br />Puede utilizar las siguientes opciones y utilitarios: ";
$pgv_lang["language_to_edit_help"]	= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[language_to_edit]#</b><br /><br />Aquí selecciona el idioma cuyos mensajes desee <b>editar</b>.";
$pgv_lang["file_to_edit_help"]	= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[file_to_edit]#</b><br /><br />En esta lista selecciona el nombre del archivo de idioma que desee editar.<br /><br />Las opciones son:<br /><br />lang.xx.php<br />facts.xx.php<br />configure_help.xx.php<br />help_text.xx.php<br />rs_lang.xx.php<br /><br />Donde <b>xx</b> significa el código del idioma elegido y se selecciona automáticamente.<br />Sólo se indica como opción <b>rs_lang.xx.php</b> si el \"plug-in\" <b>Registro de Investigación</b> está instalado.";
$pgv_lang["hide_translated_help"]	= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[hide_translated]#</b><br /><br />Fijado en \"Sí\", sólo verá los mensajes en el idioma seleccionado que aún no han sido traducidos, es decir los que aún no existen en el idioma seleccionado.<br />Después de agregar una nueva traducción a un mensaje, éste desaparecerá de la lista.";
$pgv_lang["language_to_export_help"]	= "#pgv_lang[export_lang_utility]# >> <b>#pgv_lang[language_to_export]#</b><br /><br />Aquí selecciona el idioma cuyos mensajes desee <b>exportar</b>.";
$pgv_lang["new_language_help"]	= "#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[new_language]#</b><br /><br />Aquí selecciona el idioma que tiene los mensajes originales que desea comparar con otro idioma.<br /><br />Todos las modificaciones y agregados a los archivos de idioma se deben hacer primero a los archivos de idioma <b>Inglés</b>";
$pgv_lang["old_language_help"]	= "#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[old_language]#</b><br /><br />En esta lista, selecciona el idioma que desea comparar con el idioma elegido en la lista <b>Idioma fuente</b>.<br /><br />Después de haber realizado la selección, presione el botón <b>Comparar</b> y obtendrá un listado de agregados y quitas.<br /><br />Para asegurarse:<br /><br /><b>Agregado</b> significa: existe <b>en</b> el archivo fuente, pero <b>no</b> en el archivo destino.<br /><b>Quita</b> significa: <b>No</b> existe (más) en el archivo fuente, pero (aún) <b>existe</b> en el archivo destino.";
$pgv_lang["add_new_lang_help"]	= "<b>#pgv_lang[add_new_language]#</b><br />Con esta selección, puede agregar un nuevo idioma a PhpGedView.<br />Puede establecer las opciones standard de ese nuevo idioma tales como: detección de idioma, sentido del idioma, día de comienzo de la semana, opciones de fecha y hora, alfabeto, etc.<br /><br />Para mayor ayuda sobre las opciones de idiomas soportados por PhpGedView, agregue un idioma y luego edítelo. En la nueva ventana de las opciones de ese idioma verá más <b>?</b> de ayuda contextual que le podrán ayudar.";
$pgv_lang["help_contents_head_help"]	= "<b>CONTENIDO DE AYUDA</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]	= "Información GEDCOM";
$pgv_lang["help_contents_gedcom_places"]	= "Lugares en el GEDCOM";
$pgv_lang["admin_help_contents_head_help"]	= "<b>CONTENIDO DE AYUDA<br /><br />ÍTEMS DE AYUDA DEL ADMINISTRADOR</b> agregados al comienzo de la lista.<br /><br />";
$pgv_lang["ah1_help"]	= "_Actualización";
$pgv_lang["ah2_help"]	= "_Configurar PhpGedView";
$pgv_lang["ah3_help"]	= "_GEDCOM: Añadir versus Grabar";
$pgv_lang["ah4_help"]	= "_GEDCOM: Archivo de configuración";
$pgv_lang["ah5_help"]	= "_GEDCOM: Por omisión";
$pgv_lang["ah6_help"]	= "_GEDCOM: Borrar";
$pgv_lang["ah7_help"]	= "_GEDCOM: Añadir";
$pgv_lang["ah8_help"]	= "_GEDCOM: Crear nuevo";
$pgv_lang["ah9_help"]	= "_GEDCOM: Grabar";
$pgv_lang["ah10_help"]	= "_GEDCOM: Página de administración";
$pgv_lang["ah11_help"]	= "_GEDCOM: Configurar";
$pgv_lang["ah12_help"]	= "_GEDCOM: Importar";
$pgv_lang["ah13_help"]	= "_GEDCOM: Grabar";
$pgv_lang["ah14_help"]	= "_GEDCOM: Validar";
$pgv_lang["ah15_help"]	= "_GEDCOM: Convertir ANSI a UTF-8";
$pgv_lang["ah16_help"]	= "_GEDCOM: Opciones de Privacidad";
$pgv_lang["ah17_help"]	= "_Administración de Usuarios";
$pgv_lang["ah18_help"]	= "_Administración";
$pgv_lang["ah19_help"]	= "_GEDCOM: Herramienta de Medios";
$pgv_lang["ah20_help"]	= "_GEDCOM: Cambiar el ID personal a ........";
$pgv_lang["ah21_help"]	= "_Archivos de Idioma";
$pgv_lang["help_header"]	= "Información acerca de:";
?>
