<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: functions.inc.php,v 1.8 2001/10/01 01:13:08 milosch Exp $ */

	function cat_option($cat_id='',$notall=False,$java=True)
	{
		if ($java)
		{
			$jselect = ' onChange="this.form.submit();"';
		}
		// Setup all and none first
		$cats_link  = "\n" .'<select name="cat_id"' .$jselect .">\n";
		if (!$notall)
		{
			$cats_link .= '<option value=""';
			if ($cat_id=="all")
			{
				$cats_link .= ' selected';
			}
			$cats_link .= '>'.lang("all").'</option>'."\n";
		}

		// Get global and app-specific category listings
		$cats       = CreateObject('phpgwapi.categories');
		$cats_link .= $cats->formated_list('select','all',$cat_id,False);
		$cats_link .= '</select>'."\n";
		return $cats_link;
	}

	function nicesize($filesize='')
	{
		$revsize = strrev($filesize);
		$checkarr = array(0,3,6,9,12,15,18,21,24);
		
		while (list($null,$start) = each($checkarr))
		{
			if ($start <= strlen($revsize))
			{
				$newsize .= substr($revsize,$start,3) . ',';
			}
			else
			{
				break;
			}
		}
		$newsize = substr(strrev($newsize),1) . ' ' . lang('Bytes');
		return $newsize;
	}

	function get_dirs()
	{
		$dirs = array();

		$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_dj_directories WHERE dir_id>0");
		while ($GLOBALS['phpgw']->db->next_record())
		{
			if ($GLOBALS['phpgw']->db->f('dir_name'))
			{
				//$servers[$GLOBALS['phpgw']->db->f('name')] = array(
				$dirs[$GLOBALS['phpgw']->db->f('dir_id')]= array(
					'dir_id'   => trim(stripslashes($GLOBALS['phpgw']->db->f('dir_id'))),
					'dir_name' => trim(stripslashes($GLOBALS['phpgw']->db->f('dir_name')))
				);
			}
		}
		return $dirs;
	}

	function song_exists($song_name='')
	{
		if($song_name)
		{
			$song_name = addslashes($song_name);
			$GLOBALS['phpgw']->db->query("SELECT COUNT(*) FROM phpgw_dj_songlist WHERE song_name='$song_name'");
			$GLOBALS['phpgw']->db->next_record();
			if ($GLOBALS['phpgw']->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}
		else
		{
			return True;
		}
	}

	function get_files()
	{
		$dirs = get_dirs();
		$filelist = array();
		$i = 0;

		while (list($key,$dir) = each($dirs))
		{
			if (is_dir($dir['dir_name']))
			{
				chdir($dir['dir_name']);
				$current = opendir('.');
				while ($fname = readdir($current))
				{
					if (!is_dir($fname))
					{
						$fname = trim($fname);
						$lname = strtolower(substr($fname,-3));
						if ($lname == 'mp3')
						{
							$filelist[$i] = $dir['dir_name'] . SEP . $fname;
							$i++;
							//echo $dir['dir_name'] . SEP . $fname ."\n";
						}
					}
				}
				closedir($current);
			}
		}
		return $filelist;
	}

	function get_info($filename='')
	{
		if ($filename)
		{
			$data = ereg_replace("\n",'',$filename);
			$mp3info = CreateObject('dj.id3',$data);

			return $mp3info;
		}
	}

	function delete_songs()
	{
		$sql = "DELETE FROM phpgw_dj_songlist";
		$GLOBALS['phpgw']->db->query($sql);
	}

	function add_song($mp3info='')
	{
		$status = ($GLOBALS['mark_unavailable'] ? 'N' : 'A');

		if ($mp3info)
		{
			// Some MP3s do this, I don't know why
			if ($mp3info->sample == 'Reserved')
			{
				$mp3info->sample = 0;
			}

			$sql = "INSERT INTO phpgw_dj_songlist (song_name,song_title,song_artist,song_year,song_comment,"
				. "song_album,song_genre,song_size, song_length, song_bitsize, song_samplerate,song_frames,"
				. "song_emphasis,song_cmode,song_version, song_layer,song_crc,song_copyright,song_original,"
				. "song_status,song_cycle_status) VALUES ('"
				. addslashes($mp3info->file)
				. "','" . addslashes($mp3info->title)
				. "','" . addslashes($mp3info->artists)
				. "','" . addslashes($mp3info->year)
				. "','" . addslashes($mp3info->comment)
				. "','" . addslashes($mp3info->album)
				. "','" . addslashes($mp3info->genre)
				. "','" . addslashes($mp3info->filesize)
				. "','" . addslashes($mp3info->lengths)
				. "','" . addslashes($mp3info->bitrate)
				. "','" . addslashes($mp3info->sample)
				. "','" . addslashes($mp3info->frames)
				. "','" . addslashes($mp3info->emphasis)
				. "','" . addslashes($mp3info->chmode)
				. "','" . addslashes($mp3info->mpeg_ver)
				. "','" . addslashes($mp3info->layer)
				. "','" . addslashes($mp3info->crc)
				. "','" . addslashes($mp3info->copyright)
				. "','" . addslashes($mp3info->original)
				. "','$status','A')";
			$GLOBALS['phpgw']->db->query($sql);
		}
		return $mp3info;
	}

	function get_form($data='')
	{
		$hp = $GLOBALS['HTTP_POST_VARS'];
		$hg = $GLOBALS['HTTP_GET_VARS'];

		if (!(isset($hp['start']) || isset($hg['start'])))
		{
			$GLOBALS['start']  = $data['start'];
		}
		else
		{
			$GLOBALS['start'] = $hp['start'] ? $hp['start'] : $hg['start'];
		}

		if (!(isset($hp['fcat_id']) || isset($hg['cat_id'])))
		{
			$GLOBALS['cat_id'] = $data['cat_id'];
		}
		else
		{
			$GLOBALS['cat_id'] = isset($hp['fcat_id']) ? $hp['fcat_id'] : $hg['cat_id'];
		}
		$GLOBALS['fcat_id'] = $GLOBALS['cat_id'];

		if (!(isset($hp['query']) || isset($hg['query'])))
		{
			$GLOBALS['query'] = $data['query'];
		}
		else
		{
			$GLOBALS['query'] = isset($hp['query']) ? $hp['query'] : $hg['query'];
		}

		if (!(isset($hp['sort']) || isset($hg['sort'])))
		{
			$GLOBALS['sort'] = $data['sort'];
		}
		else
		{
			$GLOBALS['sort'] = $hp['sort'] ? $hp['sort'] : $hg['sort'];
		}

		if (!(isset($hp['order']) || isset($hg['order'])))
		{
			$GLOBALS['order'] = $data['order'];
		}
		else
		{
			$GLOBALS['order'] = $hp['order'] ? $hp['order'] : $hg['order'];
		}
	}

?>
