/*
 * ftp leeching routines, uses patched fget (see "patches/")
 *
 */

#include <errno.h>
#include <time.h>
#include <ctype.h>
#include <dirent.h>
#include <getopt.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "adopt.h"
#include "common.h"
#include "pimppa.h"
#include "ftp.h"

#define LINEBUF 4096

extern MYSQL *src_db,*dst_db;

int collapsedir(char *dirname, int level);

int p_ftpleech(char *urlfile, int options)
{
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	char olddir[PATH_MAX];
	char tmppath[PATH_MAX];
	char buffer[LINEBUF];
	char combuf[PATH_MAX];
	char tmpfile[PATH_MAX];
	struct stat st;
	FILE *fp,*dp;
	char *value;

	fp=fopen(urlfile, "r");
	if(!fp)
	{
		fprintf(stderr, "Unable to open %s\n", urlfile);
		return(1);
	}

	umask(002);

	value=p_getmisc(src_db, P_KEY_TMPDIR);
	if(!value)
		value=P_TMPDIR;

	getcwd(olddir, PATH_MAX);
	if(stat(value, &st)!=0)
		mkdir(value,0770);

	chdir(value);

	sprintf(tmppath, "%s%sftpleech_tmp%d",
			value, (p_checkp(value) ? "" : "/"), getpid());
	mkdir(tmppath, 0770);
	if(chdir(tmppath))
	{
		fprintf(stderr, "Error: can't change to %s\n", tmppath);
		fclose(fp);
		return(1);
	}
		
	sprintf(tmpfile, "%s%sftpleech_url%d",
			value, (p_checkp(value) ? "" : "/"), getpid());

	// Read the urls
	while((fgets(buffer, LINEBUF, fp)))
	{
		int len,area_id=0;

		len=strlen(buffer);
		len--;
		if(buffer[len]=='\n')
			buffer[len]=0;	// Remove endline
		while(len>=0 && buffer[len]!=' ')	// Find last comp == area name
			len--;
		buffer[len++]=0;
	
		if(options & OPT_VERBOSE)
			printf("url: %s\narea: %s\n", buffer, &buffer[len]);	

		p_query(src_db, "SELECT area_id FROM p_areas "
				"WHERE area_name='%s'", 
			&buffer[len]);
		sql_res=mysql_store_result(src_db);
		if(sql_res)
		{
			if((sql_row=mysql_fetch_row(sql_res)))
				area_id=atoi(sql_row[0]);
			else
			{
				fprintf(stderr, "Target area %s not found\n", &buffer[len]);
				mysql_free_result(sql_res);
				continue;
			}
			mysql_free_result(sql_res);
		}
		
		printf("%d\n", area_id);

		umask(066);
		dp=fopen(tmpfile, "w");
		if(!dp)
		{
			fprintf(stderr, "Urk, unable to open %s\n", tmpfile);
			break;
		}
		fprintf(dp, "%s\n", buffer);
		fclose(dp);
		umask(002);

		// FIXME: Patched fget still does dupechecking
		if(!(options & OPT_SLOPPY))
			sprintf(combuf, "fget -a %d -I %s", area_id, tmpfile);
		else
			sprintf(combuf, "fget -I %s", tmpfile);

		system(combuf);

		remove(tmpfile);

		// collapse the dir tree created by fget
		collapsedir(".",0);
		
		p_adopt(tmppath, area_id, options|OPT_MOVE|OPT_STATS);

	}
	
	fclose(fp);
	
	chdir(olddir);

	remove(tmppath);

	return(0);
}

/*
 * This will recursively collapse a dir tree under a given
 * dir to flat. (all files in subdirs are moved to the base
 * dir, then subdirs are removed)
 * 
 * When calling, always use level=0. 
 *
 */
int collapsedir(char *dirname, int level)
{
	DIR *dirp;
	struct dirent *dirdata;
	struct stat st;

//	printf("Dir: %s\n", dirname);

	dirp=opendir(dirname);
	if(!dirp)
		return(1);
	
	chdir(dirname);

	while((dirdata=readdir(dirp)))
	{
		if(!strcmp(dirdata->d_name, ".") || !strcmp(dirdata->d_name, ".."))
			continue;

		stat(dirdata->d_name, &st);
		if(S_ISDIR(st.st_mode))
		{
			collapsedir(dirdata->d_name,level+1);
			remove(dirdata->d_name);
		}
	}
	
	closedir(dirp);

	if(level>0)
	{
//		printf("level %d, mov\n", level);
		system("mv -f * ..");
		chdir("..");
	}
	
	return(0);
}

