/*
 * PIMPPA - describe files in current dir
 * 
 * Usage: pdesc <files> ["Des cript ion"]
 *
 */

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "pimppa.h"

void usage(char *name)
{
	fprintf(stderr, "Usage: %s [files] [\"Desc\"]\n\n", name);
}

int main(int argc, char *argv[])
{
	char src_lastcomp[PATH_MAX];
	char src_true[PATH_MAX];
	unsigned long src_id;
	MYSQL *db;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int i,files_described=0;
	char *escaped_desc=NULL;

	if(argc<3)
	{
		usage(argv[0]);
		return(-1);
	}

	db=p_connect();
	if(!db)
		return(-1);

	if(!getcwd(src_true, PATH_MAX))
	{
		fprintf(stderr, "getcwd() failure.\n");
		return(-1);
	}

	if(src_true[strlen(src_true)-1]!='/')
		strcat(src_true, "/");

	for(i=strlen(src_true)-2;i>=0;i--)			// Find last dir component
	{
		if(src_true[i]=='/')
			break;
	}
	strcpy(src_lastcomp, &src_true[i]);

//	printf("'%s' '%s'\n", src_true, src_lastcomp);

/************** get source area *****************************/

	p_query(db, "SELECT area_id "
 		    "FROM p_areas " 
		    "WHERE area_path like '%%%s'", 
		src_lastcomp);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "Error: %s\n", mysql_error(db));
		return(-1);
	}
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row)
		{
			src_id=atoi(sql_row[0]);
		}
		else
		{
			fprintf(stderr, "Current dir '%s' doesn't match any area in the db.\n", src_true);
			return(-1);
		}

		mysql_free_result(sql_result);
	}
	else
		return(-2);

//	printf("Proot!\n");

/************** prepare desc  *******************************/
	
	escaped_desc=malloc(2*strlen(argv[argc-1]));
	if(!escaped_desc)
		return(-5);

	mysql_escape_string(escaped_desc, argv[argc-1], strlen(argv[argc-1]));
	
/************ Ok, desc files ****************/

	for(i=1;i<argc-1;i++)
	{
		char escaped_fn[2*P_LEN_FILE_NAME+1];

		mysql_escape_string(escaped_fn, argv[i], strlen(argv[i]));

//		fprintf(stderr, "This: %s\n", argv[i]);

		p_query(db, "UPDATE p_files SET file_desc='%s' "
			    "WHERE file_name='%s' AND file_area=%ld",
			escaped_desc, escaped_fn, src_id);
		if(mysql_error(db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(db));
			return(-4);
		}
		
		files_described++;
	}
	
	mysql_close(db);

	if(files_described)
		fprintf(stderr, "%d files described...\n", files_described);

	free(escaped_desc);

	return(0);
}

