#
#  KDEB.pm
#    $Last modified: Mon Dec 13 14:11:19 1999$
#                   Copyright (c) 1999 kamop
#  $Id: KDEB.pm,v 1.1 1999/12/06 09:50:15 kamop Exp $
# 

package KDEB;

use strict;
use FileHandle;

my($debug) = 1;
my(@priority_array) = ("extra","optional","standard","important","required");
#my(@required_fields) = ('Depends', 'Recommends', 'Suggests');
my(@required_fields) = ('Depends', 'Pre-Depends', 'Recommends');

my($pltag) = 'LEVEL';

sub new{
  my $myself = {};
  bless $myself;
  return $myself;
} # end of new

## Read Configuration file
sub conf_read{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($file) = $ref{'file'};
  my($debug) = defined($ref{'debug'}) ? $ref{'debug'} : 0;
  my($fh, $res) = &open_file(file=>$file);
  die if($res == 0);
  return(&fileconf_read(fh=>$fh, debug=>$debug));
} ## conf_new

#######################################################################
## - struct PAC HASH
##   NA                 ѥå̾          PACN_names()
##   C::package         ѥå̾åѿ  PACN_check()
##   D::package::info   ѥå            PACN_info()
##   P::package         ۥѥå̾          PACN_provide()
##   PA                 ۥѥå̾      PACN_provides()
##     package := ѥå̾
##     info := PackagesեΥPackageϽ
## - struct PACF 
##   - ǤHASH¤
##     id                  ID
##     file               ѥåե̾
##     base_dir           ѥåǥ쥯ȥ
##     PAC                pac ؤΥե
## - ؿ PACN_
#######################################################################
sub PAC_new{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my(%pac);
  my(@names) = ();
  my($tag_names) = &PACN_names();
  $pac{$tag_names} = \@names;
  return(\%pac);
} ## PAC_new

#######################################################################
## MODULE: PACF_read_packages
## DESC: Packagesեɤ߹
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub PACF_read_packages{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($pacf) = $ref{'PACF'};
##
  my($tag_names) = &PACN_names();
  my($i);
  my($fh, $res, $pac);
  for($i = 0; $i <= $#{$pacf}; $i++){
    ($fh, $res) = &open_file(file=>$pacf->[$i]->{'file'});
    next if($res == 0);
    $pac = &PAC_read_package(fh=>$fh);
    $pacf->[$i]->{'PAC'} = $pac;
    print STDERR $pacf->[$i]->{'id'}." => ".$#{$pac->{$tag_names}}." Packages.\n"
      if($debug & 1);
    $fh->close();
  } ## for($i)
} ## PACF_read_packages

#######################################################################
## MODULE: PACF_new
## DESC: conf  PACF 
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub PACF_new{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($conf) = $ref{'conf'};
##
  my($id);
  my($tag_base);
  my(@pacf) = ();
  foreach $id (@{$conf->{'pacfiles'}}){
    $tag_base = "pacfile::".$id."::";
    my($pac) = {};
    $pac->{"id"} = $id;
    $pac->{"file"} = $conf->{"base_dir"}."/".$conf->{$tag_base."file"};
    $pac->{"base_dir"} = $conf->{$tag_base."base_dir"};
    push(@pacf, $pac);
  } ## foreach $id
  return(\@pacf);
} ## PACF_new

#######################################################################
#######################################################################
#######################################################################

#######################################################################
#######################################################################
## СӴؿ
#######################################################################
## MODULE: compare_version
## DESC: 2ĤΥѥåС
## IN:
##    ver_a  
##    ver_b  
## OUT:
##      0: a == b
##      1: a >  b
##     -1: a <  b
## OP:
## STATUS:
## END:
sub compare_version{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($ver_a) = $ref{'ver_a'};
  my($ver_b) = $ref{'ver_b'};
##
  my($res);
  ## եȥС Debian СʬΥ
  my($upper_a, $lower_a) = &divide_version(ver=>$ver_a);
  my($upper_b, $lower_b) = &divide_version(ver=>$ver_b);
  $res = &compare_version_each(ver_a=>$upper_a, ver_b=>$upper_b);
  return($res) if($res != 0);
  $res = &compare_version_each(ver_a=>$lower_a, ver_b=>$lower_b);
  return($res);
} ## compare_version()

#######################################################################
## MODULE: compare_version_each
## DESC: С
## IN:
##    ver_a  
##    ver_b  
## OUT:
## OP:
## STATUS:
## END:
sub compare_version_each{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($ver_a) = $ref{'ver_a'};
  my($ver_b) = $ref{'ver_b'};
##
  my($digit_a, $digit_b, $str_a, $str_b, $len_a, $len_b, $length);
  while(($ver_a ne '') && ($ver_b ne '')){
    ## ŪӤǤСѴ
    ($digit_a, $ver_a) = &get_arithmetic_version(ver=>$ver_a);
    ($digit_b, $ver_b) = &get_arithmetic_version(ver=>$ver_b);
    return(-1) if($digit_a < $digit_b);
    return(1) if($digit_a > $digit_b);
    return(-1) if(($ver_a eq '') && ($ver_b ne ''));
    return(1) if(($ver_a ne '') && ($ver_b eq ''));
    ($str_a, $ver_a) = &get_string_version(ver=>$ver_a);
    ($str_b, $ver_b) = &get_string_version(ver=>$ver_b);
    $len_a = length($str_a);
    $len_b = length($str_b);
    $length = ($len_a < $len_b) ? $len_a : $len_b;
    return(-1) if(hex(substr($str_a, 0, $length)) <
                  hex(substr($str_b, 0, $length)));
    return(1) if(hex(substr($str_a, 0, $length)) >
                 hex(substr($str_b, 0, $length)));
    return(-1) if($len_a < $len_b);
    return(1) if($len_a < $len_b);
  } ## while
  return(0);
} ## compare_version_each()

#######################################################################
## MODULE: divide_version
## DESC: ѥåС򥽥եȥС Debian С
## IN: ver С
## OUT: (A, B)
##     A := եȥС
##     B := Debian С
## OP:
## STATUS:
## END:
sub divide_version{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  $ref{'ver'} =~ /^\s*(.*)-(.*)\s*$/;
  return($1, $2);
} ## divide_version()

#######################################################################
## MODULE: get_string_version
## DESC: ʸʬΥ
##       Сʸκǽ餫鸫ƿ . ʤʬȤʳ
##       ʸޤޤʬʬΥ
## IN:  ver := С
## OUT: (A, B)
##      A := 0-9  . ʤʸ
##      B := ¾ʸ
## OP:
## STATUS:
## END:
sub get_string_version{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($ver) = $ref{'ver'};
##
  $ver =~ /^([^0-9\.]+)(.*)$/;
  return($1, $2);
} ##

#######################################################################
## MODULE: get_arithmetic_version
## DESC: ŪӤǤСѴ
## IN:  ver := С
## OUT: (A, B)
##     A := ŪӲǽʸ
##     B := ŪԲǽʸ
## OP:
##  - :  0 Ѵ
##  - ܰʹߤ .  0 Ѵ
## STATUS:
## END:
sub get_arithmetic_version{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($ver) = $ref{'ver'};
##
  my($digit, $str);
  $ver =~ /^([0-9\.]*)(.*)$/;
  $digit = $1;
  $str = $2;
  $digit =~ tr/:/0/d;
  $digit =~ s/([\.]*)\.(.*)$/$1-$2/g;
  $digit =~ tr/./0/d;
  $digit =~ tr/-/./d;
  return($digit, $str);
} ## get_arithmetic_version

#######################################################################
#######################################################################

## PACN_ ؿ
sub PACN_names{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("NA");
} ## PACN_names()
sub PACN_check{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("C::".$ref{'name'});
} ## PACN_check()
sub PACN_info{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("D::".$ref{'name'}."::".$ref{'info'});
} ## PACN_info()
sub PACN_provide{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("P::".$ref{'name'});
} ## PACN_provide()
sub PACN_provides{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("PA");
} ## PACN_provide()

#######################################################################
#######################################################################

## PACF_
#######################################################################
## MODULE: PACF_check_name
## DESC: PACF椫ѥå̾򸡺
## IN:
## OUT:
## OP:
## STATUS:
## END:
# $PACF椫ǿΥѥåӽФɬפ
sub PACF_check_name{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PACF) = $ref{'PACF'};
  my($name) = $ref{'name'};
##
  my($i, $res);
  for($i = 0; $i <= $#{$PACF}; $i++){
    $res = &PAC_check_name(PAC=>$PACF->[$i]->{'PAC'}, name=>$name);
    return($res, $i) if($res > 0);
  } ## for($i)
  return(0, -1);
} ## PACF_check_name

#######################################################################
## MODULE: PACF_get_info
## DESC:
## IN: name := ѥå̾
##     info := PackagesեΥ
## OUT: [1] Succes(1) or fail(0)
##      [2] 줿
##      [3] եID
## OP:
## STATUS:
## END:
sub PACF_get_info{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PACF) = $ref{'PACF'};
  my($name) = $ref{'name'};
  my($iname) = $ref{'info'};
##
  my($i, $res, $info);
  for($i = 0; $i <= $#{$PACF}; $i++){
    ($res, $info) = &PAC_get_info(PAC=>$PACF->[$i]->{'PAC'},
                                  name=>$name, info=>$iname);
    return(1, $info, $i) if($res == 1);
  } ## for($i)
  return(0, "", -1);
} ## PACF_get_info()

#######################################################################
#######################################################################

## PAC_
#######################################################################
## MODULE: PAC_read_package
## DESC: Packagesեɤ߹
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub PAC_read_package{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fh) = $ref{'fh'};
##
  my($tag, $value, $line);
  my($lock) = 0;
  my($pac) = &PAC_new();
  my($name) = '';
  my($info) = '';
  my($tag_names) = &PACN_names();
  my($tag_check, $tag_info);
##
## 'A: B' => $tag=A, $value=B
## 
  while(<$fh>){
    chomp;
    $line = $_;
    if((! /^\s/) && (/^([^:]+):\s*(.*)\s*$/)){
      ## ǽ餬򤸤ʤơ"A: B"ä
      $tag = $1;
      $value= $2;
      if($tag eq 'Package'){
        $name = $value;
        ## ѥå̾Ͽ
        if(&PAC_add_name(PAC=>$pac, name=>$name, check=>'x') == 0){
          print STDERR "Duplicate package '$name'. Skip.\n";
          $lock = 1;  ## ѥå֤̾äƤ顤ʬϥå
        }
#        ## ǤˤΥѥå̾ϿƤ뤫å
#        $tag_check = &PACN_check(name=>$name);
#        if(defined($pac->{$tag_check})){
#          print STDERR "Duplicate package '$name'. Skip.\n";
#          $lock = 1;  ## ѥå֤̾äƤ顤ʬϥå
#        }else{
#          ## åHASHϿѥå̾˥ѥå̾
#          $pac->{$tag_check} = "x";
#          push(@{$pac->{$tag_names}}, $name);
#        }
      }else{
        ## 'Package' ʳΥΤȤ
        $info = $tag;
        if(($name ne '') && ($info ne '')){
          $tag_info = &PACN_info(name=>$name, info=>$info);
          $pac->{$tag_info} = $value if($lock == 0);
        }else{
          print STDERR "Error!!\n";
        }
        ## $pltag('LEVEL')ͥ١ʿˤ
        if(($tag eq 'Priority') && ($lock == 0)){
          $pac->{&PACN_info(name=>$name, info=>$pltag)} =
            &get_priority_level(priority=>$value);
        }
      } ## if($tag)
    }elsif(/^\s*$/){
      ## ĤΥѥå󤬽äƤ
      $name = '';
      $info = '';
      $lock = 0;
    }else{
      ## ³
      $pac->{$tag_info} .= "\n".$line if($lock == 0);
    } ## if()
  } ## while(<$fh>)
  ## ۥѥå̾Ͽ
  foreach $name (@{$pac->{$tag_names}}){
    $tag_info = &PACN_info(name=>$name, info=>"Provides");
    &PAC_add_provide(PAC=>$pac, name=>$name,
                     provides=>$pac->{$tag_info});
  } ## foreach $name
  return($pac);
} ## read_package

#######################################################################
## MODULE: PAC_add_package
## DESC: ѥå̾ɲä
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub PAC_add_package{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($PACF) = $ref{'PACF'};
  my($name) = $ref{'name'};
##
  my($res, $i, $provides);
  my($tag_info);
##
  ## ѥå̾
  ($res, $i) = &PACF_check_name(PACF=>$PACF, name=>$name);
  ## ѥå̾Ͽ
  ##  - åʸϥեID Ȥ
  &PAC_add_name(PAC=>$PAC, name=>$name, check=>$i);
  ## Priority򥳥ԡ
  my($tag_info);
  $tag_info = &PACN_info(name=>$name, info=>"Priority");
  $PAC->{$tag_info} = $PACF->[$i]->{"PAC"}->{$tag_info};
  $tag_info = &PACN_info(name=>$name, info=>'LEVEL');
  $PAC->{$tag_info} = $PACF->[$i]->{"PAC"}->{$tag_info};
  ## ѥå Provides 
  ($res, $provides) = &PAC_get_info(PAC=>$PACF->[$i]->{"PAC"}, name=>$name,
                                    info=>"Provides");
  ## Provides ɲ
  if(($res == 1) && ($provides ne '')){
    &PAC_add_provide(PAC=>$PAC, name=>$name, provides=>$provides);
  }
} ## PAC_add_package

#######################################################################
## MODULE: PAC_get_info
## DESC: ѥå
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub PAC_get_info{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($name) = $ref{'name'};
  my($info) = $ref{'info'};
##
  my($i);
  my($tag_info) = &PACN_info(name=>$name, info=>$info);
  if(defined($PAC->{$tag_info})){
    return(1, $PAC->{$tag_info});
  }else{
    return(0, "");
  }
} ## PAC_get_info()

#######################################################################
## MODULE: PAC_check_name
## DESC:
## IN:
## OUT:
##   0 == ѥå¸ߤʤ
##   1 == ¥ѥå
##   2 == ۥѥåȤ󶡤Ƥ
## OP:
## STATUS:
## END:
sub PAC_check_name{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($name) = $ref{'name'};
  my($ver) = $ref{'ver'};
  my($vercomp) = $ref{'vercomp'}; ## ">=" or "<="
##
  my($tag_check, $tag_provide);
  my($tag_info, $comp);
  $tag_check = &PACN_check(name=>$name);
  if(defined($PAC->{$tag_check})){
    return(1) if((! defined($ver)) || (! defined($vercomp)));
    return(1) if(($ver eq '') || ($vercomp eq ''));
    $tag_info = &PACN_info(name=>$name, info=>"Version");
    $comp = &compare_version(ver_a=>$ver, ver_b=>$PAC->{$tag_info});
    return(1) if(($vercomp eq ">=") && ($comp >= 0));
    return(1) if(($vercomp eq "<=") && ($comp <= 0));
    return(0);
  }
  ## ѥå̾ۥѥå̾ξ
  $tag_provide = &PACN_provide(name=>$name);
  return(2) if((defined($PAC->{$tag_provide})) &&
               ($#{$PAC->{$tag_provide}} >= 0));
  return(0);
} ## PAC_check_name

#######################################################################
## MODULE: PAC_add_name
## DESC: ѥå̾Ͽ롥
##       åʸͿʤ "x" ˤʤ롥
## IN: PAC
##     name   ѥå̾
##     check  åʸ
## OUT: ѥå̾ϿǤɤ
##       0 : Ǥ˥ѥå̾ϿƤΤϿʤä.
##       1 : ѥå̾Ͽ
## OP:
## STATUS:
## END:
sub PAC_add_name{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($name) = $ref{'name'};
  my($check) = ($ref{'check'} ne '') ? $ref{'check'} : "x";
##
  my($tag_names) = &PACN_names();
  my($tag_check) = &PACN_check(name=>$name);
  ## Ǥ˥ѥå̾ϿƤ 0 ֤
  return(0) if(defined($PAC->{$tag_check}));
  ## ѥå̾Ͽ
  push(@{$PAC->{$tag_names}}, $name);
  ## åʸ
  $PAC->{$tag_check} = $check;
  return(1);
} ## PAC_add_name()

#######################################################################
## MODULE: PAC_add_provide
## DESC: ۥѥå̾Ͽ
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub PAC_add_provide{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
##  my($PACF) = $ref{'PACF'};
  my($name) = $ref{'name'};
  my($provides) = $ref{'provides'};
##  
  my($tag_provide);
  my($p, $n);
 PP:
  foreach $p (split(/\s*,\s*/, $provides)){
    ## $p = ۥѥå̾
    $tag_provide = &PACN_provide(name=>$p);
    ## ۥѥå̾ä顤ۥѥåǡΰ
    if(! defined($PAC->{$tag_provide})){
      my($tag_provides) = &PACN_provides();
      ## ۥѥå̾Ͽ
      push(@{$PAC->{$tag_provides}}, $p);
      ## ¥ѥå̾Ǽΰ
      my(@provide) = ();
      $PAC->{$tag_provide} = \@provide;
    }
    ## Ǥ Provide ˥ѥå̾ϿƤ next
    foreach $n (@{$PAC->{$tag_provide}}){
      ## $n = $pʲۥѥåˤ󶡤Ƥ¥ѥå̾
      next PP if($n eq $name);
    }
    ## ۥѥå˼¥ѥå̾Ͽ
    &insert_provide(PAC=>$PAC, provide=>$p, name=>$name);
  }
  return(1);
} ## PAC_add_provide()

#######################################################################
## MODULE: PAC_get_priority_level
## DESC: ͥ٤ɽ
## IN:
##     PAC := 
##     name := ѥå̾
## OUT:
## OP:
## STATUS:
## END:
sub PAC_get_priority_level{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($name) = $ref{'name'};
##
  my($res, $priority) = &PAC_get_info(PAC=>$PAC,name=>$name,info=>'Priority');
  return(&get_priority_level(priority=>$priority));
} ## PAC_get_priority_level()

#######################################################################
#######################################################################
#######################################################################

## DSC¤

#######################################################################
## MODULE: DSC_new
## DESC:
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub DSC_new{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my(%dsc);
  my(@names) = ();
  my($tag_names) = &DSCN_names();
  $dsc{$tag_names} = \@names;
  return(\%dsc);
} ## PAC_new

## DSCN_ ؿ
sub DSCN_names{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("NA");
} ## DSCN_names

sub DSCN_binname{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("BIN::".$ref{'name'});
} ## DSCN_name

sub DSCN_filenames{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("FILES::".$ref{'name'});
}

sub DSCN_version{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("VERSION::".$ref{'name'});
}

sub DSCN_totalsize{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  return("TS::".$ref{'name'});
} ## DSCN_name

#######################################################################
## MODULE: DSC_read
## DESC:
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub DSC_read{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fh) = $ref{'fh'};
##
  my($dsc) = &DSC_new();
  my($source);
  ## mode
  ##   0 == normal
  ##   1 == Reading Files: contents
  ##   2 == Comment out
  my($mode) = 0;
  my($total_size) = 0;
  my($size, $md5sum, $file);
  my($tag_totalsize);
  my($tag_filenames);
  my($tag_version);
##
  while(<$fh>){
    chomp;
    if(/^Source:\s*(.*)/){
      $mode = 0;
      $source = $1;
      $tag_filenames = &DSCN_filenames(name=>$source);
#      print STDERR "Entry Source(".$source.").\n" if($debug & 2);
      print STDERR "Entry Source(".$source.").\n";
      my(@array) = ();
      $dsc->{$tag_filenames} = \@array;
    }
    if(/^-----BEGIN PGP SIGNATURE-----/){
      $mode = 2;
      next;
    }
    if($mode == 0){
      if(/^Binary:\s*(.*)/){
        &DSC_add_binary(DSC=>$dsc, binaries=>$1, source=>$source);
      }elsif(/^Files:\s*(.*)/){
        $mode = 1;
        $total_size = 0;
      }elsif(/^Version:\s*(.*)/){
        $tag_version = &DSCN_version(name=>$source);
        $dsc->{$tag_version} = $1;
      }
      next;
    }
    if(($mode == 2) && (/-----END PGP SIGNATURE-----/)){
      $mode = 0;
      next;
    }
    next if($mode == 2);
    ## $mode == 1
    if(/ (.*)\s+(.*)\s+(.*)/){
      $md5sum = $1;
      $size = $2;
      $file = $3;
      $total_size += $size;
      my($filehash) = {};
      $filehash->{'md5sum'} = $md5sum;
      $filehash->{'size'} = $size;
      $filehash->{'name'} = $file;
      push(@{$dsc->{$tag_filenames}}, $filehash);
#      print STDERR " $file $size\n";
    }else{
      ## 'Files:' եɽλ
      $mode = 0;
      $tag_totalsize = &DSCN_totalsize(name=>$source);
      print STDERR "  Total size of sources is ".$total_size."\n"
        if($debug & 2);
      $dsc->{$tag_totalsize} = $total_size;
    }
  } ## while(<$fh>)
  return($dsc);
} ## DSC_read

sub DSC_add_binary{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($dsc) = $ref{'DSC'};
  my($binaries) = $ref{'binaries'};
  my($source) = $ref{'source'};
##
  my($tag_bin);
  my($bin);
  foreach $bin (split(/\s*,\s*/, $binaries)){
    $tag_bin = &DSCN_binname(name=>$bin);
    $dsc->{$tag_bin} = $source;
    print STDERR "  Add binary(".$bin.") to ".$source."\n" if($debug & 2);
  } ## foreach $bin
} ## DSC_add_binary

#######################################################################
#######################################################################
#######################################################################

#######################################################################
## MODULE: get_required_packages
## DESC: $name ѥåɬפʥѥå̾
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub get_required_packages{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($name) = $ref{'name'};
#  my($packages) = $ref{'packages'};
##
  my(@add_packages);
  my($info);
##
  my($key, $p, $pp);
  my($res);
  my($add);
  ## ƥեɤȤ롥
  ##  - |(or) ϤΤޤޡ
  ##  - ,϶ڤʸ
  foreach $key (@required_fields){
    $add = &get_field_packages(PAC=>$PAC, name=>$name, field=>$key);
    push(@add_packages, @{$add});
  } ## foreach $key
  return(\@add_packages);
} ## get_required_packages

#######################################################################
## MODULE: get_field_packages
## DESC: ꤷեɤΥѥå
## IN:p
## OUT:
## OP:
## STATUS:
## END:
sub get_field_packages{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($name) = $ref{'name'};
  my($field) = $ref{'field'};
##
  my(@packages);
  my($pp, $p);
  my($res, $info) = &PAC_get_info(PAC=>$PAC, name=>$name, info=>$field);
  foreach $p (split(/\s*\,\s*/, $info)){
    my(@or_packages);
    foreach $pp (split(/\s*\|\s*/, $p)){
      push(@or_packages, $pp);
    }
    push(@packages, \@or_packages);
  } ## foreach $p
  return(\@packages);
} ## get_field_packages()

#######################################################################
## MODULE: insert_provide
## DESC: ͥ٥٥򸫤ơ¥ѥå̾ۥѥå롥
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub insert_provide{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($provide) = $ref{'provide'};
  my($name) = $ref{'name'};
##
  my($tag_provide) = &PACN_provide(name=>$provide);
  ## $name ͥ٥٥
  my($res, $pl) = &PAC_get_info(PAC=>$PAC, name=>$name, info=>$pltag);
  my($i, $n, $l);
  ## ۥѥåγǤˤĤ
  for($i = 0; $i <= $#{$PAC->{$tag_provide}}; $i++){
    ## $n = $iܤǤμ¥ѥå̾
    $n = $PAC->{$tag_provide}->[$i];
    ## $l = $n ͥ٥٥
    ($res, $l) = &PAC_get_info(PAC=>$PAC, name=>$n, info=>$pltag);
    ## $pl ͥ٤⤫ä顤ΰ֤˼¥ѥå̾
    if($l < $pl){
#      print "SPLICE $i $tag_provide $name\n";
      splice(@{$PAC->{$tag_provide}}, $i, 0, $name);
#      &debug_print_provide(PAC=>$PAC, provide=>$provide);
      return;
    }
  } ## for($i)
  ## ۥѥåκǸϿ
  push(@{$PAC->{$tag_provide}}, $name);
} ## insert_provide

#######################################################################
## MODULE: debug_print_provide
## DESC:
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub debug_print_provide{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  no strict;
  my($PAC) = $ref{'PAC'};
  my($provide) = $ref{'provide'};
  my($fhout) = $ref{'fhout'} ? $ref{'fhout'} : STDOUT;
##
  my($n, $l, $res);
  my($tag_provide) = &PACN_provide(name=>$provide);
  print $fhout "Provide(".$provide.") => ";
  foreach $n (@{$PAC->{$tag_provide}}){
    ($res, $l) = &PAC_get_info(PAC=>$PAC, name=>$n, info=>$pltag);
    print $fhout $n."(".$l.") ";
  } ## foreach $n
  print $fhout "\n";
} ## debug_print_provide

#######################################################################
## MODULE: get_priority_level
## DESC: ͥ٤Ѵ
## IN:
##     priority := ͥ̾"required""optional"ʤɡ
## OUT: A
##     A := ͥ٤Υ٥
##          ͥ٤ι⤤Τ礭ʿ
## OP:
## STATUS:
## END:
sub get_priority_level{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($priority) = $ref{'priority'};
##
  my($i);
  for($i = 0; $i <= $#priority_array; $i++){
    return($i) if($priority eq $priority_array[$i]);
  } ## for($i)
  return(-1);
} ## get_priority_level()

#######################################################################
## MODULE: get_real_package_name
## DESC: RecommendsʤɤΡС̾Υѥå̾
## IN:
## OUT: [1] ѥå̾
##      [2] С
## OP:
## STATUS:
## END:
sub get_real_package_name{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($name) = $ref{'name'};
##
  my($n, $v);
  ## 'package (>= 1.0-1)' Τ褦˥СΥѥå̾
  if($name =~ /^([^\s]*)\s*\((.*)\)/){
    $n = $1; $v = $2;
  }else{
    $n = $name; $v = '';
  } ## if($name)
  return($n, $v);
} ## get_real_package_name

#######################################################################
#######################################################################
#######################################################################

# PREF: INPUT_BEGIN "${perlib}/fileconf.pl" "fileconf"
# PREF: REGION_BEGIN "fileconf"
#  $Id: KDEB.pm,v 1.1 1999/12/06 09:50:15 kamop Exp $
#######################################################################
## MODULE: fileconf_read
## DESC:
## IN: fh := եϥɥ
##     debug := ǥХå٥ʻ꤬ʤ 0 
##       0 == Ϥʤ
##       1 == ɸŪʥǥХå
##       2 == ƤΤɽ
##       3 == Ǥɽ
##     conf := fileconfե󥹡ʻ꤬ʤϼư
## OUT:
## OP:
## STATUS:
## END:
sub fileconf_read{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fh) = $ref{'fh'};
  my($debug) = defined($ref{'debug'}) ? $ref{'debug'} : 0;
  my($conf) = defined($ref{'conf'}) ? $ref{'conf'} : {};
##
  my($command)= {
    'ARRAY' => ['gen_array'],
  };
##
  my($tag, $value);
  my($func, $cmd, $arg);
  while(<$fh>){
    chomp;
    next if(/^[\#].*/);
    if(/^CONF:\s*(\S+)\s*(.*)\s*$/){
      $cmd = $1; $arg = $2;
      $func = "fileconf_func_".$command->{$cmd}[0];
      if(defined(&$func)){
        no strict 'refs';
        &$func(conf=>$conf, arg=>$arg, debug=>$debug);
      }
    } ## if(CONF)
    next if(! /^\s*(\S+)\s*=\s*(.*)\s*$/);
    $tag = $1; $value = $2;
    $value = "" if(!defined($value));
    print STDERR "FileConf:: Parse TAG=".$tag.", VALUE=".$value."\n"
      if($debug >= 3);
    if(ref($conf->{$tag}) eq "ARRAY"){
      print STDERR "FileConf:: Insert ARRAY(".$tag.") ".$value."\n"
        if($debug >= 2);
      push(@{$conf->{$tag}}, $value);
    }else{
      if(defined($conf->{$tag})){
        print STDERR "FileConf:: Duplicate tag(".$tag.")\n"
          if($debug >= 3);
        next;
      }
      print STDERR "FileConf:: Add TAG(".$tag.") = ".$value."\n"
        if($debug >= 2);
      $conf->{$tag} = $value;
    }
  } ## while(<$fh>)
  return($conf);
} ## fileconf_read

#######################################################################
## MODULE: fileconf_func_gen_array
## DESC: ΰκ
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub fileconf_func_gen_array{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($conf) = $ref{'conf'};
  my($arg) = $ref{'arg'};
  my($debug) = $ref{'debug'};
##
  my(@array) = ();
  $conf->{$arg} = \@array;
  print STDERR "FileConf:: Generate ARRAY(".$arg.")\n"
    if($debug >= 3);
} ## fileconf_func_gen_array

#######################################################################
## MODULE: fileconf_print
## DESC: ɽ
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub fileconf_print{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($conf) = $ref{'conf'};
##
  if(ref($conf) ne 'HASH'){
    die;
  }
  my($key);
  my($akey);
  foreach $key (keys(%{$conf})){
    print $key ."  =  ";
    if(ref($conf->{$key}) eq "ARRAY"){
      foreach $akey (@{$conf->{$key}}){
        print "'".$akey."' ";
      } ## foreach $akey
      print "\n";
    }elsif(ref($conf->{$key}) eq "HASH"){
      print STDERR "Not supported hash. Why?\n";
      next;
    }else{
      print $conf->{$key}."\n";
    }
  } ## foreach
} ## fileconf_print

# PREF: REGION_END "fileconf"
# PREF: INPUT_END "${perlib}/fileconf.pl"

# PREF: INPUT_BEGIN "${perlib}/open_file" "open_file"
# PREF: REGION_BEGIN "open_file"
# open_file --- open file and return the file pointer
#   [REQUIRE] FileHandle
#     use FileHandle;
#   (in)
#     $file
#     $flag == '1'  return if error
#   (out)
#     ($res, $filehandle)  'result code' and 'file pointer'
# Usage:
#   ($filehandle, $res) = open_file(file=>'file_name');
#   return if($res == 0);   # file open error
sub open_file{
  my $self = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
  my($file) = $ref{'file'};
#  my($flag) = $ref{'flag'};
  my($fh);
  my($res) = 0;
  no strict 'subs';
  die "open_file:File name is empty.\n" if($file eq '');
  if($file eq '-'){
    $fh = STDIN;
    $res = 1;
  }else{
    if($file =~ /\.gz$/){
      $file = "gzip -cd $file |";
    } # end of if
    $fh = new FileHandle;
    $res = $fh->open($file);
  }
  return($fh, $res);
} # end of open_file
sub close_file{
  my $self = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fh) = $ref{'fh'};
##
  no strict 'subs';
  if($fh eq STDIN){
    return;
  }else{
    $fh->close;
    return;
  }
}
# PREF: REGION_END "open_file"
# PREF: INPUT_END "open_file"
#######################################################################
1;
# Local Variables:
# End:
