/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef __PGT_MODEL_H__
#define __PGT_MODEL_H__

#include <glib.h>
#include <glib-object.h>
#include "pgt-view.h"

G_BEGIN_DECLS

#define PGT_TYPE_MODEL                  (pgt_model_get_gtype ())
#define PGT_MODEL(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGT_TYPE_MODEL, PgtModel))
#define PGT_MODEL_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), PGT_TYPE_MODEL, PgtModelClass))
#define PGT_IS_MODEL(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGT_TYPE_MODEL))
#define PGT_IS_MODEL_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), PGT_TYPE_MODEL))
#define PGT_MODEL_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), PGT_TYPE_MODEL, PgtModelClass))

typedef struct _PgtModel PgtModel;
typedef struct _PgtModelClass PgtModelClass;

GType pgt_model_get_gtype (void);

PgtModel* pgt_model_new (PgtView *view);

gchar const * pgt_model_get_gallery_name (PgtModel *self);
gchar const * pgt_model_get_album_name (PgtModel *self);
gchar const * pgt_model_get_album_date (PgtModel *self);
gchar const * pgt_model_get_album_desc (PgtModel *self);
gchar const * pgt_model_get_photo_dir (PgtModel *self);
gboolean      pgt_model_get_option (PgtModel *self, PgtConvertOption opt);

gboolean pgt_model_add_gallery (PgtModel *self, gchar const *name, gchar const *url);
gboolean pgt_model_del_gallery (PgtModel *self, gchar const *name);

G_END_DECLS

#endif /* __PGT_MODEL_H__ */
