#ifndef _WCETYPES_H_
#define _WCETYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef Bool
typedef int            Bool;
#endif
#ifndef TRUE
enum    bools {FALSE, TRUE};
#endif
typedef char           Char;
typedef double         Double;
#ifdef dblflt
typedef double         Float;
#else
typedef float          Float;
#endif
typedef int            Int;
typedef long           Long;
#if 1
typedef long long      Quad;
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX  0x7fffffffffffffff
#define LONG_LONG_MIN  (-LONG_LONG_MAX-1L)
#endif
#define QUAD_MAX       LONG_LONG_MAX
#define QUAD_MIN       LONG_LONG_MIN
#else
typedef __int64        Quad;
#define QUAD_MAX       _I64_MAX
#define QUAD_MIN       _I64_MIN
#endif
#ifndef _QuadFmt_
#define _QuadFmt_
#define QuadFmt(x)     "%"#x "I64d"
#endif
typedef char         * Ptr;
typedef short          Short;
typedef void           Void;

typedef unsigned       Uns;
typedef unsigned char  UChar;
typedef unsigned int   UInt;
typedef unsigned long  ULong;
typedef unsigned short UShort;

typedef Long           LONG;
#ifndef VXWORKS
typedef ULong          ULONG;
#endif
typedef ULONG         *PULONG;
typedef UShort         USHORT;
typedef USHORT        *PUSHORT;
typedef UChar          UCHAR;
typedef UCHAR         *PUCHAR;
typedef Char          *PSZ;
typedef Void          *PVOID;

typedef Void          *HANDLE;
typedef Void          *HMODULE;

#define IN
#define FAR
#define OUT
#define OPTIONAL

#define __cdecl
#define __export
#define __stdcall


#undef  far
#undef  near
#undef  pascal

#define far
#define near
#define CONST          const

typedef ULong          DWORD;
#ifndef XWINDOWS
typedef Bool           BOOL;
#else
#ifndef XMD_H
typedef int            BOOL;
#endif
#endif
typedef UChar          BYTE;
typedef UShort         WORD;
typedef Char           CHAR;
typedef Char          *PCHAR;
typedef Float          FLOAT;
typedef Float         *PFLOAT;
typedef Bool          *PBOOL;
typedef Bool          *LPBOOL;
typedef Char          *PBYTE;
typedef Char          *LPBYTE;
typedef Int           *PINT;
typedef Int           *LPINT;
typedef UShort        *PWORD;
typedef UShort        *LPWORD;
typedef Long          *LPLONG;
typedef Long          *PLONG;
typedef ULong         *PDWORD;
typedef ULong         *LPDWORD;
typedef Void          *HKEY;
typedef HKEY          *PHKEY;
typedef Void           VOID;
typedef Void          *LPVOID;
typedef const Void    *LPCVOID;
typedef Int            INT;
typedef UInt           UINT;
typedef UInt          *PUINT;

typedef Quad           QWORD;
typedef Quad          *PQWORD;

typedef UShort         WCHAR;
typedef UShort         TCHAR;
typedef UShort        *PWCHAR;
typedef Char          *PSTR;
typedef UShort        *PWSTR;
typedef UShort        *LPWSTR;
typedef const UShort  *PCWSTR;
typedef const UShort  *LPCWSTR;
typedef const UShort  *LPTSTR;
typedef const Char    *LPCSTR, *PCSTR;
typedef const Char   **LPPCSTR, *PPCSTR;
typedef Ptr            LPSTORAGE;
typedef Ptr            LPSTR;

/* Function pointer types used in various interfaces */
typedef void (*LPFNDESTROYED) (void);

/* Types for passing & returning polymorphic values */
typedef UInt   WPARAM;
typedef Long   HRESULT;
typedef Long   SCODE;
typedef Long  *PSCODE;
typedef Long   LPARAM;
typedef Long   LRESULT;
typedef UShort LANGID;

/* Registry Types */
typedef DWORD  ACCESS_MASK;

/* The HWND typedef */
typedef Void  *HWND;

typedef Void        *RECT;
typedef const Void  *LPCRECT;

#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))

#ifdef __cplusplus
}
#endif
#endif /* _WCETYPES_H_ */

