//
// PipeStream.cpp
//
// $Id: //poco/1.2/Foundation/src/PipeStream.cpp#1 $
//
// Library: Foundation
// Package: Processes
// Module:  PipeStream
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/PipeStream.h"


namespace Poco {


//
// PipeStreamBuf
//


PipeStreamBuf::PipeStreamBuf(const Pipe& pipe, openmode mode): 
	BufferedStreamBuf(STREAM_BUFFER_SIZE, mode),
	_pipe(pipe)
{
}


PipeStreamBuf::~PipeStreamBuf()
{
}


int PipeStreamBuf::readFromDevice(char* buffer, std::streamsize length)
{
	return _pipe.readBytes(buffer, (int) length);
}


int PipeStreamBuf::writeToDevice(const char* buffer, std::streamsize length)
{
	return _pipe.writeBytes(buffer, (int) length);
}


void PipeStreamBuf::close()
{
	_pipe.close(Pipe::CLOSE_BOTH);
}


//
// PipeIOS
//


PipeIOS::PipeIOS(const Pipe& pipe, openmode mode):
	_buf(pipe, mode)
{
	poco_ios_init(&_buf);
}


PipeIOS::~PipeIOS()
{
	try
	{
		_buf.sync();
	}
	catch (...)
	{
	}
}


PipeStreamBuf* PipeIOS::rdbuf()
{
	return &_buf;
}


void PipeIOS::close()
{
	_buf.sync();
	_buf.close();
}


//
// PipeOutputStream
//


PipeOutputStream::PipeOutputStream(const Pipe& pipe):
	PipeIOS(pipe, std::ios::out),
	std::ostream(&_buf)
{
}


PipeOutputStream::~PipeOutputStream()
{
}


//
// PipeInputStream
//


PipeInputStream::PipeInputStream(const Pipe& pipe):
	PipeIOS(pipe, std::ios::in),
	std::istream(&_buf)
{
}


PipeInputStream::~PipeInputStream()
{
}


} // namespace Poco
