//
// ConfigurationMapper.h
//
// $Id: //poco/1.2/Util/include/Poco/Util/ConfigurationMapper.h#1 $
//
// Library: Util
// Package: Configuration
// Module:  ConfigurationMapper
//
// Definition of the ConfigurationMapper class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Util_ConfigurationMapper_INCLUDED
#define Util_ConfigurationMapper_INCLUDED


#include "Poco/Util/Util.h"
#include "Poco/Util/AbstractConfiguration.h"


namespace Poco {
namespace Util {


class Util_API ConfigurationMapper: public AbstractConfiguration
	/// This configuration maps a property hierarchy into another
	/// hierarchy.
	/// 
	/// For example, given a configuration with the following properties:
	///     config.value1
	///     config.value2
	///     config.sub.value1
	///     config.sub.value2
	/// and a ConfigurationView with fromPrefix == "config" and toPrefix == "root.conf", then
	/// the above properties will be available via the mapper as
	///     root.conf.value1
	///     root.conf.value2
	///     root.conf.sub.value1
	///     root.conf.sub.value2
	///
	/// FromPrefix can be empty, in which case, and given toPrefix == "root",
	/// the properties will be available as
	///     root.config.value1
	///     root.config.value2
	///     root.config.sub.value1
	///     root.config.sub.value2
	///
	/// This is equivalent to the functionality of the ConfigurationView class.
	///
	/// Similarly, toPrefix can also be empty. Given fromPrefix == "config" and
	/// toPrefix == "", the properties will be available as
	///     value1
	///     value2
	///     sub.value1
	///     sub.value2
	///
	/// If both fromPrefix and toPrefix are empty, no mapping is performed.
	///
	/// A ConfigurationMapper is most useful in combination with a
	/// LayeredConfiguration.
{
public:
	ConfigurationMapper(const std::string& fromPrefix, const std::string& toPrefix, AbstractConfiguration* pConfig);
		/// Creates the ConfigurationMapper. The ConfigurationMapper does not take
		/// ownership of the passed configuration.

protected:
	bool getRaw(const std::string& key, std::string& value) const;
	void setRaw(const std::string& key, const std::string& value);
	void enumerate(const std::string& key, Keys& range) const;
	
	std::string translateKey(const std::string& key) const;
	
	~ConfigurationMapper();

private:
	ConfigurationMapper(const ConfigurationMapper&);
	ConfigurationMapper& operator = (const ConfigurationMapper&);

	std::string _fromPrefix;
	std::string _toPrefix;
	AbstractConfiguration* _pConfig;
};


} } // namespace Poco::Util


#endif // Util_ConfigurationMapper_INCLUDED
