/*
 *  This file is part of Poedit (http://www.poedit.net)
 *
 *  Copyright (C) 2003-2005 Vaclav Slavik
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE. 
 *
 *  $Id: chooselang.h 1175 2007-10-03 06:38:00Z vaclavslavik $
 *
 *  Functions for choosing UI language
 *
 */

#ifndef _CHOOSELANG_H_
#define _CHOOSELANG_H_

#include <wx/string.h>
#include <wx/intl.h>

#if defined(__UNIX__) && !defined(__WXMAC__)
    #define NEED_CHOOSELANG_UI 0
#else
    #define NEED_CHOOSELANG_UI 1
#endif

#if NEED_CHOOSELANG_UI
/// Let the user select language
wxLanguage ChooseLanguage();

/// Let the user change UI language
void ChangeUILanguage();
#endif

/** Return currently choosen language. Calls  ChooseLanguage if neccessary. */
wxLanguage GetUILanguage();

#endif
