#! /usr/bin/env python

# Date last modified:
# Time-stamp: <2004-08-30 10:22:28 olandgren>

import os
import sys
import re
import string
import getopt

class StraceFilter:
    def __init__(self):
        self.file = ""
        self.filterHome = "/afs/rcf/project/selinux/src/garrison/strace.filters"
        # This regex finds those lines which begin with the desired information
        # fstat64, stat64, accept
        self.lineRe = re.compile("^open|^close|^read|^write|^open_mmap|^connect|^bind|^execve|^unlink")
        # This regular expression recognizes lines which end in
        # negative values
        self.negRe = re.compile(" = -1 ")

    def filterData(self, file):
        # Find only those lines beginning with open, close, read,
        # write
        matches = list()
        for line in file:
            if self.lineRe.match(line):
                matches.append(line)

        # Matches now contains only those lines which begin with open, close, read, or write
        worthwhile = list()
        for line in matches:
            if (not (self.negRe.match(line))):
                # Keep this line
                worthwhile.append(line)

        # Apply transformations
        output = list()
        for line in worthwhile:

            # Turn leftparen into a tilde
            temp = string.replace(line, "(", "~")
            temp = string.replace(temp, " = ", "~")
            # Eliminate these characters
            temp = re.compile("[)<>,\"\#]").sub("", temp)

            #Compact multiple spaces to a single space
            temp = re.compile(r"\s+").sub(" ", temp)

            # Remove space in front of tildes
            temp = re.compile(" ~").sub("~", temp)
            # compact the system_u: context
            temp = re.compile(" system_u:").sub("~system_u:", temp)
            # Compact the user_u context
            temp = re.compile(" user_u:").sub("~user_u:", temp)
            # Add tildes in front of words
            # The (?!$) says that if the next character is the end of the string,
            # then we shouldn't put a tilde in.
            translated = re.compile(" (?!$)").sub("~", temp)
            output.append(translated)

        for line in output :
            print line

# If we need to change this later
class UnfilteredStraceFilter(StraceFilter):
    pass

def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hu", ["help", "unfiltered"])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    s = None
    for o,a in opts:
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o in ("-u, --unfiltered"):
            s = UnfilteredStraceFilter()

    if s == None:
        s = StraceFilter()

    s.filterData(sys.stdin)

def usage():
    print """
    Usage:
    cat <strace output> | python filter.strace.py | python track.fd.py >
    <output file>

    Options:
    -h, --help:          Print this message
    -u, --unfiltered:    Utilize output from a non-security-enabled strace
    """

if __name__ == "__main__":
    main()
