/*
 * Modified for QT style "Polymer"
 * Copyright 2004-2005, Adam Jakubek <mig21@static.int.pl>
 *
 * Copyright 2003, Sandro Giessl <ceebx@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MISC_H
#define __MISC_H

QColor alphaBlendColors(const QColor &backgroundColor, const QColor &foregroundColor, const int alpha);
    
enum GradientType { VerticalGradient, HorizontalGradient,
                    DiagonalGradient, CrossDiagonalGradient,
                    PyramidGradient, RectangleGradient,
                    PipeCrossGradient, EllipticGradient };

QPixmap& pixmapGradient(QPixmap &pixmap, const QColor &ca,
	const QColor &cb, GradientType eff, int ncols = 3);

QImage& imageBlend(const QColor& clr, QImage& dst, float opacity);
QImage& imageBlend(QImage& src, QImage& dst, float opacity);

#endif // __MISC_H
