/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libpolyxmass-reportopt.h"
#include "libpolyxmass-prop.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmReportOpt *
libpolyxmass_reportopt_new (void)
{
  PxmReportOpt *reportopt = g_malloc0 (sizeof (PxmReportOpt));
  
  reportopt->propGPA = g_ptr_array_new ();

  return reportopt;
}

PxmProp*
libpolyxmass_reportopt_prop_new (void)
{
  PxmProp *prop = libpolyxmass_prop_new ();
  
  PxmReportOpt *reportopt = libpolyxmass_reportopt_new ();
  
  libpolyxmass_prop_set_name (prop, "REPORTOPT");
  
  prop->data = (gpointer) reportopt;

  prop->custom_dup = libpolyxmass_reportopt_prop_dup;
  prop->custom_cmp = libpolyxmass_reportopt_prop_cmp;
  prop->custom_free = libpolyxmass_reportopt_prop_free;
  
  return prop;
}


PxmReportOpt *
libpolyxmass_reportopt_dup (PxmReportOpt *reportopt, PxmHowDup how_dup)
{
  PxmReportOpt *reportopt_new = NULL;
  
  g_assert (reportopt != NULL);
  
  reportopt_new = g_malloc0 (sizeof (PxmReportOpt));

  reportopt_new->polymer_opt = reportopt->polymer_opt;
  reportopt_new->oligomer_opt = reportopt->oligomer_opt;
  reportopt_new->monomer_opt = reportopt->monomer_opt;

  reportopt_new->calcopt = reportopt->calcopt;

  reportopt_new->line_chars = reportopt->line_chars;
  reportopt_new->page_lines = reportopt->page_lines;

  reportopt_new->export_format = reportopt->export_format;
  reportopt_new->codes_per_div = reportopt->codes_per_div;

  g_assert (reportopt->propGPA != NULL);

  reportopt_new->propGPA = 
    libpolyxmass_prop_GPA_dup (reportopt->propGPA, how_dup);

  return reportopt_new;
}


gboolean
libpolyxmass_reportopt_copy_not_deep (PxmReportOpt *dest, 
				      PxmReportOpt *src)
{
  
  g_assert (src != NULL);
  g_assert (dest != NULL);
  

  dest->polymer_opt = src->polymer_opt;
  dest->oligomer_opt = src->oligomer_opt;
  dest->monomer_opt = src->monomer_opt;

  dest->calcopt = src->calcopt;

  dest->line_chars = src->line_chars;
  dest->page_lines = src->page_lines;

  dest->export_format = src->export_format;
  dest->codes_per_div = src->codes_per_div;


  
  /* Copy is not deep, and thus we do not deal with the array of prop
     objects.
  */
  return TRUE;
}


PxmProp *
libpolyxmass_reportopt_prop_dup (PxmProp *prop, PxmHowDup how_dup)
{
  PxmProp *prop_new = NULL;
  PxmReportOpt *reportopt_new = NULL;
  
  g_assert (prop != NULL);
  
  prop_new = libpolyxmass_prop_new ();
  libpolyxmass_prop_set_name (prop_new, prop->name);

  reportopt_new = 
    libpolyxmass_reportopt_dup ((PxmReportOpt *) prop->data, how_dup);
  prop_new->data = (gpointer) reportopt_new;
  
  /* And now set the pointer to the prop's housekeeping functions:
   */
  g_assert (prop->custom_dup != NULL);
  prop_new->custom_dup = prop->custom_dup ;

  g_assert (prop->custom_cmp != NULL);
  prop_new->custom_cmp = prop->custom_cmp;

  g_assert (prop->custom_free != NULL);
  prop_new->custom_free = prop->custom_free;
  
  return prop_new;
}


  /* DATA MODIFYING FUNCTIONS
   */
gboolean
libpolyxmass_reportopt_set_default (PxmReportOpt *reportopt) 
{
  g_assert (reportopt != NULL);
  
  reportopt->polymer_opt |= PXM_PLM_REPORTOPT_CALCOPTIONS 
    | PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES
    | PXM_PLM_REPORTOPT_SELECTION_MASSES;
  
  reportopt->oligomer_opt |= PXM_OLM_REPORTOPT_CALCOPTIONS
    | PXM_OLM_REPORTOPT_SEQUENCE
    | PXM_OLM_REPORTOPT_MONO_MASS
    | PXM_OLM_REPORTOPT_AVG_MASS;
      
  /*
    reportopt->monomer_opt |= PXM_MNM_REPORTOPT_PROP;
  */
  
  reportopt->export_format = EXPORT_FORMAT_TEXT;

  return TRUE;
}


/* COMPARISON FUNCTIONS -- PROP AND NO-PROP --
 */
gint
libpolyxmass_reportopt_cmp (PxmReportOpt *reportopt1, 
			    PxmReportOpt *reportopt2,
			    PxmHowCmp how_cmp)
{
  gint result = 0;



  g_assert (reportopt1 != NULL);
  g_assert (reportopt2 != NULL);
  
  /* We do not use how_cmp yet.
   */
  result += (reportopt1->polymer_opt != reportopt2->polymer_opt);
  result += (reportopt1->oligomer_opt != reportopt2->oligomer_opt);
  result += (reportopt1->monomer_opt != reportopt2->monomer_opt);

  result += (reportopt1->calcopt != reportopt2->calcopt);

  result += (reportopt1->line_chars != reportopt2->line_chars);
  result += (reportopt1->page_lines != reportopt2->page_lines);

  result += (reportopt1->export_format != reportopt2->export_format);

  result += (reportopt1->codes_per_div != reportopt2->codes_per_div);
  
  /* FIXME: We should compare all the different prop objects in the
     propGPA.
   */
  return result;
}

gint
libpolyxmass_reportopt_prop_cmp (PxmProp *prop1, PxmProp *prop2, 
				 PxmHowCmp how_cmp)
{
  PxmReportOpt *reportopt1 = NULL;
  PxmReportOpt *reportopt2 = NULL;
  
  g_assert (prop1 != NULL);
  g_assert (prop2 != NULL);

  
  reportopt1 = (PxmReportOpt *) prop1->data;
  reportopt2 = (PxmReportOpt *) prop1->data;
  
  g_assert (reportopt1 != NULL);
  g_assert (reportopt2 != NULL);
  
  return libpolyxmass_reportopt_cmp (reportopt1, reportopt2, 
				     how_cmp);
}





/* FREE'ING FUNCTIONS
 */
gint 
libpolyxmass_reportopt_free (PxmReportOpt *reportopt)
{
  g_assert (reportopt != NULL);
  
  /* Free inner material first.
   */
  if (reportopt->propGPA != NULL)
    libpolyxmass_prop_GPA_free (reportopt->propGPA);

  
  g_free (reportopt);
  
  return TRUE;
}


gint 
libpolyxmass_reportopt_prop_free (PxmProp *prop)
{
  g_assert (prop != NULL);
  
  if (prop->name != NULL)
    g_free (prop->name);
  
  if (prop->data != NULL)
    libpolyxmass_reportopt_free ((PxmReportOpt *) prop->data);
  
  g_free (prop);
  
  return 1;
}
