/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PXMCHEM_MODIF_H
#define PXMCHEM_MODIF_H

#include "libpolyxmass-globals.h"
#include "pxmchem-polchemdef.h"
#include "libpolyxmass-prop.h"
#include "libpolyxmass-masspair.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  /* typedef's
   */
  typedef struct _PxmModif PxmModif;

  struct _PxmModif
  {
    gchar *name;
    gchar *actform;
    GPtrArray *propGPA;
  };


  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS, INITING FUNCTIONS ...
   */
  PxmModif *
  pxmchem_modif_new (void);


  PxmModif *
  pxmchem_modif_new_by_name (gchar *name, GPtrArray *GPA);


  PxmModif *
  pxmchem_modif_dup (const PxmModif *modif, PxmHowDup how_dup);

  PxmProp *
  pxmchem_modif_prop_dup (PxmProp *prop, PxmHowDup how_dup);
  
  gboolean
  pxmchem_modif_set_name (PxmModif *modif, gchar *name);


  gboolean
  pxmchem_modif_set_actform (PxmModif *modif, gchar *actform);


  /* COMPARISON FUNCTIONS -- PROP AND NO-PROP --
   */
  gint
  pxmchem_modif_cmp (PxmModif *modif1, PxmModif *modif2, PxmHowCmp how_cmp);
  
  gint
  pxmchem_modif_prop_cmp (PxmProp *prop1, PxmProp *prop2, PxmHowCmp how_cmp);
  

  /* INTEGRITY CHECKING FUNCTIONS
   */
  gboolean
  pxmchem_modif_validate (PxmModif *modif, GPtrArray *atom_refGPA, 
			  gchar **valid);
  
  gboolean
  pxmchem_modif_unique_by_name (PxmModif *modif, 
				GPtrArray *GPA);

  gboolean
  pxmchem_modif_check_actform_syntax (PxmModif *modif);


  /*  LOCATING FUNCTIONS
   */
  gint
  pxmchem_modif_get_index_by_name (gchar *name, GPtrArray *GPA);


  gint
  pxmchem_modif_get_index_top_by_name (gchar *name, GPtrArray *GPA);


  gint
  pxmchem_modif_get_index_bottom_by_name (gchar *name, GPtrArray *GPA);


  gint
  pxmchem_modif_get_index_by_ptr (PxmModif *modif, GPtrArray *GPA);


  PxmModif *
  pxmchem_modif_get_ptr_by_name (gchar *name, GPtrArray *GPA);




  /* MASS/ELEMENTAL COMPOSITION ACCOUNTING FUNCTIONS
   */
  gboolean
  pxmchem_modif_account_mass_by_name (gchar *name,
				      GPtrArray *modifGPA,
				      GPtrArray *atom_refGPA,
				      gint times,
				      PxmMasspair *masspair);
  
  gboolean
  pxmchem_modif_account_elemcompos_by_name (gchar *name,
					    GPtrArray *modifGPA,
					    GPtrArray *atom_refGPA,
					    gint times,
					    GPtrArray *acGPA);
  



  /* UTILITY FUNCTIONS
   */



  /* XML-format TRANSACTIONS
   */
  gchar *
  pxmchem_modif_format_xml_string_mdf (PxmModif *modif, 
				       gchar *indent, gint offset);


  PxmModif *
  pxmchem_modif_render_xml_node_mdf (xmlDocPtr xml_doc,
				     xmlNodePtr xml_node,
				     gpointer user_data);


  /* FREE'ING FUNCTIONS
   */
  gboolean
  pxmchem_modif_free (PxmModif *modif);

  gint
  pxmchem_modif_prop_free (PxmProp *prop);
  
  /* GPtrArray-RELATED FUNCTIONS
   */
  gint
  pxmchem_modif_GPA_empty (GPtrArray *GPA);
  
  gint
  pxmchem_modif_GPA_free (GPtrArray *GPA);

  gint
  pxmchem_modif_GPA_prop_free (PxmProp *prop);
  


#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* PXMCHEM_MODIF_H */

