/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxcalc-globals.h"
#include "polyxcalc-calcctxt.h"

gboolean
polyxcalc_init (void)
{

  /* Initialize the array that will contain all the polyxcalc contexts
     (PxmCalcCtxt instances) made on behalf of the polymer mass
     calculator (polyxcalc).
  */
  polyxcalc_calcctxtGPA = g_ptr_array_new ();

  polyxcalc_uninitialized = FALSE;
  
  return TRUE;
}


gboolean
polyxcalc_uninit (void)
{
  /* Since this function might be called more than once in a single 
     GNU polyxmass session, we must ensure that what we might free 
     here in the first run does not get freed a second time, otherwise
     crash guaranteed!
  */
  if (polyxcalc_uninitialized == TRUE)
    return TRUE;
  
  
  polyxcalc_calcctxt_GPA_free (polyxcalc_calcctxtGPA);
  
  polyxcalc_uninitialized = TRUE;
  
  return TRUE;
}
