/*
Addressbook.h
*/

#ifndef __ADDRESSBOOK_H
#define __ADDRESSBOOK_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Language.h"
#include "Utils.h"
#include "XString.h"
#include "XVector.h"
#include "UserOptions.h"

typedef struct
  {
  XString Nickname, Fullname, Addresses, Fcc, Comment;
  } TEntry, *PEntry;

typedef XVector<TEntry> TAgenda;

void FlipEntries (const void *e1, const void *e2);
int CompareEntriesByNickname  (const void *e1, const void *e2);
int CompareEntriesByFullname  (const void *e1, const void *e2);
int CompareEntriesByFcc (const void *e1, const void *e2);
int CompareEntriesByAddresses (const void *e1, const void *e2);
      
class Addressbook
  {
  private:
    LINEA fnaddressbook;
    TAgenda agenda;
    bool MODIFIED;
    UserOptions *uo;
    int sortby;
    char *getToken (const char *linea, int numtoken, TBuffer token);
    void initEntry (TEntry *aentry);
    void setNickname (int pos, char *value);
    void setFullname (int pos, char *value);
    void setAddresses (int pos, char *value);
    void setFcc (int pos, char *value);
    void setComment (int pos, char *value);
  public:
    Addressbook (const char *fn, UserOptions *auo);
    virtual ~Addressbook ();
    void setSortby (int asortby);
    bool SaveAddressbook (void);
    bool SaveAddressbookAs (const char *fn);    
    void Clear (void);
    void SORT (int asortby);
    void readAddressbook (void); 
    int Count (void);
    char *getFulllinea (int pos);
    const char *getNickname (int pos);
    const char *getFullname (int pos);
    const char *getAddresses (int pos);
    char *getMultiAddresses (const char *positions);
    const char *getFcc (int pos);
    const char *getComment (int pos);
    bool DeleteEntries (const char *positions);
    void UpdateEntryFromFile (int numentry, char *fn);
    int AddNewEntry (void);
    int AddNewEntry (const char *addresses);
  };
 
#endif


  


  
