/*
Configuration.h
*/

#ifndef __CONFIGURATION_H
#define __CONFIGURATION_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "Utils.h"
#include "Config.h"
#include "XString.h"
#include "XVector.h"

typedef XVector<XString> StringList;

const int XXLINE_LEN_MAX = 300;
const int XXBUFFERSIZE   = XXLINE_LEN_MAX + 2;

class Configuration
  {
  private:
    XString fnconf;
    StringList SLFile;
    bool AbortInError;
    void Error (void);
  public:
    Configuration (const char *afnconf, bool aAbortInError);
    virtual ~Configuration (); 
    bool ConfRead (void);
    bool ConfSave (void);
    const char *getFileName (void);
    void setFileName (const char *afilename);
    bool newFile (const char *filecont);
    bool Reload (void);    
    bool Sync (void);
    void dumpDebug (void);
    char *getString (const char *asection, const char *akey, const char *adefault, int amaxsize);    
    bool setString (const char *asection, const char *akey, const char *astring, int amaxsize);
    int getInt (const char *asection, const char *akey, int adefault);
    bool setInt (const char *asection, const char *akey, int aint);
    bool IsThereSection (const char *asection);    
    bool getSection (const char *asection, StringList *ASection);
    int getFreeSlot (const char *slot, int CMAX);
    bool deleteSection (const char *asection);
  };
  
#endif


