/*
NewsRC.h

Modifications of Mark Crispin original
*/

#ifndef __NEWSRC_H
#define __NEWSRC_H

#include <ctype.h>
#include <stdio.h>
#include <c-client.h>

#include "Utils.h"


/*
 * Program:     Newsrc manipulation routines
 *
 * Authhor:     Mark Crispin
 *              Networks and Distributed Computing
 *              Computing & Communications
 *              University of Washington
 *              Administration Building, AG-44
 *              Seattle, WA  98195
 *              Internet: MRC@CAC.Washington.EDU
 *
 * Date:        12 September 1994
 * Last Edited: 24 October 2000
 * 
 * The IMAP toolkit provided in this Distribution is
 * Copyright 2000 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


/* Function prototypes */

long Newsrc_error (char *fmt,char *text,long errflg);
long Newsrc_write_error (char *name,FILE *f1,FILE *f2);
FILE *Newsrc_create (MAILSTREAM *stream,int notify);
long Newsrc_newstate (FILE *f,char *group,char state,char *nl);
long Newsrc_newmessages (FILE *f,MAILSTREAM *stream,char *nl);
void Newsrc_lsub (MAILSTREAM *stream,char *pattern);
long Newsrc_update (MAILSTREAM *stream,char *group,char state);
long Newsrc_read (char *group,MAILSTREAM *stream);
long Newsrc_write (const char *group, MAILSTREAM *stream);
char *Newsrc_state (MAILSTREAM *stream,char *group);
void Newsrc_check_uid (char *state,unsigned long uid,unsigned long *recent,
                       unsigned long *unseen);

#endif

