/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "autotraceformats.h"

AutotraceFormats::AutotraceFormats(QObject *parent, const char *name): QObject(parent, name), allOK(true) {
	inputProcess=new QProcess(this);
	outputProcess=new QProcess(this);

	inputProcess->addArgument("autotrace");
	inputProcess->addArgument("--list-input-formats");
	
	outputProcess->addArgument("autotrace");
	outputProcess->addArgument("--list-output-formats");
	
	connect(inputProcess,SIGNAL(readyReadStderr()),this,SLOT(inputRead()));
	connect(outputProcess,SIGNAL(readyReadStderr()),this,SLOT(outputRead()));
	
	if(!(inputProcess->start()) || !(outputProcess->start())) {
		allOK=false;
	}
}

void AutotraceFormats::inputRead( ) {
	while(inputProcess->canReadLineStderr()) {
		input+=inputProcess->readLineStderr();
	}
}

void AutotraceFormats::outputRead( ) {
	while(outputProcess->canReadLineStderr()) {
		QString tmp=outputProcess->readLineStderr();
		if(!(tmp.startsWith("Supported")))
			output+=tmp.stripWhiteSpace();
	}
}

bool AutotraceFormats::OK( ) {
	return allOK;
}

bool AutotraceFormats::done( ) {
	return (!(inputProcess->isRunning()) && !(outputProcess->isRunning()));
}

QStringList AutotraceFormats::inputFormats( ) {
	return input;
}

QStringList AutotraceFormats::outputFormats( ) {
	return output;
}


#include "autotraceformats.moc"
