/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 *               Author(s): Timo Hoenig <thoenig@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef POWERSAVE_BRIGHTNESS_H
#define POWERSAVE_BRIGHTNESS_H

#define PANASONIC_BRIGHTNESS_INTERFACE_IS_DOG_SLOW

#define ACPI_ASUS      "/proc/acpi/asus/brn"
#define ACPI_IBM       "/proc/acpi/ibm/brightness"
#define ACPI_SONY      "/proc/acpi/sony/brightness"
#define ACPI_TOSHIBA   "/proc/acpi/toshiba/lcd"
#define ACPI_PANASONIC "/proc/acpi/panasonic/"
#define LCD_OMNIBOOK   "/proc/omnibook/lcd"

#include "config.h" 

#ifdef ARCH_PPC
#define DEV_PMU        "/dev/pmu"
#endif

/* merge #include "powersaved.h" */

class Brightness {
      protected:
	const char *iface;
	int fd;
	int last_percent;
	int PercentToLevel(int);

      public:
	 virtual ~ Brightness();
	static Brightness *Probe();

	virtual void Init();

	virtual int Get();
	virtual void Set(int);
	int GetPercent();
	void SetPercent(int);

	/* those are driver-dependent, since e.g. setting the brightness
	   to zero actually might switch the display off which might not
	   be exactly what you want */
	virtual void Min();
	virtual void Med();

	/* those are generic */
	void Max();
	void Up();
	void Down();

	virtual int GetLevels();
};

class BrightnessASUS:public Brightness {
      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};

class BrightnessIBM:public Brightness {
      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};

class BrightnessSony:public Brightness {
      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};

class BrightnessToshiba:public Brightness {
      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};

class BrightnessPanasonic:public Brightness {
      protected:
#ifndef PANASONIC_BRIGHTNESS_INTERFACE_IS_DOG_SLOW
	char *iface_dc;
#endif
	int brt_max, brt_min, brt_scale;

      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};

class BrightnessOmnibook:public Brightness {
      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};

#ifdef ARCH_PPC
class BrightnessPMU:public Brightness {
      public:
	void Init();

	int Get();
	void Set(int);

	void Min();
	void Med();

	int GetLevels();
};
#endif				/* ARCH_PPC */
#endif				/* POWERSAVE_BRIGHTNESS_H */

