#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

int main(int argc, char **argv)
{
    ssize_t count;
    int fd, ret, err;

    if (argc != 3) {
        fprintf(stderr, "i need 2 arguments: file and value\n");
        return 255;
    }

    fd = open(argv[1], O_WRONLY);
    if (fd < 0) {
        err = errno;
        fprintf(stderr, "open failed: %s\n", strerror(err));
        return err;
    }

    count = write(fd, argv[2], strlen(argv[2]));
    if (count < 0) {
        err = errno;
        fprintf(stderr, "write failed: %s\n", strerror(err));
        return err;
    }

    ret = close(fd);
    if (ret) {
        err = errno;
        fprintf(stderr, "close failed: %s\n", strerror(err));
        return err;
    }

    return 0;
}
