  /*  signals.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"
#include <signal.h>

GtkWidget * popup_file;
int norename;
extern int size_x, size_y;
extern GtkWidget * statusbar;
extern GnomeUIInfo * file_menu, * edit_menu, * help_menu;

int last_page, last_page2, last_page3;

void term_resize (GtkWidget * widget, GdkEvent * event, gpointer callback_data)
{
  int w, h;
  char buf[512];

  int fw, ew, hw;
  int nb;

  ZvtTerm * term = widget;


  nb = notebook->requisition.width;


  w = (GTK_WIDGET(term)->allocation.width - (GTK_WIDGET(term)->style->klass->xthickness *2)) /
    term->charwidth;
  h = (GTK_WIDGET(term)->allocation.height - (GTK_WIDGET(term)->style->klass->ythickness *2)) /
    term->charheight;

  size_x = w;
  size_y = h;

}

void configure_event (GtkWidget * widget, GdkEvent * event, gpointer callback_data)
{

  int a;
  int w, h;
  int nb;
  char buf[512];

  /*
    w = ((GdkEventConfigure *)event)->width;
    h = ((GdkEventConfigure *)event)->height;
  */



  windowmoved(NULL,NULL);
}

void child_died_event (ZvtTerm *term)
{
  gtk_widget_hide (GTK_WIDGET(term));  
  gtk_container_remove (GTK_CONTAINER(notebook), GTK_WIDGET(term)->parent);      	

  gtk_notebook_set_page (GTK_NOTEBOOK(notebook), last_page);
}

void term_died_event (ZvtTerm *term)
{
  zvt_term_closepty (term);

  terms_open--;

  if (Prefs.hidetabswhensingle)
  {
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK(notebook), terms_open > 1);
  }

  if (!terms_open)
    {
      gtk_main_quit();
    }
}

void quit_proggie (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  gtk_main_quit ();
}

char * trunc_string (char * s, int len)
{
  int a;

  if (strlen(s) < len)
    return s;

  s[len-1] = '\0';
  s[len-2] = s[len-3] = s[len-4] = '.';

  return s;
  

}

void title_changed_event (ZvtTerm *term, VTTITLE_TYPE type, char *newtitle)
{
  GtkWidget * nblabel;
  int a=0;
  char buf[512];

  while (term != get_nth_zvt(GTK_NOTEBOOK(notebook),a))
    {
      a++;
      if (!get_nth_zvt(GTK_NOTEBOOK(notebook), a))
	return;
    }

  nblabel = gtk_notebook_get_tab_label (GTK_NOTEBOOK(notebook),
     	       	gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), a));
  gtk_label_set (GTK_LABEL(nblabel), trunc_string(newtitle, 15));

  if (a == gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))
    {
      sprintf (buf, "PowerShell - [%s]", newtitle);
      gtk_window_set_title (GTK_WINDOW(window), buf); 
    }

}




void set_hints (GtkWidget *widget)
{
  ZvtTerm *term;
  GdkGeometry hints;
  GtkWidget *app;

  int mw;  /* menubar width */

  mw = GNOME_APP(window)->menubar->requisition.width;

  g_assert (widget != NULL);
  term = ZVT_TERM (widget);
  
  app = gtk_widget_get_toplevel(widget);
  g_assert (app != NULL);
  

  hints.width_inc = term->charwidth;
  hints.height_inc = term->charheight;


  hints.base_width = (hints.width_inc + mw +
		      GTK_WIDGET(term)->style->klass->xthickness * 2);

  hints.base_height = (GTK_WIDGET(term)->style->klass->ythickness * 2) + 
    hints.height_inc * 4;

  hints.min_width = hints.base_width;
  hints.min_height = hints.base_height;


  gtk_window_set_geometry_hints(GTK_WINDOW(app),
				GTK_WIDGET(term),
				&hints,
				GDK_HINT_RESIZE_INC|GDK_HINT_MIN_SIZE|GDK_HINT_BASE_SIZE);
}


void NotebookHandler (GtkNotebook * notebook, GtkNotebookPage * page,
		      gint page_num, gpointer user_data)
/******************************************************
This function is lame... but it works.  Could be done
a hell of a lot better.
******************************************************/

{
  GtkWidget * tmp;
  gchar ** tmp2;
  gchar tmp3[512];

  tmp = gtk_notebook_get_tab_label (GTK_NOTEBOOK(notebook), 
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK(notebook), 
							       page_num));
  gtk_label_get (GTK_LABEL(tmp), (gchar **)(&tmp2));
  sprintf (tmp3, "PowerShell - [%s]", tmp2);

  /*  gtk_notebook_set_page (GTK_NOTEBOOK(notebook), page_num);*/
  
  gtk_window_set_title (GTK_WINDOW(window), tmp3); 

  last_page = last_page2;
  last_page2 = last_page3;
  last_page3 = page_num;

} 


volatile int ok_click;
GtkWidget * arglabel;
gchar complete_command[1024];
gchar incomplete_command[512];

extern GtkWidget * hidemenubaritem, * hidemenubaritem2;
extern GtkWidget * hidestatusbaritem, * hidestatusbaritem2;

void arg_ok_clicked (gchar * newname, gpointer data)
{
  char * tmp;
  char command[512], args[512];

  if (!newname)
  {
    sprintf (complete_command, incomplete_command, "");
    ok_click=1;
    return;
  }

  sprintf (complete_command, incomplete_command, newname);
  ok_click = 1;

  tmp = strstr (complete_command, " ");
  if (!tmp)
    strcpy (command, complete_command);
  else
    {
      *tmp = '\0';
      strcpy (command, complete_command);
      *tmp = ' ';
      tmp++;
      strcpy (args, tmp);
    }
  new_term (GTK_WIDGET(notebook), command, args, app_entries[(int)data-1].tab_title);
  
}

void GetArgs (gchar * prompt, gchar * default_val, gchar * data)
{
  ok_click = 0;
  gnome_request_dialog (FALSE, prompt, default_val, 256, arg_ok_clicked, data,
			GTK_WINDOW(window));
}

extern GnomeUIInfo menubar[5];

void MenuHandler (GtkWidget * w, gchar * data)
{
  char command[512], args[512];
  char * tmp;
  char buf[512];
  GtkWidget * t;
  GtkWidget * curpage;
  

  if ((int)data < 64)
    {
      bzero (command, 512);
      bzero (args, 512);

      tmp = strstr (app_entries[(int)data-1].command, "%s");
      if (tmp)
	{
	  strcpy (incomplete_command, app_entries[(int)data-1].command);
	  *tmp='\0';
	  sprintf (buf, "Enter arguments for %s", app_entries[(int)data-1].command);
	  *tmp='%';
	  GetArgs (buf, "", data);
	  return;
	}
      
      strcpy (complete_command, app_entries[(int)data-1].command);
      

      tmp = strstr (complete_command, " ");
      if (!tmp)
	strcpy (command, complete_command);
      else
	{
	  *tmp = '\0';
	  strcpy (command, complete_command);
	  *tmp = ' ';
	  tmp++;
	  strcpy (args, tmp);
	}
      new_term (GTK_WIDGET(notebook), command, args, app_entries[(int)data-1].tab_title);
      return;
    }


  switch ((int)data)
    {
      /* file menu */
    case 94:
      Prefs.hidemenubar=!Prefs.hidemenubar;

      if (Prefs.hidemenubar)
	gtk_widget_hide (GNOME_APP(window)->menubar->parent);
      else
	gtk_widget_show (GNOME_APP(window)->menubar->parent);

      WriteRCFile();
      break;

    case 93:
      Prefs.hidestatusbar=!Prefs.hidestatusbar;

      if (Prefs.hidestatusbar)
	gtk_widget_hide (GNOME_APP(window)->statusbar->parent);
      else
	gtk_widget_show (GNOME_APP(window)->statusbar->parent);
      
      WriteRCFile();
      break;

    case 96:
      RunArbitrary();
      break;
    case 97:
      RenameTerm();
      break;
    case 98:
      child_died_event (get_nth_zvt (GTK_NOTEBOOK(notebook), gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook))));
      break;
    case 99:
      gtk_main_quit();
      break;
      
      /* edit menu */
    case 101:     /* Edit->Cut */
      break;
    case 102:     /* Edit->Copy */
      break;
    case 103:     /* Edit->Paste */
      break;
    case 104:     /* Edit->Preferences */
      DoPreferences();
      break;
    case 105:
      FontSel();
      break;
      
    case 210:     /* rename term */
      RenameTerm2();
      break;


      /* help menu */
    case 1001:    /* Help->About */
      AboutDialog();
      break;

    }
  
  if ((int)data / 100 == 2)
    {
      gtk_notebook_set_page (GTK_NOTEBOOK(notebook), (int)data - 201);
    }
  
}


gboolean term_key_event (GtkWidget * widget, GdkEventKey * event, gpointer user_data)
{
  int cur_term;
  int a;

  if ((event->state & keyprefs.cycle_backwards.modifiers) && (event->keyval == keyprefs.cycle_backwards.key))
    {
      cur_term = gtk_notebook_get_current_page (GTK_NOTEBOOK(notebook));
      if (cur_term > 0)
	gtk_notebook_prev_page (GTK_NOTEBOOK(notebook));
      else
	gtk_notebook_set_page (GTK_NOTEBOOK(notebook), terms_open-1);
      
      
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
    }

  if ((event->state & keyprefs.cycle_forwards.modifiers) && (event->keyval == keyprefs.cycle_forwards.key))
    {
      cur_term = gtk_notebook_get_current_page (GTK_NOTEBOOK(notebook));
      if (gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),cur_term+1))
	gtk_notebook_next_page (GTK_NOTEBOOK(notebook));
      else
	gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 0);
      
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
    }

  for (a=0;a<20;a++)
    {
      if ((event->state & keyprefs.specific_term[a].modifiers) && 
	  (event->keyval == keyprefs.specific_term[a].key))
	{
	  gtk_notebook_set_page (GTK_NOTEBOOK(notebook), a);
	  event->state = event->keyval = event->length = 0;
	  event->string = NULL;
	  
	  return TRUE;
	}
    }

  if ((event->state & keyprefs.move_backwards.modifiers) && (event->keyval == keyprefs.move_backwards.key))
    {
      cur_term = gtk_notebook_get_current_page (GTK_NOTEBOOK(notebook));
      gtk_notebook_reorder_child (GTK_NOTEBOOK(notebook), 
				  gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), cur_term),
				  cur_term-1);

      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
    }

  if ((event->state & keyprefs.move_forwards.modifiers) && (event->keyval == keyprefs.move_forwards.key))
    {
      cur_term = gtk_notebook_get_current_page (GTK_NOTEBOOK(notebook));
      gtk_notebook_reorder_child (GTK_NOTEBOOK(notebook), 
				  gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), cur_term),
				  cur_term+1);
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
   }

  if ((event->state & keyprefs.close.modifiers) && (event->keyval == keyprefs.close.key))
    {

      MenuHandler (NULL, 98);
     
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
   }
  
  if ((event->state & keyprefs.quit.modifiers) && (event->keyval == keyprefs.quit.key))
    {

      MenuHandler (NULL, 99);
     
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
   }

  if ((event->state & keyprefs.rename.modifiers) && (event->keyval == keyprefs.rename.key))
    {

      MenuHandler (NULL, 97);
     
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
   }

  if ((event->state & keyprefs.run.modifiers) && (event->keyval == keyprefs.run.key))
    {

      MenuHandler (NULL, 96);
     
      event->state = event->keyval = event->length = 0;
      event->string = NULL;
      
      return TRUE;
   }

  
  return FALSE;
}

gint notebook_click_event (GtkWidget * widget, GdkEventButton * event,
			   gpointer user_data)
{
  gint w;
  gint dummy;

  
  if (norename)
    {
      norename = 0;
      return FALSE;
    }
  
  if (event->button == 2)
    {
      RenameTerm();
      event->send_event = 0;
      event->window = NULL;
      return TRUE;
    }

  return TRUE;
}


gint term_click_event (GtkWidget * widget, GdkEventButton * event)
{
  char * URL;
  char * type;
  char buf[512];
  char buf2[512];
  int a;
  int char_x = (int)event->x / ZVT_TERM(widget)->charwidth;
  int char_y = (int)event->y / ZVT_TERM(widget)->charheight;



  /* norename is a flag which is set if the user clicks on the term...
     this tells notebook_click_event not to open a rename dialog */

  norename = 1;

  if (event->button == 3)
    {
      a = gnome_popup_menu_do_popup_modal (popup_file, NULL, NULL, NULL, (gpointer)90);
      
      if (a>-1)
	MenuHandler (GTK_WIDGET(window), (gchar *)(file_menu[a].user_data));
    }



#ifdef ZVT_USE_MATCHING
  else
    if (URL = zvt_term_match_check (ZVT_TERM(widget), char_x, char_y, (void **)(&type)))
      {
	
	if (!strcmp (type, "http"))
	  new_term (notebook, Prefs.http_handler, URL, "http");
	if (!strcmp (type, "ftp"))
	  new_term (notebook, Prefs.ftp_handler, URL, "ftp");
	if (!strcmp (type, "mailto"))
	  {
	    sprintf (buf2, "compose to %s", URL);
	    new_term (notebook, Prefs.mail_handler, URL, buf2);
	  }      
	if (!strcmp (type, "telnet"))
	  {
	    strcpy (buf, URL+9);
	    sprintf (buf2, "telnet %s", buf);
	    new_term (notebook, Prefs.telnet_handler, buf, buf2);
	  }
	
      }
#endif
}
