//
//  PRTransforms.m
//  PRICE
//
//  Created by Riccardo Mottola on Mon Dec 23 2002.
//  Copyright (c) 2002-2003-2004 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRTransforms.h"


@implementation PRTransforms

- (PRImage *)transposeImage:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
        {
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            printf("Color image with alpha\n");
            return srcImage;
        }
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
        {   /* Grayscale image */
            /* allocate destination image and its representation */
            destImage = [[PRImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
            destImageRep = [[NSBitmapImageRep alloc]
                        initWithBitmapDataPlanes:NULL
                        pixelsWide:h
                        pixelsHigh:w
                        bitsPerSample:8
                        samplesPerPixel:1
                        hasAlpha:NO
                        isPlanar:NO
                        colorSpaceName:NSCalibratedWhiteColorSpace
                        bytesPerRow:0
                        bitsPerPixel:0];
    
            srcData = [srcImageRep bitmapData];
            destData = [destImageRep bitmapData];
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (x * h + y);
                    p2[0] = p1[0];
                }
        }
        else
        {   /* Color Image */
            /* allocate destination image and its representation */
            destImage = [[PRImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
            destImageRep = [[NSBitmapImageRep alloc]
                        initWithBitmapDataPlanes:NULL
                        pixelsWide:h
                        pixelsHigh:w
                        bitsPerSample:8
                        samplesPerPixel:3
                        hasAlpha:NO
                        isPlanar:NO
                        colorSpaceName:NSCalibratedRGBColorSpace
                        bytesPerRow:0
                        bitsPerPixel:0];
    
            srcData = [srcImageRep bitmapData];
            destData = [destImageRep bitmapData];
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (x * h + y);
                    p2[0] = p1[0];
                    p2[1] = p1[1];
                    p2[2] = p1[2];
                }
        }
    }

    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

- (PRImage *)rotateImage90:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
    if (isColorImage)
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    else /* greyscale */
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {   /* Color Image */
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((w-x-1) * h + y);
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {   /* Greyscale */
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((w-x-1) * h + y);
                p2[0] = p1[0];
            }
    }
    
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

- (PRImage *)rotateImage180:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColorImage)
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    else /* greyscale */
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {   /* Color image */
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + (w-x-1));
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {   /* Greyscale Image */
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + (w-x-1));
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}


- (PRImage *)rotateImage270:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
    if (isColorImage)
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    else /* greyscale */
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {   /* color image */
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (x * h + (h-y-1));
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {   /* greyscale image */
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (x * h + (h-y-1));
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

- (PRImage *)flipImageVert:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColorImage)
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    else /* greyscale */
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + x);
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + x);
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

- (PRImage *)flipImageHoriz:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColorImage)
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    else /* greyscale */
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (y * w + (w-x-1));
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (y * w + (w-x-1));
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}


@end
