;;;; insparens.el: Commands to insert parenthesises.
;;;; $Id: insparens.el,v 1.1 2003/12/27 08:45:31 komatsu Exp $
;;;;
;;;; Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;;
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(defcustom insparens-template-list
  '(("(" . ")") ("[" . "]") ("<" . ">") ("{" . "}"))
  "Template list for insparens")

;(defcustom insparens-template-list
;  '(("$B!V(B" . "$B!W(B") ("$B!X(B" . "$B!Y(B") ("$B!Z(B" . "$B![(B") ("$B!R(B" . "$B!S(B") ("$B!T(B" . "$B!U(B")
;    ("$B!J(B" . "$B!K(B") ("$B!L(B" . "$B!M(B") ("$B!N(B" . "$B!O(B") ("$B!P(B" . "$B!Q(B") ("$B!H(B" . "$B!I(B")
;    ("$B!F(B" . "$B!G(B"))
;  "Template list for insparens")

(defvar insparens-counter 0 
  "Counter for insparens-insert-parents (internal variable)")
(defvar insparens-region nil
  "Region for insparens-insert-parents (internal variable)")

(defvar insparens-insert-function-list
  '(insparens-insert-parens insparens-insert-parens-reverse)
  "List of functions dealt as insparens-insert-parens functions.")

;(global-set-key "\M-\[" 'insparens-insert-parens)
;(global-set-key "\M-\]" 'insparens-insert-parens-reverse)

(defun insparens-insert-parens ()
  (interactive)
  (insparens-insert-parens-internal 1))

(defun insparens-insert-parens-reverse ()
  (interactive)
  (insparens-insert-parens-internal -1))

(defun insparens-insert-parens-internal (steps)
  (if (not (member last-command
		   insparens-insert-function-list))
      (setq insparens-counter 0)
    (setq insparens-counter 
	  (% (+ insparens-counter steps (length insparens-template-list))
	     (length insparens-template-list)))
    (apply 'delete-region (cdr insparens-region))
    (apply 'delete-region (car insparens-region)))
  (let (beginning
	end
	(paren-open  (car (nth insparens-counter insparens-template-list)))
	(paren-close (cdr (nth insparens-counter insparens-template-list)))
	)
    (if (and (mell-transient-region-active-p) (not running-xemacs))
	(message
	 ;; Sorry, transient region function is supported on only XEmacs"))
	 "$B%j!<%8%g%s$r;H$C$?3g8L$NF~NO$O(B XEmacs $B$G$N$_%5%]!<%H$7$F$$$^$9(B."))
    (if (and (mell-transient-region-active-p) running-xemacs)
	(progn
	  (setq beginning (region-beginning))
	  (setq end       (+ (region-end) (length paren-open)))
	  (goto-char beginning)
	  (insert paren-open)
	  (goto-char end)
	  (insert paren-close))
      (setq beginning (point))
      (setq end (+ (point) (length paren-open)))
      (insert paren-open)
      (insert paren-close)
      (goto-char end))
    (setq insparens-region 
	  (cons (list beginning (+ beginning (length paren-open)))
		(list end       (+ end       (length paren-close)))))
    )
  (mell-transient-region-stay)
  )

(provide 'insparens)
